/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.charts;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.geoway.adf.dms.charts.dto.ChartDataQueryParam;
import com.geoway.adf.dms.charts.dto.ChartSceneDTO;
import com.geoway.adf.dms.charts.entity.ChartScene;
import com.geoway.adf.dms.charts.entity.ChartSceneVersion;
import com.geoway.adf.dms.charts.service.ChartSceneService;
import com.geoway.adf.dms.charts.service.impl.ChartDataQueryService;
import com.geoway.adf.dms.charts.service.impl.XzqhQueryService;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/chart/scene"})
@Api(tags={"07.02-\u56fe\u8868\u914d\u7f6e-\u56fe\u8868\u573a\u666f"})
public class ChartSceneController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ChartSceneService chartSceneService;
    @Resource
    private ChartDataQueryService chartDataQueryService;
    @Resource
    private XzqhQueryService xzqhQueryService;

    @ApiOperation(value="00-\u56fe\u8868\u573a\u666f\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public String getChartConfig(@PathVariable String id) {
        ChartSceneDTO chartSceneDTO = this.chartSceneService.getDetail(id);
        Assert.notNull((Object)chartSceneDTO, (String)"\u56fe\u8868\u573a\u666f\u4e0d\u5b58\u5728\uff01");
        return chartSceneDTO.getConfig();
    }

    @ApiOperation(value="01-\u83b7\u53d6\u56fe\u8868\u573a\u666f\u5217\u8868\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="withDataScene", value="\u662f\u5426\u8fd4\u56de\u6570\u636e\u56fe\u8868"), @ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57")})
    @GetMapping(value={"/tree"})
    public Response<List<ChartSceneDTO>> tree(@RequestParam(defaultValue="false") Boolean withDataScene, @RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.chartSceneService.tree(withDataScene, keyword));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u5206\u7c7b\u8282\u70b9\u4e0b\u6240\u6709\u56fe\u8868\u573a\u666f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pid", value="\u7236\u5206\u7c7bid"), @ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57")})
    @GetMapping(value={"/list"})
    public Response<List<ChartSceneDTO>> list(@RequestParam(required=false) String pid, @RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.chartSceneService.listScene(pid, keyword));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u56fe\u8868\u573a\u666f\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    public Response<ChartSceneDTO> getDetail(@RequestParam String id) {
        ChartSceneDTO chartSceneDTO = this.chartSceneService.getDetail(id);
        Assert.notNull((Object)chartSceneDTO, (String)"\u56fe\u8868\u573a\u666f\u4e0d\u5b58\u5728\uff01");
        return Response.ok((Object)chartSceneDTO);
    }

    @ApiOperation(value="04-\u4fdd\u5b58\u56fe\u8868\u573a\u666f")
    @PostMapping(value={"/save"})
    public Response<String> saveChart(@RequestBody ChartScene chartScene) {
        return Response.ok((Object)this.chartSceneService.saveScene(chartScene));
    }

    @ApiOperation(value="05-\u5220\u9664\u56fe\u8868\u573a\u666f")
    @PostMapping(value={"/del"})
    public Response deleteStatConfig(@RequestParam String id) {
        this.chartSceneService.deleteScene(id);
        return Response.ok();
    }

    @ApiOperation(value="06-\u79fb\u52a8\u56fe\u8868\u573a\u666f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6807\u8bc6", required=true), @ApiImplicitParam(name="pid", value="\u56fe\u8868\u7236id", required=false), @ApiImplicitParam(name="order", value="\u79fb\u52a8\u540e\u4e0a\u4e00\u4e2a\u5144\u5f1f\u8282\u70b9\u7684\u4f4d\u6b21\uff08\u4f4d\u6b21\u4ece1\u5f00\u59cb\uff0c\u6ca1\u6709\u4e0a\u4e2a\u5144\u5f1f\u8282\u70b9\u65f6\u6b64\u5904\u4e3a0\uff09", required=true)})
    @PostMapping(value={"/move"})
    public Response moveConfigOrder(@RequestParam String id, @RequestParam(required=false) String pid, @RequestParam Integer order) {
        this.chartSceneService.moveChartScene(id, pid, order);
        return Response.ok();
    }

    @ApiOperation(value="07-\u67e5\u8be2\u56fe\u8868\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="indicator", value="\u7edf\u8ba1\u6307\u6807id", required=true), @ApiImplicitParam(name="yearfilter", value="\u6570\u636e\u5e74\u4efd"), @ApiImplicitParam(name="xzqhfilter", value="\u884c\u653f\u533a\u8fc7\u6ee4\u7f16\u7801"), @ApiImplicitParam(name="geometryfilter", value="\u7a7a\u95f4\u8fc7\u6ee4\u51e0\u4f55"), @ApiImplicitParam(name="fieldfilter", value="\u5b57\u6bb5\u8fc7\u6ee4", example="Q!fieldA!S!EQ=500;Q!fieldB!N!LT=600"), @ApiImplicitParam(name="onlyfields", value="\u662f\u5426\u53ea\u8fd4\u56de\u5b57\u6bb5\u5217\u8868")})
    @GetMapping(value={"/data"})
    public List queryStatResult(@ApiIgnore @RequestParam Map<String, Object> params) {
        String indicator = null;
        Boolean onlyfields = null;
        ChartDataQueryParam queryParam = new ChartDataQueryParam();
        LinkedHashMap<String, Object> fieldValueFilters = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> kv : params.entrySet()) {
            if (kv.getKey().equalsIgnoreCase("onlyfields")) {
                onlyfields = Boolean.parseBoolean(kv.getValue().toString());
                continue;
            }
            if (kv.getKey().equalsIgnoreCase("indicator")) {
                indicator = kv.getValue().toString();
                queryParam.setIndicator(indicator);
                continue;
            }
            if (kv.getKey().equalsIgnoreCase("yearfilter")) {
                queryParam.setYearfilter(kv.getValue().toString());
                continue;
            }
            if (kv.getKey().equalsIgnoreCase("xzqhfilter")) {
                queryParam.setXzqhfilter(kv.getValue().toString());
                continue;
            }
            if (kv.getKey().equalsIgnoreCase("geometryfilter")) {
                queryParam.setGeometryfilter(kv.getValue().toString());
                continue;
            }
            if (kv.getKey().equalsIgnoreCase("fieldfilter")) {
                queryParam.setFieldfilter(kv.getValue().toString());
                continue;
            }
            if (kv.getKey().equals("_t")) continue;
            fieldValueFilters.put(kv.getKey(), kv.getValue());
        }
        if (Boolean.TRUE.equals(onlyfields)) {
            return this.chartDataQueryService.queryChartDataFields(indicator);
        }
        return this.chartDataQueryService.queryChartDataUseCache(queryParam);
    }

    @ApiOperation(value="08-\u83b7\u53d6\u884c\u653f\u533a\u5212\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="yearfilter", value="\u6570\u636e\u5e74\u4efd")})
    @GetMapping(value={"/xzqh.json"})
    public String getXzqh(@RequestParam(required=false) String yearfilter) {
        return this.xzqhQueryService.getXzqhTree(yearfilter);
    }

    @ApiOperation(value="09-\u83b7\u53d6\u4e0b\u4e00\u7ea7\u884c\u653f\u533a\u7a7a\u95f4\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="yearfilter", value="\u6570\u636e\u5e74\u4efd")})
    @GetMapping(value={"/xzqhGeomtry.json"})
    public String getXzqhGeometry(@RequestParam(required=false) String yearfilter, @RequestParam(required=false) String code) {
        return this.xzqhQueryService.getXzqhGeojson(yearfilter, code);
    }

    @ApiOperation(value="10-\u83b7\u53d6\u884c\u653f\u533a\u7ea7\u522b\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="yearfilter", value="\u6570\u636e\u5e74\u4efd")})
    @GetMapping(value={"/xzqhLevels.json"})
    public String getXzqhLevels(@RequestParam(required=false) String yearfilter) {
        return this.xzqhQueryService.getXzqhLevels(yearfilter);
    }

    @ApiOperation(value="11-\u56fe\u8868\u573a\u666f\u914d\u7f6e\u4e2d\u7ec4\u4ef6\u7c7b\u578b\u5217\u8868")
    @GetMapping(value={"/{id}/types"})
    public Response<List<String>> getChartConfigTypes(@PathVariable String id) {
        ArrayList<String> types = new ArrayList<String>();
        try {
            ChartSceneDTO chartSceneDTO = this.chartSceneService.getDetail(id);
            Assert.notNull((Object)chartSceneDTO, (String)"\u56fe\u8868\u573a\u666f\u4e0d\u5b58\u5728\uff01");
            String strConfig = chartSceneDTO.getConfig();
            if (StringUtil.isEmptyOrWhiteSpace((String)strConfig)) {
                return Response.ok(types);
            }
            JSONObject jsonObject = JSONObject.parseObject((String)strConfig);
            JSONArray components = jsonObject.getJSONArray("components");
            for (int i = 0; i < components.size(); ++i) {
                JSONObject component = components.getJSONObject(i);
                String type = component.getString("type");
                if (types.contains(type)) continue;
                types.add(type);
            }
            return Response.ok(types);
        }
        catch (Exception e) {
            this.log.error(id + "\u56fe\u6807\u573a\u666f\u914d\u7f6e\u8bfb\u53d6\u5931\u8d25", (Throwable)e);
            Response response = Response.error((String)"\u56fe\u6807\u573a\u666f\u914d\u7f6e\u8bfb\u53d6\u5931\u8d25");
            response.setData(types);
            return response;
        }
    }

    @ApiOperation(value="12-\u83b7\u53d6\u573a\u666f\u5386\u53f2\u7248\u672c\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sceneId", value="\u573a\u666fid")})
    @GetMapping(value={"/versions"})
    public Response<List<ChartSceneVersion>> list(@RequestParam(required=false) String sceneId) {
        return Response.ok((Object)this.chartSceneService.listChartSceneVersion(sceneId));
    }

    @ApiOperation(value="13-\u83b7\u53d6\u573a\u666f\u5386\u53f2\u7248\u672c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="versionId", value="\u573a\u666f\u7248\u672cid")})
    @GetMapping(value={"/version"})
    public Response<ChartSceneVersion> getSceneVersion(@RequestParam(required=false) String versionId) {
        return Response.ok((Object)this.chartSceneService.getChartSceneVersion(versionId));
    }
}

