/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.check;

import com.geoway.adf.dms.api.action.check.UploadFileCheck;
import com.geoway.adf.dms.api.action.check.UploadFileType;
import com.geoway.adf.dms.common.exception.FileUploadIllegalException;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlMapFactoryBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileUrlResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
@ConditionalOnExpression(value="${project.upload-file-check:true}")
public class UploadFileCheckAspect {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, List<String>> validTypeMap = new LinkedHashMap<String, List<String>>();

    public UploadFileCheckAspect() {
        try {
            FileUrlResource configResource;
            File customFile = new File("uploadFileType.yml");
            if (customFile.exists()) {
                configResource = new FileUrlResource(customFile.getAbsolutePath());
            } else {
                customFile = new File("config/uploadFileType.yml");
                if (customFile.exists()) {
                    configResource = new FileUrlResource(customFile.getAbsolutePath());
                } else {
                    configResource = null;
                    URL fileUrl = this.getClass().getClassLoader().getResource("uploadFileType.yml");
                    if (fileUrl != null) {
                        configResource = new FileUrlResource(fileUrl);
                    }
                    if (configResource == null) {
                        configResource = new ClassPathResource("uploadFileType.yml");
                    }
                }
            }
            this.log.info("\u52a0\u8f7d\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\u914d\u7f6e\uff1a" + configResource.getURL());
            YamlMapFactoryBean yamlProFb = new YamlMapFactoryBean();
            yamlProFb.setResources(new Resource[]{configResource});
            Map objectMap = yamlProFb.getObject();
            for (String typeName : objectMap.keySet()) {
                Object values = objectMap.get(typeName);
                if (!(values instanceof List)) continue;
                this.validTypeMap.put(typeName, ListUtil.convertAll((List)((List)values), Object::toString));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\u914d\u7f6e\u8bfb\u53d6\u5931\u8d25", e);
        }
    }

    @Before(value="@annotation(annotation)")
    public void before(JoinPoint joinPoint, UploadFileCheck annotation) {
        String[] suffixes = annotation.supportedSuffixes();
        UploadFileType[] fileTypes = annotation.supportedFileTypes();
        String message = annotation.message();
        ArrayList<String> fileExtList = new ArrayList<String>();
        if (suffixes != null && suffixes.length > 0) {
            for (String string : suffixes) {
                fileExtList.add(this.getExtension(string));
            }
        }
        if (fileTypes != null && fileTypes.length > 0) {
            for (UploadFileType uploadFileType : fileTypes) {
                fileExtList.addAll(this.getFileExtList(uploadFileType));
            }
        }
        if (fileExtList.size() == 0) {
            fileExtList.addAll(this.getFileExtList(UploadFileType.VectorFile));
            fileExtList.addAll(this.getFileExtList(UploadFileType.RasterFile));
            fileExtList.addAll(this.getFileExtList(UploadFileType.ThreeModelFile));
            fileExtList.addAll(this.getFileExtList(UploadFileType.MediaFile));
            fileExtList.addAll(this.getFileExtList(UploadFileType.CustomFile));
        }
        for (Object object : joinPoint.getArgs()) {
            MultipartFile[] files = null;
            if (object instanceof MultipartFile) {
                files = new MultipartFile[]{(MultipartFile)object};
            } else if (object instanceof MultipartFile[]) {
                files = (MultipartFile[])object;
            }
            if (files == null) continue;
            for (MultipartFile file : files) {
                if (file.getOriginalFilename() == null) {
                    throw new FileUploadIllegalException("\u4e0a\u4f20\u6587\u4ef6\u540d\u4e0d\u53ef\u4e3a\u7a7a");
                }
                String fileName = FileUtil.getFileName((String)file.getOriginalFilename());
                boolean valid = false;
                String fileSuffix = this.getExtension(fileName);
                for (String suffix : fileExtList) {
                    if (!suffix.equalsIgnoreCase(fileSuffix)) continue;
                    valid = true;
                    break;
                }
                if (valid) continue;
                throw new FileUploadIllegalException(fileName, StringUtil.isEmpty((String)message) ? "\u4e0d\u5141\u8bb8\u7684\u6587\u4ef6\u4e0a\u4f20" : message);
            }
        }
    }

    private List<String> getFileExtList(UploadFileType fileType) {
        ArrayList<String> extList = new ArrayList<String>();
        if (this.validTypeMap.containsKey(fileType.name())) {
            List<String> values = this.validTypeMap.get(fileType.name());
            extList.addAll(values);
        }
        return extList;
    }

    private String getExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index >= 0) {
            return fileName.substring(index + 1);
        }
        return "";
    }
}

