/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.config;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.config.dto.basemap.BaseMapDTO;
import com.geoway.adf.dms.config.dto.basemap.BaseMapServiceDTO;
import com.geoway.adf.dms.config.service.CmBaseMapService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/config/base/map"})
@Api(tags={"04.08-\u914d\u7f6e\u7ba1\u7406-\u5e95\u56fe\u914d\u7f6e"})
public class BaseMapController {
    @Resource
    private CmBaseMapService baseMapService;

    @ApiOperation(value="01-\u83b7\u53d6\u5e95\u56fe\u914d\u7f6e\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="types", value="\u7c7b\u578b\uff0c\u591a\u4e2a\u7528\u9017\u53f7\u9694\u5f00", allowableValues="com.geoway.adf.dms.config.dto.basemap.BaseMapItemTypeEnum")})
    @GetMapping(value={"/list"})
    public Response<List<BaseMapDTO>> list(@RequestParam(required=false) String types) {
        return Response.ok((Object)this.baseMapService.list(types));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u5e95\u56fe\u914d\u7f6e\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6807\u8bc6", required=true)})
    @GetMapping(value={"/detail"})
    public Response<BaseMapDTO> getDetail(@RequestParam String id) {
        return Response.ok((Object)this.baseMapService.getDetail(id));
    }

    @ApiOperation(value="03-\u6dfb\u52a0\u5206\u7ec4")
    @PostMapping(value={"/group"})
    public Response<String> addBaseMapGroup(@RequestBody BaseMapDTO groupDTO) {
        return Response.ok((Object)this.baseMapService.addBaseMapGroup(groupDTO));
    }

    @ApiOperation(value="04-\u7f16\u8f91\u5206\u7ec4")
    @PutMapping(value={"/group"})
    public Response updateBaseMapGroup(@RequestBody BaseMapDTO groupDTO) {
        this.baseMapService.updateBaseMapGroup(groupDTO);
        return Response.ok();
    }

    @ApiOperation(value="05-\u6dfb\u52a0\u5e95\u56fe\u670d\u52a1")
    @PostMapping(value={"/service"})
    public Response<String> addBaseMapService(@RequestBody BaseMapServiceDTO serviceDTO) {
        return Response.ok((Object)this.baseMapService.addBaseMapService(serviceDTO));
    }

    @ApiOperation(value="06-\u4fee\u6539\u5e95\u56fe\u670d\u52a1")
    @PutMapping(value={"/service"})
    public Response updateBaseMapService(@RequestBody BaseMapServiceDTO serviceDTO) {
        this.baseMapService.updateBaseMapService(serviceDTO);
        return Response.ok();
    }

    @ApiOperation(value="07-\u5220\u9664\u5206\u7ec4\u6216\u5e95\u56fe\u670d\u52a1")
    @ApiImplicitParam(name="id", value="\u6807\u8bc6", required=true)
    @DeleteMapping(value={""})
    public Response deleteBaseMap(@RequestParam String id) {
        this.baseMapService.deleteBaseMap(id);
        return Response.ok();
    }

    @ApiOperation(value="8-\u8bbe\u7f6e\u9ed8\u8ba4\u5206\u7ec4")
    @PutMapping(value={"/group/default"})
    public Response updateBaseMapGroup(@RequestParam String id, @RequestParam Boolean isDefault) {
        this.baseMapService.setDefaultGroup(id, isDefault);
        return Response.ok();
    }

    @ApiOperation(value="9-\u8c03\u6574\u5e95\u56fe\u670d\u52a1\u7684\u987a\u5e8f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6807\u8bc6", required=true), @ApiImplicitParam(name="order", value="\u79fb\u52a8\u540e\u4e0a\u4e00\u4e2a\u5144\u5f1f\u8282\u70b9\u7684\u4f4d\u6b21\uff08\u4f4d\u6b21\u4ece1\u5f00\u59cb\uff0c\u6ca1\u6709\u4e0a\u4e2a\u5144\u5f1f\u8282\u70b9\u65f6\u6b64\u5904\u4e3a0\uff09", required=true)})
    @PutMapping(value={"/order"})
    public Response updateServiceOrder(@RequestParam String id, @RequestParam Integer order) {
        this.baseMapService.updateServiceOrder(id, order);
        return Response.ok();
    }

    @ApiOperation(value="10-\u7f16\u8f91\u5206\u7ec4\u56fe\u7247")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6807\u8bc6", required=true), @ApiImplicitParam(name="deletePicture", value="\u662f\u5426\u5220\u9664\u76ee\u5f55\u56fe\u7247", dataType="boolean"), @ApiImplicitParam(name="picture", value="\u76ee\u5f55\u56fe\u7247", dataTypeClass=MultipartFile.class)})
    @PostMapping(value={"/group/picture"})
    public Response editGroupPicture(@RequestParam String id, @RequestParam(required=false, defaultValue="false") Boolean deletePicture, @RequestPart(required=false) MultipartFile picture) {
        this.baseMapService.editGroupPicture(id, deletePicture, picture);
        return Response.ok();
    }

    @ApiOperation(value="11-\u83b7\u53d6\u5e95\u56fe\u7684\u521d\u59cb\u4f4d\u7f6e")
    @GetMapping(value={"/extent"})
    public Response<String> getBaseMapExtentJson() {
        return Response.ok((Object)this.baseMapService.getBaseMapExtentJson());
    }

    @ApiOperation(value="12-\u7f16\u8f91\u5e95\u56fe\u7684\u521d\u59cb\u4f4d\u7f6e")
    @PostMapping(value={"/extent"})
    public Response updateBaseMapExtentJson(String extentJson) {
        this.baseMapService.updateBaseMapExtentJson(extentJson);
        return Response.ok();
    }
}

