/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.config;

import com.geoway.adf.dms.api.action.check.UploadFileCheck;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.dto.dict.edit.DmDictValueCreateDTO;
import com.geoway.adf.dms.config.dto.dict.edit.DmDictValueEditDTO;
import com.geoway.adf.dms.config.dto.dict.edit.DmDictValueSortDTO;
import com.geoway.adf.dms.config.dto.dict.edit.DmDictionaryCreateDTO;
import com.geoway.adf.dms.config.entity.DmDictionary;
import com.geoway.adf.dms.config.service.DictionaryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/config/dictionary"})
@Api(tags={"04.06-\u914d\u7f6e\u7ba1\u7406-\u503c\u57df\u914d\u7f6e"})
public class DictionaryController {
    @Resource
    private DictionaryService dictionaryService;

    @ApiOperation(value="01-\u83b7\u53d6\u503c\u57df\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57")})
    @GetMapping(value={"/list"})
    public Response<List<DmDictionary>> list(@RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.dictionaryService.list(keyword));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u503c\u57df\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u503c\u57df\u7f16\u7801")})
    @GetMapping(value={"/dic"})
    public Response<DmDictValueDTO> getDictionaryTree(@RequestParam String key) {
        DmDictValueDTO dictValueDTO = this.dictionaryService.getDictionaryTree(key);
        if (dictValueDTO != null) {
            return Response.ok((Object)dictValueDTO);
        }
        return Response.error((String)String.format("\u5b57\u5178\u503c\u57df[%s]\u4e0d\u5b58\u5728", key));
    }

    @ApiOperation(value="02-01-\u83b7\u53d6\u503c\u57df\u6811\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keys", value="\u503c\u57df\u7f16\u7801,\u591a\u4e2a\u9017\u53f7\u5206\u9694")})
    @GetMapping(value={"/dics"})
    public Response<List<DmDictValueDTO>> getDictionaryTreeList(@RequestParam String keys) {
        String[] keyList = keys.split(",");
        return Response.ok((Object)this.dictionaryService.getDictionaryTreeByKeys(keyList));
    }

    @ApiOperation(value="03-\u6dfb\u52a0\u503c\u57df")
    @PostMapping(value={"/dic"})
    public Response<Long> addDictionary(@RequestBody DmDictionaryCreateDTO createDTO) {
        return Response.ok((Object)this.dictionaryService.addDictionary(createDTO));
    }

    @ApiOperation(value="04-\u4fee\u6539\u503c\u57df")
    @PutMapping(value={"/dic"})
    public Response updateDictionary(@RequestBody DmDictionaryCreateDTO editDTO) {
        this.dictionaryService.updateDictionary(editDTO);
        return Response.ok();
    }

    @ApiOperation(value="05-\u5220\u9664\u503c\u57df")
    @DeleteMapping(value={"/dic"})
    public Response deleteDictionary(@RequestParam String key) {
        this.dictionaryService.deleteDictionary(key);
        return Response.ok();
    }

    @ApiOperation(value="06-\u6dfb\u52a0\u503c\u57df\u503c")
    @PostMapping(value={"/dic/value"})
    public Response<Long> addDictionaryValue(@RequestBody DmDictValueCreateDTO createDTO) {
        return Response.ok((Object)this.dictionaryService.addDictionaryValue(createDTO));
    }

    @ApiOperation(value="07-\u4fee\u6539\u503c\u57df\u503c")
    @PutMapping(value={"/dic/value"})
    public Response updateDictionaryValue(@RequestBody DmDictValueEditDTO editDTO) {
        this.dictionaryService.updateDictionaryValue(editDTO);
        return Response.ok();
    }

    @ApiOperation(value="08-\u6279\u91cf\u5220\u9664\u503c\u57df\u503c")
    @ApiImplicitParam(name="ids", value="\u76ee\u5f55\u8282\u70b9ID\uff0c\u591a\u4e2a\u9017\u53f7\u5206\u9694", required=true)
    @DeleteMapping(value={"/dic/value"})
    public Response deleteDictionaryValue(@RequestParam String ids) {
        this.dictionaryService.deleteDictionaryValue(ids);
        return Response.ok();
    }

    @ApiOperation(value="09-\u8c03\u6574\u503c\u57df\u503c\u987a\u5e8f")
    @PostMapping(value={"/dic/value/sort"})
    public Response sort(@RequestBody DmDictValueSortDTO sortDTO) {
        this.dictionaryService.sort(sortDTO);
        return Response.ok();
    }

    @ApiOperation(value="10-\u5bfc\u5165")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dictionaryId", value="\u503c\u57df\u6807\u8bc6"), @ApiImplicitParam(name="file", value="xml\u6587\u4ef6", required=true, dataTypeClass=MultipartFile.class)})
    @UploadFileCheck(supportedSuffixes={".xml"})
    @PostMapping(value={"/importXml"})
    public Response importXml(@RequestPart MultipartFile file, @RequestParam(required=false) Long dictionaryId) {
        this.dictionaryService.importXml(file, dictionaryId);
        return Response.ok();
    }

    @ApiOperation(value="11-\u5bfc\u51fa")
    @ApiImplicitParam(name="dictionaryId", value="\u503c\u57df\u6807\u8bc6", required=true)
    @GetMapping(value={"/exportXml"})
    public void exportXml(HttpServletResponse response, @RequestParam Long dictionaryId) {
        this.dictionaryService.exportXml(response, dictionaryId);
    }
}

