/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.datasource;

import com.geoway.adf.dms.api.action.datasource.ResponseDatasetList;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetPageList;
import com.geoway.adf.dms.datasource.dto.create.ExternalServiceCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.ServiceEditDTO;
import com.geoway.adf.dms.datasource.dto.dataset.ServiceDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.VTilePropertiesDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.VTileServiceDefaultStyleDTO;
import com.geoway.adf.dms.datasource.service.GeoServerEngineService;
import com.geoway.adf.gis.geosrv.ServiceType;
import com.geoway.adf.gis.geosrv.vtile.VTileServiceStyle;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource/geosrv"})
@Api(tags={"01.08-\u7a7a\u95f4\u670d\u52a1"})
public class GeoServerController {
    @Resource
    private GeoServerEngineService geoServerStorageService;

    @ApiOperation(value="01-\u83b7\u53d6\u7a7a\u95f4\u670d\u52a1\u5668\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="types", value="\u6570\u636e\u6e90\u7c7b\u578b\uff0c\u591a\u4e2a\u9017\u53f7\u5206\u9694(41-IME\u670d\u52a1\u5668; 42-\u77e2\u91cf\u74e6\u7247\u670d\u52a1\u5668)", paramType="query"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query")})
    @GetMapping(value={"/list"})
    public Response<List<DataSourceDTO>> listServer(@RequestParam(required=false) String types, @RequestParam(required=false) String keyword) {
        List sourceTypes = new ArrayList();
        if (StringUtil.isNotEmpty((String)types)) {
            sourceTypes = StringUtil.split((String)types, (String)",", t -> DataSourceTypeEnum.getByValue((Integer)Integer.valueOf(t)));
        }
        List databaseDTOList = this.geoServerStorageService.listServer(sourceTypes, keyword);
        return Response.ok((Object)databaseDTOList);
    }

    @ApiOperation(value="02-\u83b7\u53d6\u670d\u52a1\u6570\u636e\u96c6\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u670d\u52a1\u5668\u6807\u8bc6(\u5916\u90e8\u670d\u52a1\u6807\u8bc6\u4e3a\u7a7a)", paramType="query"), @ApiImplicitParam(name="serviceTypes", value="\u670d\u52a1\u7c7b\u578b\uff0c\u591a\u4e2a\u9017\u53f7\u5206\u9694", paramType="query", allowableValues="com.geoway.adf.gis.geosrv.ServiceType"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query")})
    @GetMapping(value={"/service/list"})
    public ResponseDatasetList<ServiceDatasetDTO> listGeoService(@RequestParam(required=false) String key, @RequestParam(required=false) String serviceTypes, @RequestParam(required=false) String keyword, @RequestParam(required=false) Integer pageIndex, @RequestParam(required=false) Integer rows) {
        List types = null;
        if (StringUtil.isNotEmpty((String)serviceTypes)) {
            types = StringUtil.split((String)serviceTypes, (String)",", t -> ServiceType.getByValue((Integer)Integer.valueOf(t)));
        }
        DatasetPageList pageList = this.geoServerStorageService.listService(key, types, keyword, pageIndex, rows);
        return ResponseDatasetList.ok(pageList);
    }

    @ApiOperation(value="03-\u5220\u9664\u670d\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u670d\u52a1id", required=true, paramType="path")})
    @DeleteMapping(value={"/service/del/{id}"})
    public Response deleteDataset(@PathVariable String id) {
        this.geoServerStorageService.deleteService(id);
        return Response.ok();
    }

    @ApiOperation(value="04-\u4fee\u6539\u670d\u52a1")
    @PostMapping(value={"/service/update"})
    public Response updateSingleService(@RequestBody ServiceEditDTO service) {
        this.geoServerStorageService.updateService(service);
        return Response.ok();
    }

    @ApiOperation(value="05-\u83b7\u53d6\u5916\u90e8\u670d\u52a1\u4e2a\u6570")
    @GetMapping(value={"/external/count"})
    public Response<Integer> singleServiceCount() {
        return Response.ok((Object)this.geoServerStorageService.getExternalServiceCount());
    }

    @ApiOperation(value="06-\u65b0\u589e\u5916\u90e8\u670d\u52a1")
    @PostMapping(value={"/external/add"})
    public Response<String> addSingleService(@RequestBody ExternalServiceCreateDTO service) {
        return Response.ok((Object)this.geoServerStorageService.addExternalService(service));
    }

    @ApiOperation(value="07-\u83b7\u53d6\u77e2\u91cf\u74e6\u7247\u670d\u52a1\u5668\u5c5e\u6027")
    @ApiImplicitParam(name="key", value="\u670d\u52a1\u5668key", paramType="query")
    @GetMapping(value={"/vtile/prop"})
    public Response<VTilePropertiesDTO> getVTileProperties(String key) {
        return Response.ok((Object)this.geoServerStorageService.getVTileProperties(key));
    }

    @ApiOperation(value="08-\u83b7\u53d6\u77e2\u91cf\u74e6\u7247\u670d\u52a1\u6837\u5f0f\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="serverKey", value="\u670d\u52a1\u5668key", required=true, paramType="query"), @ApiImplicitParam(name="serviceName", value="\u670d\u52a1\u540d\u79f0", required=true, paramType="query")})
    @GetMapping(value={"/vtile/styles"})
    public Response<List<VTileServiceStyle>> getVTileServiceStyle(String serverKey, String serviceName) {
        return Response.ok((Object)this.geoServerStorageService.listVTileServiceStyle(serverKey, serviceName));
    }

    @ApiOperation(value="09-\u8bbe\u7f6e\u77e2\u91cf\u74e6\u7247\u670d\u52a1\u9ed8\u8ba4\u6837\u5f0f")
    @PostMapping(value={"/vtile/style/default"})
    public Response setVTileServiceDefaultStyle(@RequestBody VTileServiceDefaultStyleDTO defaultStyleDTO) {
        this.geoServerStorageService.setVTileServiceDefaultStyle(defaultStyleDTO.getServerKey(), defaultStyleDTO.getServiceName(), defaultStyleDTO.getStyleId());
        return Response.ok();
    }
}

