/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.util;

import cn.hutool.core.io.unit.DataSizeUtil;
import com.geoway.adf.dms.api.action.check.UploadFileCheck;
import com.geoway.adf.dms.common.config.OutputPathConfig;
import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.dto.ExtentDTO;
import com.geoway.adf.dms.common.dto.MapNumber;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.FileViewerUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.MapIDUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.util.ZipAndRarUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.util.FieldUtil;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.adf.gis.raster.info.RasterInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={""})
@Api(tags={"06-\u901a\u7528\u5de5\u5177"})
public class CommonUtilController {
    private static final Logger log = LoggerFactory.getLogger(CommonUtilController.class);

    @ApiOperation(value="01-\u56fe\u5e45\u53f7\u89e3\u6790")
    @ApiImplicitParams(value={@ApiImplicitParam(name="mapNos", value="\u56fe\u5e45\u53f7\uff0c\u591a\u4e2a\u7528\u9017\u53f7\u9694\u5f00")})
    @GetMapping(value={"/util/map/number"})
    public Response<List<MapNumber>> list(@RequestParam String mapNos) {
        List mapNoList = StringUtil.split((String)mapNos, (String)",", f -> f);
        List mapNumberList = ListUtil.convertAll((List)mapNoList, MapIDUtil::getMapNumber);
        return Response.ok((Object)mapNumberList);
    }

    @ApiOperation(value="02-\u4e34\u65f6\u7ed3\u679c\u4e0b\u8f7d")
    @GetMapping(value={"/datasource/util/download"})
    public void downloadTempResult(String id, String outputName, HttpServletRequest request, HttpServletResponse response) {
        Path outputPath = OutputPathConfig.getOutputPath();
        File file = (outputPath = outputPath.resolve(id)).toFile();
        if (!file.exists()) {
            throw new HttpClientErrorException(HttpStatus.NOT_FOUND, id + "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        File[] subFiles = file.listFiles();
        DownloadUtil.downloadZipFile(Arrays.asList(subFiles == null ? new File[]{} : subFiles), (String)file.toString(), (String)(outputName + ".zip"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="03-\u4e0a\u4f20shp\u6587\u4ef6/geojson\u6587\u4ef6/shp\u3001gdb\u7684\u538b\u7f29\u5305\u8bfb\u53d6\u5408\u5e76\u56fe\u5f62wkt", notes="\u4e0a\u4f20shp\u6587\u4ef6/geojson\u6587\u4ef6/shp\u3001gdb\u7684\u538b\u7f29\u5305\u8bfb\u53d6\u5408\u5e76\u56fe\u5f62wkt\uff0c\u6587\u4ef6\u5927\u5c0f\u4e0d\u8d85\u8fc710MB")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u4e0a\u4f20\u7684\u6587\u4ef6", required=true, dataTypeClass=MultipartFile.class), @ApiImplicitParam(name="srid", value="\u76ee\u6807\u7a7a\u95f4\u53c2\u8003srid", dataType="int", defaultValue="4490")})
    @UploadFileCheck(supportedSuffixes={".shp", ".geojson", ".zip"})
    @PostMapping(value={"/datasource/util/shpgeometry"})
    public Response<String> uploadGeometryFile(@RequestPart MultipartFile file, @RequestParam(required=false, defaultValue="4490") Integer srid) {
        Response response;
        if (file.getSize() > 0xA00000L) {
            return Response.error((String)"\u6587\u4ef6\u4e0d\u80fd\u5927\u4e8e10MB");
        }
        String fileName = file.getOriginalFilename();
        try (IFeatureWorkspace workspace = null;){
            Path localPath = UploadPathConfig.getUploadPath().resolve(UUID.randomUUID().toString());
            localPath.toFile().mkdirs();
            localPath = localPath.resolve(Paths.get(fileName, new String[0]));
            file.transferTo(localPath);
            if (localPath.toString().toLowerCase(Locale.ROOT).endsWith(".zip")) {
                Path unZipPath = Paths.get(localPath.getParent().toString(), FileUtil.getFileNameWithoutExtension((String)localPath.toString()));
                ZipAndRarUtil.unZipFiles((File)localPath.toFile(), (String)(unZipPath + File.separator));
                String workspacePath = this.getFirstWorkspacePath(unZipPath.toFile());
                if (workspacePath == null) {
                    Response response2 = Response.error((String)"\u672a\u8bfb\u53d6\u5230\u6570\u636e");
                    return response2;
                }
                workspace = WorkspaceUtil.openLocalFileGeodatabase((String)workspacePath);
                List layers = workspace.getDatasets();
                for (IGeoDataset dataset : layers) {
                    if (dataset.getType() != GeoDatasetType.FeatureClass) continue;
                    IGeometry geometry = null;
                    IFeatureClass featureClass = (IFeatureClass)dataset;
                    IFeatureCursor cursor = featureClass.searchFeature(null);
                    IFeature feature = cursor.nextFeature();
                    while (feature != null) {
                        geometry = geometry == null ? feature.getGeometry() : geometry.union(feature.getGeometry());
                        feature = cursor.nextFeature();
                    }
                    cursor.release();
                    if (geometry != null) {
                        if (srid != null && srid > 0) {
                            geometry.project(featureClass.getSpatialReferenceSystem(), SpatialReferenceSystemFunc.createSpatialReference((int)srid));
                            Response response3 = Response.ok((Object)this.forceGeometry(geometry).toWkt());
                            return response3;
                        }
                        Response response4 = Response.ok((Object)geometry.toWkt());
                        return response4;
                    }
                    break;
                }
            } else {
                IGeometry geometry = WorkspaceUtil.readLocalFileGeometry((String)localPath.toString());
                if (geometry != null) {
                    Response response5 = Response.ok((Object)this.forceGeometry(geometry).toWkt());
                    return response5;
                }
            }
            response = Response.error((String)"\u672a\u8bfb\u53d6\u5230\u6570\u636e");
            return response;
        }
    }

    private String getFirstWorkspacePath(File dir) {
        File[] fileItems = dir.listFiles();
        if (fileItems == null) {
            return null;
        }
        String workspacePath = null;
        for (File item : fileItems) {
            if (item.getName().toLowerCase(Locale.ROOT).endsWith(".shp") || item.getName().toLowerCase(Locale.ROOT).endsWith(".gdb")) {
                workspacePath = item.getAbsolutePath();
                break;
            }
            if (item.isDirectory() && (workspacePath = this.getFirstWorkspacePath(item)) != null) break;
        }
        return workspacePath;
    }

    private IGeometry forceGeometry(IGeometry geometry) {
        GeometryType geometryType = geometry.getType();
        switch (geometryType) {
            case LinearRing: 
            case Curve: {
                return GeometryFunc.forceToLineString((IGeometry)geometry);
            }
            case MultiCurve: {
                return GeometryFunc.forceToMultiLineString((IGeometry)geometry);
            }
            case CurvePolygon: {
                return GeometryFunc.forceToPolygon((IGeometry)geometry);
            }
            case MultiCurvePolygon: 
            case GeometryCollection: {
                return GeometryFunc.forceToMultiPolygon((IGeometry)geometry);
            }
        }
        return geometry;
    }

    /*
     * WARNING - void declaration
     */
    @ApiOperation(value="04-\u4e0a\u4f20\u5f71\u50cf\u6587\u4ef6\u83b7\u53d6\u5f71\u50cf\u4fe1\u606f", notes="\u4e0a\u4f20\u5f71\u50cf\u6587\u4ef6\u83b7\u53d6\u6587\u4ef6\u9884\u89c8\u5730\u5740\u548c\u5f71\u50cf\u4fe1\u606f\uff0c\u6587\u4ef6\u5927\u5c0f\u4e0d\u8d85\u8fc710MB")
    @UploadFileCheck
    @PostMapping(value={"/datasource/util/temp/rasterInfo"})
    public Response<TempRasterInfo> uploadRasterFile(@RequestPart MultipartFile[] files) {
        long size = 0L;
        for (MultipartFile multipartFile : files) {
            size += multipartFile.getSize();
        }
        if (size > 0xA00000L) {
            return Response.error((String)"\u6587\u4ef6\u4e0d\u80fd\u5927\u4e8e5MB");
        }
        try {
            void var7_15;
            LinkedHashMap<String, String> fileMap = new LinkedHashMap<String, String>();
            String id = UUID.randomUUID().toString();
            Path localPath = UploadPathConfig.getUploadPath().resolve(id);
            localPath.toFile().mkdirs();
            for (MultipartFile file : files) {
                String fileName = file.getOriginalFilename();
                Path localFile = localPath.resolve(Paths.get(fileName, new String[0]));
                file.transferTo(localFile);
                fileMap.put(FileUtil.getExtension((String)fileName).toLowerCase(), localFile.toString());
            }
            String string = "";
            if (fileMap.containsKey(".tif")) {
                String string2 = (String)fileMap.get(".tif");
            } else if (fileMap.containsKey(".img")) {
                String string3 = (String)fileMap.get(".img");
            } else if (fileMap.containsKey(".jpg")) {
                String string4 = (String)fileMap.get(".jpg");
            }
            if (StringUtil.isEmpty((String)var7_15)) {
                return Response.error((String)"\u672a\u8bfb\u53d6\u5230\u6805\u683c\u6570\u636e");
            }
            RasterInfo rasterInfo = WorkspaceUtil.readRasterInfo((String)var7_15);
            TempRasterInfo tempRasterInfo = new TempRasterInfo();
            tempRasterInfo.setExtent(GeoDatasetUtil.toExtentDTO((IEnvelope)rasterInfo.getExtent()));
            tempRasterInfo.setBandCount(rasterInfo.getBandCount());
            tempRasterInfo.setUrl(String.format("/datasource/util/temp/view/%s/%s", id, FileUtil.getFileName((String)var7_15)));
            return Response.ok((Object)tempRasterInfo);
        }
        catch (Exception e) {
            log.error("\u5f71\u50cf\u8bfb\u53d6\u5931\u8d25", (Throwable)e);
            return Response.error((String)("\u5f71\u50cf\u8bfb\u53d6\u5931\u8d25:" + e.getMessage()));
        }
    }

    @ApiOperation(value="05-\u4e0a\u4f20\u4e34\u65f6\u6587\u4ef6", notes="\u4e0a\u4f20\u4e34\u65f6\u6587\u4ef6\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\uff0c\u6587\u4ef6\u5927\u5c0f\u4e0d\u8d85\u8fc710MB")
    @UploadFileCheck
    @PostMapping(value={"/datasource/util/temp/fileInfo"})
    public Response<TempFileInfo> uploadTempFile(@RequestPart MultipartFile file) {
        if (file.getSize() > 0xA00000L) {
            return Response.error((String)"\u6587\u4ef6\u4e0d\u80fd\u5927\u4e8e5MB");
        }
        String fileName = file.getOriginalFilename();
        try {
            String id = UUID.randomUUID().toString();
            Path localPath = UploadPathConfig.getUploadPath().resolve(id);
            localPath.toFile().mkdirs();
            Path localFile = localPath.resolve(Paths.get(fileName, new String[0]));
            file.transferTo(localFile);
            TempFileInfo tempFileInfo = new TempFileInfo();
            tempFileInfo.setFileName(fileName);
            tempFileInfo.setFileSize(DataSizeUtil.format((long)file.getSize()));
            tempFileInfo.setUrl(String.format("/datasource/util/temp/view/%s/%s", id, fileName));
            return Response.ok((Object)tempFileInfo);
        }
        catch (Exception e) {
            log.error(fileName + "\u8bfb\u53d6\u5931\u8d25", (Throwable)e);
            return Response.error((String)(fileName + "\u8bfb\u53d6\u5931\u8d25:" + e.getMessage()));
        }
    }

    @ApiOperation(value="06-\u9884\u89c8\u4e34\u65f6\u6587\u4ef6")
    @GetMapping(value={"/datasource/util/temp/view/{id}/{fileName}"})
    public void viewTempFile(@PathVariable String id, @PathVariable String fileName, HttpServletRequest request, HttpServletResponse response) {
        Path tempPath = UploadPathConfig.getUploadPath().resolve(id);
        Path tempFile = tempPath.resolve(Paths.get(fileName, new String[0]));
        FileViewerUtil.viewFile((File)tempFile.toFile(), (HttpServletRequest)request, (HttpServletResponse)response);
    }

    @ApiOperation(value="07-\u51e0\u4f55\u56fe\u5f62\u7f13\u51b2")
    @PostMapping(value={"/datasource/util/geometry/buffer"})
    public Response<List<String>> bufferGeometry(BufferWKT bufferWKT) {
        ArrayList<String> bufferWkts = new ArrayList<String>();
        for (String strWkt : bufferWKT.wkts) {
            IGeometry geometry = GeometryFunc.createGeometry((String)strWkt);
            if (geometry == null) continue;
            geometry = geometry.buffer(bufferWKT.distance.doubleValue());
            bufferWkts.add(geometry.toWkt());
        }
        return Response.ok(bufferWkts);
    }

    @ApiOperation(value="08-\u51e0\u4f55\u56fe\u5f62\u6295\u5f71\u8f6c\u6362")
    @PostMapping(value={"/datasource/util/geometry/project"})
    public Response<List<String>> bufferGeometry(@RequestBody GeometryProject geometryProject) {
        Integer targetSrid;
        Integer srcSrid = geometryProject.getSrcSrid();
        if (srcSrid.equals(targetSrid = geometryProject.getTargetSrid())) {
            return Response.ok(geometryProject.getWkts());
        }
        ISpatialReferenceSystem srcSrs = SpatialReferenceSystemFunc.createSpatialReference((int)srcSrid);
        ISpatialReferenceSystem targetSrs = SpatialReferenceSystemFunc.createSpatialReference((int)targetSrid);
        ArrayList<String> projectWkts = new ArrayList<String>();
        for (String strWkt : geometryProject.getWkts()) {
            IGeometry geometry = GeometryFunc.createGeometry((String)strWkt);
            if (geometry == null || (geometry = geometry.projectToCopy(srcSrs, targetSrs)) == null) continue;
            projectWkts.add(geometry.toWkt());
        }
        return Response.ok(projectWkts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="09-\u51e0\u4f55\u56fe\u5f62\u5bfc\u51fa\u5230shpfile")
    @PostMapping(value={"/datasource/util/geometry/export"})
    public Response<String> exportGeometry2Shpfile(@RequestBody GeometryExport geometryExport) {
        ISpatialReferenceSystem srcSrs = SpatialReferenceSystemFunc.createSpatialReference((int)geometryExport.getSrcSrid());
        ISpatialReferenceSystem targetSrs = SpatialReferenceSystemFunc.createSpatialReference((int)geometryExport.getTargetSrid());
        String tempId = "geometry_out_" + UUID.randomUUID();
        Path outputPath = OutputPathConfig.getOutputPath();
        outputPath = outputPath.resolve(tempId);
        File file = outputPath.toFile();
        String outputName = geometryExport.getOutputName();
        IFeatureWorkspace workspace = WorkspaceUtil.createLocalFileGeodatabase((String)file.getAbsolutePath());
        IFeatureClass pointFC = null;
        IFeatureClass lineFC = null;
        IFeatureClass polygonFC = null;
        IFeatureCursor pointCursor = null;
        IFeatureCursor lineCursor = null;
        IFeatureCursor polygonCursor = null;
        try {
            for (String strWkt : geometryExport.getWkts()) {
                IGeometry geometry = GeometryFunc.createGeometry((String)strWkt);
                if (geometry == null) {
                    throw new RuntimeException("\u51e0\u4f55\u56fe\u5f62\u4e0d\u6b63\u786e");
                }
                if ((geometry = geometry.projectToCopy(srcSrs, targetSrs)) == null) continue;
                switch (FeatureType.getByGeometryType((GeometryType)geometry.getType())) {
                    case Point: {
                        if (pointFC == null) {
                            Fields fields = new Fields();
                            fields.addField(FieldUtil.buildObjectIdField((String)"objectid", (String)"objectid"));
                            fields.addField(FieldUtil.buildShapeField((String)"shape", (String)"shape", (GeometryType)GeometryType.Point, (int)geometryExport.getTargetSrid()));
                            pointFC = workspace.createFeatureClass(outputName + "_p", (IFields)fields, FeatureType.Point, "shape", null);
                            pointCursor = pointFC.insertFeature();
                        }
                        IFeature point = pointFC.createFeature();
                        point.setGeometry(geometry);
                        pointCursor.insertFeature(point);
                        break;
                    }
                    case Polyline: {
                        if (lineFC == null) {
                            Fields fields = new Fields();
                            fields.addField(FieldUtil.buildObjectIdField((String)"objectid", (String)"objectid"));
                            fields.addField(FieldUtil.buildShapeField((String)"shape", (String)"shape", (GeometryType)GeometryType.Polyline, (int)geometryExport.getTargetSrid()));
                            lineFC = workspace.createFeatureClass(outputName + "_l", (IFields)fields, FeatureType.Polyline, "shape", null);
                            lineCursor = lineFC.insertFeature();
                        }
                        IFeature line = lineFC.createFeature();
                        line.setGeometry(geometry);
                        lineCursor.insertFeature(line);
                        break;
                    }
                    case Polygon: {
                        if (polygonFC == null) {
                            Fields fields = new Fields();
                            fields.addField(FieldUtil.buildObjectIdField((String)"objectid", (String)"objectid"));
                            fields.addField(FieldUtil.buildShapeField((String)"shape", (String)"shape", (GeometryType)GeometryType.Polygon, (int)geometryExport.getTargetSrid()));
                            polygonFC = workspace.createFeatureClass(outputName + "_a", (IFields)fields, FeatureType.Polygon, "shape", null);
                            polygonCursor = polygonFC.insertFeature();
                        }
                        IFeature polygon = polygonFC.createFeature();
                        polygon.setGeometry(geometry);
                        polygonCursor.insertFeature(polygon);
                    }
                }
            }
        }
        finally {
            if (pointCursor != null) {
                pointCursor.release();
            }
            if (lineCursor != null) {
                lineCursor.release();
            }
            if (polygonCursor != null) {
                polygonCursor.release();
            }
            if (workspace != null) {
                workspace.close();
            }
        }
        return Response.ok((Object)tempId);
    }

    public static class GeometryExport {
        private List<String> wkts;
        private String outputName;
        private Integer srcSrid = 4490;
        private Integer targetSrid = 4490;

        public List<String> getWkts() {
            return this.wkts;
        }

        public String getOutputName() {
            return this.outputName;
        }

        public Integer getSrcSrid() {
            return this.srcSrid;
        }

        public Integer getTargetSrid() {
            return this.targetSrid;
        }

        public void setWkts(List<String> wkts) {
            this.wkts = wkts;
        }

        public void setOutputName(String outputName) {
            this.outputName = outputName;
        }

        public void setSrcSrid(Integer srcSrid) {
            this.srcSrid = srcSrid;
        }

        public void setTargetSrid(Integer targetSrid) {
            this.targetSrid = targetSrid;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GeometryExport)) {
                return false;
            }
            GeometryExport other = (GeometryExport)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$srcSrid = this.getSrcSrid();
            Integer other$srcSrid = other.getSrcSrid();
            if (this$srcSrid == null ? other$srcSrid != null : !((Object)this$srcSrid).equals(other$srcSrid)) {
                return false;
            }
            Integer this$targetSrid = this.getTargetSrid();
            Integer other$targetSrid = other.getTargetSrid();
            if (this$targetSrid == null ? other$targetSrid != null : !((Object)this$targetSrid).equals(other$targetSrid)) {
                return false;
            }
            List<String> this$wkts = this.getWkts();
            List<String> other$wkts = other.getWkts();
            if (this$wkts == null ? other$wkts != null : !((Object)this$wkts).equals(other$wkts)) {
                return false;
            }
            String this$outputName = this.getOutputName();
            String other$outputName = other.getOutputName();
            return !(this$outputName == null ? other$outputName != null : !this$outputName.equals(other$outputName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GeometryExport;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $srcSrid = this.getSrcSrid();
            result = result * 59 + ($srcSrid == null ? 43 : ((Object)$srcSrid).hashCode());
            Integer $targetSrid = this.getTargetSrid();
            result = result * 59 + ($targetSrid == null ? 43 : ((Object)$targetSrid).hashCode());
            List<String> $wkts = this.getWkts();
            result = result * 59 + ($wkts == null ? 43 : ((Object)$wkts).hashCode());
            String $outputName = this.getOutputName();
            result = result * 59 + ($outputName == null ? 43 : $outputName.hashCode());
            return result;
        }

        public String toString() {
            return "CommonUtilController.GeometryExport(wkts=" + this.getWkts() + ", outputName=" + this.getOutputName() + ", srcSrid=" + this.getSrcSrid() + ", targetSrid=" + this.getTargetSrid() + ")";
        }
    }

    public static class GeometryProject {
        private List<String> wkts;
        private Integer srcSrid = 4490;
        private Integer targetSrid = 4490;

        public List<String> getWkts() {
            return this.wkts;
        }

        public Integer getSrcSrid() {
            return this.srcSrid;
        }

        public Integer getTargetSrid() {
            return this.targetSrid;
        }

        public void setWkts(List<String> wkts) {
            this.wkts = wkts;
        }

        public void setSrcSrid(Integer srcSrid) {
            this.srcSrid = srcSrid;
        }

        public void setTargetSrid(Integer targetSrid) {
            this.targetSrid = targetSrid;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GeometryProject)) {
                return false;
            }
            GeometryProject other = (GeometryProject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$srcSrid = this.getSrcSrid();
            Integer other$srcSrid = other.getSrcSrid();
            if (this$srcSrid == null ? other$srcSrid != null : !((Object)this$srcSrid).equals(other$srcSrid)) {
                return false;
            }
            Integer this$targetSrid = this.getTargetSrid();
            Integer other$targetSrid = other.getTargetSrid();
            if (this$targetSrid == null ? other$targetSrid != null : !((Object)this$targetSrid).equals(other$targetSrid)) {
                return false;
            }
            List<String> this$wkts = this.getWkts();
            List<String> other$wkts = other.getWkts();
            return !(this$wkts == null ? other$wkts != null : !((Object)this$wkts).equals(other$wkts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GeometryProject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $srcSrid = this.getSrcSrid();
            result = result * 59 + ($srcSrid == null ? 43 : ((Object)$srcSrid).hashCode());
            Integer $targetSrid = this.getTargetSrid();
            result = result * 59 + ($targetSrid == null ? 43 : ((Object)$targetSrid).hashCode());
            List<String> $wkts = this.getWkts();
            result = result * 59 + ($wkts == null ? 43 : ((Object)$wkts).hashCode());
            return result;
        }

        public String toString() {
            return "CommonUtilController.GeometryProject(wkts=" + this.getWkts() + ", srcSrid=" + this.getSrcSrid() + ", targetSrid=" + this.getTargetSrid() + ")";
        }
    }

    public static class BufferWKT {
        private List<String> wkts;
        private Double distance;

        public List<String> getWkts() {
            return this.wkts;
        }

        public Double getDistance() {
            return this.distance;
        }

        public void setWkts(List<String> wkts) {
            this.wkts = wkts;
        }

        public void setDistance(Double distance) {
            this.distance = distance;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BufferWKT)) {
                return false;
            }
            BufferWKT other = (BufferWKT)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$distance = this.getDistance();
            Double other$distance = other.getDistance();
            if (this$distance == null ? other$distance != null : !((Object)this$distance).equals(other$distance)) {
                return false;
            }
            List<String> this$wkts = this.getWkts();
            List<String> other$wkts = other.getWkts();
            return !(this$wkts == null ? other$wkts != null : !((Object)this$wkts).equals(other$wkts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BufferWKT;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $distance = this.getDistance();
            result = result * 59 + ($distance == null ? 43 : ((Object)$distance).hashCode());
            List<String> $wkts = this.getWkts();
            result = result * 59 + ($wkts == null ? 43 : ((Object)$wkts).hashCode());
            return result;
        }

        public String toString() {
            return "CommonUtilController.BufferWKT(wkts=" + this.getWkts() + ", distance=" + this.getDistance() + ")";
        }
    }

    public class TempFileInfo {
        private String url;
        private String fileName;
        private String fileSize;

        public String getUrl() {
            return this.url;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFileSize() {
            return this.fileSize;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setFileSize(String fileSize) {
            this.fileSize = fileSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TempFileInfo)) {
                return false;
            }
            TempFileInfo other = (TempFileInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                return false;
            }
            String this$fileSize = this.getFileSize();
            String other$fileSize = other.getFileSize();
            return !(this$fileSize == null ? other$fileSize != null : !this$fileSize.equals(other$fileSize));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TempFileInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            String $fileSize = this.getFileSize();
            result = result * 59 + ($fileSize == null ? 43 : $fileSize.hashCode());
            return result;
        }

        public String toString() {
            return "CommonUtilController.TempFileInfo(url=" + this.getUrl() + ", fileName=" + this.getFileName() + ", fileSize=" + this.getFileSize() + ")";
        }
    }

    public class TempRasterInfo {
        private String url;
        private ExtentDTO extent;
        private Integer bandCount;

        public String getUrl() {
            return this.url;
        }

        public ExtentDTO getExtent() {
            return this.extent;
        }

        public Integer getBandCount() {
            return this.bandCount;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setExtent(ExtentDTO extent) {
            this.extent = extent;
        }

        public void setBandCount(Integer bandCount) {
            this.bandCount = bandCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TempRasterInfo)) {
                return false;
            }
            TempRasterInfo other = (TempRasterInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$bandCount = this.getBandCount();
            Integer other$bandCount = other.getBandCount();
            if (this$bandCount == null ? other$bandCount != null : !((Object)this$bandCount).equals(other$bandCount)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            ExtentDTO this$extent = this.getExtent();
            ExtentDTO other$extent = other.getExtent();
            return !(this$extent == null ? other$extent != null : !this$extent.equals(other$extent));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TempRasterInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $bandCount = this.getBandCount();
            result = result * 59 + ($bandCount == null ? 43 : ((Object)$bandCount).hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            ExtentDTO $extent = this.getExtent();
            result = result * 59 + ($extent == null ? 43 : $extent.hashCode());
            return result;
        }

        public String toString() {
            return "CommonUtilController.TempRasterInfo(url=" + this.getUrl() + ", extent=" + this.getExtent() + ", bandCount=" + this.getBandCount() + ")";
        }
    }
}

