/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.datasource;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.entity.DsBackup;
import com.geoway.adf.dms.datasource.service.DataSourceBackupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource/backup"})
@Api(tags={"01.12-\u6570\u636e\u6e90\u5907\u4efd"})
public class DataSourceBackupController {
    @Resource
    private DataSourceBackupService dataSourceBackupService;

    @ApiOperation(value="01-\u83b7\u53d6\u53ef\u5907\u4efd\u7684\u6570\u636e\u5e93\u5217\u8868")
    @GetMapping(value={"/list"})
    public Response<List<DataSourceDTO>> listDataSource(@RequestParam(required=false) String dataStoreTypes, @RequestParam(required=false) String keyword) {
        List storeTypes = null;
        if (StringUtil.isNotEmpty((String)dataStoreTypes)) {
            storeTypes = StringUtil.split((String)dataStoreTypes, (String)",", t -> DataStoreTypeEnum.getByValue((Integer)Integer.valueOf(t)));
        }
        return Response.ok((Object)this.dataSourceBackupService.listDataSource(storeTypes, keyword));
    }

    @ApiOperation(value="02-\u5907\u4efd")
    @PostMapping(value={""})
    public Response<Boolean> listDataSource(String dsKey) {
        return Response.ok((Object)this.dataSourceBackupService.backup(dsKey, ""));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u5907\u4efd\u8bb0\u5f55")
    @GetMapping(value={"/record"})
    public Response<List<DsBackup>> listBackupRecords(@RequestParam String dsKey) {
        return Response.ok((Object)this.dataSourceBackupService.listBackupRecords(dsKey));
    }
}

