/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.datasource;

import com.geoway.adf.dms.api.action.check.UploadFileCheck;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.file.FileDTO;
import com.geoway.adf.dms.datasource.dto.file.FileDataTypeEnum;
import com.geoway.adf.dms.datasource.dto.file.FileDetailDTO;
import com.geoway.adf.dms.datasource.dto.file.FilePermissionDTO;
import com.geoway.adf.dms.datasource.dto.file.SelectFileDataDTO;
import com.geoway.adf.dms.datasource.dto.file.VectorLayerDTO;
import com.geoway.adf.dms.datasource.service.FileStorageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/datasource/filestorage"})
@Api(tags={"01.04-\u6587\u4ef6\u5b58\u50a8"})
public class FileStorageController {
    @Resource
    private FileStorageService fileStorageService;

    @ApiOperation(value="01-\u83b7\u53d6\u6587\u4ef6\u5b58\u50a8\u8fde\u63a5\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="types", value="\u6570\u636e\u6e90\u7c7b\u578b\uff0c\u591a\u4e2a\u9017\u53f7\u5206\u9694(31-HDFS; 32-\u5171\u4eab\u76ee\u5f55; 33-FTP; 34-MinIO; 35-OBS; 36-OSS; 37-S3)", paramType="query"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query")})
    @GetMapping(value={"/list"})
    public Response<List<DataSourceDTO>> list(@RequestParam(required=false) String types, @RequestParam(required=false) String keyword) {
        List sourceTypes = null;
        if (StringUtil.isNotEmpty((String)types)) {
            sourceTypes = StringUtil.split((String)types, (String)",", t -> DataSourceTypeEnum.getByValue((Integer)Integer.valueOf(t)));
        }
        List databaseDTOList = this.fileStorageService.listFileStorage(sourceTypes, keyword);
        return Response.ok((Object)databaseDTOList);
    }

    @ApiOperation(value="02-\u83b7\u53d6\u6307\u5b9a\u8def\u5f84\u4e0b\u7684\u6587\u4ef6\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="path", value="\u8def\u5f84", required=true, paramType="query", example="\\\\172.16.67.66\\\u6d4b\u8bd5\u6570\u636e")})
    @GetMapping(value={"/file/list"})
    public Response<List<FileDTO>> listFile(@RequestParam String key, @RequestParam String path) {
        return Response.ok((Object)this.fileStorageService.listFile(key, path));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u6587\u4ef6\u5c5e\u6027")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="path", value="\u8def\u5f84", required=true, paramType="query", example="\\\\172.16.67.66\\\u6d4b\u8bd5\u6570\u636e\\test1208new.mbtiles")})
    @GetMapping(value={"/file/detail"})
    public Response<FileDetailDTO> getFileDetail(@RequestParam String key, @RequestParam String path) {
        return Response.ok((Object)this.fileStorageService.getFileDetail(key, path));
    }

    @ApiOperation(value="04-\u83b7\u53d6\u6587\u4ef6\u6743\u9650")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="path", value="\u8def\u5f84", required=true, paramType="query", example="\\\\172.16.67.66\\\u6d4b\u8bd5\u6570\u636e\\test1208new.mbtiles")})
    @GetMapping(value={"/file/permission"})
    public Response<FilePermissionDTO> getFilePermission(@RequestParam String key, @RequestParam String path) {
        return Response.ok((Object)this.fileStorageService.getFilePermission(key, path));
    }

    @ApiOperation(value="05-\u521b\u5efa\u6587\u4ef6\u5939")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="path", value="\u8def\u5f84", required=true, paramType="query", example="\\\\172.16.67.66\\\u6d4b\u8bd5\u6570\u636e\\\u4e34\u65f6\u6587\u4ef6"), @ApiImplicitParam(name="dirName", value="\u6587\u4ef6\u5939\u540d\u79f0", required=true, paramType="query")})
    @PostMapping(value={"/createdir"})
    public Response<FileDTO> createDirectory(@RequestParam String key, @RequestParam String path, @RequestParam String dirName) {
        return Response.ok((Object)this.fileStorageService.createDirectory(key, path, dirName));
    }

    @ApiOperation(value="06-\u5220\u9664\u6587\u4ef6\u6216\u6587\u4ef6\u5939")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="path", value="\u8def\u5f84", required=true, paramType="query", example="\\\\172.16.67.66\\\u6d4b\u8bd5\u6570\u636e\\\u4e34\u65f6\u6587\u4ef6\\test123"), @ApiImplicitParam(name="password", value="\u5220\u9664\u53e3\u4ee4", paramType="query")})
    @PostMapping(value={"/file/delete"})
    public Response deleteFile(@RequestParam String key, @RequestParam String path, @RequestParam(required=false) String password) {
        if (this.fileStorageService.deleteFile(key, path, password)) {
            return Response.ok();
        }
        return Response.error((String)"");
    }

    @ApiOperation(value="07-\u6279\u91cf\u5220\u9664\u6587\u4ef6\u6216\u6587\u4ef6\u5939")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6587\u4ef6\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="paths", value="\u8def\u5f84\u5217\u8868", dataTypeClass=List.class, allowMultiple=true, required=true, paramType="query"), @ApiImplicitParam(name="password", value="\u5220\u9664\u53e3\u4ee4", required=true, paramType="query")})
    @PostMapping(value={"/file/delete-batch"})
    public Response batchDeleteFile(@RequestParam String key, @RequestParam List<String> paths, @RequestParam String password) {
        this.fileStorageService.batchDeleteFile(key, paths, password);
        return Response.ok();
    }

    @ApiOperation(value="08-\u9009\u62e9\u6587\u4ef6\u5b58\u50a8\u4e0a\u7684\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u6587\u4ef6\u5b58\u50a8\u6570\u636e\u6e90\u6807\u8bc6", required=false), @ApiImplicitParam(name="path", value="\u8def\u5f84", required=true, paramType="query", example="\\\\172.16.67.66\\data\\\u77e2\u91cf"), @ApiImplicitParam(name="filterTypes", value="\u9009\u62e9\u7c7b\u578b\uff0c\u591a\u4e2a\u9017\u53f7\u9694\u5f00", required=true, paramType="query", allowableValues="com.geoway.adf.dms.datasource.dto.file.FileDataTypeEnum"), @ApiImplicitParam(name="customFileExts", value="\u81ea\u5b9a\u4e49\u7c7b\u578b\u6587\u4ef6\u540e\u7f00\uff0c\u591a\u4e2a\u9017\u53f7\u9694\u5f00", example=".txt,.mat")})
    @GetMapping(value={"/selectfile/list"})
    public Response<List<SelectFileDataDTO>> selectFiles(@RequestParam(required=false) String dsKey, @RequestParam String path, @RequestParam(defaultValue="0") String filterTypes, @RequestParam(required=false) String customFileExts) {
        List fileTypes = StringUtil.split((String)filterTypes, (String)",", t -> FileDataTypeEnum.getByValue((Integer)Integer.valueOf(t)));
        return Response.ok((Object)this.fileStorageService.selectFiles(dsKey, path, fileTypes, customFileExts));
    }

    @ApiOperation(value="09-\u4e0a\u4f20\u5f85\u9009\u62e9\u7684\u6587\u4ef6", notes="\u4e0a\u4f20\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u4e0a\u4f20\u7684\u6587\u4ef6", required=true, dataTypeClass=MultipartFile.class), @ApiImplicitParam(name="uuid", value="\u6807\u8bc6id", example="12d161ef-d5d4-4d24-89a3-14967d9f1aa9", required=true), @ApiImplicitParam(name="unzip", value="\u4e0a\u4f20\u540e\u662f\u5426\u89e3\u538b", defaultValue="true")})
    @UploadFileCheck
    @PostMapping(value={"/selectfile/upload"})
    public Response<String> uploadSelectFile(@RequestPart MultipartFile file, @RequestParam(required=true) String uuid, @RequestParam(required=false, defaultValue="true") Boolean unzip) {
        return Response.ok((Object)this.fileStorageService.uploadSelectFile(file, uuid, unzip));
    }

    @ApiOperation(value="10-\u9009\u62e9\u4e0a\u4f20\u540e\u7684\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="uuid", value="\u4e0a\u4f20\u6807\u8bc6id", required=true, paramType="query", example="12d161ef-d5d4-4d24-89a3-14967d9f1aa9"), @ApiImplicitParam(name="filterTypes", value="\u9009\u62e9\u7c7b\u578b\uff0c\u591a\u4e2a\u9017\u53f7\u9694\u5f00", required=true, paramType="query", allowableValues="com.geoway.adf.dms.datasource.dto.file.FileDataTypeEnum"), @ApiImplicitParam(name="customFileExts", value="\u81ea\u5b9a\u4e49\u7c7b\u578b\u6587\u4ef6\u540e\u7f00\uff0c\u591a\u4e2a\u9017\u53f7\u9694\u5f00", example=".txt,.mat")})
    @GetMapping(value={"/selectfile/listupload"})
    public Response<List<SelectFileDataDTO>> listUploadFile(@RequestParam String uuid, @RequestParam String filterTypes, @RequestParam(required=false) String customFileExts) {
        List fileTypes = StringUtil.split((String)filterTypes, (String)",", t -> FileDataTypeEnum.getByValue((Integer)Integer.valueOf(t)));
        return Response.ok((Object)this.fileStorageService.listUploadFile(uuid, fileTypes, customFileExts));
    }

    @ApiOperation(value="11-\u83b7\u53d6\u77e2\u91cf\u56fe\u5c42\u4fe1\u606f\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u6587\u4ef6\u5b58\u50a8\u6570\u636e\u6e90\u6807\u8bc6", required=false), @ApiImplicitParam(name="path", value="\u8def\u5f84", required=true, paramType="query", example="\\\\172.16.67.66\\data\\\u77e2\u91cf\\\u4e2d\u56fd\u6cb3\u6d41.gdb"), @ApiImplicitParam(name="withFields", value="\u662f\u5426\u8fd4\u56de\u5b57\u6bb5\u4fe1\u606f", paramType="query")})
    @GetMapping(value={"/selectfile/listvectorlayer"})
    public Response<List<VectorLayerDTO>> listFileLayerInfo(@RequestParam(required=false) String dsKey, @RequestParam String path, @RequestParam(required=false, defaultValue="false") Boolean withFields) {
        return Response.ok((Object)this.fileStorageService.listFileVectorLayer(dsKey, path, withFields));
    }

    @ApiOperation(value="12-\u83b7\u53d6\u77e2\u91cf\u56fe\u5c42\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u6587\u4ef6\u5b58\u50a8\u6570\u636e\u6e90\u6807\u8bc6", required=false), @ApiImplicitParam(name="path", value="\u8def\u5f84", required=true, paramType="query", example="\\\\172.16.67.66\\data\\\u77e2\u91cf\\\u4e2d\u56fd\u6cb3\u6d41.gdb\\\u4e2d\u56fd\u6cb3\u6d41"), @ApiImplicitParam(name="withFields", value="\u662f\u5426\u8fd4\u56de\u5b57\u6bb5\u4fe1\u606f", paramType="query")})
    @GetMapping(value={"/selectfile/vectorlayerinfo"})
    public Response<VectorLayerDTO> getFileLayerInfo(@RequestParam(required=false) String dsKey, @RequestParam String path, @RequestParam(required=false, defaultValue="false") Boolean withFields) {
        return Response.ok((Object)this.fileStorageService.getFileVectorLayer(dsKey, path, withFields));
    }

    @ApiOperation(value="13-\u83b7\u53d6\u77e2\u91cf/\u8868\u683c\u56fe\u5c42\u5b57\u6bb5\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u6587\u4ef6\u5b58\u50a8\u6570\u636e\u6e90\u6807\u8bc6", required=false), @ApiImplicitParam(name="path", value="\u8def\u5f84", required=true, paramType="query", example="\\\\172.16.66.152\\webstore_data\\\u7efc\u5408\u5e93\u6d4b\u8bd5\u6570\u636e\\\u529f\u80fd\u6d4b\u8bd5\\\u5143\u6570\u636e\u6a21\u677f\u6d4b\u8bd5\\\u5143\u6570\u636e\u6a21\u677f-web.xlsx")})
    @GetMapping(value={"/selectfile/listfield"})
    public Response<List<FieldDTO>> listFileField(@RequestParam(required=false) String dsKey, @RequestParam String path) {
        return Response.ok((Object)this.fileStorageService.listFileLayerField(dsKey, path));
    }

    @ApiOperation(value="14-\u83b7\u53d6\u6570\u636e\u96c6\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true), @ApiImplicitParam(name="path", value="\u6570\u636e\u8def\u5f84", required=true)})
    @GetMapping(value={"/datasets"})
    public Response<List<SimpleDatasetDTO>> listDataset(@RequestParam String key, @RequestParam String path) {
        return Response.ok((Object)this.fileStorageService.listDatasets(key, path));
    }

    @ApiOperation(value="15-\u9884\u89c8\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u6570\u636e\u6e90key"), @ApiImplicitParam(name="filePath", value="\u6587\u4ef6\u8def\u5f84")})
    @GetMapping(value={"/view"})
    public void viewFile(String dsKey, String filePath, HttpServletRequest request, HttpServletResponse response) {
        this.fileStorageService.viewFile(dsKey, filePath, request, response);
    }

    @ApiOperation(value="16-\u6587\u4ef6\u4e0b\u8f7d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u6570\u636e\u6e90key"), @ApiImplicitParam(name="filePath", value="\u6587\u4ef6\u8def\u5f84")})
    @GetMapping(value={"/download"})
    public void downloadFile(String dsKey, String filePath, HttpServletRequest request, HttpServletResponse response) {
        this.fileStorageService.downloadFile(dsKey, filePath, request, response);
    }

    @ApiOperation(value="17-\u6587\u4ef6\u6279\u91cf\u4e0b\u8f7d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u6570\u636e\u6e90key"), @ApiImplicitParam(name="filePaths", value="\u6587\u4ef6\u8def\u5f84\u5217\u8868", dataTypeClass=List.class, allowMultiple=true)})
    @PostMapping(value={"/download-batch"})
    public void batchDownloadFile(@RequestParam String dsKey, @RequestParam List<String> filePaths, HttpServletRequest request, HttpServletResponse response) {
        this.fileStorageService.batchDownloadFile(dsKey, filePaths, request, response);
    }

    @ApiOperation(value="18-\u4e0a\u4f20\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u4e0a\u4f20\u7684\u6587\u4ef6", required=true, dataTypeClass=MultipartFile.class), @ApiImplicitParam(name="dbKey", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true), @ApiImplicitParam(name="tarPath", value="\u5bfc\u5165\u7684\u76ee\u6807\u8def\u5f84", required=true), @ApiImplicitParam(name="overwrite", value="\u662f\u5426\u8986\u76d6\u5df2\u6709\u6587\u4ef6", defaultValue="true")})
    @UploadFileCheck
    @PostMapping(value={"/file/upload"})
    public void uploadSelectFile(@RequestPart MultipartFile file, @RequestParam String dbKey, @RequestParam String tarPath, @RequestParam(required=false, defaultValue="true") Boolean overwrite) {
        this.fileStorageService.uploadFile(file, dbKey, tarPath, overwrite);
    }
}

