/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.catalog;

import com.geoway.adf.dms.api.action.check.UploadFileCheck;
import com.geoway.adf.dms.catalog.dto.view.ViewSchemaCreateDTO;
import com.geoway.adf.dms.catalog.dto.view.ViewSchemaDTO;
import com.geoway.adf.dms.catalog.service.ViewSchemaService;
import com.geoway.adf.dms.common.web.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/catalog/browse"})
@Api(tags={"03.04-\u5e94\u7528\u76ee\u5f55-\u663e\u793a\u65b9\u6848(\u4e66\u7b7e)"})
public class MapViewSchemaController {
    @Resource
    private ViewSchemaService viewSchemaService;

    @ApiOperation(value="01-\u83b7\u53d6\u663e\u793a\u65b9\u6848\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyword", value="\u5173\u952e\u8bcd")})
    @GetMapping(value={"/view/schemas"})
    public Response<List<ViewSchemaDTO>> getViewSchemaList(@RequestParam(required=false) String keyword, @RequestParam(required=false, defaultValue="false") Boolean withPicture) {
        return Response.ok((Object)this.viewSchemaService.listViewSchema(keyword, withPicture));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u663e\u793a\u65b9\u6848\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="schemaId", value="\u663e\u793a\u65b9\u6848\u6807\u8bc6", required=true)})
    @GetMapping(value={"/view/schema"})
    public Response<ViewSchemaDTO> getViewSchemaDetail(@RequestParam Long schemaId) {
        return Response.ok((Object)this.viewSchemaService.getViewSchemaDetail(schemaId));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u663e\u793a\u65b9\u6848\u5206\u7ec4")
    @GetMapping(value={"/view/schema/groups"})
    public Response<List<String>> getViewSchemaGroupList() {
        return Response.ok((Object)this.viewSchemaService.groupList());
    }

    @ApiOperation(value="04-\u65b0\u589e\u663e\u793a\u65b9\u6848")
    @UploadFileCheck(supportedSuffixes={".png", ".jpg", ".svg"})
    @PostMapping(value={"/view/schema"})
    public Response addViewSchema(@RequestParam String name, @RequestParam(required=false) String groupName, @RequestParam Short catalogModel, @RequestParam String appCatalogId, @RequestParam(required=false) String cardId, @RequestParam(required=false) String layerInfo, @RequestParam(required=false) String location, @RequestParam(required=false) String chartUrl, @RequestParam(required=false) Boolean isPublic, @RequestPart(required=false) MultipartFile picture) {
        ViewSchemaCreateDTO createDTO = new ViewSchemaCreateDTO();
        createDTO.setName(name);
        createDTO.setGroupName(groupName);
        createDTO.setCatalogModel(catalogModel);
        createDTO.setAppCatalogId(appCatalogId);
        createDTO.setCardId(cardId);
        createDTO.setLayerInfo(layerInfo);
        createDTO.setLocation(location);
        createDTO.setChartUrl(chartUrl);
        createDTO.setPicture(picture);
        createDTO.setIsPublic(isPublic);
        this.viewSchemaService.addOrUpdateViewSchema(createDTO, Boolean.valueOf(false));
        return Response.ok();
    }

    @ApiOperation(value="05-\u66f4\u65b0\u663e\u793a\u65b9\u6848")
    @UploadFileCheck(supportedSuffixes={".png", ".jpg", ".svg"})
    @PutMapping(value={"/view/schema"})
    public Response updateViewSchema(@RequestParam Long schemaId, @RequestParam String name, @RequestParam(required=false) String groupName, @RequestParam Short catalogModel, @RequestParam String appCatalogId, @RequestParam(required=false) String cardId, @RequestParam(required=false) String layerInfo, @RequestParam(required=false) String location, @RequestParam(required=false) String chartUrl, @RequestParam(required=false) Boolean isPublic, @RequestPart(required=false) MultipartFile picture, @RequestParam(required=false, defaultValue="false") Boolean deletePicture) {
        ViewSchemaCreateDTO schemaDTO = new ViewSchemaCreateDTO();
        schemaDTO.setSchemaId(schemaId);
        schemaDTO.setName(name);
        schemaDTO.setGroupName(groupName);
        schemaDTO.setCatalogModel(catalogModel);
        schemaDTO.setAppCatalogId(appCatalogId);
        schemaDTO.setCardId(cardId);
        schemaDTO.setLayerInfo(layerInfo);
        schemaDTO.setLocation(location);
        schemaDTO.setChartUrl(chartUrl);
        schemaDTO.setPicture(picture);
        schemaDTO.setIsPublic(isPublic);
        this.viewSchemaService.addOrUpdateViewSchema(schemaDTO, deletePicture);
        return Response.ok();
    }

    @ApiOperation(value="06-\u5220\u9664\u663e\u793a\u65b9\u6848")
    @DeleteMapping(value={"/view/schema/{id}"})
    public Response deleteViewSchema(@PathVariable Long id) {
        this.viewSchemaService.deleteViewSchema(id);
        return Response.ok();
    }
}

