/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.datasource;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.dto.output.OutputDataResultDTO;
import com.geoway.adf.dms.datasource.dto.output.OutputParams;
import com.geoway.adf.dms.datasource.service.DataOutputService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource/output"})
@Api(tags={"01.15-\u6570\u636e\u5bfc\u51fa"})
public class DataOutputController {
    @Resource
    private DataOutputService dataOutputService;

    @ApiOperation(value="01-\u5bfc\u51fa\u5e76\u4e0b\u8f7d\u77e2\u91cf\u6570\u636e")
    @GetMapping(value={"/downloadvector"})
    public Response downloadVectorData(OutputParams outputParams) {
        this.dataOutputService.downloadVectorData(outputParams);
        return null;
    }

    @ApiOperation(value="02-\u5bfc\u51fa\u77e2\u91cf\u6570\u636e(\u5f02\u6b65)")
    @GetMapping(value={"/exportvector"})
    public Response<String> exportVectorData(OutputParams outputParams) {
        return Response.ok((Object)this.dataOutputService.exportVectorDataAsync(outputParams));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u6570\u636e\u5bfc\u51fa\u7ed3\u679c")
    @ApiImplicitParam(name="id", value="\u4efb\u52a1id", required=true, paramType="query")
    @GetMapping(value={"/status"})
    public Response<OutputDataResultDTO> getOutputResult(@RequestParam String id) {
        return Response.ok((Object)this.dataOutputService.getExportResult(id));
    }

    @ApiOperation(value="04-\u4e0b\u8f7d\u5bfc\u51fa\u7684\u6570\u636e")
    @ApiImplicitParam(name="id", value="\u4efb\u52a1id", required=true, paramType="query")
    @GetMapping(value={"/download"})
    public Response downloadData(@RequestParam String id) {
        this.dataOutputService.downloadExportData(id);
        return null;
    }
}

