/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.datasource;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.dto.edit.DataBatchDeleteDTO;
import com.geoway.adf.dms.datasource.dto.edit.DataBatchUpdateDTO;
import com.geoway.adf.dms.datasource.dto.edit.GeoDataEditDTO;
import com.geoway.adf.dms.datasource.service.GeoDatabaseEditService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource/geodb/edit"})
@Api(tags={"01.01-\u7a7a\u95f4\u6570\u636e\u5e93-\u6570\u636e\u7f16\u8f91"})
public class GeoDatabaseDataEditController {
    @Resource
    private GeoDatabaseEditService geoDatabaseEditService;

    @ApiOperation(value="01-\u63d2\u5165\u6570\u636e")
    @PostMapping(value={"/insert"})
    public Response<Object> insertData(@RequestBody GeoDataEditDTO geoDataEdit) {
        return Response.ok((Object)this.geoDatabaseEditService.insertData(geoDataEdit));
    }

    @ApiOperation(value="02-\u6279\u91cf\u63d2\u5165\u6570\u636e")
    @PostMapping(value={"/batchInsert"})
    public Response<Object> insertData(@RequestBody List<GeoDataEditDTO> geoDataEdits) {
        return Response.ok((Object)this.geoDatabaseEditService.batchInsertData(geoDataEdits));
    }

    @ApiOperation(value="03-\u66f4\u65b0\u6570\u636e")
    @PostMapping(value={"/update"})
    public Response<Boolean> updateData(@RequestBody GeoDataEditDTO geoDataEdit) {
        return Response.ok((Object)this.geoDatabaseEditService.updateData(geoDataEdit));
    }

    @ApiOperation(value="04-\u6279\u91cf\u66f4\u65b0\u6570\u636e")
    @PostMapping(value={"/batchUpdate"})
    public Response<Boolean> updateData(@RequestBody List<GeoDataEditDTO> geoDataEdits) {
        return Response.ok((Object)this.geoDatabaseEditService.batchUpdateData(geoDataEdits));
    }

    @ApiOperation(value="05-\u6839\u636e\u8fc7\u6ee4\u6761\u4ef6\u6279\u91cf\u66f4\u65b0\u6570\u636e")
    @PostMapping(value={"/batchUpdateByFilter"})
    public Response<Long> batchUpdateByFilter(@RequestBody DataBatchUpdateDTO dataBatchUpdateDTO) {
        return Response.ok((Object)this.geoDatabaseEditService.batchUpdateDataByFilter(dataBatchUpdateDTO));
    }

    @ApiOperation(value="06-\u5220\u9664\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="datasetId", value="\u6570\u636e\u96c6id", required=true, paramType="query"), @ApiImplicitParam(name="objectId", value="\u6570\u636eid\uff0c\u591a\u4e2a\u9017\u53f7\u5206\u5272", required=true, paramType="query"), @ApiImplicitParam(name="updateRenderIndex", value="\u662f\u5426\u66f4\u65b0\u6e32\u67d3\u7d22\u5f15", required=false, paramType="query")})
    @PostMapping(value={"/delete"})
    public Response<Boolean> deleteData(@RequestParam String datasetId, @RequestParam String objectId, @RequestParam(required=false, defaultValue="false") Boolean updateRenderIndex) {
        return Response.ok((Object)this.geoDatabaseEditService.deleteData(datasetId, objectId, updateRenderIndex));
    }

    @ApiOperation(value="07-\u6839\u636e\u8fc7\u6ee4\u6761\u4ef6\u6279\u91cf\u5220\u9664\u6570\u636e")
    @PostMapping(value={"/deleteByFilter"})
    public Response<Long> deleteByFilter(@RequestBody DataBatchDeleteDTO dataBatchDeleteDTO) {
        return Response.ok((Object)this.geoDatabaseEditService.deleteDataByFilter(dataBatchDeleteDTO));
    }
}

