/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.charts;

import com.geoway.adf.dms.charts.dto.StatDataResult;
import com.geoway.adf.dms.charts.dto.StatIndicatorClassEditDTO;
import com.geoway.adf.dms.charts.dto.StatIndicatorDTO;
import com.geoway.adf.dms.charts.dto.StatIndicatorSimpleDTO;
import com.geoway.adf.dms.charts.service.StatIndicatorService;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/chart/stat"})
@Api(tags={"07.01-\u56fe\u8868\u914d\u7f6e-\u7edf\u8ba1\u6307\u6807"})
public class StatIndicatorController {
    @Resource
    private StatIndicatorService countStatConfigService;

    @ApiOperation(value="01-\u83b7\u53d6\u7edf\u8ba1\u6307\u6807\u5217\u8868\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="withIndicator", value="\u662f\u5426\u8fd4\u56de\u6307\u6807"), @ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57")})
    @GetMapping(value={"/tree"})
    public Response<List<StatIndicatorSimpleDTO>> tree(@RequestParam(defaultValue="false") Boolean withIndicator, @RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.countStatConfigService.tree(withIndicator, keyword));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u5206\u7c7b\u8282\u70b9\u4e0b\u6240\u6709\u6307\u6807")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pid", value="\u7236\u5206\u7c7bid"), @ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57")})
    @GetMapping(value={"/indicator/list"})
    public Response<List<StatIndicatorDTO>> list(@RequestParam(required=false) String pid, @RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.countStatConfigService.listIndicator(pid, keyword));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u7edf\u8ba1\u6307\u6807\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7edf\u8ba1\u6307\u6807\u6807\u8bc6", required=true)})
    @GetMapping(value={"/indicator"})
    public Response<StatIndicatorDTO> getDetail(@RequestParam String id) {
        StatIndicatorDTO statIndicatorDTO = this.countStatConfigService.getIndicatorDetail(id);
        if (statIndicatorDTO == null) {
            throw new RuntimeException("\u7edf\u8ba1\u6307\u6807\u4e0d\u5b58\u5728\uff01");
        }
        return Response.ok((Object)statIndicatorDTO);
    }

    @ApiOperation(value="04-\u6dfb\u52a0\u6307\u6807\u5206\u7c7b")
    @PostMapping(value={"/class/add"})
    public Response<String> addStatClass(@RequestBody StatIndicatorClassEditDTO addDTO) {
        addDTO.setId(null);
        return Response.ok((Object)this.countStatConfigService.addIndicatorClass(addDTO));
    }

    @ApiOperation(value="05-\u4fee\u6539\u6307\u6807\u5206\u7c7b")
    @PostMapping(value={"/class/save"})
    public Response updateStatClass(@RequestBody StatIndicatorClassEditDTO editDTO) {
        this.countStatConfigService.updateIndicatorClass(editDTO);
        return Response.ok();
    }

    @ApiOperation(value="06-\u5220\u9664\u6307\u6807\u5206\u7c7b")
    @PostMapping(value={"/class/del"})
    public Response deleteStatConfig(@RequestParam String id) {
        this.countStatConfigService.deleteStatIndicator(id);
        return Response.ok();
    }

    @ApiOperation(value="07-\u6dfb\u52a0(\u7c98\u8d34)\u7edf\u8ba1\u6307\u6807")
    @PostMapping(value={"/indicator/add"})
    public Response<String> addStatIndicator(@RequestBody StatIndicatorDTO addDTO) {
        if (addDTO.getDataSql() != null) {
            addDTO.setDataSql(StringUtil.base64Decode((String)addDTO.getDataSql()));
        }
        return Response.ok((Object)this.countStatConfigService.addStatIndicator(addDTO));
    }

    @ApiOperation(value="08-\u4fee\u6539\u7edf\u8ba1\u6307\u6807")
    @PostMapping(value={"/indicator/save"})
    public Response updateStatIndicator(@RequestBody StatIndicatorDTO editDTO) {
        if (editDTO.getDataSql() != null) {
            editDTO.setDataSql(StringUtil.base64Decode((String)editDTO.getDataSql()));
        }
        this.countStatConfigService.updateStatIndicator(editDTO);
        return Response.ok();
    }

    @ApiOperation(value="09-\u5220\u9664\u7edf\u8ba1\u6307\u6807")
    @ApiImplicitParam(name="id", value="\u7edf\u8ba1\u6210\u679c\u6807\u8bc6", required=true)
    @PostMapping(value={"/indicator/del"})
    public Response deleteStatConfigIndicator(@RequestParam String id) {
        this.countStatConfigService.deleteStatIndicator(id);
        return Response.ok();
    }

    @ApiOperation(value="10-\u8c03\u6574\u7edf\u8ba1\u5206\u7c7b\u987a\u5e8f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6807\u8bc6", required=true), @ApiImplicitParam(name="pid", value="\u79fb\u52a8\u540e\u7684pid", required=false), @ApiImplicitParam(name="order", value="\u79fb\u52a8\u540e\u4e0a\u4e00\u4e2a\u5144\u5f1f\u8282\u70b9\u7684\u4f4d\u6b21\uff08\u4f4d\u6b21\u4ece1\u5f00\u59cb\uff0c\u6ca1\u6709\u4e0a\u4e2a\u5144\u5f1f\u8282\u70b9\u65f6\u6b64\u5904\u4e3a0\uff09", required=true)})
    @PostMapping(value={"/order"})
    public Response moveConfigOrder(@RequestParam String id, @RequestParam(required=false) String pid, @RequestParam Integer order) {
        this.countStatConfigService.moveIndicatorOrder(id, pid, order);
        return Response.ok();
    }

    @ApiOperation(value="11-\u67e5\u8be2\u6307\u6807\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7edf\u8ba1\u6210\u679c\u6807\u8bc6", required=true)})
    @GetMapping(value={"/data"})
    public Response<StatDataResult> queryStatResult(@RequestParam String id) {
        return Response.ok((Object)this.countStatConfigService.queryStatResult(id));
    }

    @ApiOperation(value="12-\u67e5\u8be2\u6570\u636e\u96c6\u6307\u6807\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="datasetId", value="\u6570\u636e\u96c6id", required=true), @ApiImplicitParam(name="filter", value="\u8fc7\u6ee4\u6761\u4ef6", required=true)})
    @PostMapping(value={"/data/bydataset"})
    public Response<StatDataResult> queryStatResultByDataset(@RequestParam String datasetId, @RequestParam String filter) {
        return Response.ok((Object)this.countStatConfigService.queryStatResultByDataset(datasetId, filter));
    }

    @ApiOperation(value="13-\u67e5\u8be2sql\u7edf\u8ba1\u7ed3\u679c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u6570\u636e\u6e90key", required=true), @ApiImplicitParam(name="dataSql", value="\u67e5\u8be2\u8bed\u53e5", required=true)})
    @PostMapping(value={"/data/bysql"})
    public Response<StatDataResult> queryStatResultBySql(String dsKey, String dataSql) {
        dataSql = StringUtil.base64Decode((String)dataSql);
        return Response.ok((Object)this.countStatConfigService.queryStatResultBySql(dsKey, dataSql));
    }

    @ApiOperation(value="14-\u67e5\u8be2sql\u7edf\u8ba1\u7ed3\u679c\u5b57\u6bb5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u6570\u636e\u6e90key", required=true), @ApiImplicitParam(name="dataSql", value="\u67e5\u8be2\u8bed\u53e5", required=true)})
    @PostMapping(value={"/fieldsbysql"})
    public Response<List<FieldDTO>> getFieldsBySql(String dsKey, String dataSql) {
        dataSql = StringUtil.base64Decode((String)dataSql);
        return Response.ok((Object)this.countStatConfigService.getFieldsBySql(dsKey, dataSql));
    }

    @ApiOperation(value="15-\u542f\u7528/\u505c\u7528\u6307\u6807\u9879")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6307\u6807\u9879\u6807\u8bc6", required=true), @ApiImplicitParam(name="enable", value="\u662f\u5426\u542f\u7528", required=true)})
    @PostMapping(value={"/indicator/enable"})
    public Response enableStatConfigIndicator(@RequestParam String id, @RequestParam Boolean enable) {
        this.countStatConfigService.enableStatConfigIndicator(id, enable);
        return Response.ok();
    }

    @ApiOperation(value="16-\u7acb\u5373\u6267\u884c\u5728\u7ebf\u7edf\u8ba1\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6307\u6807\u9879\u6807\u8bc6", required=true)})
    @PostMapping(value={"/execute"})
    public Response enableStatConfigIndicator(@RequestParam String id) {
        this.countStatConfigService.excuteStatSchedule(id);
        return Response.ok();
    }
}

