/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.datasource;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.entity.DsStatistic;
import com.geoway.adf.dms.datasource.service.DataSourceStatisticService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource/stat"})
@Api(tags={"01.11-\u6570\u636e\u5b58\u50a8\u7edf\u8ba1"})
public class DataSourceStatisticController {
    @Resource
    private DataSourceStatisticService dataSourceStatisticService;

    @ApiOperation(value="01-\u6267\u884c\u6570\u636e\u6e90\u5b58\u50a8\u7edf\u8ba1")
    @PostMapping(value={"/do"})
    public Response dataSourceStatistic(@RequestParam(required=false) String dsKey) {
        this.dataSourceStatisticService.dataSourceStatistic(dsKey);
        return Response.ok();
    }

    @ApiOperation(value="02-\u6267\u884c\u6570\u636e\u6e90\u5b58\u50a8\u7edf\u8ba1(\u5f02\u6b65)")
    @PostMapping(value={"/do/async"})
    public Response dataSourceStatisticAsync(@RequestParam(required=false) String dsKey) {
        this.dataSourceStatisticService.dataSourceStatisticAsync(dsKey);
        return Response.ok();
    }

    @ApiOperation(value="03-\u83b7\u53d6\u6b63\u5728\u6267\u884c\u7edf\u8ba1\u7684\u6570\u636e\u6e90")
    @GetMapping(value={"/listrunnings"})
    public Response<List<String>> listRunningDataSource() {
        return Response.ok((Object)this.dataSourceStatisticService.listRunningDataSource());
    }

    @ApiOperation(value="04-\u83b7\u53d6\u6570\u636e\u6e90\u5b58\u50a8\u7edf\u8ba1\u4fe1\u606f")
    @GetMapping(value={"/list"})
    public Response<List<DsStatistic>> listStatistic(@RequestParam(required=false) String dsKey) {
        return Response.ok((Object)this.dataSourceStatisticService.listStatistic(dsKey));
    }

    @ApiOperation(value="05-\u6267\u884c\u6570\u636e\u96c6\u5b58\u50a8\u7edf\u8ba1")
    @PostMapping(value={"/dataset/do"})
    public Response<DsStatistic> datasetStatistic(@RequestParam String datasetId) {
        return Response.ok((Object)this.dataSourceStatisticService.datasetStatistic(datasetId));
    }

    @ApiOperation(value="06-\u83b7\u53d6\u6570\u636e\u96c6\u5b58\u50a8\u7edf\u8ba1\u4fe1\u606f")
    @GetMapping(value={"/statinfo"})
    public Response<DsStatistic> getDataStatistic(@RequestParam String datasetId) {
        return Response.ok((Object)this.dataSourceStatisticService.getDataStatistic(datasetId));
    }
}

