/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.datasource;

import com.geoway.adf.dms.api.action.datasource.ResponseDatasetList;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetPageList;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.create.TileDatasetCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.TileDatasetEditDTO;
import com.geoway.adf.dms.datasource.dto.create.TileFileDatasetCreateDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TileDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.service.TileDatabaseService;
import com.geoway.adf.gis.tile.TileType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource/tiledb"})
@Api(tags={"01.02-\u74e6\u7247\u6570\u636e\u5e93"})
public class TileDatabaseController {
    @Resource
    private TileDatabaseService tileDatabaseService;

    @ApiOperation(value="01-\u83b7\u53d6\u74e6\u7247\u6570\u636e\u6e90\u8fde\u63a5\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="types", value="\u6570\u636e\u6e90\u7c7b\u578b\uff0c\u591a\u4e2a\u9017\u53f7\u5206\u9694(21-Mongo\u6570\u636e\u5e93)", paramType="query"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query")})
    @GetMapping(value={"/list"})
    public Response<List<DataSourceDTO>> listDb(@RequestParam(required=false) String types, @RequestParam(required=false) String keyword) {
        List sourceTypes = null;
        if (StringUtil.isNotEmpty((String)types)) {
            sourceTypes = StringUtil.split((String)types, (String)",", t -> DataSourceTypeEnum.getByValue((Integer)Integer.valueOf(t)));
        }
        List databaseDTOList = this.tileDatabaseService.listDatabase(sourceTypes, keyword);
        return Response.ok((Object)databaseDTOList);
    }

    @ApiOperation(value="02-\u83b7\u53d6\u8fde\u63a5\u4e0b\u6240\u6709\u7684\u6570\u636e\u5e93")
    @PostMapping(value={"/listdb"})
    public Response<List<String>> listDbName(@RequestBody DataSourceDTO dataSource) {
        return Response.ok((Object)this.tileDatabaseService.listAllDatabaseNames(dataSource));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u74e6\u7247\u6570\u636e\u96c6\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="types", value="\u7a7a\u95f4\u6570\u636e\u96c6\u7c7b\u578b", paramType="query", allowableValues="com.geoway.adf.gis.tile.TileType"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query")})
    @GetMapping(value={"/dataset/list"})
    public ResponseDatasetList<SimpleDatasetDTO> listGeoDataset(@RequestParam String key, @RequestParam(required=false) String types, @RequestParam(required=false) String keyword, @RequestParam(required=false) Integer pageIndex, @RequestParam(required=false) Integer rows) {
        List tileTypes = null;
        if (StringUtil.isNotEmpty((String)types)) {
            tileTypes = StringUtil.split((String)types, (String)",", t -> TileType.getByValue((Integer)Integer.valueOf(t)));
        }
        DatasetPageList datasets = this.tileDatabaseService.listTileDatasets(key, tileTypes, keyword, pageIndex, rows);
        return ResponseDatasetList.ok(datasets);
    }

    @ApiOperation(value="04-\u5220\u9664\u74e6\u7247\u6570\u636e\u96c6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6570\u636e\u96c6id", required=true, paramType="path")})
    @DeleteMapping(value={"/dataset/{id}"})
    public Response deleteDataset(@PathVariable String id) {
        this.tileDatabaseService.deleteTileDataset(id);
        return Response.ok();
    }

    @ApiOperation(value="05-\u521b\u5efa\u74e6\u7247\u6570\u636e\u96c6")
    @PostMapping(value={"/dataset/create"})
    public Response<String> createFeatureDataset(@RequestBody TileDatasetCreateDTO tile) {
        return Response.ok((Object)this.tileDatabaseService.createTileDataset(tile));
    }

    @ApiOperation(value="06-\u4fee\u6539\u74e6\u7247\u6570\u636e\u96c6")
    @PostMapping(value={"/dataset/update"})
    public Response updateFeatureDataset(@RequestBody TileDatasetEditDTO tile) {
        this.tileDatabaseService.updateTileDataset(tile);
        return Response.ok();
    }

    @ApiOperation(value="07-\u6d4b\u8bd5\u8fde\u63a5\u6587\u4ef6\u578b\u74e6\u7247\u6570\u636e\u96c6")
    @PostMapping(value={"/testFileTile"})
    public Response testFileTileDataset(@RequestBody TileFileDatasetCreateDTO tile) {
        this.tileDatabaseService.testFileTileDataset(tile);
        return Response.ok();
    }

    @ApiOperation(value="08-\u6dfb\u52a0\u6587\u4ef6\u578b\u74e6\u7247\u6570\u636e\u96c6")
    @PostMapping(value={"/addFileTile"})
    public Response<TileDatasetDTO> addFileTileDataset(@RequestBody TileFileDatasetCreateDTO tile) {
        return Response.ok((Object)this.tileDatabaseService.addFileTileDataset(tile));
    }
}

