/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.config;

import io.swagger.models.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.Operation;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2MapperImpl;

@Primary
@Component
@ConditionalOnExpression(value="${swagger.enabled:false}")
public class Swagger2MapperImplExt
extends ServiceModelToSwagger2MapperImpl {
    protected Map<String, Path> mapApiListings(Map<String, List<ApiListing>> apiListings) {
        LinkedHashMap<String, Path> paths = new LinkedHashMap<String, Path>();
        for (List<ApiListing> each : apiListings.values()) {
            for (ApiListing apiListing : each) {
                ArrayList<ApiDescription> newApiDescList = new ArrayList<ApiDescription>(apiListing.getApis());
                newApiDescList.sort(Comparator.comparing(left -> ((Operation)left.getOperations().get(0)).getSummary()));
                for (ApiDescription api : newApiDescList) {
                    paths.put(api.getPath(), this.mapOperations(api, Optional.ofNullable(paths.get(api.getPath()))));
                }
            }
        }
        return paths;
    }

    private Path mapOperations(ApiDescription api, Optional<Path> existingPath) {
        Path path = existingPath.orElse(new Path());
        for (Operation each : api.getOperations()) {
            io.swagger.models.Operation operation = this.mapOperation(each, null);
            path.set(each.getMethod().toString().toLowerCase(), operation);
        }
        return path;
    }
}

