--图表场景添加标签字段
alter table tbchart_scene
    add f_labels text;
comment on column tbchart_scene.f_labels is '标签';

--新建应用目录节点关联图表场景表
create table tbcm_catalognodeapp_chart
(
    f_nodeid       varchar(32)
        constraint tbcm_catalognodeapp_chart_tbcm_catalognodeapp_f_id_fk
            references tbcm_catalognodeapp
            on delete cascade,
    f_catalogid    varchar(32),
    f_chartsceneid varchar(32)
        constraint tbcm_catalognodeapp_chart_tbchart_scene_f_id_fk
            references tbchart_scene
            on delete cascade
);
comment on table tbcm_catalognodeapp_chart is '应用目录节点图表场景';
comment on column tbcm_catalognodeapp_chart.f_nodeid is '节点id';
comment on column tbcm_catalognodeapp_chart.f_catalogid is '目录id';
comment on column tbcm_catalognodeapp_chart.f_chartsceneid is '图表场景id';

create index tbcm_catalognodeapp_chart_f_catalogid_index
    on tbcm_catalognodeapp_chart (f_catalogid);

create index tbcm_catalognodeapp_chart_f_nodeid_index
    on tbcm_catalognodeapp_chart (f_nodeid);

--新建应用目录节点关联统计指标表
create table tbcm_catalognodeapp_indicator
(
    f_nodeid      varchar(32)
        constraint tbcm_catalognodeapp_indicator_fk1
            references tbcm_catalognodeapp
            on delete cascade,
    f_catalogid   varchar(32),
    f_indicatorid varchar(64)
        constraint tbcm_catalognodeapp_indicator_fk2
            references tbchart_indicator
            on delete cascade
);
comment on table tbcm_catalognodeapp_indicator is '应用目录节点统计指标表';
comment on column tbcm_catalognodeapp_indicator.f_nodeid is '节点id';
comment on column tbcm_catalognodeapp_indicator.f_catalogid is '目录id';
comment on column tbcm_catalognodeapp_indicator.f_indicatorid is '统计指标id';

create index tbcm_catalognodeapp_indicator_f_catalogid_index
    on tbcm_catalognodeapp_indicator (f_catalogid);

create index tbcm_catalognodeapp_indicator_f_nodeid_index
    on tbcm_catalognodeapp_indicator (f_nodeid);