/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.config;

import com.geoway.adf.dms.api.action.check.UploadFileCheck;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.common.web.ResponsePage;
import com.geoway.adf.dms.config.dto.material.MaterialDTO;
import com.geoway.adf.dms.config.dto.material.MaterialGroupDTO;
import com.geoway.adf.dms.config.service.MaterialService;
import com.geoway.adf.gis.basic.PageList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/material"})
@Api(tags={"04.01-\u7d20\u6750\u7ba1\u7406"})
public class MaterialController {
    @Resource
    private MaterialService materialService;

    @ApiOperation(value="01-\u83b7\u53d6\u7d20\u6750\u5206\u7c7b\u5217\u8868")
    @GetMapping(value={"/types"})
    public Response<List<MaterialGroupDTO>> listTypes() {
        return Response.ok((Object)this.materialService.listTypes());
    }

    @ApiOperation(value="02-\u83b7\u53d6\u5206\u7ec4\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="typeId", value="\u7d20\u6750\u7c7b\u578bId"), @ApiImplicitParam(name="withChildren", value="\u662f\u5426\u8fd4\u56de\u5206\u7ec4\u4e0b\u7d20\u6750"), @ApiImplicitParam(name="childrenCount", value="\u5206\u7ec4\u4e0b\u7d20\u6750\u6570\u91cf")})
    @GetMapping(value={"/groups"})
    public Response<List<MaterialGroupDTO>> listGroups(String typeId, @RequestParam(required=false, defaultValue="false") Boolean withChildren, @RequestParam(required=false, defaultValue="10") Integer childrenCount) {
        return Response.ok((Object)this.materialService.listGroups(typeId, withChildren, childrenCount));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u7d20\u6750\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", value="\u5206\u7ec4Id"), @ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query")})
    @GetMapping(value={"/list"})
    public ResponsePage<MaterialDTO> listMaterials(String groupId, @RequestParam(required=false) String keyword, @RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows) {
        return ResponsePage.ok((PageList)this.materialService.listMaterials(groupId, keyword, pageIndex, rows));
    }

    @ApiOperation(value="04-\u4fdd\u5b58\u5206\u7ec4")
    @PostMapping(value={"/saveGroup"})
    public Response<String> saveGroup(@RequestBody MaterialGroupDTO group) {
        return Response.ok((Object)this.materialService.saveGroup(group));
    }

    @ApiOperation(value="05-\u5220\u9664\u5206\u7ec4")
    @PostMapping(value={"/delGroup"})
    public Response delGroup(String id) {
        this.materialService.deleteGroup(id);
        return Response.ok();
    }

    @ApiOperation(value="06-\u7d20\u6750\u4e0a\u4f20")
    @UploadFileCheck
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", value="\u5206\u7ec4id"), @ApiImplicitParam(name="files", value="\u4e0a\u4f20\u7684\u7d20\u6750\u6587\u4ef6\u6570\u7ec4", required=true, allowMultiple=true, dataTypeClass=MultipartFile.class)})
    @PostMapping(value={"/upload"})
    public Response<List<String>> uploadMaterial(String groupId, @RequestPart MultipartFile[] files) {
        return Response.ok((Object)this.materialService.uploadMaterial(groupId, files));
    }

    @ApiOperation(value="07-\u7d20\u6750\u91cd\u547d\u540d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7d20\u6750Id"), @ApiImplicitParam(name="name", value="\u65b0\u540d\u79f0")})
    @PostMapping(value={"/rename"})
    public Response renameMaterial(String id, String name) {
        this.materialService.renameMaterial(id, name);
        return Response.ok();
    }

    @ApiOperation(value="08-\u5220\u9664\u7d20\u6750")
    @PostMapping(value={"/del"})
    public Response delete(String ids) {
        this.materialService.deleteMaterial(ids.split(","));
        return Response.ok();
    }

    @ApiOperation(value="09-\u79fb\u52a8\u7d20\u6750\u5206\u7ec4")
    @PostMapping(value={"/move"})
    public Response move2Group(String ids, String newGroupId) {
        this.materialService.move2Group(ids.split(","), newGroupId);
        return Response.ok();
    }

    @ApiOperation(value="10-\u7d20\u6750\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    public Response<MaterialDTO> getDetail(String id) {
        return Response.ok((Object)this.materialService.getMaterialDetail(id));
    }

    @ApiOperation(value="11-\u7d20\u6750\u5185\u5bb9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", value="\u5206\u7ec4id"), @ApiImplicitParam(name="sourceName", value="\u7d20\u6750\u6e90\u540d\u79f0")})
    @GetMapping(value={"/{groupId}/{sourceName}"})
    public void getMaterialContent(@PathVariable String groupId, @PathVariable String sourceName, HttpServletRequest request, HttpServletResponse response) {
        this.materialService.viewMaterial(groupId, sourceName, request, response);
    }

    @ApiOperation(value="12-\u4e0b\u8f7d\u7d20\u6750")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", value="\u5206\u7ec4id", paramType="query"), @ApiImplicitParam(name="ids", value="\u5f85\u4e0b\u8f7d\u7d20\u6750id\uff0c\u591a\u4e2a\u9017\u53f7\u5206\u9694", paramType="query")})
    @GetMapping(value={"/download"})
    public void download(String groupId, String ids, HttpServletRequest request, HttpServletResponse response) {
        this.materialService.download(groupId, ids, request, response);
    }

    @ApiOperation(value="13-\u5bfc\u51fa\u5206\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", value="\u5206\u7ec4id", paramType="query", required=true)})
    @GetMapping(value={"/export"})
    public void export(@RequestParam String groupId, HttpServletRequest request, HttpServletResponse response) {
        this.materialService.exportGroup(groupId, request, response);
    }

    @ApiOperation(value="14-\u5bfc\u5165\u5206\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="typeId", value="\u5206\u7c7bid"), @ApiImplicitParam(name="importStrategy", value="\u5bfc\u5165\u65f6\u91cd\u590d\u5904\u7406\u7b56\u7565", allowableValues="com.geoway.adf.dms.config.dto.material.MaterialImportStrategy"), @ApiImplicitParam(name="file", value="\u7d20\u6750\u6587\u4ef6\u5305", required=true, dataTypeClass=MultipartFile.class)})
    @UploadFileCheck(supportedSuffixes={".gmt"})
    @PostMapping(value={"/import"})
    public Response<String> importGroup(String typeId, Integer importStrategy, @RequestPart MultipartFile file) {
        return Response.ok((Object)this.materialService.importGroup(typeId, importStrategy, file));
    }
}

