/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.datasource;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.dto.query.BufferAnalyseFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterBasicDTO;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.StatQueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.StatQueryResultDTO;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource/geodb"})
@Api(tags={"01.01-\u7a7a\u95f4\u6570\u636e\u5e93-\u6570\u636e\u67e5\u8be2"})
public class GeoDatabaseQueryController {
    @Resource
    private GeoDatabaseService geoDatabaseService;

    @ApiOperation(value="01-\u6570\u636e\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="\u6570\u636e\u96c6\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="dsKey", value="\u6570\u636e\u6e90\u6807\u8bc6\uff0c\u4e3a\u7a7a\u65f6\u67e5\u8be2\u9ed8\u8ba4\u7a7a\u95f4\u5e93", required=false, paramType="query")})
    @PostMapping(value={"/query/{name}"})
    public Response<DataQueryResult> queryGeoDataset(@PathVariable String name, @RequestParam(required=false) String dsKey, QueryFilterDTO queryFilterDTO) {
        return Response.ok((Object)this.geoDatabaseService.queryGeoDataset(dsKey, name, queryFilterDTO));
    }

    @ApiOperation(value="02-\u6839\u636e\u6570\u636eoid\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="\u6570\u636e\u96c6\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="objectId", value="\u6570\u636eoid", required=true, paramType="query"), @ApiImplicitParam(name="dsKey", value="\u6570\u636e\u6e90\u6807\u8bc6\uff0c\u4e3a\u7a7a\u65f6\u67e5\u8be2\u9ed8\u8ba4\u7a7a\u95f4\u5e93", required=false, paramType="query"), @ApiImplicitParam(name="fields", value="\u6570\u636e\u96c6\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="returnGeometry", value="\u662f\u5426\u8fd4\u56de\u51e0\u4f55\u56fe\u5f62", required=false, paramType="query")})
    @GetMapping(value={"/query/{name}/{objectId}"})
    public Response<DataQueryResult> queryByObjectId(@PathVariable String name, @PathVariable Object objectId, @RequestParam(required=false) String dsKey, @RequestParam(required=false) String fields, @RequestParam(required=false, defaultValue="false") Boolean returnGeometry) {
        return Response.ok((Object)this.geoDatabaseService.queryByObjectId(dsKey, name, objectId, fields, returnGeometry));
    }

    @ApiOperation(value="03-\u6570\u91cf\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u6570\u636e\u6e90\u6807\u8bc6\uff0c\u4e3a\u7a7a\u65f6\u67e5\u8be2\u9ed8\u8ba4\u7a7a\u95f4\u5e93", required=false, paramType="query"), @ApiImplicitParam(name="name", value="\u6570\u636e\u96c6\u540d\u79f0", required=true, paramType="query")})
    @PostMapping(value={"/query/{name}/count"})
    public Response<Long> queryDataCount(@PathVariable String name, @RequestParam(required=false) String dsKey, QueryFilterBasicDTO queryFilterDTO) {
        return Response.ok((Object)this.geoDatabaseService.queryDataCount(dsKey, name, queryFilterDTO));
    }

    @ApiOperation(value="04-\u5b57\u6bb5\u552f\u4e00\u503c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u6570\u636e\u6e90\u6807\u8bc6\uff0c\u4e3a\u7a7a\u65f6\u67e5\u8be2\u9ed8\u8ba4\u7a7a\u95f4\u5e93", required=false, paramType="query"), @ApiImplicitParam(name="name", value="\u6570\u636e\u96c6\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="limit", value="\u8fd4\u56de\u6570\u91cf", required=false, paramType="query")})
    @PostMapping(value={"/query/{name}/distinct"})
    public Response<List<Object>> queryDataUniqValues(@PathVariable String name, @RequestParam(required=false) String dsKey, @RequestParam(required=false, defaultValue="100") Integer limit, QueryFilterBasicDTO queryFilter) {
        return Response.ok((Object)this.geoDatabaseService.queryDataFieldUniqValues(dsKey, name, queryFilter, limit));
    }

    @ApiOperation(value="05-\u6570\u636e\u7edf\u8ba1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u6570\u636e\u6e90\u6807\u8bc6", paramType="query"), @ApiImplicitParam(name="datasetName", value="\u6570\u636e\u96c6\u540d\u79f0", paramType="query"), @ApiImplicitParam(name="statMethod", value="\u7edf\u8ba1\u65b9\u6cd5", paramType="query", allowableValues="com.geoway.adf.dms.datasource.dto.query.StatMethodEnum")})
    @PostMapping(value={"/query/{name}/stats"})
    public Response<List<StatQueryResultDTO>> queryDataStatistics(@PathVariable String name, @RequestParam(required=false) String dsKey, StatQueryFilterDTO statFilter) {
        return Response.ok((Object)this.geoDatabaseService.queryDataStatistics(dsKey, name, statFilter));
    }

    @ApiOperation(value="06-\u7f13\u51b2\u5206\u6790")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u6570\u636e\u6e90\u6807\u8bc6", paramType="query")})
    @PostMapping(value={"/query/bufferAnalyse"})
    public Response<DataQueryResult> bufferAnalyse(@RequestParam(required=false) String dsKey, BufferAnalyseFilterDTO bufferAnalyseFilter) {
        return Response.ok((Object)this.geoDatabaseService.bufferAnalyse(dsKey, bufferAnalyseFilter));
    }
}

