/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.config;

import com.geoway.adf.dms.api.action.check.UploadFileCheck;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.config.dto.attachment.AttachmentDTO;
import com.geoway.adf.dms.config.service.AttachmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/attachment"})
@Api(tags={"04.03-\u9644\u4ef6\u7ba1\u7406"})
public class AttachmentController {
    @Resource
    private AttachmentService attachmentService;

    @ApiOperation(value="01-\u4e0a\u4f20\u9644\u4ef6")
    @PostMapping(value={"/upload"})
    @UploadFileCheck
    @ApiImplicitParams(value={@ApiImplicitParam(name="relatedType", value="\u9644\u4ef6\u5173\u8054\u7c7b\u578b\uff08\u6bd4\u5982\u6807\u7ed8\u65b9\u6848\u7684\u9644\u4ef6\uff1adraw\uff09"), @ApiImplicitParam(name="relatedId", value="\u9644\u4ef6\u5173\u8054id\uff08\u6bd4\u5982\u6807\u7ed8\u65b9\u6848id\uff09"), @ApiImplicitParam(name="files", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6570\u7ec4", required=true, allowMultiple=true, dataTypeClass=MultipartFile.class)})
    public Response<List<AttachmentDTO>> uploadAttachment(String relatedType, String relatedId, @RequestPart MultipartFile[] files, HttpServletRequest request, HttpServletResponse response) {
        return Response.ok((Object)this.attachmentService.upload(relatedType, relatedId, files));
    }

    @ApiOperation(value="02-\u9644\u4ef6\u5217\u8868")
    @GetMapping(value={"/list"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="relatedType", value="\u9644\u4ef6\u5173\u8054\u7c7b\u578b\uff08\u6bd4\u5982\u6807\u7ed8\u65b9\u6848\u7684\u9644\u4ef6\uff1adraw\uff09"), @ApiImplicitParam(name="relatedId", value="\u9644\u4ef6\u5173\u8054id\uff08\u6bd4\u5982\u6807\u7ed8\u65b9\u6848id\uff09")})
    public Response<List<AttachmentDTO>> listAttachment(String relatedType, String relatedId, HttpServletRequest request, HttpServletResponse response) {
        return Response.ok((Object)this.attachmentService.list(relatedType, relatedId));
    }

    @ApiOperation(value="02-\u9644\u4ef6\u5217\u8868")
    @GetMapping(value={"/list/ids"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u9644\u4ef6id\uff0c\u591a\u4e2a\u9017\u53f7\u5206\u9694")})
    public Response<List<AttachmentDTO>> getAttachments(String ids) {
        return Response.ok((Object)this.attachmentService.getAttachments(ids));
    }

    @ApiOperation(value="03-\u5220\u9664\u9644\u4ef6")
    @PostMapping(value={"/del"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u9644\u4ef6id")})
    public Response deleteAttachment(String id) {
        this.attachmentService.delete(id);
        return Response.ok();
    }

    @ApiOperation(value="04-\u6279\u91cf\u5220\u9664\u9644\u4ef6")
    @PostMapping(value={"/batchDel"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="relatedType", value="\u9644\u4ef6\u5173\u8054\u7c7b\u578b\uff08\u6bd4\u5982\u6807\u7ed8\u65b9\u6848\u7684\u9644\u4ef6\uff1adraw\uff09"), @ApiImplicitParam(name="relatedId", value="\u9644\u4ef6\u5173\u8054id\uff08\u6bd4\u5982\u6807\u7ed8\u65b9\u6848id\uff09")})
    public Response deleteAttachment(String relatedType, String relatedId) {
        this.attachmentService.delete(relatedType, relatedId);
        return Response.ok();
    }

    @ApiOperation(value="05-\u9884\u89c8\u9644\u4ef6")
    @GetMapping(value={"/view/{relatedType}/{relatedId}/{fileName}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="relatedType", value="\u9644\u4ef6\u5173\u8054\u7c7b\u578b\uff08\u6bd4\u5982\u6807\u7ed8\u65b9\u6848\u7684\u9644\u4ef6\uff1adraw\uff09"), @ApiImplicitParam(name="relatedId", value="\u9644\u4ef6\u5173\u8054id\uff08\u6bd4\u5982\u6807\u7ed8\u65b9\u6848id\uff09"), @ApiImplicitParam(name="fileName", value="\u6587\u4ef6\u540d")})
    public void viewAttachment(@PathVariable String relatedType, @PathVariable String relatedId, @PathVariable String fileName, HttpServletRequest request, HttpServletResponse response) {
        this.attachmentService.view(relatedType, relatedId, fileName, request, response);
    }

    @ApiOperation(value="05-\u4e0b\u8f7d\u9644\u4ef6")
    @GetMapping(value={"/download"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u9644\u4ef6id")})
    public void download(String id, HttpServletRequest request, HttpServletResponse response) {
        this.attachmentService.download(id, request, response);
    }
}

