/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.datasource;

import com.geoway.adf.dms.api.action.datasource.ResponseDatasetList;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.config.dto.filepackage.data.FileDataUnitDTO;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatumDatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatabaseDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datum.create.DatumDatabaseCreateDTO;
import com.geoway.adf.dms.datasource.dto.datum.create.DatumDatabaseEditDTO;
import com.geoway.adf.dms.datasource.dto.datum.create.DatumDatasetCreateDTO;
import com.geoway.adf.dms.datasource.dto.datum.create.DatumDatasetEditDTO;
import com.geoway.adf.dms.datasource.dto.datum.create.DatumFieldsEditDTO;
import com.geoway.adf.dms.datasource.dto.edit.DataBatchDeleteDTO;
import com.geoway.adf.dms.datasource.dto.edit.DataBatchUpdateDTO;
import com.geoway.adf.dms.datasource.dto.edit.GeoDataEditDTO;
import com.geoway.adf.dms.datasource.dto.file.FilePathDTO;
import com.geoway.adf.dms.datasource.dto.file.FilePathRepairDTO;
import com.geoway.adf.dms.datasource.service.DatumDataSourceService;
import com.geoway.adf.dms.datasource.service.DatumDatabaseEditService;
import com.geoway.adf.dms.datasource.service.DatumDatabaseService;
import com.geoway.adf.dms.datasource.service.FileDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource/datum"})
@Api(tags={"01.03-\u6587\u4ef6\u6570\u636e\u5e93"})
public class DatumDatabaseController {
    @Resource
    private DatumDatabaseService datumDatabaseService;
    @Resource
    private DatumDataSourceService datumDataSourceService;
    @Resource
    private FileDataService fileDataService;
    @Resource
    private DatumDatabaseEditService datumDatabaseEditService;

    @ApiOperation(value="01-\u83b7\u53d6\u6570\u636e\u6e90\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataStoreTypes", value="\u6570\u636e\u5b58\u50a8\u7c7b\u578b(4-\u6587\u4ef6\u6570\u636e\u5e93\uff1b8-\u6a21\u578b\u6570\u636e\u5e93))", paramType="query", defaultValue="4"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query"), @ApiImplicitParam(name="category", value="\u5206\u7c7b\u8fc7\u6ee4", paramType="query")})
    @GetMapping(value={"/list"})
    public Response<List<DatumDatabaseDTO>> list(@RequestParam(required=false, defaultValue="4") String dataStoreTypes, @RequestParam(required=false) String keyword, @RequestParam(required=false) String category) {
        List storeTypes = null;
        if (StringUtil.isNotEmpty((String)dataStoreTypes)) {
            storeTypes = StringUtil.split((String)dataStoreTypes, (String)",", t -> DataStoreTypeEnum.getByValue((Integer)Integer.valueOf(t)));
        }
        return Response.ok((Object)this.datumDatabaseService.listDatumDatabase(storeTypes, keyword, category));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u6587\u4ef6\u6570\u636e\u5e93\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    public Response<DatumDatabaseDTO> getDatumDatabaseDetail(@RequestParam String key) {
        return Response.ok((Object)this.datumDatabaseService.getDatumDatabaseDetailWithOutPassWord(key));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u6587\u4ef6\u6570\u636e\u96c6\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="datumTypes", value="\u6587\u4ef6\u6570\u636e\u96c6\u7c7b\u578b", paramType="query", allowableValues="com.geoway.adf.dms.datasource.constant.DatumDatasetTypeEnum"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query")})
    @GetMapping(value={"/dataset/list"})
    public ResponseDatasetList<SimpleDatasetDTO> listDatumDataset(@RequestParam String dsKey, @RequestParam(required=false) String datumTypes, @RequestParam(required=false) String keyword, @RequestParam(required=false) Integer pageIndex, @RequestParam(required=false) Integer rows) {
        List datasetTypes = new ArrayList();
        if (StringUtil.isNotEmpty((String)datumTypes)) {
            datasetTypes = StringUtil.split((String)datumTypes, (String)",", t -> DatumDatasetTypeEnum.getByValue((Integer)Integer.valueOf(t)));
        }
        return ResponseDatasetList.ok(this.datumDatabaseService.listDatumDataset(dsKey, datasetTypes, keyword, pageIndex, rows));
    }

    @ApiOperation(value="04-\u83b7\u53d6\u6587\u4ef6\u6570\u636e\u96c6\u8be6\u60c5")
    @GetMapping(value={"/dataset/detail"})
    public Response<DatumDatasetDTO> getDatasetDetail(@RequestParam String key) {
        return Response.ok((Object)this.datumDatabaseService.getDatasetDetail(key));
    }

    @ApiOperation(value="05-\u521b\u5efa\u6587\u4ef6\u6570\u636e\u5e93")
    @PostMapping(value={""})
    public Response<String> addDataSource(@RequestBody DatumDatabaseCreateDTO datumDatabaseCreateDTO) {
        return Response.ok((Object)this.datumDataSourceService.createDatumDatabase(datumDatabaseCreateDTO));
    }

    @ApiOperation(value="06-\u4fee\u6539\u6587\u4ef6\u6570\u636e\u5e93")
    @PutMapping(value={""})
    public Response updateDatumDatabase(@RequestBody DatumDatabaseEditDTO datumDatabaseEditDTO) {
        this.datumDataSourceService.updateDatumDatabase(datumDatabaseEditDTO);
        return Response.ok();
    }

    @ApiOperation(value="07-\u5220\u9664\u6587\u4ef6\u6570\u636e\u5e93")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u5e93\u6807\u8bc6", required=true, paramType="path"), @ApiImplicitParam(name="deleteBizInfo", value="\u662f\u5426\u5220\u9664\u5173\u8054\u7684\u4e1a\u52a1\u4fe1\u606f", dataType="Boolean")})
    @DeleteMapping(value={""})
    public Response deleteDatumDatabase(@RequestParam String key, @RequestParam(required=false, defaultValue="false") Boolean deleteBizInfo) {
        this.datumDataSourceService.deleteDatumDatabase(key, deleteBizInfo);
        return Response.ok();
    }

    @ApiOperation(value="08-\u521b\u5efa\u6587\u4ef6\u6570\u636e\u96c6")
    @PostMapping(value={"/dataset"})
    public Response<String> createDatumDataset(@RequestBody DatumDatasetCreateDTO createDTO) {
        return Response.ok((Object)this.datumDatabaseService.createDatumDataset(createDTO));
    }

    @ApiOperation(value="09-\u4fee\u6539\u6587\u4ef6\u6570\u636e\u96c6")
    @PutMapping(value={"/dataset"})
    public Response updateDatumDataset(@RequestBody DatumDatasetEditDTO editDTO) {
        this.datumDatabaseService.updateDatumDataset(editDTO);
        return Response.ok();
    }

    @ApiOperation(value="10-\u4fee\u6539\u6587\u4ef6\u6570\u636e\u96c6\u5b57\u6bb5")
    @PostMapping(value={"/dataset/updatefields/{id}"})
    public Response updateFields(@PathVariable String id, @RequestBody DatumFieldsEditDTO fields) {
        this.datumDatabaseService.updateDatumFields(id, fields);
        return Response.ok();
    }

    @ApiOperation(value="11-\u5220\u9664\u6587\u4ef6\u6570\u636e\u96c6")
    @DeleteMapping(value={"/dataset"})
    public Response deleteDatumDatabase(@RequestParam String id) {
        this.datumDatabaseService.deleteDatumDataset(id);
        return Response.ok();
    }

    @ApiOperation(value="12-\u83b7\u53d6\u6570\u636e\u5305\u6587\u4ef6\u7ec4\u7ec7\u7ed3\u6784")
    @GetMapping(value={"/file/data/catalogByOID"})
    public Response<FileDataUnitDTO> getFileDataCatalog(@RequestParam String datasetId, @RequestParam Object objectId) {
        return Response.ok((Object)this.datumDatabaseService.getDatasetFileData(datasetId, objectId));
    }

    @ApiOperation(value="13-\u83b7\u53d6\u6570\u636e\u5305\u6587\u4ef6\u7ec4\u7ec7\u7ed3\u6784")
    @GetMapping(value={"/file/data/catalog"})
    public Response<FileDataUnitDTO> getFileDataCatalog(@RequestParam String dataId) {
        return Response.ok((Object)this.fileDataService.getFileDataTree(dataId));
    }

    @ApiOperation(value="14-\u9a8c\u8bc1\u6587\u4ef6\u6570\u636e\u5305\u662f\u5426\u53ef\u4ee5\u4e0b\u8f7d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataId", value="\u6570\u636eID", required=true), @ApiImplicitParam(name="fileLocation", value="\u6587\u4ef6\uff08\u5939\uff09\u76f8\u5bf9\u8def\u5f84\uff0c\u552f\u4e00\u6807\u8bc6")})
    @GetMapping(value={"/file/data/download/check"})
    public Response<Boolean> fileDataUnitDownloadCheck(@RequestParam String dataId, @RequestParam(required=false) String fileLocation) {
        return Response.ok((Object)this.fileDataService.fileDataUnitDownloadCheck(dataId, fileLocation));
    }

    @ApiOperation(value="15-\u4e0b\u8f7d\u6587\u4ef6\u6570\u636e\u5305")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataId", value="\u6570\u636eID", required=true), @ApiImplicitParam(name="fileLocation", value="\u6587\u4ef6\uff08\u5939\uff09\u76f8\u5bf9\u8def\u5f84\uff0c\u552f\u4e00\u6807\u8bc6")})
    @GetMapping(value={"/file/data/download"})
    public void getFileDataCatalog(@RequestParam String dataId, @RequestParam(required=false) String fileLocation) {
        this.fileDataService.downloadFileDataUnit(dataId, fileLocation);
    }

    @ApiOperation(value="16-\u9884\u89c8\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataId", value="\u6570\u636eID", required=true), @ApiImplicitParam(name="fileLocation", value="\u6587\u4ef6\uff08\u5939\uff09\u76f8\u5bf9\u8def\u5f84\uff0c\u552f\u4e00\u6807\u8bc6")})
    @GetMapping(value={"/file/data/view"})
    public void viewFile(@RequestParam String dataId, @RequestParam(required=false) String fileLocation, HttpServletRequest request, HttpServletResponse response) {
        this.fileDataService.viewFileDataUnit(dataId, fileLocation, request, response);
    }

    @ApiOperation(value="17-\u83b7\u53d6\u6587\u4ef6\u6570\u636e\u96c6\u6570\u636e\u5305\u6587\u4ef6\u5217\u8868")
    @GetMapping(value={"/dataset/file/path/list"})
    public Response<List<FilePathDTO>> getDatasetFilePathList(@RequestParam String datasetId) {
        return Response.ok((Object)this.datumDatabaseService.getDatasetFilePathList(datasetId));
    }

    @ApiOperation(value="18-\u8def\u5f84\u8f6c\u6362(\u8def\u5f84\u4fee\u590d)")
    @PostMapping(value={"/dataset/file/path/repair"})
    public Response updateFields(@RequestBody List<FilePathRepairDTO> repairList) {
        this.datumDatabaseService.repairFilePath(repairList);
        return Response.ok();
    }

    @ApiOperation(value="19-\u66f4\u65b0\u6570\u636e")
    @PostMapping(value={"/dataset/data/update"})
    public Response<Boolean> updateData(@RequestBody GeoDataEditDTO geoDataEdit) {
        return Response.ok((Object)this.datumDatabaseEditService.updateData(geoDataEdit));
    }

    @ApiOperation(value="20-\u6839\u636e\u8fc7\u6ee4\u6761\u4ef6\u6279\u91cf\u66f4\u65b0\u6570\u636e")
    @PostMapping(value={"/data/batchUpdateByFilter"})
    public Response<Long> batchUpdateByFilter(@RequestBody DataBatchUpdateDTO dataBatchUpdateDTO) {
        return Response.ok((Object)this.datumDatabaseEditService.batchUpdateDataByFilter(dataBatchUpdateDTO));
    }

    @ApiOperation(value="21-\u5220\u9664\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="datasetId", value="\u6570\u636e\u96c6id", required=true, paramType="query"), @ApiImplicitParam(name="objectId", value="\u6570\u636eid\uff0c\u591a\u4e2a\u9017\u53f7\u5206\u5272", required=true, paramType="query"), @ApiImplicitParam(name="updateRenderIndex", value="\u662f\u5426\u66f4\u65b0\u6e32\u67d3\u7d22\u5f15", required=false, paramType="query")})
    @PostMapping(value={"/data/delete"})
    public Response<Boolean> deleteData(@RequestParam String datasetId, @RequestParam String objectId, @RequestParam(required=false, defaultValue="false") Boolean updateRenderIndex) {
        return Response.ok((Object)this.datumDatabaseEditService.deleteData(datasetId, objectId, updateRenderIndex));
    }

    @ApiOperation(value="22-\u6839\u636e\u8fc7\u6ee4\u6761\u4ef6\u6279\u91cf\u5220\u9664\u6570\u636e")
    @PostMapping(value={"/data/deleteByFilter"})
    public Response<Long> deleteByFilter(@RequestBody DataBatchDeleteDTO dataBatchDeleteDTO) {
        return Response.ok((Object)this.datumDatabaseEditService.deleteDataByFilter(dataBatchDeleteDTO));
    }
}

