/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.datasource;

import com.geoway.adf.dms.api.action.datasource.ResponseDatasetList;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.config.dto.filepackage.data.FileDataUnitDTO;
import com.geoway.adf.dms.datasource.constant.ModelDatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatabaseDTO;
import com.geoway.adf.dms.datasource.dto.model.ModelDatasetDTO;
import com.geoway.adf.dms.datasource.dto.model.create.ModelDatabaseCreateDTO;
import com.geoway.adf.dms.datasource.dto.model.create.ModelDatabaseEditDTO;
import com.geoway.adf.dms.datasource.dto.model.create.ModelDatasetCreateDTO;
import com.geoway.adf.dms.datasource.dto.model.create.ModelDatasetEditDTO;
import com.geoway.adf.dms.datasource.service.FileDataService;
import com.geoway.adf.dms.datasource.service.ModelDataSourceService;
import com.geoway.adf.dms.datasource.service.ModelDatabaseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource/model"})
@Api(tags={"01.06-\u6a21\u578b\u6570\u636e\u5e93"})
public class ModelDatabaseController {
    @Resource
    private ModelDatabaseService modelDatabaseService;
    @Resource
    private ModelDataSourceService modelDataSourceService;
    @Resource
    private FileDataService fileDataService;

    @ApiOperation(value="01-\u83b7\u53d6\u6570\u636e\u6e90\u5217\u8868")
    @GetMapping(value={"/list"})
    public Response<List<DatumDatabaseDTO>> list(@RequestParam(required=false) String keyword, @RequestParam(required=false) String category) {
        return Response.ok((Object)this.modelDatabaseService.listModelDatabase(keyword, category));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u6a21\u578b\u6570\u636e\u5e93\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    public Response<DatumDatabaseDTO> getDatumDatabaseDetail(@RequestParam String key) {
        return Response.ok((Object)this.modelDatabaseService.getModelDatabaseDetailWithOutPassWord(key));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u6a21\u578b\u6570\u636e\u96c6\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="types", value="\u6a21\u578b\u6570\u636e\u96c6\u7c7b\u578b", paramType="query", allowableValues="com.geoway.adf.dms.datasource.constant.ModelDatasetTypeEnum"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query")})
    @GetMapping(value={"/dataset/list"})
    public ResponseDatasetList<SimpleDatasetDTO> listDatumDataset(@RequestParam String dsKey, @RequestParam(required=false) String modelTypes, @RequestParam(required=false) String keyword, @RequestParam(required=false) Integer pageIndex, @RequestParam(required=false) Integer rows) {
        List datasetTypes = new ArrayList();
        if (StringUtil.isNotEmpty((String)modelTypes)) {
            datasetTypes = StringUtil.split((String)modelTypes, (String)",", t -> ModelDatasetTypeEnum.getByValue((Integer)Integer.valueOf(t)));
        }
        return ResponseDatasetList.ok(this.modelDatabaseService.listModelDataset(dsKey, datasetTypes, keyword, pageIndex, rows));
    }

    @ApiOperation(value="04-\u83b7\u53d6\u6a21\u578b\u6570\u636e\u96c6\u8be6\u60c5")
    @GetMapping(value={"/dataset/detail"})
    public Response<ModelDatasetDTO> getDatasetDetail(@RequestParam String key) {
        return Response.ok((Object)this.modelDatabaseService.getDatasetDetail(key));
    }

    @ApiOperation(value="05-\u521b\u5efa\u6a21\u578b\u6570\u636e\u5e93")
    @PostMapping(value={""})
    public Response<String> addDataSource(@RequestBody ModelDatabaseCreateDTO modelDatabaseCreateDTO) {
        return Response.ok((Object)this.modelDataSourceService.createModelDatabase(modelDatabaseCreateDTO));
    }

    @ApiOperation(value="06-\u4fee\u6539\u6a21\u578b\u6570\u636e\u5e93")
    @PutMapping(value={""})
    public Response updateModelDatabase(@RequestBody ModelDatabaseEditDTO modelDatabaseEditDTO) {
        this.modelDataSourceService.updateModelDatabase(modelDatabaseEditDTO);
        return Response.ok();
    }

    @ApiOperation(value="07-\u5220\u9664\u6a21\u578b\u6570\u636e\u5e93")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u5e93\u6807\u8bc6", required=true, paramType="path"), @ApiImplicitParam(name="deleteBizInfo", value="\u662f\u5426\u5220\u9664\u5173\u8054\u7684\u4e1a\u52a1\u4fe1\u606f", dataType="Boolean")})
    @DeleteMapping(value={""})
    public Response deleteModelDatabase(@RequestParam String key, @RequestParam(required=false, defaultValue="false") Boolean deleteBizInfo) {
        this.modelDataSourceService.deleteModelDatabase(key, deleteBizInfo);
        return Response.ok();
    }

    @ApiOperation(value="08-\u521b\u5efa\u6a21\u578b\u6570\u636e\u96c6")
    @PostMapping(value={"/dataset"})
    public Response<String> createModelDataset(@RequestBody ModelDatasetCreateDTO createDTO) {
        return Response.ok((Object)this.modelDatabaseService.createModelDataset(createDTO));
    }

    @ApiOperation(value="09-\u4fee\u6539\u6a21\u578b\u6570\u636e\u96c6")
    @PutMapping(value={"/dataset"})
    public Response updateDatumDataset(@RequestBody ModelDatasetEditDTO editDTO) {
        this.modelDatabaseService.updateModelDataset(editDTO);
        return Response.ok();
    }

    @ApiOperation(value="10-\u5220\u9664\u6a21\u578b\u6570\u636e\u96c6")
    @DeleteMapping(value={"/dataset"})
    public Response deleteModelDatabase(@RequestParam String id) {
        this.modelDatabaseService.deleteModelDataset(id);
        return Response.ok();
    }

    @ApiOperation(value="11-\u83b7\u53d6\u6570\u636e\u5305\u6587\u4ef6\u7ec4\u7ec7\u7ed3\u6784")
    @GetMapping(value={"/file/data/catalog"})
    public Response<FileDataUnitDTO> getFileDataCatalog(@RequestParam String dataId) {
        return Response.ok((Object)this.fileDataService.getFileDataTree(dataId));
    }

    @ApiOperation(value="12-\u4e0b\u8f7d\u6a21\u578b\u6570\u636e\u5305")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataId", value="\u6570\u636eID", required=true), @ApiImplicitParam(name="fileLocation", value="\u6587\u4ef6\uff08\u5939\uff09\u76f8\u5bf9\u8def\u5f84\uff0c\u552f\u4e00\u6807\u8bc6")})
    @GetMapping(value={"/file/data/download"})
    public void getFileDataCatalog(@RequestParam String dataId, @RequestParam(required=false) String fileLocation) {
        this.fileDataService.downloadFileDataUnit(dataId, fileLocation);
    }
}

