/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.charts.check;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.geoway.adf.dms.charts.check.BuildTime;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.JdbcWorkspace;
import java.sql.Timestamp;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class ChartLicenseChecker {
    private static final Logger log = LoggerFactory.getLogger(ChartLicenseChecker.class);
    @Resource
    private GeoDatabaseService geoDatabaseService;
    private final int validMonth = 6;

    public ChartLicenseChecker() {
        log.info("chart module build time:" + BuildTime.BUILD_TIME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        DateTime expiryDate;
        String buildDateStr = BuildTime.BUILD_TIME;
        try {
            expiryDate = DateUtil.parseDate((CharSequence)buildDateStr);
            expiryDate = DateUtil.offsetMonth((Date)expiryDate, (int)6);
        }
        catch (Exception e) {
            log.error("buildDate:" + buildDateStr);
            throw new RuntimeException("ABF\u7f16\u8f91\u529f\u80fd\u5df2\u5230\u671f", e);
        }
        Date nowDate = new Date();
        if (nowDate.compareTo((Date)expiryDate) > 0) {
            throw new RuntimeException("ABF\u7f16\u8f91\u529f\u80fd\u5df2\u5230\u671f");
        }
        Timestamp serverDate = null;
        try (IFeatureWorkspace workspace = null;){
            workspace = this.geoDatabaseService.openGeoWorkspace("key");
            if (workspace instanceof JdbcWorkspace && ((serverDate = ((JdbcWorkspace)workspace).getServerDate()) == null || ((Date)serverDate).compareTo((Date)expiryDate) > 0)) {
                throw new RuntimeException("ABF\u7f16\u8f91\u529f\u80fd\u5df2\u5230\u671f");
            }
        }
    }
}

