/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.charts.service.impl;

import com.geoway.adf.dms.charts.dao.ChartSnapshotDao;
import com.geoway.adf.dms.charts.entity.ChartSnapshot;
import com.geoway.adf.dms.charts.service.ChartSceneSnapshotService;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ChartSceneSnapshotServiceImpl
implements ChartSceneSnapshotService {
    @Resource
    private ChartSnapshotDao chartSnapshotDao;

    @Override
    public PageInfo<ChartSnapshot> list(int page, int rows, String sceneId, String keyword) {
        PageHelper.startPage((int)(page + 1), (int)rows);
        return new PageInfo(this.chartSnapshotDao.select(sceneId, keyword));
    }

    @Override
    public ChartSnapshot getChartSnapshot(String sceneId, String snapshotKey) {
        if (snapshotKey == null) {
            snapshotKey = "";
        }
        return this.chartSnapshotDao.selectBySnapshotKey(sceneId, snapshotKey);
    }

    @Override
    public String getSceneShot(String sceneId, String snapshotKey) {
        byte[] data;
        if (snapshotKey == null) {
            snapshotKey = "";
        }
        if ((data = (byte[])this.chartSnapshotDao.selectSceneShot(sceneId, snapshotKey)) != null) {
            return new String(data, StandardCharsets.UTF_8);
        }
        return null;
    }

    @Override
    public String getMapShot(String sceneId, String snapshotKey) {
        byte[] data;
        if (snapshotKey == null) {
            snapshotKey = "";
        }
        if ((data = (byte[])this.chartSnapshotDao.selectMapShot(sceneId, snapshotKey)) != null) {
            return new String(data, StandardCharsets.UTF_8);
        }
        return null;
    }

    @Override
    public void saveSceneSnapshot(ChartSnapshot chartSnapshot) {
        if (StringUtil.isEmptyOrWhiteSpace((String)chartSnapshot.getSceneId())) {
            throw new RuntimeException("\u573a\u666f\u6807\u8bc6\u4e3a\u7a7a");
        }
        if (chartSnapshot.getSnapshotKey() == null) {
            chartSnapshot.setSnapshotKey("");
        }
        chartSnapshot.setCreateTime(new Date());
        this.chartSnapshotDao.deleteBySnapshotKey(chartSnapshot.getSceneId(), chartSnapshot.getSnapshotKey());
        this.chartSnapshotDao.insert(chartSnapshot);
    }

    @Override
    public void deleteSceneSnapshot(String ids) {
        List list = ListUtil.convertAll((Object[])ids.split(","), Long::parseLong);
        this.chartSnapshotDao.deleteByIds(list);
    }
}

