/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.charts.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.geoway.adf.dms.charts.dto.ChartDataQueryParam;
import com.geoway.adf.dms.charts.dto.StatDataTypeEnum;
import com.geoway.adf.dms.charts.dto.StatIndicatorDTO;
import com.geoway.adf.dms.charts.dto.StatScheduleDTO;
import com.geoway.adf.dms.charts.service.StatIndicatorService;
import com.geoway.adf.dms.charts.service.impl.StatIndicatorServiceImpl;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.sql.SQLQueryExpressionParser;
import com.geoway.adf.dms.common.sql.SQLQueryWhereClause;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TableDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TableViewDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.FieldUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.JdbcWorkspace;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ChartDataQueryService {
    private static final Logger log = LoggerFactory.getLogger(ChartDataQueryService.class);
    @Resource
    private StatIndicatorService indicatorService;
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    private Cache<String, List<Map<String, Object>>> resultCache;
    static List<SimpleDateFormat> dateFormats;

    @Autowired
    public void initCache() {
        this.resultCache = Caffeine.newBuilder().expireAfterWrite(1500L, TimeUnit.MILLISECONDS).maximumSize(10000L).build();
    }

    public List<Map<String, Object>> queryChartDataUseCache(ChartDataQueryParam params) {
        String key = JSON.toJSONString((Object)params, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.MapSortField});
        List<Map<String, Object>> result = (List<Map<String, Object>>)this.resultCache.getIfPresent((Object)key);
        if (result == null && (result = this.queryChartData(params)) != null) {
            this.resultCache.put((Object)key, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<Map<String, Object>> queryChartData(ChartDataQueryParam queryParam) {
        StatIndicatorDTO indicator = this.indicatorService.getIndicatorDetail(queryParam.getIndicator(), false);
        Assert.isTrue((boolean)StatIndicatorServiceImpl.TYPE_INDICATOR.equals(indicator.getType()), (String)"\u65e0\u6548\u7edf\u8ba1\u6307\u6807\uff01");
        Assert.isTrue((boolean)indicator.getEnable(), (String)"\u7edf\u8ba1\u6307\u6807\u5df2\u505c\u7528\uff01");
        try (IFeatureWorkspace workspace = null;){
            String sql = null;
            ArrayList<Object> args = new ArrayList<Object>();
            IFields fields = null;
            StatDataTypeEnum statDataTypeEnum = StatDataTypeEnum.getByValue(indicator.getDataType());
            switch (statDataTypeEnum) {
                case Table: {
                    String tableFullName;
                    if (StringUtil.isEmptyOrWhiteSpace((String)indicator.getDatasetId())) {
                        throw new RuntimeException(indicator.getName() + " \u672a\u8bbe\u7f6e\u7edf\u8ba1\u7ed3\u679c\u8868\uff01");
                    }
                    DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo((String)indicator.getDatasetId());
                    String dsKey = datasetNameInfo.getDsKey();
                    workspace = this.geoDatabaseService.openGeoWorkspace(dsKey);
                    Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
                    if (workspace instanceof JdbcWorkspace) {
                        ((JdbcWorkspace)workspace).setQueryTimeout(10);
                    }
                    IGeoDataset geoDataset = workspace.openGeoDataset(datasetNameInfo.getName());
                    Assert.isTrue((boolean)(geoDataset instanceof ITable), (String)(datasetNameInfo.getName() + "\u4e0d\u652f\u6301\u67e5\u8be2\uff01"));
                    ITable geoTable = (ITable)geoDataset;
                    fields = geoTable.getFields();
                    ArrayList<String> fieldNames = new ArrayList<String>();
                    for (IField fld : geoTable.getFields()) {
                        if (fld.getFieldType() == FieldType.Shape) continue;
                        if (fld.getPhysicalName() != null && !fld.getPhysicalName().isEmpty()) {
                            fieldNames.add("\"" + fld.getPhysicalName() + "\"");
                            continue;
                        }
                        fieldNames.add(fld.getName());
                    }
                    int index = geoDataset.getFullName().indexOf(".");
                    if (index > 0) {
                        String schema = geoDataset.getFullName().substring(0, index);
                        String tableName = geoDataset.getFullName().substring(index + 1);
                        tableFullName = schema + ".\"" + tableName + "\"";
                    } else {
                        tableFullName = "\"" + geoDataset.getFullName() + "\"";
                    }
                    sql = "select " + String.join((CharSequence)",", fieldNames) + " from " + tableFullName;
                    String condition = this.getQueryCondition(indicator, queryParam, fields, args);
                    if (!StringUtil.isNotEmpty((String)condition)) break;
                    sql = sql + " where " + condition;
                    break;
                }
                case SQLQuery: {
                    if (StatScheduleDTO.isStatSchedule(indicator.getStatSchedule()) && StringUtil.isNotEmpty((String)indicator.getStatSchedule().getStatTableName())) {
                        workspace = this.geoDatabaseService.openGeoWorkspace("key");
                        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
                        if (workspace instanceof JdbcWorkspace) {
                            ((JdbcWorkspace)workspace).setQueryTimeout(10);
                        }
                        String tableName = indicator.getStatSchedule().getStatTableName();
                        ITable geoTable = workspace.openTable(tableName);
                        Assert.notNull((Object)geoTable, (String)("\u7edf\u8ba1\u8868[" + tableName + "]\u6253\u5f00\u5931\u8d25\uff01"));
                        fields = geoTable.getFields();
                        ArrayList<String> fieldNames = new ArrayList<String>();
                        for (IField fld : geoTable.getFields()) {
                            if (fld.getFieldType() == FieldType.Shape) continue;
                            fieldNames.add("\"" + fld.getName() + "\"");
                        }
                        sql = "select " + String.join((CharSequence)",", fieldNames) + " from " + tableName;
                        String condition = this.getQueryCondition(indicator, queryParam, fields, args);
                        if (!StringUtil.isNotEmpty((String)condition)) break;
                        sql = sql + " where " + condition;
                        break;
                    }
                    if (StringUtil.isEmptyOrWhiteSpace((String)indicator.getDsKey())) {
                        throw new RuntimeException(indicator.getName() + " \u6570\u636e\u6e90\u6807\u8bc6\u4e3a\u7a7a\uff01");
                    }
                    if (StringUtil.isEmptyOrWhiteSpace((String)indicator.getDataSql())) {
                        throw new RuntimeException(indicator.getName() + " \u67e5\u8be2\u8bed\u53e5\u4e3a\u7a7a\uff01");
                    }
                    DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(indicator.getDsKey());
                    workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSourceDTO);
                    Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
                    ICursor fieldCursor = null;
                    try {
                        String fieldSql = String.format("select * from (%s) temp___ where 1=2", indicator.getDataSql());
                        fieldCursor = workspace.excuteQuerySql(fieldSql);
                        fields = fieldCursor.getFields();
                    }
                    finally {
                        if (fieldCursor != null) {
                            fieldCursor.release();
                        }
                    }
                    sql = indicator.getDataSql();
                    String condition = this.getQueryCondition(indicator, queryParam, fields, args);
                    if (!StringUtil.isNotEmpty((String)condition)) break;
                    sql = String.format("select * from (%s) temp___ where %s", sql, condition);
                    break;
                }
                default: {
                    throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u7684\u6307\u6807\u6570\u636e\u7c7b\u578b\uff1a" + (Object)((Object)statDataTypeEnum));
                }
            }
            ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
            ICursor cursor = null;
            try {
                IRow row;
                cursor = workspace.excuteQuerySql(sql, args.toArray());
                while ((row = cursor.nextRow()) != null) {
                    LinkedHashMap<String, Object> attMap = new LinkedHashMap<String, Object>();
                    for (IField fld : fields) {
                        if (!row.getFields().contains(fld.getName()) || fld.getFieldType() == FieldType.Shape) continue;
                        attMap.put(fld.getAliasName(), row.getValue(fld.getName()));
                    }
                    dataList.add(attMap);
                    if (dataList.size() != 10000) continue;
                    break;
                }
                ArrayList<Map<String, Object>> arrayList = dataList;
                return arrayList;
            }
            catch (Exception e) {
                if (sql != null && e instanceof SQLException) {
                    log.error(String.format("\u6267\u884csql\u5f02\u5e38\uff1a%s", sql));
                }
                throw new RuntimeException(indicator.getName() + " \u6307\u6807\u6570\u636e\u67e5\u8be2\u5931\u8d25", e);
            }
            finally {
                if (cursor != null) {
                    cursor.release();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public List<String> queryChartDataFields(String indicatorId) {
        List fieldList;
        StatIndicatorDTO indicator = this.indicatorService.getIndicatorDetail(indicatorId, false);
        Assert.isTrue((boolean)StatIndicatorServiceImpl.TYPE_INDICATOR.equals(indicator.getType()), (String)"\u65e0\u6548\u7edf\u8ba1\u6307\u6807\uff01");
        Assert.isTrue((boolean)indicator.getEnable(), (String)"\u7edf\u8ba1\u6307\u6807\u5df2\u505c\u7528\uff01");
        StatDataTypeEnum statDataTypeEnum = StatDataTypeEnum.getByValue(indicator.getDataType());
        switch (statDataTypeEnum) {
            case Table: {
                if (StringUtil.isEmptyOrWhiteSpace((String)indicator.getDatasetId())) {
                    throw new RuntimeException(indicator.getName() + " \u672a\u8bbe\u7f6e\u7edf\u8ba1\u7ed3\u679c\u8868\uff01");
                }
                DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(indicator.getDatasetId());
                if (datasetDTO instanceof TableDatasetDTO) {
                    fieldList = ((TableDatasetDTO)datasetDTO).getFields();
                    break;
                }
                if (datasetDTO instanceof FeatureClassDTO) {
                    fieldList = ((FeatureClassDTO)datasetDTO).getFields();
                    break;
                }
                if (datasetDTO instanceof TableViewDTO) {
                    fieldList = ((TableViewDTO)datasetDTO).getFields();
                    break;
                }
                throw new RuntimeException(datasetDTO.getName() + "\u4e0d\u652f\u6301\u67e5\u8be2\uff01");
            }
            case SQLQuery: {
                if (StringUtil.isEmptyOrWhiteSpace((String)indicator.getDsKey())) {
                    throw new RuntimeException(indicator.getName() + " \u6570\u636e\u6e90\u6807\u8bc6\u4e3a\u7a7a\uff01");
                }
                if (StringUtil.isEmptyOrWhiteSpace((String)indicator.getDataSql())) {
                    throw new RuntimeException(indicator.getName() + " \u67e5\u8be2\u8bed\u53e5\u4e3a\u7a7a\uff01");
                }
                fieldList = this.indicatorService.getFieldsBySql(indicator.getDsKey(), indicator.getDataSql());
                break;
            }
            default: {
                throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u7684\u6307\u6807\u6570\u636e\u7c7b\u578b\uff1a" + (Object)((Object)statDataTypeEnum));
            }
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (FieldDTO fld : fieldList) {
            if (fld.getFieldType().intValue() == FieldType.Shape.getValue()) continue;
            fieldNames.add(fld.getAliasName());
        }
        return fieldNames;
    }

    private String getParentXzqCode(String xzqdm) {
        if (StringUtil.isEmptyOrWhiteSpace((String)xzqdm)) {
            return "";
        }
        String pCode = xzqdm.length() <= 6 ? (xzqdm.endsWith("000000") ? "000000" : (xzqdm.endsWith("0000") ? "000000" : (xzqdm.endsWith("00") ? xzqdm.substring(0, 2) + "0000" : (this.isSpecialXzqh(xzqdm) ? xzqdm.substring(0, 2) + "0000" : (xzqdm.length() == 2 ? xzqdm + "0000" : (xzqdm.length() == 4 ? xzqdm + "00" : (xzqdm.length() == 6 ? xzqdm.substring(0, 4) + "00" : null))))))) : (xzqdm.length() <= 9 ? xzqdm.substring(0, 6) : (xzqdm.length() <= 12 ? xzqdm.substring(0, 9) : xzqdm.substring(0, 12)));
        return pCode;
    }

    private boolean isSpecialXzqh(String xzqdm) {
        return xzqdm.startsWith("11") || xzqdm.startsWith("12") || xzqdm.startsWith("50") || xzqdm.startsWith("81") || xzqdm.startsWith("82");
    }

    private String getQueryCondition(StatIndicatorDTO indicator, ChartDataQueryParam queryParam, IFields fields, List<Object> queryArgs) {
        ArrayList<String> conditions = new ArrayList<String>();
        if (!(indicator.getDataType() != null && indicator.getDataType().intValue() != StatDataTypeEnum.Table.getValue() || StringUtil.isEmptyOrWhiteSpace((String)indicator.getFilterStr()))) {
            conditions.add("(" + indicator.getFilterStr() + ")");
        }
        String yearfilter = queryParam.getYearfilter();
        IField yearField = null;
        if (!StringUtil.isEmptyOrWhiteSpace((String)indicator.getTimeField())) {
            yearField = fields.findField(indicator.getTimeField());
        }
        if (yearField != null && !StringUtil.isEmptyOrWhiteSpace((String)yearfilter)) {
            Object yearValue;
            String[] yearRang = yearfilter.split(",", 2);
            if (yearRang.length == 2) {
                if (yearRang[0].isEmpty() && !yearRang[1].isEmpty()) {
                    conditions.add(String.format("%s <= ?", indicator.getTimeField()));
                    yearValue = this.convertValue(yearField.getFieldType(), yearRang[1]);
                    queryArgs.add(yearValue);
                } else if (!yearRang[0].isEmpty() && yearRang[1].isEmpty()) {
                    conditions.add(String.format("%s >= ?", indicator.getTimeField()));
                    yearValue = this.convertValue(yearField.getFieldType(), yearRang[0]);
                    queryArgs.add(yearValue);
                } else if (!yearRang[0].isEmpty() && !yearRang[1].isEmpty()) {
                    conditions.add(String.format("(%s >= ? and %s <= ?)", indicator.getTimeField(), indicator.getTimeField()));
                    yearValue = this.convertValue(yearField.getFieldType(), yearRang[0]);
                    queryArgs.add(yearValue);
                    yearValue = this.convertValue(yearField.getFieldType(), yearRang[1]);
                    queryArgs.add(yearValue);
                }
            } else {
                conditions.add(String.format("%s=?", indicator.getTimeField()));
                yearValue = this.convertValue(yearField.getFieldType(), yearfilter);
                queryArgs.add(yearValue);
            }
        }
        String xzqhfilter = queryParam.getXzqhfilter();
        IField xzqdmField = null;
        if (!StringUtil.isEmptyOrWhiteSpace((String)indicator.getDistrictField())) {
            xzqdmField = fields.findField(indicator.getDistrictField());
        }
        if (xzqdmField != null && !StringUtil.isEmptyOrWhiteSpace((String)xzqhfilter)) {
            String[] xzghCodes = xzqhfilter.split(",");
            conditions.add(String.format("%s in (%s)", indicator.getDistrictField(), String.join((CharSequence)",", Collections.nCopies(xzghCodes.length, "?"))));
            for (String str : xzghCodes) {
                queryArgs.add(this.convertValue(xzqdmField.getFieldType(), str));
            }
        }
        ArrayList<FieldDTO> fieldDTOs = new ArrayList<FieldDTO>();
        for (IField fld : fields) {
            fieldDTOs.add(FieldUtil.convertField((IField)fld));
        }
        if (!StringUtil.isEmptyOrWhiteSpace((String)queryParam.getFieldfilter())) {
            SQLQueryWhereClause sqlQueryWhereClause = SQLQueryExpressionParser.parse((String)queryParam.getFieldfilter(), (String)"!", (String)"=", fieldDTOs);
            if (StringUtil.isEmptyOrWhiteSpace((String)sqlQueryWhereClause.getWhere())) {
                log.error("\u5b57\u6bb5\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u6b63\u786e\uff1a" + queryParam.getFieldfilter());
            } else {
                conditions.add("(" + sqlQueryWhereClause.getWhere() + ")");
                queryArgs.addAll(sqlQueryWhereClause.getValues());
            }
        }
        String condition = "";
        if (conditions.size() > 0) {
            condition = StringUtil.join((String)" and ", conditions);
        }
        return condition;
    }

    private boolean fieldValueEquals(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null) {
            value1 = "";
        }
        if (value2 == null) {
            value2 = "";
        }
        return value1.toString().trim().equals(value2.toString().trim());
    }

    private Object convertValue(FieldType fieldType, Object value) {
        if (value == null) {
            return null;
        }
        switch (fieldType) {
            case Decimal: {
                if (value instanceof BigDecimal) {
                    return value;
                }
                if (value instanceof String) {
                    return new BigDecimal((String)value);
                }
                return value;
            }
            case Double: {
                if (value instanceof Double) {
                    return value;
                }
                if (value instanceof String) {
                    return Double.valueOf((String)value);
                }
                return value;
            }
            case Short: {
                if (value instanceof Short) {
                    return value;
                }
                if (value instanceof String) {
                    return Short.valueOf((String)value);
                }
                return value;
            }
            case Int: {
                if (value instanceof Integer) {
                    return value;
                }
                if (value instanceof String) {
                    return Integer.valueOf((String)value);
                }
                return value;
            }
            case Long: {
                if (value instanceof Long) {
                    return value;
                }
                if (value instanceof String) {
                    return Long.valueOf((String)value);
                }
                return value;
            }
            case Float: {
                if (value instanceof Float) {
                    return value;
                }
                if (value instanceof String) {
                    return Float.valueOf((String)value);
                }
                return value;
            }
            case String: 
            case Text: {
                return value.toString();
            }
            case DateTime: {
                String strValue = value.toString();
                for (SimpleDateFormat pattern : dateFormats) {
                    try {
                        return new Timestamp(pattern.parse(strValue).getTime());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                return value;
            }
        }
        return value;
    }

    static {
        String[] formats = new String[]{"yyyy", "yyyy\u5e74", "yyyy-MM", "yyyy/MM", "yyyy\u5e74MM\u6708", "yyyyMM", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy\u5e74MM\u6708dd\u65e5", "yyyyMMdd", "yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2"};
        dateFormats = new ArrayList<SimpleDateFormat>();
        for (String f : formats) {
            SimpleDateFormat df = new SimpleDateFormat(f);
            df.setLenient(false);
            dateFormats.add(df);
        }
    }
}

