/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.charts.component;

import cn.hutool.core.date.CalendarUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.geoway.adf.dms.charts.dto.StatDataTypeEnum;
import com.geoway.adf.dms.charts.dto.StatIndicatorDTO;
import com.geoway.adf.dms.charts.dto.StatScheduleDTO;
import com.geoway.adf.dms.charts.dto.StatTimeUnitEnum;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class StatIndicatorScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(StatIndicatorScheduleTask.class);
    @Resource
    private GeoDatabaseService geoDatabaseService;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(5);
    private final Map<String, RunningScheduler> tasks = new ConcurrentHashMap<String, RunningScheduler>();

    public IFeatureWorkspace openStatWorkspace() {
        return this.geoDatabaseService.openGeoWorkspace("key");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createStatTable(StatIndicatorDTO indicatorDTO) {
        if (StatDataTypeEnum.SQLQuery.getValue() != indicatorDTO.getDataType().intValue()) {
            throw new RuntimeException("\u53ea\u652f\u6301SQL\u7edf\u8ba1");
        }
        IFeatureWorkspace statWorkspace = null;
        IFeatureWorkspace dataWorkspace = null;
        ICursor cursor = null;
        try {
            ITable statTable;
            statWorkspace = this.openStatWorkspace();
            Assert.notNull((Object)statWorkspace, (String)"\u4e1a\u52a1\u5e93\u8fde\u63a5\u5931\u8d25");
            DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(indicatorDTO.getDsKey());
            dataWorkspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSourceDTO);
            Assert.notNull((Object)dataWorkspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
            String sql = String.format("select * from (%s) temp___ where 1=2", indicatorDTO.getDataSql());
            cursor = dataWorkspace.excuteQuerySql(sql);
            ArrayList<IField> fields = new ArrayList<IField>();
            for (IField fld : cursor.getFields()) {
                IField newField = fld.clone();
                newField.setPhysicalName(fld.getName());
                fields.add(newField);
            }
            StatScheduleDTO statScheduleDTO = indicatorDTO.getStatSchedule();
            if (this.tasks.containsKey(indicatorDTO.getId())) {
                this.cancelScheduleTask(indicatorDTO.getId());
            }
            if ((statTable = statWorkspace.openTable(statScheduleDTO.getStatTableName())) != null) {
                statTable.delete();
            }
            boolean bl = (statTable = statWorkspace.createTable(statScheduleDTO.getStatTableName(), (IFields)new Fields(fields))) != null;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            if (statWorkspace != null) {
                statWorkspace.close();
            }
            if (dataWorkspace != null) {
                dataWorkspace.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteStatTable(String statTableName) {
        Assert.notNull((Object)statWorkspace, (String)"\u4e1a\u52a1\u5e93\u8fde\u63a5\u5931\u8d25");
        try (IFeatureWorkspace statWorkspace = this.openStatWorkspace();){
            ITable table = statWorkspace.openTable(statTableName);
            if (table != null) {
                table.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean excuteStat(StatIndicatorDTO indicatorDTO) {
        RunningScheduler runningScheduler = this.tasks.get(indicatorDTO.getId());
        if (runningScheduler != null && runningScheduler.canceled) {
            return false;
        }
        if (StatDataTypeEnum.SQLQuery.getValue() != indicatorDTO.getDataType().intValue()) {
            throw new RuntimeException("\u53ea\u652f\u6301SQL\u7edf\u8ba1");
        }
        log.info("\u7edf\u8ba1\u6307\u6807[" + indicatorDTO.getName() + "]\u5f00\u59cb\u6267\u884c\u7edf\u8ba1");
        StatScheduleDTO statScheduleDTO = indicatorDTO.getStatSchedule();
        IFeatureWorkspace statWorkspace = null;
        IFeatureWorkspace dataWorkspace = null;
        ICursor cursor = null;
        ICursor insertCursor = null;
        try {
            statWorkspace = this.openStatWorkspace();
            Assert.notNull((Object)statWorkspace, (String)"\u4e1a\u52a1\u5e93\u8fde\u63a5\u5931\u8d25");
            DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(indicatorDTO.getDsKey());
            dataWorkspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSourceDTO);
            Assert.notNull((Object)dataWorkspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
            ITable statTable = statWorkspace.openTable(statScheduleDTO.getStatTableName());
            if (statTable == null) {
                if (this.createStatTable(indicatorDTO)) {
                    statTable = statWorkspace.openTable(statScheduleDTO.getStatTableName());
                }
                Assert.notNull((Object)statTable, (String)"\u7edf\u8ba1\u8868\u521b\u5efa\u5931\u8d25\uff01");
            }
            statWorkspace.beginTransaction();
            statTable.deleteRow(null);
            cursor = dataWorkspace.excuteQuerySql(indicatorDTO.getDataSql());
            insertCursor = statTable.batchInsertRow();
            IRow row = cursor.nextRow();
            while (row != null) {
                if (runningScheduler != null && runningScheduler.canceled) {
                    throw new RuntimeException("\u4efb\u52a1\u5df2\u53d6\u6d88");
                }
                IRow newRow = statTable.createRow();
                for (IField fld : row.getFields()) {
                    if (fld.getFieldType() == FieldType.Shape) continue;
                    newRow.setValue(fld.getName(), row.getValue(fld.getName()));
                }
                insertCursor.insertRow(newRow);
                row = cursor.nextRow();
            }
            insertCursor.release();
            insertCursor = null;
            statWorkspace.commitTransaction();
            log.info("\u7edf\u8ba1\u6307\u6807[" + indicatorDTO.getName() + "]\u6267\u884c\u7edf\u8ba1\u7ed3\u675f");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error(indicatorDTO.getDataSql());
            log.error("\u7edf\u8ba1\u6307\u6807[" + indicatorDTO.getName() + "]\u6267\u884c\u7edf\u8ba1\u5f02\u5e38", (Throwable)e);
            if (statWorkspace != null && statWorkspace.getInTransaction()) {
                statWorkspace.rollbackTransaction();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            if (insertCursor != null) {
                insertCursor.release();
            }
            if (dataWorkspace != null) {
                dataWorkspace.close();
            }
            if (statWorkspace != null) {
                statWorkspace.close();
            }
        }
    }

    public void addScheduleTask(StatIndicatorDTO indicatorDTO) {
        if (StatDataTypeEnum.SQLQuery.getValue() != indicatorDTO.getDataType().intValue()) {
            return;
        }
        if (this.tasks.containsKey(indicatorDTO.getId())) {
            return;
        }
        StatScheduleDTO statScheduleDTO = indicatorDTO.getStatSchedule();
        Date dateNow = new Date();
        Date startDate = statScheduleDTO.getStatStartTime();
        ScheduledFuture<?> future = null;
        StatTimeUnitEnum statTimeUnitEnum = StatTimeUnitEnum.getByValue(statScheduleDTO.getStatTimeUnit());
        switch (statTimeUnitEnum) {
            case None: 
            case Once: {
                break;
            }
            case Daily: {
                long period = 86400L;
                Date nextDate = this.getNextDate(dateNow, startDate, period);
                long initialDelay = DateUtil.between((Date)dateNow, (Date)nextDate, (DateUnit)DateUnit.SECOND);
                future = this.scheduler.scheduleAtFixedRate(() -> this.excuteStat(indicatorDTO), initialDelay, period, TimeUnit.SECONDS);
                break;
            }
            case Weekly: {
                long period = 604800L;
                Date nextDate = this.getNextDate(dateNow, startDate, period);
                long initialDelay = DateUtil.between((Date)dateNow, (Date)nextDate, (DateUnit)DateUnit.SECOND);
                future = this.scheduler.scheduleAtFixedRate(() -> this.excuteStat(indicatorDTO), initialDelay, period, TimeUnit.SECONDS);
                break;
            }
            case Monthly: {
                Date nextDate = this.getNextMouthDate(dateNow, startDate);
                long initialDelay = DateUtil.between((Date)dateNow, (Date)nextDate, (DateUnit)DateUnit.SECOND);
                future = this.scheduler.schedule(() -> this.excuteScheduleMouth(indicatorDTO), initialDelay, TimeUnit.SECONDS);
                break;
            }
            case IntervalMinutes: {
                long period = statScheduleDTO.getStatInterval() * 60L;
                Date nextDate = this.getNextDate(dateNow, startDate, period);
                long initialDelay = DateUtil.between((Date)dateNow, (Date)nextDate, (DateUnit)DateUnit.SECOND);
                future = this.scheduler.scheduleWithFixedDelay(() -> this.excuteStat(indicatorDTO), initialDelay, period, TimeUnit.SECONDS);
                break;
            }
            case IntervalHours: {
                long period = statScheduleDTO.getStatInterval() * 60L * 60L;
                Date nextDate = this.getNextDate(dateNow, startDate, period);
                long initialDelay = DateUtil.between((Date)dateNow, (Date)nextDate, (DateUnit)DateUnit.SECOND);
                future = this.scheduler.scheduleWithFixedDelay(() -> this.excuteStat(indicatorDTO), initialDelay, period, TimeUnit.SECONDS);
                break;
            }
            case IntervalDays: {
                long period = statScheduleDTO.getStatInterval() * 24L * 60L * 60L;
                Date nextDate = this.getNextDate(dateNow, startDate, period);
                long initialDelay = DateUtil.between((Date)dateNow, (Date)nextDate, (DateUnit)DateUnit.SECOND);
                future = this.scheduler.scheduleWithFixedDelay(() -> this.excuteStat(indicatorDTO), initialDelay, period, TimeUnit.SECONDS);
            }
        }
        if (future != null) {
            RunningScheduler runningScheduler = new RunningScheduler();
            runningScheduler.future = future;
            this.tasks.put(indicatorDTO.getId(), runningScheduler);
        }
    }

    private void excuteScheduleMouth(StatIndicatorDTO indicatorDTO) {
        this.excuteStat(indicatorDTO);
        this.cancelScheduleTask(indicatorDTO.getId());
        Date dateNow = new Date();
        Date startDate = indicatorDTO.getStatSchedule().getStatStartTime();
        Date nextDate = this.getNextMouthDate(dateNow, startDate);
        long initialDelay = DateUtil.between((Date)dateNow, (Date)nextDate, (DateUnit)DateUnit.SECOND);
        ScheduledFuture<?> future = this.scheduler.schedule(() -> this.excuteScheduleMouth(indicatorDTO), initialDelay, TimeUnit.SECONDS);
        RunningScheduler runningScheduler = new RunningScheduler();
        runningScheduler.future = future;
        this.tasks.put(indicatorDTO.getId(), runningScheduler);
    }

    private Date getNextDate(Date nowDate, Date startDate, long period) {
        long interval = DateUtil.between((Date)nowDate, (Date)startDate, (DateUnit)DateUnit.SECOND);
        if (nowDate.compareTo(startDate) > 0) {
            interval = (long)((int)Math.ceil((double)interval / (double)period)) * period - interval;
        }
        if (interval == 0L) {
            interval = period;
        }
        return DateUtil.offsetSecond((Date)nowDate, (int)((int)interval));
    }

    private Date getNextMouthDate(Date nowDate, Date startDate) {
        long interval = DateUtil.between((Date)nowDate, (Date)startDate, (DateUnit)DateUnit.SECOND);
        if (nowDate.compareTo(startDate) > 0) {
            Calendar calendar = CalendarUtil.calendar((Date)nowDate);
            calendar.set(5, DateUtil.dayOfMonth((Date)startDate));
            calendar.set(11, DateUtil.hour((Date)startDate, (boolean)true));
            calendar.set(12, DateUtil.minute((Date)startDate));
            calendar.set(13, DateUtil.second((Date)startDate));
            DateTime nextDate = DateUtil.date((Calendar)calendar);
            if (nowDate.compareTo((Date)nextDate) > 0) {
                calendar.add(2, 1);
                nextDate = DateUtil.date((Calendar)calendar);
            }
            interval = DateUtil.between((Date)nowDate, (Date)nextDate, (DateUnit)DateUnit.SECOND);
        }
        return DateUtil.offsetSecond((Date)nowDate, (int)((int)interval));
    }

    public void cancelScheduleTask(String id) {
        RunningScheduler runningScheduler = this.tasks.get(id);
        if (runningScheduler != null) {
            runningScheduler.canceled = true;
            runningScheduler.future.cancel(false);
            this.tasks.remove(id);
        }
    }

    public void shutdownScheduler() {
        this.scheduler.shutdown();
    }

    static class RunningScheduler {
        public ScheduledFuture<?> future;
        public boolean canceled = false;

        RunningScheduler() {
        }
    }
}

