/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.charts.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.adf.dms.common.config.OutputPathConfig;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictLevelDTO;
import com.geoway.adf.dms.datasource.dto.district.DmDistrictDTO;
import com.geoway.adf.dms.datasource.service.DistrictService;
import com.geoway.adf.gis.basic.gdalFunc;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Driver;
import org.gdal.ogr.Feature;
import org.gdal.ogr.FeatureDefn;
import org.gdal.ogr.FieldDefn;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.Layer;
import org.gdal.ogr.ogr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class XzqhQueryService {
    private static final Logger log = LoggerFactory.getLogger(XzqhQueryService.class);
    @Resource
    private DistrictService districtService;
    private Map<Long, String> geojsonCache = new LinkedHashMap<Long, String>();

    public String getXzqhTree(String yearFilter) {
        DmDistrictDTO defaultDistrict = this.getDefaultDistrict(yearFilter);
        if (defaultDistrict == null) {
            return null;
        }
        List districtItemDTOS = this.districtService.getDistrictItem(defaultDistrict.getId(), null, null, null, Boolean.valueOf(true), null);
        List levelDTOS = this.districtService.getDistrictLevels(defaultDistrict.getId());
        HashMap<Short, String> levelMap = new HashMap<Short, String>();
        levelDTOS.forEach(l -> levelMap.put(l.getIndex(), l.getName()));
        JSONObject rootObject = new JSONObject();
        for (DistrictItemDTO itemDTO : districtItemDTOS) {
            rootObject.put(itemDTO.getCode(), (Object)this.convertDistrictItem(itemDTO, levelMap));
        }
        return rootObject.toString(new SerializerFeature[]{SerializerFeature.MapSortField});
    }

    public String getXzqhLevels(String yearFilter) {
        DmDistrictDTO defaultDistrict = this.getDefaultDistrict(yearFilter);
        if (defaultDistrict == null) {
            return null;
        }
        List levelDTOS = this.districtService.getDistrictLevels(defaultDistrict.getId());
        JSONArray rootArray = new JSONArray();
        for (DistrictLevelDTO itemDTO : levelDTOS) {
            JSONObject levelObject = new JSONObject();
            levelObject.put("level", (Object)itemDTO.getIndex());
            levelObject.put("name", (Object)itemDTO.getName());
            rootArray.add((Object)levelObject);
        }
        return rootArray.toString(new SerializerFeature[]{SerializerFeature.MapSortField});
    }

    public DmDistrictDTO getDefaultDistrict(String yearFilter) {
        List list = this.districtService.list();
        if (list == null || list.size() == 0) {
            return null;
        }
        DmDistrictDTO defaultDistrict = (DmDistrictDTO)ListUtil.find((List)list, DmDistrictDTO::getIsDefault);
        if (defaultDistrict == null) {
            defaultDistrict = (DmDistrictDTO)list.get(0);
        }
        if (defaultDistrict != null && StringUtil.isNotEmpty((String)yearFilter)) {
            String key = defaultDistrict.getName();
            List districtList = ListUtil.findAll((List)list, d -> StringUtil.equals((String)d.getName(), (String)key));
            districtList.sort((d2, d1) -> StringUtil.compare((String)d1.getDataPhase(), (String)d2.getDataPhase()));
            DmDistrictDTO latestDistrict = null;
            for (DmDistrictDTO district : districtList) {
                if (StringUtil.compare((String)yearFilter, (String)district.getDataPhase()) < 0) continue;
                latestDistrict = district;
                break;
            }
            if (latestDistrict != null) {
                defaultDistrict = latestDistrict;
            } else if (districtList.size() > 0) {
                defaultDistrict = (DmDistrictDTO)districtList.get(districtList.size() - 1);
            }
        }
        return defaultDistrict;
    }

    private JSONObject convertDistrictItem(DistrictItemDTO itemDTO, Map<Short, String> levelMap) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)itemDTO.getName());
        JSONArray center = new JSONArray();
        center.add((Object)itemDTO.getCenterX());
        center.add((Object)itemDTO.getCenterY());
        jsonObject.put("cp", (Object)center);
        JSONArray box = new JSONArray();
        box.add((Object)itemDTO.getExtent().getXmin());
        box.add((Object)itemDTO.getExtent().getYmin());
        box.add((Object)itemDTO.getExtent().getXmax());
        box.add((Object)itemDTO.getExtent().getYmax());
        jsonObject.put("box", (Object)box);
        jsonObject.put("level", (Object)itemDTO.getLevelIndex());
        jsonObject.put("levelName", (Object)levelMap.get(itemDTO.getLevelIndex()));
        if (itemDTO.getChildren() != null) {
            JSONObject childrenObject = new JSONObject();
            jsonObject.put("children", (Object)childrenObject);
            for (DistrictItemDTO subItem : itemDTO.getChildren()) {
                childrenObject.put(subItem.getCode(), (Object)this.convertDistrictItem(subItem, levelMap));
            }
        }
        return jsonObject;
    }

    public String getXzqhGeojson(String yearFilter, String parentCode) {
        try {
            DmDistrictDTO defaultDistrict = this.getDefaultDistrict(yearFilter);
            if (defaultDistrict == null) {
                return null;
            }
            List districtItemDTOS = this.districtService.getDistrictItem(defaultDistrict.getId(), null, parentCode, null, Boolean.valueOf(false), null);
            if (districtItemDTOS == null || districtItemDTOS.size() == 0) {
                return null;
            }
            Long parentId = ((DistrictItemDTO)districtItemDTOS.get(0)).getPid();
            if (this.geojsonCache.containsKey(parentId)) {
                return new String(Files.readAllBytes(Paths.get(this.geojsonCache.get(parentId), new String[0])), StandardCharsets.UTF_8);
            }
            return this.createGeojson(parentId, districtItemDTOS);
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u884c\u653f\u533a\u6570\u636e\u5931\u8d25\uff1a" + yearFilter + "," + parentCode, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String createGeojson(Long parentId, List<DistrictItemDTO> districtItemDTOS) throws IOException {
        String fileName;
        String geojsonFile;
        File file;
        if (this.geojsonCache.containsKey(parentId)) {
            return new String(Files.readAllBytes(Paths.get(this.geojsonCache.get(parentId), new String[0])), StandardCharsets.UTF_8);
        }
        File districPath = OutputPathConfig.getOutputPath().resolve("xzqh").toFile();
        if (!districPath.exists()) {
            districPath.mkdirs();
        }
        if ((file = new File(geojsonFile = new File(districPath, fileName = parentId + ".geojson").getAbsolutePath())).exists() && file.isFile()) {
            file.delete();
        }
        DataSource oDS = null;
        try {
            if (!gdalFunc.isAvailable()) {
                String string = null;
                return string;
            }
            Driver oDriver = ogr.GetDriverByName((String)"GeoJSON");
            oDS = oDriver.CreateDataSource(geojsonFile, null);
            if (oDS == null) {
                log.error("\u521b\u5efa\u77e2\u91cf\u6587\u4ef6\u3010" + geojsonFile + "\u3011\u5931\u8d25");
                String string = null;
                return string;
            }
            Layer oLayer = oDS.CreateLayer(fileName, null, 3, null);
            if (oLayer == null) {
                log.error("\u56fe\u5c42\u521b\u5efa\u5931\u8d25");
                String string = null;
                return string;
            }
            this.createField(oLayer, "NAME_CHN", 4);
            this.createField(oLayer, "SOC", 4);
            this.createField(oLayer, "adcode", 4);
            this.createField(oLayer, "adcode_county", 4);
            this.createField(oLayer, "adcode_cit", 4);
            this.createField(oLayer, "adcode_pro", 4);
            this.createField(oLayer, "level", 4);
            this.createField(oLayer, "x", 2);
            this.createField(oLayer, "y", 2);
            this.createField(oLayer, "id", 4);
            this.createField(oLayer, "name", 4);
            this.createField(oLayer, "cp", 3);
            this.createField(oLayer, "level", 0);
            FeatureDefn oDefn = oLayer.GetLayerDefn();
            for (DistrictItemDTO itemDTO : districtItemDTOS) {
                IGeometry geometry = this.districtService.getDistrictItemGeometry(itemDTO.getId());
                if (geometry == null) {
                    log.error(itemDTO.getCode() + "(" + itemDTO.getId() + ")\u672a\u8bfb\u53d6\u5230\u8303\u56f4");
                    continue;
                }
                Feature oFeature = new Feature(oDefn);
                oFeature.SetField("NAME_CHN", itemDTO.getName());
                oFeature.SetField("SOC", "CHN");
                oFeature.SetField("adcode", itemDTO.getCode());
                oFeature.SetField("adcode_county", itemDTO.getCode().substring(0, 6));
                oFeature.SetField("adcode_cit", StrUtil.fillAfter((String)itemDTO.getCode().substring(0, 4), (char)'0', (int)6));
                oFeature.SetField("adcode_pro", StrUtil.fillAfter((String)itemDTO.getCode().substring(0, 2), (char)'0', (int)6));
                oFeature.SetField("level", this.getCodeLevel(itemDTO.getCode()));
                oFeature.SetField("x", itemDTO.getCenterX().doubleValue());
                oFeature.SetField("y", itemDTO.getCenterY().doubleValue());
                oFeature.SetField("id", itemDTO.getCode());
                oFeature.SetField("name", itemDTO.getName());
                oFeature.SetFieldDoubleList(11, new double[]{itemDTO.getCenterX(), itemDTO.getCenterY()});
                oFeature.SetField("level", (int)itemDTO.getLevelIndex().shortValue());
                Geometry geom = (Geometry)geometry.getObject();
                String level = this.getCodeLevel(itemDTO.getCode());
                double tolerance = 1.0E-6;
                if ("country".equals(level)) {
                    tolerance = 0.01;
                } else if ("province".equals(level)) {
                    tolerance = 0.005;
                } else if ("city".equals(level)) {
                    tolerance = 0.001;
                } else if ("county".equals(level)) {
                    tolerance = 5.0E-4;
                } else if ("town".equals(level)) {
                    tolerance = 1.0E-4;
                } else if ("village".equals(level)) {
                    tolerance = 5.0E-5;
                }
                geom = geom.Simplify(tolerance);
                oFeature.SetGeometry(geom);
                oLayer.CreateFeature(oFeature);
            }
            oLayer.delete();
            this.geojsonCache.put(parentId, geojsonFile);
            String string = new String(Files.readAllBytes(Paths.get(this.geojsonCache.get(parentId), new String[0])), StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            log.error(fileName + "\u5199\u5165\u5931\u8d25", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (oDS != null) {
                oDS.delete();
            }
        }
    }

    private void createField(Layer oLayer, String name, int type) {
        FieldDefn oField = new FieldDefn();
        oField.SetName(name);
        oField.SetType(type);
        oLayer.CreateField(oField, 1);
    }

    private String getCodeLevel(String code) {
        if (StringUtil.isEmptyOrWhiteSpace((String)code)) {
            return "";
        }
        String level = null;
        if (code.length() <= 6) {
            if (code.endsWith("000000")) {
                level = "country";
            } else if (code.endsWith("0000")) {
                level = "province";
            } else if (code.endsWith("00")) {
                level = "city";
            } else {
                if (code.startsWith("11") || code.startsWith("12") || code.startsWith("50") || code.startsWith("81") || code.startsWith("82")) {
                    // empty if block
                }
                level = "county";
            }
        } else if (code.length() <= 9) {
            level = "town";
        } else if (code.length() <= 12) {
            level = "village";
        }
        return level;
    }
}

