/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.charts.check;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson2.JSONObject;
import com.geoway.adf.dms.charts.check.BuildTime;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.JdbcWorkspace;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.sql.Timestamp;
import java.util.Base64;
import java.util.Date;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public final class ChartLicenseChecker {
    private static final Logger log = LoggerFactory.getLogger(ChartLicenseChecker.class);
    @Resource
    private GeoDatabaseService geoDatabaseService;
    private final int validMonth = 6;
    private final Date expiryDate;

    public ChartLicenseChecker() {
        log.info("chart module build time:" + BuildTime.BUILD_TIME);
        this.expiryDate = this.readLicense();
        log.info("chart module expiration time:" + this.expiryDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        DateTime buildDate;
        if (this.expiryDate == null) {
            throw new RuntimeException("ABF\u7f16\u8f91\u529f\u80fd\u4e0d\u53ef\u7528");
        }
        String buildDateStr = BuildTime.BUILD_TIME;
        try {
            buildDate = DateUtil.parseDate((CharSequence)buildDateStr);
        }
        catch (Exception e) {
            log.error("buildDate:" + buildDateStr);
            throw new RuntimeException("ABF\u7f16\u8f91\u529f\u80fd\u4e0d\u53ef\u7528", e);
        }
        Date nowDate = new Date();
        if (nowDate.compareTo((Date)DateUtil.offsetDay((Date)buildDate, (int)-1)) < 0) {
            throw new RuntimeException("ABF\u7f16\u8f91\u529f\u80fd\u4e0d\u53ef\u7528");
        }
        if (nowDate.compareTo(this.expiryDate) > 0) {
            throw new RuntimeException("ABF\u7f16\u8f91\u529f\u80fd\u4e0d\u53ef\u7528");
        }
        Timestamp serverDate = null;
        try (IFeatureWorkspace workspace = null;){
            workspace = this.geoDatabaseService.openGeoWorkspace("key");
            if (workspace instanceof JdbcWorkspace && ((serverDate = ((JdbcWorkspace)workspace).getServerDate()) == null || ((Date)serverDate).compareTo(this.expiryDate) > 0)) {
                throw new RuntimeException("ABF\u7f16\u8f91\u529f\u80fd\u4e0d\u53ef\u7528");
            }
        }
    }

    private Date readLicense() {
        try {
            byte[] dataBytes;
            File customFile = new File("license.gwlic");
            if (customFile.exists()) {
                log.info("load license:" + customFile.getAbsolutePath());
                dataBytes = Files.readAllBytes(customFile.toPath());
            } else {
                ClassPathResource resource = new ClassPathResource("license.gwlic");
                log.info("load license:" + resource.getURL());
                try (InputStream in = resource.getInputStream();){
                    dataBytes = new byte[in.available()];
                    in.read(dataBytes, 0, in.available());
                }
            }
            String dataBase64 = new String(dataBytes, StandardCharsets.UTF_8);
            dataBytes = Base64.getDecoder().decode(dataBase64);
            String pem = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAkbFc0j/sgIOIBLJu4Vv5bI8q3W9p6GrAyYmpYzwNgXmpf1bXYP0JKyAlytztzcmROJRqRfocwj0sGkZzbgrQ6JD3Tl2z9a2VBuPwwvTn8RlyA+4DFe8y9VEWAgFn3J8sjT7G64lWaFUpWdICV/nB+iIqXQ6GQXrCequrpSKbI5xpub2pXft2RN8b+tJ4QhKFjGny4jEy9h7wgEe2bkO/fXgoKypWCFN2oRw+wuizzABYmWVh5Gm3+0LLTsLLVALX2eRi9YP162VgxoUe7pmre7pPZWXLJlsIvCsH4OKm9/3KyzsTIpHTvA/D2s/O3xS868zEGSbf65GUi9DALZLUMwIDAQAB";
            byte[] keyBytes = Base64.getDecoder().decode(pem);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, publicKey);
            byte[] decrypted = cipher.doFinal(dataBytes);
            String data = new String(decrypted, StandardCharsets.UTF_8);
            JSONObject jsonObject = JSONObject.parseObject((String)data);
            String dateStr = jsonObject.getString("ExpirationDate");
            if (dateStr == null || dateStr.isEmpty()) {
                return null;
            }
            return DateUtil.parseDate((CharSequence)dateStr);
        }
        catch (Exception e) {
            log.error("bad license", (Throwable)e);
            return null;
        }
    }
}

