/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.charts.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.charts.check.ChartLicenseChecker;
import com.geoway.adf.dms.charts.component.StatIndicatorScheduleTask;
import com.geoway.adf.dms.charts.dao.ChartIndicatorDao;
import com.geoway.adf.dms.charts.dto.IndicatorFieldDTO;
import com.geoway.adf.dms.charts.dto.StatDataResult;
import com.geoway.adf.dms.charts.dto.StatDataTypeEnum;
import com.geoway.adf.dms.charts.dto.StatIndicatorBusinessDTO;
import com.geoway.adf.dms.charts.dto.StatIndicatorClassEditDTO;
import com.geoway.adf.dms.charts.dto.StatIndicatorDTO;
import com.geoway.adf.dms.charts.dto.StatIndicatorSimpleDTO;
import com.geoway.adf.dms.charts.dto.StatScheduleDTO;
import com.geoway.adf.dms.charts.dto.StatTimeUnitEnum;
import com.geoway.adf.dms.charts.entity.ChartIndicator;
import com.geoway.adf.dms.charts.service.StatIndicatorService;
import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.component.LoginUserHelper;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.service.SysLogService;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.dataset.MosaicDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TableDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TableViewDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatasetDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.FieldUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.dms.datasource.util.GeoTableQueryCheckUtil;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.IField;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Transactional(rollbackFor={Exception.class})
@Primary
@Service
public class StatIndicatorServiceImpl
implements StatIndicatorService {
    private static final Logger log = LoggerFactory.getLogger(StatIndicatorServiceImpl.class);
    @Resource
    private ChartIndicatorDao chartIndicatorDao;
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private StatIndicatorScheduleTask statIndicatorScheduleTask;
    @Resource
    private ChartLicenseChecker chartLicenseChecker;
    @Resource
    private SysLogService sysLogService;
    @Resource
    private LoginUserHelper loginUserHelper;
    protected static final Integer TYPE_CLASS = 0;
    protected static final Integer TYPE_INDICATOR = 1;
    @Value(value="${project.dataIndicatorScheduleEnabled:false}")
    private Boolean dataIndicatorScheduleEnabled;

    @Override
    public void initSchedules() {
        try {
            if (!Boolean.TRUE.equals(this.dataIndicatorScheduleEnabled)) {
                return;
            }
            List<ChartIndicator> indicators = this.chartIndicatorDao.selectSchedules();
            for (ChartIndicator indicator : indicators) {
                try {
                    if (!StatScheduleDTO.isStatSchedule(indicator.getStatTimeUnit()) || !StringUtil.isNotEmpty((String)indicator.getStatTableName())) continue;
                    log.info("\u7edf\u8ba1\u6307\u6807[" + indicator.getName() + "]\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1");
                    StatIndicatorDTO statIndicatorDTO = this.convertToIndicatorDTO(indicator, false);
                    this.statIndicatorScheduleTask.addScheduleTask(statIndicatorDTO);
                }
                catch (Exception e) {
                    log.error("\u7edf\u8ba1\u6307\u6807[" + indicator.getName() + "]\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error("\u7edf\u8ba1\u6307\u6807\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    @PreDestroy
    public void stopSchedules() {
        this.statIndicatorScheduleTask.shutdownScheduler();
    }

    @Override
    public List<StatIndicatorSimpleDTO> tree(Boolean withIndicator, String keyword) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        LoginUserInfo loginUserInfo = this.loginUserHelper.getCurrentUser(servletRequestAttributes.getRequest());
        String userId = loginUserInfo.getUserId();
        if (!"gcloud".equals(loginUserInfo.getIdentitySource()) && this.loginUserHelper.isSystemAdmin(loginUserInfo)) {
            userId = null;
        }
        List<ChartIndicator> allStatConfig = this.chartIndicatorDao.selectByType(userId, !Boolean.TRUE.equals(withIndicator));
        List<StatIndicatorSimpleDTO> listConfig = this.completeChildren(allStatConfig, null, keyword);
        return listConfig;
    }

    @Override
    public List<StatIndicatorDTO> listIndicator(String pid, String keyword) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        LoginUserInfo loginUserInfo = this.loginUserHelper.getCurrentUser(servletRequestAttributes.getRequest());
        String userId = loginUserInfo.getUserId();
        if (!"gcloud".equals(loginUserInfo.getIdentitySource()) && this.loginUserHelper.isSystemAdmin(loginUserInfo)) {
            userId = null;
        }
        List<ChartIndicator> allStatConfig = this.chartIndicatorDao.selectByType(userId, false);
        return this.getAllIndicator(allStatConfig, pid, keyword);
    }

    @Override
    public List<StatIndicatorDTO> listIndicatorByIds(List<String> ids) {
        List<ChartIndicator> allStatConfig = this.chartIndicatorDao.selectByIds(ids);
        ArrayList<StatIndicatorDTO> indicatorDTOS = new ArrayList<StatIndicatorDTO>();
        for (ChartIndicator entity : allStatConfig) {
            indicatorDTOS.add(this.convertToIndicatorDTO(entity, false));
        }
        return indicatorDTOS;
    }

    @Override
    public StatIndicatorDTO getIndicatorDetail(String id) {
        ChartIndicator config = this.chartIndicatorDao.selectByPrimaryKey(id);
        if (config != null) {
            return this.convertToIndicatorDTO(config, true);
        }
        return null;
    }

    @Override
    public StatIndicatorDTO getIndicatorDetail(String id, boolean withFields) {
        Assert.notNull((Object)id, (String)"\u6307\u6807id\u4e3a\u7a7a");
        ChartIndicator config = this.chartIndicatorDao.selectByPrimaryKey(id);
        if (config == null) {
            log.error(id);
            throw new RuntimeException("\u7edf\u8ba1\u6307\u6807\u4e0d\u5b58\u5728\uff01");
        }
        return this.convertToIndicatorDTO(config, withFields);
    }

    @Override
    public String addIndicatorClass(StatIndicatorClassEditDTO editDTO) {
        Integer order;
        List<ChartIndicator> configs;
        this.chartLicenseChecker.check();
        if (StringUtil.isEmptyOrWhiteSpace((String)editDTO.getName())) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u540d\u79f0\uff01");
        }
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        LoginUserInfo loginUserInfo = this.loginUserHelper.getCurrentUser(servletRequestAttributes.getRequest());
        if (!Boolean.TRUE.equals(editDTO.getAllowNameDuplicate()) && (configs = this.chartIndicatorDao.selectByName(loginUserInfo.getUserId(), editDTO.getName(), true, editDTO.getFatherId())).size() > 0) {
            throw new RuntimeException("[" + editDTO.getName() + "]\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        ChartIndicator config = new ChartIndicator();
        if (StringUtil.isEmptyOrWhiteSpace((String)editDTO.getId())) {
            config.setId(UUID.randomUUID().toString().replace("-", ""));
        } else {
            config.setId(editDTO.getId());
        }
        config.setName(editDTO.getName());
        config.setDes(editDTO.getDes());
        config.setCreateTime(new Date());
        config.setPid(null);
        config.setType(TYPE_CLASS);
        config.setCreateTime(new Date());
        if (StringUtil.isNotEmpty((String)editDTO.getFatherId())) {
            ChartIndicator fatherClass = this.chartIndicatorDao.selectByPrimaryKey(editDTO.getFatherId());
            if (fatherClass == null) {
                log.error(editDTO.getFatherId());
                throw new RuntimeException("\u7236\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
            }
            if (fatherClass.getUserId() != null && !loginUserInfo.getUserId().equals(fatherClass.getUserId())) {
                throw new RuntimeException("\u5206\u7c7b\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237\uff01");
            }
            config.setPid(editDTO.getFatherId());
        }
        if ((order = this.chartIndicatorDao.queryMaxOrder(loginUserInfo.getUserId(), config.getPid())) == null) {
            order = 0;
        }
        config.setOrder(order + 1);
        config.setUserId(loginUserInfo.getUserId());
        if ("gcloud".equals(loginUserInfo.getIdentitySource()) && this.loginUserHelper.isSystemAdmin(loginUserInfo)) {
            config.setIsPublic(ConstantsValue.TRUE_SHORT);
        }
        this.chartIndicatorDao.insert(config);
        return config.getId();
    }

    @Override
    public void updateIndicatorClass(StatIndicatorClassEditDTO editDTO) {
        this.chartLicenseChecker.check();
        ChartIndicator config = this.updateCountStatConfig(editDTO.getId(), editDTO.getName(), editDTO.getDes());
        this.chartIndicatorDao.updateByPrimaryKey(config);
    }

    @Override
    public void deleteStatIndicator(String id) {
        this.chartLicenseChecker.check();
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)id), (String)"\u6807\u8bc6\u65e0\u6548\uff01");
        ChartIndicator config = this.chartIndicatorDao.selectByPrimaryKey(id);
        if (config == null) {
            log.error(id);
            throw new RuntimeException("\u7edf\u8ba1\u6307\u6807\u4e0d\u5b58\u5728\uff01");
        }
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        LoginUserInfo loginUserInfo = this.loginUserHelper.getCurrentUser(servletRequestAttributes.getRequest());
        if (config.getUserId() != null && !loginUserInfo.getUserId().equals(config.getUserId())) {
            throw new RuntimeException("\u6307\u6807\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237\uff01");
        }
        if (TYPE_CLASS.equals(config.getType())) {
            List<ChartIndicator> allStatConfig = this.chartIndicatorDao.selectAll(loginUserInfo.getUserId());
            List<String> subNodeIdList = this.getSubNodeIdList(allStatConfig, id);
            subNodeIdList.add(id);
            for (String indID : subNodeIdList) {
                ChartIndicator ind = allStatConfig.stream().filter(s -> s.getId().equals(indID)).findFirst().orElseGet(null);
                try {
                    if (ind == null || !StringUtil.isNotEmpty((String)ind.getStatTableName())) continue;
                    this.statIndicatorScheduleTask.cancelScheduleTask(indID);
                    this.statIndicatorScheduleTask.deleteStatTable(ind.getStatTableName());
                }
                catch (Exception e) {
                    log.error("\u5220\u9664\u7edf\u8ba1\u8868\u5931\u8d25\uff1a" + ind.getStatTableName());
                }
            }
            this.chartIndicatorDao.deleteByIdList(subNodeIdList);
            this.sysLogService.addLog(201, "\u5220\u9664\u6570\u636e\u6307\u6807\u5206\u7ec4[" + config.getName() + "]");
        } else {
            try {
                if (StringUtil.isNotEmpty((String)config.getStatTableName())) {
                    this.statIndicatorScheduleTask.cancelScheduleTask(id);
                    this.statIndicatorScheduleTask.deleteStatTable(config.getStatTableName());
                }
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u7edf\u8ba1\u8868\u5931\u8d25\uff1a" + config.getStatTableName());
            }
            this.chartIndicatorDao.deleteByPrimaryKey(id);
            this.sysLogService.addLog(201, "\u5220\u9664\u6570\u636e\u6307\u6807[" + config.getName() + "]");
        }
    }

    @Override
    public String addStatIndicator(StatIndicatorDTO addDTO) {
        this.chartLicenseChecker.check();
        if (addDTO.getPid() == null) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u5206\u7c7b\u6807\u8bc6\uff01");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)addDTO.getName())) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u540d\u79f0\uff01");
        }
        if (addDTO.getIndicatorFields() == null || addDTO.getIndicatorFields().size() == 0) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u6307\u6807\u5b57\u6bb5\uff01");
        }
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        LoginUserInfo loginUserInfo = this.loginUserHelper.getCurrentUser(servletRequestAttributes.getRequest());
        ChartIndicator fatherConfig = this.chartIndicatorDao.selectByPrimaryKey(addDTO.getPid());
        Assert.notNull((Object)fatherConfig, (String)"\u6307\u6807\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
        Assert.isTrue((boolean)TYPE_CLASS.equals(fatherConfig.getType()), (String)"\u53ea\u80fd\u5728\u5206\u7c7b\u4e0b\u6dfb\u52a0\u6307\u6807\uff01");
        if (fatherConfig.getUserId() != null && !loginUserInfo.getUserId().equals(fatherConfig.getUserId())) {
            throw new RuntimeException("\u5206\u7c7b\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237\uff01");
        }
        List<ChartIndicator> configs = this.chartIndicatorDao.selectByName(loginUserInfo.getUserId(), addDTO.getName(), false, addDTO.getPid());
        if (configs.size() > 0) {
            throw new RuntimeException("[" + addDTO.getName() + "]\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        ChartIndicator config = new ChartIndicator();
        config.setId(UUID.randomUUID().toString().replace("-", ""));
        config.setPid(addDTO.getPid());
        config.setName(addDTO.getName());
        config.setDes(addDTO.getDes());
        config.setType(TYPE_INDICATOR);
        config.setCreator(addDTO.getCreator());
        config.setCreateTime(new Date());
        config.setDatasetId(addDTO.getDatasetId());
        if (addDTO.getGroupFields() != null) {
            config.setGroupFields(JSONArray.toJSONString(addDTO.getGroupFields()));
        }
        config.setIndicatorFields(JSONArray.toJSONString(addDTO.getIndicatorFields()));
        config.setTimeField(addDTO.getTimeField());
        config.setDistrictField(addDTO.getDistrictField());
        config.setDistrictNameField(addDTO.getDistrictNameField());
        config.setFilterStr(addDTO.getFilterStr());
        config.setDsKey(addDTO.getDsKey());
        config.setDataSql(addDTO.getDataSql());
        config.setDataType(addDTO.getDataType());
        config.setApiParams(addDTO.getApiParams());
        Integer order = this.chartIndicatorDao.queryMaxOrder(loginUserInfo.getUserId(), config.getPid());
        if (order == null) {
            order = 0;
        }
        config.setOrder(order + 1);
        config.setEnable(ConstantsValue.TRUE_VALUE);
        if (addDTO.getBusinessInfo() != null) {
            config.setBusinessInfo(JSONObject.toJSONString((Object)addDTO.getBusinessInfo()));
        }
        if (addDTO.getStatSchedule() != null) {
            config.setStatTimeUnit(addDTO.getStatSchedule().getStatTimeUnit());
            config.setStatStartTime(addDTO.getStatSchedule().getStatStartTime());
            config.setStatInterval(addDTO.getStatSchedule().getStatInterval());
            if (StatScheduleDTO.isStatSchedule(addDTO.getStatSchedule())) {
                config.setStatTableName("stat_" + config.getId());
                if (config.getStatStartTime() == null) {
                    config.setStatStartTime(new Date());
                }
                if (config.getStatInterval() == null) {
                    config.setStatInterval(1L);
                }
            }
        }
        config.setUserId(loginUserInfo.getUserId());
        if ("gcloud".equals(loginUserInfo.getIdentitySource()) && this.loginUserHelper.isSystemAdmin(loginUserInfo)) {
            config.setIsPublic(ConstantsValue.TRUE_SHORT);
        }
        this.chartIndicatorDao.insert(config);
        if (config.getStatTableName() != null) {
            StatIndicatorDTO statIndicatorDTO = this.convertToIndicatorDTO(config, false);
            if (this.statIndicatorScheduleTask.createStatTable(statIndicatorDTO)) {
                this.statIndicatorScheduleTask.excuteStat(statIndicatorDTO);
                this.statIndicatorScheduleTask.addScheduleTask(statIndicatorDTO);
            } else {
                throw new RuntimeException("\u7edf\u8ba1\u8868\u521b\u5efa\u5931\u8d25");
            }
        }
        this.sysLogService.addLog(201, "\u65b0\u589e\u6570\u636e\u6307\u6807[" + config.getName() + "]");
        return config.getId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateStatIndicator(StatIndicatorDTO editDTO) {
        this.chartLicenseChecker.check();
        ChartIndicator config = this.updateCountStatConfig(editDTO.getId(), editDTO.getName(), editDTO.getDes());
        config.setCreator(editDTO.getCreator());
        if (editDTO.getDatasetId() != null) {
            config.setDatasetId(editDTO.getDatasetId());
        }
        if (editDTO.getGroupFields() != null && editDTO.getGroupFields().size() > 0) {
            config.setGroupFields(JSONArray.toJSONString(editDTO.getGroupFields()));
        }
        if (editDTO.getIndicatorFields() != null && editDTO.getIndicatorFields().size() > 0) {
            config.setIndicatorFields(JSONArray.toJSONString(editDTO.getIndicatorFields()));
        }
        config.setTimeField(editDTO.getTimeField());
        config.setDistrictField(editDTO.getDistrictField());
        config.setDistrictNameField(editDTO.getDistrictNameField());
        config.setFilterStr(editDTO.getFilterStr());
        config.setDsKey(editDTO.getDsKey());
        config.setDataSql(editDTO.getDataSql());
        config.setDataType(editDTO.getDataType());
        config.setApiParams(editDTO.getApiParams());
        if (editDTO.getBusinessInfo() != null) {
            config.setBusinessInfo(JSONObject.toJSONString((Object)editDTO.getBusinessInfo()));
        }
        if (editDTO.getPid() != null) {
            ChartIndicator fatherConfig = this.chartIndicatorDao.selectByPrimaryKey(editDTO.getPid());
            Assert.notNull((Object)fatherConfig, (String)"\u6307\u6807\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
            Assert.isTrue((boolean)TYPE_CLASS.equals(fatherConfig.getType()), (String)"\u6307\u6807\u53ea\u80fd\u5b58\u5728\u5206\u7c7b\u4e0b\uff01");
            config.setPid(editDTO.getPid());
        }
        if (editDTO.getStatSchedule() != null) {
            StatTimeUnitEnum statTimeUnitEnum;
            config.setStatTimeUnit(editDTO.getStatSchedule().getStatTimeUnit());
            config.setStatStartTime(editDTO.getStatSchedule().getStatStartTime());
            config.setStatInterval(editDTO.getStatSchedule().getStatInterval());
            this.statIndicatorScheduleTask.cancelScheduleTask(config.getId());
            if (StringUtil.isNotEmpty((String)config.getStatTableName())) {
                this.statIndicatorScheduleTask.deleteStatTable(config.getStatTableName());
            }
            if ((statTimeUnitEnum = StatTimeUnitEnum.getByValue(editDTO.getStatSchedule().getStatTimeUnit())).getValue() > StatTimeUnitEnum.None.getValue()) {
                StatIndicatorDTO statIndicatorDTO;
                config.setStatTableName("stat_" + config.getId());
                if (config.getStatStartTime() == null) {
                    config.setStatStartTime(new Date());
                }
                if (config.getStatInterval() == null) {
                    config.setStatInterval(1L);
                }
                if (!this.statIndicatorScheduleTask.createStatTable(statIndicatorDTO = this.convertToIndicatorDTO(config, false))) throw new RuntimeException("\u7edf\u8ba1\u8868\u521b\u5efa\u5931\u8d25");
                this.statIndicatorScheduleTask.excuteStat(statIndicatorDTO);
                this.statIndicatorScheduleTask.addScheduleTask(statIndicatorDTO);
            }
        } else {
            this.statIndicatorScheduleTask.cancelScheduleTask(config.getId());
            if (StringUtil.isNotEmpty((String)config.getStatTableName())) {
                this.statIndicatorScheduleTask.deleteStatTable(config.getStatTableName());
            }
            config.setStatTimeUnit(null);
            config.setStatStartTime(null);
            config.setStatInterval(null);
            config.setStatTableName(null);
        }
        this.chartIndicatorDao.updateByPrimaryKey(config);
        this.sysLogService.addLog(201, "\u4fee\u6539\u6570\u636e\u6307\u6807[" + config.getName() + "]");
    }

    @Override
    public void enableStatConfigIndicator(String id, Boolean enable) {
        boolean indicatorEnable;
        if (id == null) {
            throw new RuntimeException("\u8bf7\u6307\u5b9a\u7edf\u8ba1\u6307\u6807\u6807\u8bc6\uff01");
        }
        ChartIndicator config = this.chartIndicatorDao.selectByPrimaryKey(id);
        Assert.notNull((Object)config, (String)"\u7edf\u8ba1\u6307\u6807\u4e0d\u5b58\u5728\uff01");
        boolean bl = indicatorEnable = enable == null || enable != false;
        if (!indicatorEnable) {
            this.statIndicatorScheduleTask.cancelScheduleTask(id);
        } else if (StringUtil.isNotEmpty((String)config.getStatTableName())) {
            StatIndicatorDTO statIndicatorDTO = this.convertToIndicatorDTO(config, false);
            this.statIndicatorScheduleTask.addScheduleTask(statIndicatorDTO);
        }
        this.chartIndicatorDao.updateEnableByPrimaryKey(id, ConstantsValue.integerValue((Boolean)indicatorEnable));
    }

    @Override
    public void moveIndicatorOrder(String id, String fatherId, Integer order) {
        List children;
        if (id == null || order == null) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtil.equals((String)id, (String)fatherId)) {
            throw new RuntimeException("\u4e0d\u5141\u8bb8\u79fb\u52a8\u5230\u8282\u70b9\u672c\u8eab\u4e0b");
        }
        ChartIndicator config = this.chartIndicatorDao.selectByPrimaryKey(id);
        Assert.notNull((Object)config, (String)"\u8282\u70b9\u4e0d\u5b58\u5728\uff0c\u6b64\u6b21\u79fb\u52a8\u65e0\u6548");
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        LoginUserInfo loginUserInfo = this.loginUserHelper.getCurrentUser(servletRequestAttributes.getRequest());
        if (config.getUserId() != null && !loginUserInfo.getUserId().equals(config.getUserId())) {
            throw new RuntimeException("\u6307\u6807\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237\uff01");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)fatherId)) {
            fatherId = null;
        } else {
            ChartIndicator fatherConfig = this.chartIndicatorDao.selectByPrimaryKey(fatherId);
            Assert.notNull((Object)fatherConfig, (String)"\u6307\u6807\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
            Assert.isTrue((boolean)TYPE_CLASS.equals(fatherConfig.getType()), (String)"\u53ea\u80fd\u5728\u5206\u7c7b\u4e0b\u6dfb\u52a0\u6307\u6807\uff01");
            if (fatherConfig.getUserId() != null && !loginUserInfo.getUserId().equals(fatherConfig.getUserId())) {
                throw new RuntimeException("\u5206\u7c7b\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237\uff01");
            }
        }
        if (!StringUtil.equals((String)config.getPid(), (String)fatherId)) {
            List<ChartIndicator> allStatConfig = this.chartIndicatorDao.selectAll(loginUserInfo.getUserId());
            List<String> subNodeIdList = this.getSubNodeIdList(allStatConfig, config.getId());
            if (subNodeIdList.contains(fatherId)) {
                throw new RuntimeException("\u4e0d\u5141\u8bb8\u79fb\u52a8\u5230\u5b50\u8282\u70b9\u4e0b");
            }
            List<ChartIndicator> sameNameConfigs = this.chartIndicatorDao.selectByName(loginUserInfo.getUserId(), config.getName(), TYPE_CLASS.equals(config.getType()), fatherId);
            if (sameNameConfigs.size() > 0) {
                throw new RuntimeException("[" + config.getName() + "]\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            }
            config.setPid(fatherId);
            config.setOrder(-1);
            this.chartIndicatorDao.updateByPrimaryKey(config);
            String pid = fatherId;
            children = ListUtil.findAll(allStatConfig, f -> StringUtil.equals((String)f.getPid(), (String)pid));
        } else {
            children = this.chartIndicatorDao.selectByPid(loginUserInfo.getUserId(), fatherId);
            children.removeIf(f -> StringUtil.equals((String)f.getId(), (String)id));
        }
        int preIndex = -1;
        for (int i = 0; i < children.size(); ++i) {
            if (children.get(i).getOrder() != order) continue;
            preIndex = i;
            break;
        }
        if (preIndex == -1 && order > 0) {
            preIndex = order;
        }
        if (preIndex >= children.size()) {
            preIndex = children.size() - 1;
        }
        children.add(preIndex + 1, (ChartIndicator)config);
        this.sortConfigs(children);
    }

    @Override
    public StatDataResult queryStatResult(String id) {
        StatDataResult statDataResult;
        ChartIndicator config = this.chartIndicatorDao.selectByPrimaryKey(id);
        Assert.notNull((Object)config, (String)"\u7edf\u8ba1\u6307\u6807\u4e0d\u5b58\u5728\uff01");
        Assert.isTrue((boolean)TYPE_INDICATOR.equals(config.getType()), (String)"\u65e0\u6548\u7edf\u8ba1\u6307\u6807\uff01");
        StatDataTypeEnum statDataTypeEnum = StatDataTypeEnum.getByValue(config.getDataType());
        switch (statDataTypeEnum) {
            case Table: {
                statDataResult = this.queryStatResultByDataset(config.getDatasetId(), config.getFilterStr());
                break;
            }
            case SQLQuery: {
                if (StatScheduleDTO.isStatSchedule(config.getStatTimeUnit()) && StringUtil.isNotEmpty((String)config.getStatTableName())) {
                    String datasetId = DatasetUtil.getDatasetId((String)"key", (DatasetTypeEnum)DatasetTypeEnum.Table, (String)config.getStatTableName());
                    statDataResult = this.queryStatResultByDataset(datasetId, null);
                    break;
                }
                statDataResult = this.queryStatResultBySql(config.getDsKey(), config.getDataSql());
                break;
            }
            default: {
                throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u7684\u6307\u6807\u6570\u636e\u7c7b\u578b\uff1a" + (Object)((Object)statDataTypeEnum));
            }
        }
        return statDataResult;
    }

    @Override
    public StatDataResult queryStatResultByDataset(String datasetId, String filter) {
        QueryFilterDTO filterDTO = new QueryFilterDTO();
        filterDTO.setRows(Integer.valueOf(10000));
        filterDTO.setReturnGeometry(Boolean.valueOf(false));
        filterDTO.setReturnCount(Boolean.valueOf(false));
        filterDTO.setCondition(filter);
        DataQueryResult queryResult = this.dataSourceService.queryData(datasetId, filterDTO);
        StatDataResult statDataResult = new StatDataResult();
        statDataResult.setData(ListUtil.convertAll((List)queryResult.getData(), f -> f.getAttributes()));
        statDataResult.setFields(queryResult.getFields());
        return statDataResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatDataResult queryStatResultBySql(String dsKey, String dataSql) {
        StatDataResult statDataResult;
        IFeatureWorkspace workspace;
        block10: {
            if (StringUtil.isEmptyOrWhiteSpace((String)dsKey)) {
                throw new RuntimeException("\u6570\u636e\u6e90\u6807\u8bc6\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmptyOrWhiteSpace((String)dataSql)) {
                throw new RuntimeException("\u67e5\u8be2\u8bed\u53e5\u4e3a\u7a7a\uff01");
            }
            DataSourceDTO dataSourceDTO = this.dataSourceService.getDataSourceDetail(dsKey);
            GeoTableQueryCheckUtil.checkTableQuerySql((DataSourceTypeEnum)DataSourceTypeEnum.getByValue((Integer)dataSourceDTO.getDataSourceType()), (String)dataSql);
            workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSourceDTO);
            Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
            StatDataResult result = new StatDataResult();
            result.setData(new ArrayList<Map<String, Object>>());
            ICursor cursor = null;
            try {
                cursor = workspace.excuteQuerySql(dataSql);
                IRow row = cursor.nextRow();
                while (row != null) {
                    HashMap<String, Object> attMap = new HashMap<String, Object>();
                    for (IField fld : row.getFields()) {
                        if (fld.getFieldType() == FieldType.Shape) continue;
                        attMap.put(fld.getName(), row.getValue(fld.getName()));
                    }
                    result.getData().add(attMap);
                    row = cursor.nextRow();
                }
                result.setFields(ListUtil.convertAll((Object[])cursor.getFields().toArray(), f -> new ReturnField(f.getName(), f.getAliasName(), Integer.valueOf(f.getFieldType().getValue()))));
                statDataResult = result;
                if (cursor == null) break block10;
            }
            catch (Throwable throwable) {
                if (cursor != null) {
                    cursor.release();
                }
                workspace.close();
                throw throwable;
            }
            cursor.release();
        }
        workspace.close();
        return statDataResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FieldDTO> getFieldsBySql(String dsKey, String dataSql) {
        List list;
        IFeatureWorkspace workspace;
        block8: {
            if (StringUtil.isEmptyOrWhiteSpace((String)dsKey)) {
                throw new RuntimeException("\u6570\u636e\u6e90\u6807\u8bc6\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmptyOrWhiteSpace((String)dataSql)) {
                throw new RuntimeException("\u67e5\u8be2\u8bed\u53e5\u4e3a\u7a7a\uff01");
            }
            DataSourceDTO dataSourceDTO = this.dataSourceService.getDataSourceDetail(dsKey);
            GeoTableQueryCheckUtil.checkTableQuerySql((DataSourceTypeEnum)DataSourceTypeEnum.getByValue((Integer)dataSourceDTO.getDataSourceType()), (String)dataSql);
            workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSourceDTO);
            Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
            StatDataResult result = new StatDataResult();
            result.setData(new ArrayList<Map<String, Object>>());
            ICursor cursor = null;
            try {
                String sql = String.format("select * from (%s) temp___ where 1=2", dataSql);
                cursor = workspace.excuteQuerySql(sql);
                list = ListUtil.convertAll((Object[])cursor.getFields().toArray(), FieldUtil::convertField);
                if (cursor == null) break block8;
            }
            catch (Throwable throwable) {
                if (cursor != null) {
                    cursor.release();
                }
                workspace.close();
                throw throwable;
            }
            cursor.release();
        }
        workspace.close();
        return list;
    }

    @Override
    public void excuteStatSchedule(String id) {
        StatIndicatorDTO statIndicatorDTO = this.getIndicatorDetail(id, false);
        if (StatScheduleDTO.isStatSchedule(statIndicatorDTO.getStatSchedule())) {
            this.statIndicatorScheduleTask.excuteStat(statIndicatorDTO);
        }
    }

    private List<StatIndicatorSimpleDTO> completeChildren(List<ChartIndicator> allStatConfig, String pId, String keyword) {
        ArrayList<StatIndicatorSimpleDTO> statIndicatorSimpleDTOS = new ArrayList<StatIndicatorSimpleDTO>();
        List subStatConfig = ListUtil.findAll(allStatConfig, t -> {
            if (StringUtil.isEmpty((String)pId) && StringUtil.isEmpty((String)t.getPid())) {
                return true;
            }
            return StringUtil.equals((String)pId, (String)t.getPid());
        });
        for (ChartIndicator entity : subStatConfig) {
            List<StatIndicatorSimpleDTO> subIndicators = this.completeChildren(allStatConfig, entity.getId(), keyword);
            StatIndicatorSimpleDTO indicatorSimpleDTO = this.convertToStatSimpleDTO(entity);
            if (!StringUtil.isEmpty((String)keyword) && !indicatorSimpleDTO.getName().toLowerCase().contains(keyword.toLowerCase()) && !indicatorSimpleDTO.getId().equals(keyword) && subIndicators.size() <= 0) continue;
            indicatorSimpleDTO.setChildren(subIndicators);
            statIndicatorSimpleDTOS.add(indicatorSimpleDTO);
        }
        return statIndicatorSimpleDTOS;
    }

    private List<StatIndicatorDTO> getAllIndicator(List<ChartIndicator> allStatConfig, String pId, String keyword) {
        ArrayList<StatIndicatorDTO> childrenDTOS = new ArrayList<StatIndicatorDTO>();
        List subStatConfig = ListUtil.findAll(allStatConfig, t -> StringUtil.equals((String)pId, (String)t.getPid()));
        for (ChartIndicator entity : subStatConfig) {
            if (TYPE_CLASS.equals(entity.getType())) {
                childrenDTOS.addAll(this.getAllIndicator(allStatConfig, entity.getId(), keyword));
                continue;
            }
            if (!StringUtil.isEmpty((String)keyword) && !entity.getName().toLowerCase().contains(keyword.toLowerCase()) && !entity.getId().equals(keyword)) continue;
            childrenDTOS.add(this.convertToIndicatorDTO(entity, false));
        }
        return childrenDTOS;
    }

    private void sortConfigs(List<ChartIndicator> children) {
        int count = children.size();
        for (int i = 0; i < count; ++i) {
            ChartIndicator child = children.get(i);
            if (child.getOrder() == i + 1) continue;
            child.setOrder(i + 1);
            this.chartIndicatorDao.updateOrderByPrimaryKey(child.getId(), child.getOrder());
        }
    }

    private List<String> getSubNodeIdList(List<ChartIndicator> allStatConfig, String id) {
        List children = ListUtil.findAll(allStatConfig, f -> id.equals(f.getPid()));
        ArrayList<String> result = new ArrayList<String>();
        children.forEach(child -> {
            result.add(child.getId());
            result.addAll(this.getSubNodeIdList(allStatConfig, child.getId()));
        });
        return result;
    }

    private StatIndicatorSimpleDTO convertToStatSimpleDTO(ChartIndicator classConfig) {
        StatIndicatorSimpleDTO dto = new StatIndicatorSimpleDTO();
        BeanUtils.copyProperties((Object)classConfig, (Object)dto);
        dto.setEnable(classConfig.getEnable() == null || classConfig.getEnable().equals(ConstantsValue.TRUE_VALUE));
        dto.setIsPublic(ConstantsValue.boolValue((Short)classConfig.getIsPublic()));
        return dto;
    }

    private StatIndicatorDTO convertToIndicatorDTO(ChartIndicator indicator, boolean withFields) {
        StatIndicatorDTO dto = new StatIndicatorDTO();
        dto.setId(indicator.getId());
        dto.setName(indicator.getName());
        dto.setDes(indicator.getDes());
        dto.setCreator(indicator.getCreator());
        dto.setCreateTime(indicator.getCreateTime());
        dto.setPid(indicator.getPid());
        dto.setType(indicator.getType());
        dto.setOrder(indicator.getOrder());
        dto.setDatasetId(indicator.getDatasetId());
        dto.setTimeField(indicator.getTimeField());
        dto.setDistrictField(indicator.getDistrictField());
        dto.setDistrictNameField(indicator.getDistrictNameField());
        dto.setFilterStr(indicator.getFilterStr());
        dto.setDsKey(indicator.getDsKey());
        dto.setDataSql(indicator.getDataSql());
        dto.setDataType(indicator.getDataType());
        dto.setApiParams(indicator.getApiParams());
        dto.setEnable(indicator.getEnable() == null || indicator.getEnable().equals(ConstantsValue.TRUE_VALUE));
        dto.setIsPublic(ConstantsValue.boolValue((Short)indicator.getIsPublic()));
        try {
            if (StringUtil.isNotEmpty((String)indicator.getBusinessInfo())) {
                dto.setBusinessInfo((StatIndicatorBusinessDTO)JSONObject.parseObject((String)indicator.getBusinessInfo(), StatIndicatorBusinessDTO.class));
            }
        }
        catch (Exception e) {
            log.error(indicator.getName() + ":" + indicator.getBusinessInfo(), (Throwable)e);
        }
        if (indicator.getStatTimeUnit() != null) {
            StatScheduleDTO statScheduleDTO = new StatScheduleDTO();
            statScheduleDTO.setStatTimeUnit(indicator.getStatTimeUnit());
            statScheduleDTO.setStatStartTime(indicator.getStatStartTime());
            statScheduleDTO.setStatInterval(indicator.getStatInterval());
            statScheduleDTO.setStatTableName(indicator.getStatTableName());
            dto.setStatSchedule(statScheduleDTO);
        }
        if (withFields) {
            List groupFields = null;
            if (StringUtil.isNotEmpty((String)indicator.getGroupFields())) {
                groupFields = JSONArray.parseArray((String)indicator.getGroupFields(), FieldDTO.class);
            }
            ArrayList<IndicatorFieldDTO> indicatorFields = null;
            if (StringUtil.isNotEmpty((String)indicator.getIndicatorFields())) {
                indicatorFields = JSONArray.parseArray((String)indicator.getIndicatorFields(), IndicatorFieldDTO.class);
            }
            try {
                List<Object> fieldDTOList = new ArrayList();
                StatDataTypeEnum statDataTypeEnum = StatDataTypeEnum.getByValue(indicator.getDataType());
                block2 : switch (statDataTypeEnum) {
                    case Table: {
                        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(indicator.getDatasetId());
                        DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue((Integer)datasetDTO.getType());
                        switch (datasetType) {
                            case FeatureClass: {
                                fieldDTOList = ((FeatureClassDTO)datasetDTO).getFields();
                                break block2;
                            }
                            case DatumDataset: {
                                List datumFieldDTOList = ((DatumDatasetDTO)datasetDTO).getFields();
                                fieldDTOList = ListUtil.convertAll((List)datumFieldDTOList, f -> f);
                                break block2;
                            }
                            case MosaicDataset: {
                                fieldDTOList = ((MosaicDatasetDTO)datasetDTO).getFields();
                                break block2;
                            }
                            case Table: {
                                fieldDTOList = ((TableDatasetDTO)datasetDTO).getFields();
                                break block2;
                            }
                            case TableView: {
                                fieldDTOList = ((TableViewDTO)datasetDTO).getFields();
                                break block2;
                            }
                        }
                        break;
                    }
                    case SQLQuery: {
                        fieldDTOList = this.getFieldsBySql(indicator.getDsKey(), indicator.getDataSql());
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u7684\u6307\u6807\u6570\u636e\u7c7b\u578b\uff1a" + (Object)((Object)statDataTypeEnum));
                    }
                }
                if (groupFields != null) {
                    List gFields;
                    List fieldNameList = ListUtil.convertAll((List)groupFields, FieldDTO::getName);
                    groupFields = gFields = ListUtil.findAll(fieldDTOList, f -> fieldNameList.contains(f.getName()));
                }
                dto.setIndicatorFields(new ArrayList<IndicatorFieldDTO>());
                if (indicatorFields != null) {
                    ArrayList<IndicatorFieldDTO> fields = new ArrayList<IndicatorFieldDTO>();
                    for (FieldDTO field : fieldDTOList) {
                        IndicatorFieldDTO indicatorField = (IndicatorFieldDTO)((Object)ListUtil.find(indicatorFields, f -> field.getName().equals(f.getName())));
                        if (indicatorField == null) continue;
                        indicatorField.setAliasName(field.getAliasName());
                        indicatorField.setAliasName(field.getAliasName());
                        indicatorField.setFieldType(field.getFieldType());
                        indicatorField.setLength(field.getLength());
                        indicatorField.setScale(field.getScale());
                        indicatorField.setNullable(field.getNullable());
                        indicatorField.setDefaultValue(field.getDefaultValue());
                        fields.add(indicatorField);
                    }
                    indicatorFields = fields;
                }
            }
            catch (Exception e) {
                log.error("\u5b57\u6bb5\u8bfb\u53d6\u5931\u8d25", (Throwable)e);
            }
            dto.setGroupFields(groupFields);
            dto.setIndicatorFields((List<IndicatorFieldDTO>)indicatorFields);
        }
        return dto;
    }

    private ChartIndicator updateCountStatConfig(String id, String name, String description) {
        if (id == null) {
            throw new RuntimeException("\u8bf7\u6307\u5b9a\u7edf\u8ba1\u6307\u6807\u6807\u8bc6\uff01");
        }
        ChartIndicator config = this.chartIndicatorDao.selectByPrimaryKey(id);
        Assert.notNull((Object)config, (String)"\u7edf\u8ba1\u6307\u6807\u4e0d\u5b58\u5728\uff01");
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        LoginUserInfo loginUserInfo = this.loginUserHelper.getCurrentUser(servletRequestAttributes.getRequest());
        if (config.getUserId() != null && !loginUserInfo.getUserId().equals(config.getUserId())) {
            throw new RuntimeException("\u6307\u6807\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237\uff01");
        }
        if (!StringUtil.isEmptyOrWhiteSpace((String)name)) {
            List<ChartIndicator> sameNameConfigs;
            if (!config.getName().equals(name) && (sameNameConfigs = this.chartIndicatorDao.selectByName(loginUserInfo.getUserId(), name, TYPE_CLASS.equals(config.getType()), config.getPid())).size() > 0) {
                throw new RuntimeException("[" + name + "]\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            }
            config.setName(name);
        }
        config.setDes(description);
        return config;
    }
}

