/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.sql;

import com.geoway.adf.dms.common.sql.SQLFieldInfoMap;
import com.geoway.adf.gis.geodb.field.FieldType;
import java.util.List;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitorAdapter;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;

public class SQLQueryToExpression {
    public static String parseToExpression(String whereClause, List<SQLFieldInfoMap> fieldInfoMaps) throws Exception {
        String sql = "SELECT * FROM table WHERE " + whereClause;
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
        Expression where = plainSelect.getWhere();
        return SQLQueryToExpression.buildConditionString(where, fieldInfoMaps);
    }

    private static String buildConditionString(Expression expression, List<SQLFieldInfoMap> fieldInfoMaps) {
        if (expression == null) {
            return "";
        }
        if (expression instanceof AndExpression) {
            AndExpression and = (AndExpression)expression;
            String left = SQLQueryToExpression.buildConditionString(and.getLeftExpression(), fieldInfoMaps);
            String right = SQLQueryToExpression.buildConditionString(and.getRightExpression(), fieldInfoMaps);
            return SQLQueryToExpression.combineWithAnd(left, right);
        }
        if (expression instanceof OrExpression) {
            OrExpression or = (OrExpression)expression;
            String left = SQLQueryToExpression.buildConditionString(or.getLeftExpression(), fieldInfoMaps);
            String right = SQLQueryToExpression.buildConditionString(or.getRightExpression(), fieldInfoMaps);
            return SQLQueryToExpression.combineWithOr(left, right);
        }
        if (expression instanceof Parenthesis) {
            Parenthesis paren = (Parenthesis)expression;
            String content = SQLQueryToExpression.buildConditionString(paren.getExpression(), fieldInfoMaps);
            return "(" + content + ")";
        }
        if (expression instanceof EqualsTo) {
            return SQLQueryToExpression.formatCondition("Q", (ComparisonOperator)((EqualsTo)expression), "EQ", fieldInfoMaps);
        }
        if (expression instanceof NotEqualsTo) {
            return SQLQueryToExpression.formatCondition("Q", (ComparisonOperator)((NotEqualsTo)expression), "NE", fieldInfoMaps);
        }
        if (expression instanceof GreaterThan) {
            return SQLQueryToExpression.formatCondition("Q", (ComparisonOperator)((GreaterThan)expression), "GT", fieldInfoMaps);
        }
        if (expression instanceof GreaterThanEquals) {
            return SQLQueryToExpression.formatCondition("Q", (ComparisonOperator)((GreaterThanEquals)expression), "GE", fieldInfoMaps);
        }
        if (expression instanceof MinorThan) {
            return SQLQueryToExpression.formatCondition("Q", (ComparisonOperator)((MinorThan)expression), "LT", fieldInfoMaps);
        }
        if (expression instanceof MinorThanEquals) {
            return SQLQueryToExpression.formatCondition("Q", (ComparisonOperator)((MinorThanEquals)expression), "LE", fieldInfoMaps);
        }
        if (expression instanceof LikeExpression) {
            String fieldType;
            LikeExpression like = (LikeExpression)expression;
            String field = SQLQueryToExpression.getColumnName(like.getLeftExpression());
            String rawValue = SQLQueryToExpression.getRawValue(like.getRightExpression());
            String operator = SQLQueryToExpression.determineLikeOperator(like.getRightExpression().toString());
            if (like.isNot()) {
                operator = "NOT" + operator;
            }
            if (rawValue.startsWith("%")) {
                rawValue = rawValue.substring(1);
            }
            if (rawValue.endsWith("%")) {
                rawValue = rawValue.substring(0, rawValue.length() - 1);
            }
            String finalField = field;
            SQLFieldInfoMap fieldInfoMap = fieldInfoMaps.stream().filter(f -> f.getSqlFieldName().equalsIgnoreCase(finalField)).findFirst().orElse(null);
            if (fieldInfoMap == null) {
                fieldType = SQLQueryToExpression.getFieldType(like.getRightExpression());
            } else {
                field = fieldInfoMap.getExpressionFieldName();
                fieldType = SQLQueryToExpression.getFieldType(fieldInfoMap.getFieldType());
            }
            return SQLQueryToExpression.formatCondition("Q", field, fieldType, operator, rawValue);
        }
        if (expression instanceof Between) {
            String fieldType;
            Between between = (Between)expression;
            String field = SQLQueryToExpression.getColumnName(between.getLeftExpression());
            String from = SQLQueryToExpression.getRawValue(between.getBetweenExpressionStart());
            String to = SQLQueryToExpression.getRawValue(between.getBetweenExpressionEnd());
            String finalField = field;
            SQLFieldInfoMap fieldInfoMap = fieldInfoMaps.stream().filter(f -> f.getSqlFieldName().equalsIgnoreCase(finalField)).findFirst().orElse(null);
            if (fieldInfoMap == null) {
                fieldType = SQLQueryToExpression.getFieldType(between.getBetweenExpressionStart());
            } else {
                field = fieldInfoMap.getExpressionFieldName();
                fieldType = SQLQueryToExpression.getFieldType(fieldInfoMap.getFieldType());
            }
            String left = SQLQueryToExpression.formatCondition("Q", field, fieldType, "GE", from);
            String right = SQLQueryToExpression.formatCondition("Q", field, fieldType, "LE", to);
            return SQLQueryToExpression.combineWithAnd(left, right);
        }
        if (expression instanceof InExpression) {
            String fieldType;
            InExpression in = (InExpression)expression;
            String field = SQLQueryToExpression.getColumnName(in.getLeftExpression());
            String operator = in.isNot() ? "NOTIN" : "IN";
            String values = SQLQueryToExpression.getInValues(in);
            String finalField = field;
            SQLFieldInfoMap fieldInfoMap = fieldInfoMaps.stream().filter(f -> f.getSqlFieldName().equalsIgnoreCase(finalField)).findFirst().orElse(null);
            if (fieldInfoMap == null) {
                fieldType = SQLQueryToExpression.getFieldTypeFromFirstInValue(values);
            } else {
                field = fieldInfoMap.getExpressionFieldName();
                fieldType = SQLQueryToExpression.getFieldType(fieldInfoMap.getFieldType());
            }
            return SQLQueryToExpression.formatCondition("Q", field, fieldType, operator, values);
        }
        if (expression instanceof IsNullExpression) {
            IsNullExpression isNull = (IsNullExpression)expression;
            String operator = isNull.isNot() ? "NOTNULL" : "NULL";
            return SQLQueryToExpression.formatCondition("Q", SQLQueryToExpression.getColumnName(isNull.getLeftExpression()), "S", operator, "");
        }
        return "";
    }

    private static String combineWithAnd(String left, String right) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        return left + " AND " + right;
    }

    private static String combineWithOr(String left, String right) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        return left + " OR " + right;
    }

    private static String formatCondition(String connector, ComparisonOperator comp, String operator, List<SQLFieldInfoMap> fieldInfoMaps) {
        String fieldType;
        String field;
        String finalField = field = SQLQueryToExpression.getColumnName(comp.getLeftExpression());
        SQLFieldInfoMap fieldInfoMap = fieldInfoMaps.stream().filter(f -> f.getSqlFieldName().equalsIgnoreCase(finalField)).findFirst().orElse(null);
        if (fieldInfoMap == null) {
            fieldType = SQLQueryToExpression.getFieldType(comp.getRightExpression());
        } else {
            field = fieldInfoMap.getExpressionFieldName();
            fieldType = SQLQueryToExpression.getFieldType(fieldInfoMap.getFieldType());
        }
        return SQLQueryToExpression.formatCondition(connector, field, fieldType, operator, SQLQueryToExpression.getRawValue(comp.getRightExpression()));
    }

    private static String formatCondition(String connector, String field, String fieldType, String operator, String value) {
        return String.format("%s_%s_%s_%s=%s", connector, field, fieldType, operator, value);
    }

    private static String getColumnName(Expression expr) {
        if (expr instanceof Column) {
            return ((Column)expr).getColumnName();
        }
        return expr.toString();
    }

    private static String getRawValue(Expression expr) {
        if (expr instanceof StringValue) {
            return "'" + ((StringValue)expr).getValue() + "'";
        }
        if (expr instanceof LongValue) {
            return String.valueOf(((LongValue)expr).getValue());
        }
        if (expr instanceof DoubleValue) {
            return String.valueOf(((DoubleValue)expr).getValue());
        }
        if (expr instanceof JdbcParameter) {
            return "?";
        }
        if (expr instanceof Column) {
            return ((Column)expr).getColumnName();
        }
        if (expr instanceof DateValue) {
            return "'" + ((DateValue)expr).getValue().toString() + "'";
        }
        if (expr instanceof TimestampValue) {
            return "'" + ((TimestampValue)expr).getValue().toString() + "'";
        }
        if (expr instanceof TimeValue) {
            return "'" + ((TimeValue)expr).getValue().toString() + "'";
        }
        return expr.toString();
    }

    private static String getFieldType(Expression expr) {
        if (expr instanceof StringValue || expr instanceof DateValue || expr instanceof TimestampValue || expr instanceof TimeValue) {
            return "S";
        }
        if (expr instanceof LongValue || expr instanceof DoubleValue) {
            return "N";
        }
        if (expr instanceof JdbcParameter) {
            return "S";
        }
        return "S";
    }

    private static String determineLikeOperator(String originalValue) {
        if (originalValue.startsWith("'%") && originalValue.endsWith("%'")) {
            return "LK";
        }
        if (originalValue.startsWith("'%")) {
            return "RHK";
        }
        if (originalValue.endsWith("%'")) {
            return "LFK";
        }
        return "LK";
    }

    private static String getInValues(InExpression in) {
        if (in.getRightItemsList() == null) {
            return "";
        }
        final StringBuilder sb = new StringBuilder();
        in.getRightItemsList().accept((ItemsListVisitor)new ItemsListVisitorAdapter(){

            public void visit(ExpressionList expressionList) {
                for (Expression expr : expressionList.getExpressions()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(SQLQueryToExpression.getRawValue(expr));
                }
            }
        });
        return sb.toString();
    }

    private static String getFieldTypeFromFirstInValue(String values) {
        if (values.isEmpty()) {
            return "S";
        }
        String firstValue = values.split(",")[0];
        try {
            Double.parseDouble(firstValue);
            return "N";
        }
        catch (NumberFormatException e) {
            return "S";
        }
    }

    private static String getFieldType(FieldType fieldType) {
        switch (fieldType) {
            case String: {
                return "S";
            }
            case Short: 
            case Int: 
            case Long: 
            case Float: 
            case Double: {
                return "N";
            }
            case DateTime: {
                return "D";
            }
        }
        return "S";
    }
}

