/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.util;

import com.geoway.adf.dms.common.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class FileViewerUtil {
    private static final Logger log = LoggerFactory.getLogger(FileViewerUtil.class);

    public static void viewFile(File localFile, HttpServletRequest request, HttpServletResponse response) {
        if (!localFile.exists()) {
            throw new RuntimeException(localFile + " \u4e0d\u5b58\u5728");
        }
        String ext = FileUtil.getExtension(localFile.getName()).toLowerCase();
        if (".mp4".equalsIgnoreCase(ext)) {
            FileViewerUtil.viewVideoFile(localFile.getAbsolutePath(), request, response);
        } else {
            try (InputStream inputStream = Files.newInputStream(localFile.toPath(), new OpenOption[0]);){
                FileViewerUtil.viewFileStream(inputStream, localFile.getName(), localFile.length(), request, response);
            }
            catch (IOException e) {
                throw new RuntimeException(localFile + "\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25", e);
            }
        }
    }

    public static void viewFileStream(InputStream inputStream, String fileName, long dataLength, HttpServletRequest request, HttpServletResponse response) throws IOException {
        MediaType mediaType = MediaTypeFactory.getMediaType((String)fileName).orElse(MediaType.TEXT_PLAIN);
        String contentType = mediaType.toString();
        response.resetBuffer();
        response.setContentType(contentType);
        if (contentType.startsWith("text/") || contentType.startsWith("application/json")) {
            byte[] firstBytes = new byte[128];
            int bytesRead = inputStream.read(firstBytes);
            if (bytesRead > 0) {
                String charset = FileUtil.getFileCharset(firstBytes);
                response.setCharacterEncoding(charset);
                try (ServletOutputStream outputStream = response.getOutputStream();){
                    int len;
                    outputStream.write(firstBytes, 0, bytesRead);
                    byte[] buffer = new byte[4096];
                    while ((len = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, len);
                    }
                    outputStream.flush();
                }
            }
        } else if (fileName.toLowerCase().endsWith(".mp4")) {
            FileViewerUtil.viewVideoStream(inputStream, dataLength, request, response);
        } else {
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        }
    }

    public static void viewVideoFile(String filePath, HttpServletRequest request, HttpServletResponse response) {
        block30: {
            RandomAccessFile targetFile = null;
            ServletOutputStream outputStream = null;
            try {
                outputStream = response.getOutputStream();
                response.resetBuffer();
                String rangeString = request.getHeader("Range");
                File file = new File(filePath);
                if (file.exists()) {
                    targetFile = new RandomAccessFile(file, "r");
                    long fileLength = targetFile.length();
                    long requestSize = (int)fileLength;
                    if (StringUtils.hasText((String)rangeString)) {
                        long requestStart = 0L;
                        long requestEnd = 0L;
                        String[] ranges = rangeString.split("=");
                        if (ranges.length > 1) {
                            String[] rangeDatas = ranges[1].split("-");
                            requestStart = Integer.parseInt(rangeDatas[0]);
                            if (rangeDatas.length > 1) {
                                requestEnd = Integer.parseInt(rangeDatas[1]);
                            }
                        }
                        if (requestEnd != 0L && requestEnd > requestStart) {
                            requestSize = requestEnd - requestStart + 1L;
                        }
                        response.setHeader("Accept-Ranges", "bytes");
                        response.setHeader("Content-Type", "video/mp4");
                        if (!StringUtils.hasText((String)rangeString)) {
                            response.setHeader("Content-Length", fileLength + "");
                        } else if (requestEnd > 0L) {
                            long length = requestEnd - requestStart + 1L;
                            response.setHeader("Content-Length", "" + length);
                            response.setHeader("Content-Range", "bytes " + requestStart + "-" + requestEnd + "/" + fileLength);
                        } else {
                            long length = fileLength - requestStart;
                            response.setHeader("Content-Length", "" + length);
                            response.setHeader("Content-Range", "bytes " + requestStart + "-" + (fileLength - 1L) + "/" + fileLength);
                        }
                        response.setStatus(206);
                        targetFile.seek(requestStart);
                    } else {
                        response.setHeader("Content-Type", "video/mp4");
                        response.setHeader("Content-Length", String.valueOf(fileLength));
                    }
                    byte[] cache = new byte[4096];
                    try {
                        while (requestSize > 0L) {
                            int len = targetFile.read(cache);
                            if (requestSize < (long)cache.length) {
                                outputStream.write(cache, 0, (int)requestSize);
                            } else {
                                outputStream.write(cache, 0, len);
                                if (len < cache.length) break;
                            }
                            requestSize -= (long)cache.length;
                        }
                        outputStream.flush();
                    }
                    catch (IOException e) {
                        log.info("\u89c6\u9891\u9884\u89c8\uff1a" + e.getMessage());
                    }
                    break block30;
                }
                throw new RuntimeException("\u6587\u4ef6\u8def\u5f84\u6709\u8bef");
            }
            catch (Exception e) {
                throw new RuntimeException("\u6587\u4ef6\u4f20\u8f93\u9519\u8bef", e);
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        log.info(e.getMessage());
                    }
                }
                if (targetFile != null) {
                    try {
                        targetFile.close();
                    }
                    catch (IOException e) {
                        log.info(e.getMessage());
                    }
                }
            }
        }
    }

    public static void viewVideoStream(InputStream inputStream, long dataLength, HttpServletRequest request, HttpServletResponse response) {
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
            response.resetBuffer();
            String rangeString = request.getHeader("Range");
            long requestSize = (int)dataLength;
            if (StringUtils.hasText((String)rangeString)) {
                long requestStart = 0L;
                long requestEnd = 0L;
                String[] ranges = rangeString.split("=");
                if (ranges.length > 1) {
                    String[] rangeDatas = ranges[1].split("-");
                    requestStart = Integer.parseInt(rangeDatas[0]);
                    if (rangeDatas.length > 1) {
                        requestEnd = Integer.parseInt(rangeDatas[1]);
                    }
                }
                if (requestEnd != 0L && requestEnd > requestStart) {
                    requestSize = requestEnd - requestStart + 1L;
                }
                response.setHeader("Accept-Ranges", "bytes");
                response.setHeader("Content-Type", "video/mp4");
                if (!StringUtils.hasText((String)rangeString)) {
                    response.setHeader("Content-Length", dataLength + "");
                } else if (requestEnd > 0L) {
                    long length = requestEnd - requestStart + 1L;
                    response.setHeader("Content-Length", "" + length);
                    response.setHeader("Content-Range", "bytes " + requestStart + "-" + requestEnd + "/" + dataLength);
                } else {
                    long length = dataLength - requestStart;
                    response.setHeader("Content-Length", "" + length);
                    response.setHeader("Content-Range", "bytes " + requestStart + "-" + (dataLength - 1L) + "/" + dataLength);
                }
                response.setStatus(206);
                inputStream.skip(requestStart);
            } else {
                response.setHeader("Content-Type", "video/mp4");
                response.setHeader("Content-Length", String.valueOf(dataLength));
            }
            byte[] cache = new byte[4096];
            try {
                while (requestSize > 0L) {
                    int len = inputStream.read(cache);
                    if (requestSize < (long)cache.length) {
                        outputStream.write(cache, 0, (int)requestSize);
                    } else {
                        outputStream.write(cache, 0, len);
                        if (len < cache.length) break;
                    }
                    requestSize -= (long)cache.length;
                }
                outputStream.flush();
            }
            catch (IOException e) {
                log.info("\u89c6\u9891\u9884\u89c8\uff1a" + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u4f20\u8f93\u9519\u8bef", e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.info(e.getMessage());
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.info(e.getMessage());
                }
            }
        }
    }
}

