/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.util;

import com.geoway.adf.dms.common.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class FileViewerUtil {
    private static final Logger log = LoggerFactory.getLogger(FileViewerUtil.class);

    public static void viewFile(File localFile, HttpServletRequest request, HttpServletResponse response) {
        if (!localFile.exists()) {
            throw new RuntimeException(localFile + " \u4e0d\u5b58\u5728");
        }
        String ext = FileUtil.getExtension(localFile.getName()).toLowerCase();
        if (".mp4".equalsIgnoreCase(ext)) {
            FileViewerUtil.viewVideoFile(localFile.getAbsolutePath(), request, response);
        } else {
            if (localFile.length() > 524288000L) {
                throw new RuntimeException("\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u9650\u5236\uff0c\u4e0d\u652f\u6301\u9884\u89c8");
            }
            try (InputStream inputStream = Files.newInputStream(localFile.toPath(), new OpenOption[0]);){
                FileViewerUtil.viewFileStream(inputStream, localFile.getName(), localFile.length(), request, response);
            }
            catch (IOException e) {
                throw new RuntimeException(localFile + "\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25", e);
            }
        }
    }

    public static void viewFileStream(InputStream inputStream, String fileName, long dataLength, HttpServletRequest request, HttpServletResponse response) throws IOException {
        MediaType mediaType = MediaTypeFactory.getMediaType((String)fileName).orElse(MediaType.TEXT_PLAIN);
        String contentType = mediaType.toString();
        response.resetBuffer();
        response.setContentType(contentType);
        if (contentType.startsWith("text/") || contentType.startsWith("application/json")) {
            byte[] firstBytes = new byte[128];
            int bytesRead = inputStream.read(firstBytes);
            if (bytesRead > 0) {
                String charset = FileUtil.getFileCharset(firstBytes);
                response.setCharacterEncoding(charset);
                try (ServletOutputStream outputStream = response.getOutputStream();){
                    int len;
                    outputStream.write(firstBytes, 0, bytesRead);
                    byte[] buffer = new byte[4096];
                    while ((len = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, len);
                    }
                    outputStream.flush();
                }
            }
        } else if (fileName.toLowerCase().endsWith(".mp4")) {
            FileViewerUtil.viewVideoStream(inputStream, dataLength, request, response);
        } else {
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        }
    }

    public static void viewVideoFile(String filePath, HttpServletRequest request, HttpServletResponse response) {
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            log.error("\u6587\u4ef6\u4e0d\u5b58\u5728:" + filePath);
            response.setStatus(404);
            return;
        }
        response.setHeader("Accept-Ranges", "bytes");
        response.setHeader("Content-Type", "video/mp4");
        try (RandomAccessFile targetFile = new RandomAccessFile(file, "r");){
            long fileLength = targetFile.length();
            long requestSize = (int)fileLength;
            String rangeHeader = request.getHeader("Range");
            if (StringUtils.hasText((String)rangeHeader)) {
                String[] ranges = rangeHeader.substring(6).split("-");
                long start = Long.parseLong(ranges[0]);
                long end = ranges.length > 1 ? Long.parseLong(ranges[1]) : fileLength - 1L;
                requestSize = end - start + 1L;
                response.setStatus(206);
                response.setHeader("Content-Length", String.valueOf(requestSize));
                response.setHeader("Content-Range", "bytes " + start + "-" + end + "/" + fileLength);
                targetFile.seek(start);
            } else {
                response.setHeader("Content-Length", String.valueOf(fileLength));
            }
            try (ServletOutputStream outputStream = response.getOutputStream();){
                int bytesRead;
                byte[] buffer = new byte[8192];
                for (long remaining = requestSize; remaining > 0L; remaining -= (long)bytesRead) {
                    int readSize = (int)Math.min((long)buffer.length, remaining);
                    bytesRead = targetFile.read(buffer, 0, readSize);
                    if (bytesRead == -1) {
                        break;
                    }
                    outputStream.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                log.info("\u89c6\u9891\u9884\u89c8\uff1a" + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u4f20\u8f93\u9519\u8bef", e);
        }
    }

    public static void viewVideoStream(InputStream inputStream, long dataLength, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.resetBuffer();
            response.setHeader("Content-Type", "video/mp4");
            response.setHeader("Accept-Ranges", "bytes");
            String rangeHeader = request.getHeader("Range");
            long requestSize = dataLength;
            if (StringUtils.hasText((String)rangeHeader)) {
                String[] ranges = rangeHeader.substring(6).split("-");
                long start = Long.parseLong(ranges[0]);
                long end = ranges.length > 1 ? Long.parseLong(ranges[1]) : dataLength - 1L;
                requestSize = end - start + 1L;
                response.setStatus(206);
                response.setHeader("Content-Length", String.valueOf(requestSize));
                response.setHeader("Content-Range", "bytes " + start + "-" + end + "/" + dataLength);
                inputStream.skip(start);
            } else {
                response.setHeader("Content-Length", String.valueOf(dataLength));
            }
            try (ServletOutputStream outputStream = response.getOutputStream();){
                int bytesRead;
                byte[] buffer = new byte[8192];
                for (long remaining = requestSize; remaining > 0L && (bytesRead = inputStream.read(buffer, 0, (int)Math.min((long)buffer.length, remaining))) != -1; remaining -= (long)bytesRead) {
                    outputStream.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                log.info("\u89c6\u9891\u9884\u89c8\uff1a" + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u4f20\u8f93\u9519\u8bef", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.info("\u89c6\u9891\u6d41\u91ca\u653e\u9519\u8bef\uff1a" + e.getMessage());
                }
            }
        }
    }
}

