/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.util;

import com.geoway.adf.dms.common.util.StringUtil;
import java.awt.image.BufferedImage;
import java.util.stream.IntStream;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import sun.misc.BASE64Encoder;

public class ImageUtil {
    public static String toBase64DataUri(byte[] imageBytes, String imageType) {
        if (StringUtil.isEmpty(imageType) && StringUtil.isEmpty(imageType = ImageUtil.getImageType(imageBytes))) {
            imageType = "png";
        }
        MediaType mediaType = MediaTypeFactory.getMediaType((String)("." + imageType)).orElse(MediaType.IMAGE_PNG);
        String contentType = mediaType.toString();
        BASE64Encoder encoder = new BASE64Encoder();
        String base64Str = encoder.encode(imageBytes);
        base64Str = "data:" + contentType + ";base64," + base64Str;
        return base64Str;
    }

    public static String getImageType(byte[] imageBytes) {
        String typeHexStr = ImageUtil.bytesToHex(imageBytes, 8);
        if (typeHexStr.startsWith("ffd8ff")) {
            return "jpg";
        }
        if (typeHexStr.startsWith("89504e47")) {
            return "png";
        }
        if (typeHexStr.startsWith("4749463837") || typeHexStr.startsWith("4749463839")) {
            return "gif";
        }
        if (typeHexStr.startsWith("424d")) {
            return "bmp";
        }
        if (typeHexStr.startsWith("0000010001002020")) {
            return "ico";
        }
        if (typeHexStr.startsWith("3c73766720")) {
            return "svg";
        }
        if (typeHexStr.startsWith("52494646")) {
            return "webp";
        }
        return null;
    }

    public static boolean hasTransparentBounds(BufferedImage source) {
        for (int y = 0; y < source.getHeight(); ++y) {
            for (int x = 0; x < source.getWidth(); ++x) {
                int updatePixel = ImageUtil.getPixel(source, x, y);
                int alpha = updatePixel >> 24 & 0xFF;
                if (alpha != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static BufferedImage combineImage(BufferedImage updateImage, BufferedImage sourceImage) {
        if (updateImage.getHeight() != sourceImage.getHeight()) {
            throw new RuntimeException("\u56fe\u7247\u9ad8\u5ea6\u4e0d\u4e00\u81f4\uff01");
        }
        if (updateImage.getWidth() != sourceImage.getWidth()) {
            throw new RuntimeException("\u56fe\u7247\u5bbd\u5ea6\u4e0d\u4e00\u81f4\uff01");
        }
        int width = sourceImage.getWidth();
        int height = sourceImage.getHeight();
        BufferedImage mergedImage = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int sourcePixel = ImageUtil.getPixel(sourceImage, x, y);
                int updatePixel = ImageUtil.getPixel(updateImage, x, y);
                int alpha = updatePixel >> 24 & 0xFF;
                if (alpha == 0) {
                    mergedImage.setRGB(x, y, sourcePixel);
                    continue;
                }
                mergedImage.setRGB(x, y, updatePixel);
            }
        }
        return mergedImage;
    }

    private static String bytesToHex(byte[] bytes, int lenth) {
        StringBuilder builder = new StringBuilder();
        IntStream.range(0, Math.min(bytes.length, lenth)).forEach(i -> {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            builder.append(hex);
        });
        return builder.toString().toLowerCase();
    }

    private static int getPixel(BufferedImage image, int x, int y) {
        if (x >= 0 && x < image.getWidth() && y >= 0 && y < image.getHeight()) {
            return image.getRGB(x, y);
        }
        return 0;
    }
}

