/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.converters.ConverterKeyBuild;
import com.alibaba.excel.converters.DefaultConverterLoader;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelAnalysisStopException;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.gis.geodb.excel.TimestampConverter;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);
    private static final DecimalFormat decimalFormat = new DecimalFormat("###################.###########");

    public static void registerConverter() {
        try {
            Map defaultWriteConverter = DefaultConverterLoader.loadDefaultWriteConverter();
            Map allConverter = DefaultConverterLoader.loadAllConverter();
            TimestampConverter timestampConverter = new TimestampConverter();
            defaultWriteConverter.putIfAbsent(ConverterKeyBuild.buildKey((Class)timestampConverter.supportJavaTypeKey()), timestampConverter);
            allConverter.putIfAbsent(ConverterKeyBuild.buildKey((Class)timestampConverter.supportJavaTypeKey(), (CellDataTypeEnum)timestampConverter.supportExcelTypeKey()), timestampConverter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<Map<String, String>> readExcel(String filePath) {
        List dataList;
        int rowCount;
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        String completePath = filePath;
        String sheetName = "";
        File file = new File(completePath);
        if (ExcelUtil.isExcel(file.getParent()).booleanValue()) {
            sheetName = FileUtil.getFileNameWithoutExtension(completePath);
            completePath = file.getParent();
        }
        if ((rowCount = (dataList = sheetName.length() > 0 ? ((ExcelReaderSheetBuilder)EasyExcel.read((String)completePath).sheet().sheetName(sheetName).headRowNumber(Integer.valueOf(0))).doReadSync() : ((ExcelReaderSheetBuilder)EasyExcel.read((String)completePath).sheet().sheetNo(Integer.valueOf(0)).headRowNumber(Integer.valueOf(0))).doReadSync()).size()) < 2) {
            return result;
        }
        Map columnRow = (Map)dataList.get(0);
        int cellCount = columnRow.size();
        for (int i = 1; i < rowCount; ++i) {
            Map row = (Map)dataList.get(i);
            HashMap<String, String> keyValue = new HashMap<String, String>(0);
            if (row == null) continue;
            for (int j = 0; j < cellCount; ++j) {
                Object columnCell = columnRow.get(j);
                if (columnCell == null) continue;
                Object cell = row.get(j);
                String value = cell == null ? null : cell.toString();
                keyValue.put(columnCell.toString(), value);
            }
            result.add(keyValue);
        }
        return result;
    }

    public static List<List<String>> readExcelDataList(String filePath) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        String completePath = filePath;
        String sheetName = "";
        File file = new File(completePath);
        if (ExcelUtil.isExcel(file.getParent()).booleanValue()) {
            sheetName = FileUtil.getFileNameWithoutExtension(completePath);
            completePath = file.getParent();
        }
        List dataList = sheetName.length() > 0 ? ((ExcelReaderSheetBuilder)EasyExcel.read((String)completePath).sheet().sheetName(sheetName).headRowNumber(Integer.valueOf(0))).doReadSync() : ((ExcelReaderSheetBuilder)EasyExcel.read((String)completePath).sheet().sheetNo(Integer.valueOf(0)).headRowNumber(Integer.valueOf(0))).doReadSync();
        dataList.forEach(m -> {
            ArrayList values = new ArrayList();
            m.values().forEach(d -> values.add(d == null ? null : d.toString()));
            result.add(values);
        });
        return result;
    }

    public static List<Map<String, String>> readExcel(InputStream inputStream, String sheetName) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        List dataList = sheetName != null && sheetName.length() > 0 ? ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)inputStream).sheet().sheetName(sheetName).headRowNumber(Integer.valueOf(0))).doReadSync() : ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)inputStream).sheet().sheetNo(Integer.valueOf(0)).headRowNumber(Integer.valueOf(0))).doReadSync();
        int rowCount = dataList.size();
        if (rowCount < 2) {
            return result;
        }
        Map columnRow = (Map)dataList.get(0);
        int cellCount = columnRow.size();
        for (int i = 1; i < rowCount; ++i) {
            Map row = (Map)dataList.get(i);
            HashMap<String, String> keyValue = new HashMap<String, String>(0);
            if (row == null) continue;
            for (int j = 0; j < cellCount; ++j) {
                Object columnCell = columnRow.get(j);
                if (columnCell == null) continue;
                Object cell = row.get(j);
                String value = cell == null ? null : cell.toString();
                keyValue.put(columnCell.toString(), value);
            }
            result.add(keyValue);
        }
        return result;
    }

    public static List<List<String>> readExcelDataList(InputStream inputStream, String sheetName) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        List dataList = sheetName != null && sheetName.length() > 0 ? ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)inputStream).sheet().sheetName(sheetName).headRowNumber(Integer.valueOf(0))).doReadSync() : ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)inputStream).sheet().sheetNo(Integer.valueOf(0)).headRowNumber(Integer.valueOf(0))).doReadSync();
        dataList.forEach(m -> {
            ArrayList values = new ArrayList();
            m.values().forEach(d -> values.add(d == null ? null : d.toString()));
            result.add(values);
        });
        return result;
    }

    public static List<String> readExcelSheets(String filePath) {
        ArrayList<String> result = new ArrayList<String>();
        try (ExcelReader excelReader = EasyExcel.read((String)filePath).build();){
            List sheets = excelReader.excelExecutor().sheetList();
            for (ReadSheet sheet : sheets) {
                result.add(sheet.getSheetName());
            }
        }
        return result;
    }

    public static List<String> readExcelSheets(InputStream inputStream) {
        ArrayList<String> result = new ArrayList<String>();
        try (ExcelReader excelReader = EasyExcel.read((InputStream)inputStream).build();){
            List sheets = excelReader.excelExecutor().sheetList();
            for (ReadSheet sheet : sheets) {
                result.add(sheet.getSheetName());
            }
        }
        return result;
    }

    public static List<String> readExcelColumn(String filePath) {
        String completePath = filePath;
        String sheetName = "";
        File file = new File(completePath);
        if (ExcelUtil.isExcel(file.getParent()).booleanValue()) {
            sheetName = FileUtil.getFileNameWithoutExtension(completePath);
            completePath = file.getParent();
        }
        HeadDataListener headDataListener = new HeadDataListener();
        if (sheetName.length() > 0) {
            EasyExcel.read((String)completePath, (ReadListener)headDataListener).sheet().sheetName(sheetName).doReadSync();
        } else {
            EasyExcel.read((String)completePath, (ReadListener)headDataListener).sheet().sheetNo(Integer.valueOf(0)).doReadSync();
        }
        return headDataListener.headList;
    }

    public static List<String> readExcelColumn(InputStream inputStream, String sheetName) {
        HeadDataListener headDataListener = new HeadDataListener();
        if (sheetName != null && sheetName.length() > 0) {
            EasyExcel.read((InputStream)inputStream, (ReadListener)headDataListener).sheet().sheetName(sheetName).doReadSync();
        } else {
            EasyExcel.read((InputStream)inputStream, (ReadListener)headDataListener).sheet().sheetNo(Integer.valueOf(0)).doReadSync();
        }
        return headDataListener.headList;
    }

    public static Boolean isExcel(String fileName) {
        if ((fileName = fileName.toUpperCase(Locale.ROOT)).endsWith(".XLS") || fileName.endsWith(".XLSX") || fileName.endsWith(".CSV")) {
            return true;
        }
        return false;
    }

    public static void writeExcel(List<List<Object>> datas, OutputStream outputStream) {
        EasyExcel.write((OutputStream)outputStream).sheet("Sheet1").doWrite(datas);
    }

    public static void writeExcel(List<List<Object>> datas, String filePath) {
        String completePath = filePath;
        String sheetName = "";
        File file = new File(completePath);
        if (ExcelUtil.isExcel(file.getParent()).booleanValue()) {
            sheetName = FileUtil.getFileNameWithoutExtension(completePath);
            completePath = file.getParent();
        } else {
            sheetName = "Sheet1";
        }
        EasyExcel.write((String)completePath).sheet(sheetName).doWrite(datas);
    }

    public static void writeAppendExcel(List<List<Object>> datas, String filePath) {
        String completePath = filePath;
        String sheetName = "";
        File file = new File(completePath);
        if (ExcelUtil.isExcel(file.getParent()).booleanValue()) {
            sheetName = FileUtil.getFileNameWithoutExtension(completePath);
            completePath = file.getParent();
            file = file.getParentFile();
        } else {
            sheetName = "Sheet1";
        }
        if (file.exists()) {
            File tempFile = Paths.get(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString() + FileUtil.getExtension(completePath)).toFile();
            ((ExcelWriterBuilder)EasyExcel.write((File)tempFile).needHead(Boolean.valueOf(false))).withTemplate(file).sheet(sheetName).doWrite(datas);
            if (tempFile.exists()) {
                file.delete();
                tempFile.renameTo(file);
            }
        } else {
            EasyExcel.write((String)completePath).sheet(sheetName).doWrite(datas);
        }
    }

    static {
        ExcelUtil.registerConverter();
    }

    static class HeadDataListener
    extends AnalysisEventListener<Map<Integer, String>> {
        protected List<String> headList = new ArrayList<String>();

        HeadDataListener() {
        }

        public void invokeHead(Map<Integer, ReadCellData<?>> headMap, AnalysisContext context) {
            for (ReadCellData<?> cellData : headMap.values()) {
                this.headList.add(cellData.getStringValue());
            }
            throw new ExcelAnalysisStopException();
        }

        public void invoke(Map<Integer, String> data, AnalysisContext context) {
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }
    }
}

