/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.util;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectCloseUtil {
    private static final Logger logger = LoggerFactory.getLogger(ObjectCloseUtil.class);

    public static void close(AutoCloseable ... autoCloseable) {
        Arrays.stream(autoCloseable).forEach(ObjectCloseUtil::closeOne);
    }

    private static void closeOne(AutoCloseable autoCloseable) {
        try {
            if (autoCloseable != null) {
                autoCloseable.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            autoCloseable = null;
        }
    }
}

