/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.config;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
public class ThreadExecutorConfig {
    private static final Logger logger = LoggerFactory.getLogger(ThreadExecutorConfig.class);
    @Value(value="${threadPool.core-pool-size:10}")
    private int corePoolSize;
    @Value(value="${threadPool.max-pool-size:10}")
    private int maxPoolSize;
    @Value(value="${threadPool.queue-capacity:1000}")
    private int queueCapacity;
    @Value(value="${threadPool.threadNamePrefix:my-thread-}")
    private String threadNamePrefix;
    @Value(value="${threadPool.keep-alive-seconds:600}")
    private int keepAliveSeconds;
    @Value(value="${project.dataThreadCount:0}")
    private int dataThreadCount;

    @Bean(value={"threadPoolTaskExecutor"})
    @Primary
    public ThreadPoolTaskExecutor initThreadPoolTaskExecutor() {
        logger.info("init threadPoolTaskExecutor:" + this.corePoolSize);
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.corePoolSize);
        executor.setMaxPoolSize(this.maxPoolSize);
        executor.setQueueCapacity(this.queueCapacity);
        executor.setThreadNamePrefix(this.threadNamePrefix);
        executor.setKeepAliveSeconds(this.keepAliveSeconds);
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        executor.initialize();
        return executor;
    }

    @Bean(value={"threadPoolTaskExecutorData"})
    public ThreadPoolTaskExecutor initDataThreadPoolTaskExecutor() {
        if (this.dataThreadCount <= 0) {
            this.dataThreadCount = Runtime.getRuntime().availableProcessors() / 2;
        }
        if (this.dataThreadCount <= 0) {
            this.dataThreadCount = 4;
        }
        logger.info("init threadPoolTaskExecutorData:" + this.dataThreadCount);
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.dataThreadCount);
        executor.setMaxPoolSize(this.dataThreadCount);
        executor.setQueueCapacity(1000);
        executor.setThreadNamePrefix("data-thread-");
        executor.setKeepAliveSeconds(this.keepAliveSeconds);
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        executor.initialize();
        return executor;
    }
}

