/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.web;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;

public class Response<T> {
    public static final Integer C200 = 200;
    public static final Integer C204 = 204;
    public static final Integer C300 = 300;
    public static final Integer C400 = 400;
    public static final Integer C401 = 401;
    public static final Integer C404 = 404;
    public static final Integer C500 = 500;
    public static final Integer C501 = 501;
    public static final Integer C502 = 502;
    public static final String RESPONSE_OK = "ok";
    public static final String RESPONSE_ERROR = "error";
    @ApiModelProperty(value="\u72b6\u6001\u7801", example="200")
    protected int code;
    @ApiModelProperty(value="\u72b6\u6001\u4fe1\u606f\uff08ok\u8868\u793a\u6210\u529f,error\u8868\u793a\u9519\u8bef\uff09", example="ok")
    protected String status = "ok";
    @ApiModelProperty(value="\u9519\u8bef\u4fe1\u606f")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String message;
    @ApiModelProperty(value="\u8bf7\u6c42\u7ed3\u679c\u6570\u636e")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected T data;

    public Response() {
        this(C200);
    }

    public Response(int code) {
        this(code, "");
    }

    public Response(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public Response(T data) {
        this(C200, "", data);
    }

    public Response(int code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
        this.status = code == C200 || code == C204 ? RESPONSE_OK : RESPONSE_ERROR;
    }

    public static <T> Response<T> ok(T data) {
        return new Response<T>(C200, null, data);
    }

    public static Response ok() {
        return new Response<Object>(C200, null, null);
    }

    public static <T> Response<T> error(String msg) {
        Response<Object> response = new Response<Object>(C500, msg, null);
        response.setStatus(RESPONSE_ERROR);
        return response;
    }

    public static <T> Response<T> error(int code, String msg) {
        Response<Object> response = new Response<Object>(code, msg, null);
        response.setStatus(RESPONSE_ERROR);
        return response;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

