/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.util;

import com.geoway.adf.dms.common.util.ExcelUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.ZipAndRarUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DownloadUtil {
    private static final String[] IE_BROWSERS = new String[]{"MSIE", "Trident", "Edge"};

    public static void setDownloadFileName(String fileName, HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        String userAgent = request.getHeader("User-Agent");
        fileName = Arrays.stream(IE_BROWSERS).anyMatch(userAgent::contains) ? URLEncoder.encode(fileName, "UTF-8") : new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
        response.setHeader("Content-disposition", String.format("attachment; filename=\"%s\"", fileName));
    }

    public static void downloadFile(String filePath) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        DownloadUtil.downloadFile(filePath, servletRequestAttributes.getRequest(), servletRequestAttributes.getResponse());
    }

    public static void downloadFile(InputStream is, long contentLength, String fileName) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        DownloadUtil.downloadFile(is, contentLength, fileName, servletRequestAttributes.getRequest(), servletRequestAttributes.getResponse());
    }

    public static void downloadFile(String filePath, HttpServletRequest request, HttpServletResponse response) {
        File file = new File(filePath);
        Assert.state((boolean)file.exists(), (String)("\u8def\u5f84\u6709\u8bef : " + filePath));
        FileInputStream is = null;
        String fileName = file.getName();
        try {
            is = new FileInputStream(file);
            DownloadUtil.downloadFile(is, file.length(), fileName, request, response);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close(is);
                throw throwable;
            }
        }
        ObjectCloseUtil.close(is);
    }

    public static void downloadFile(InputStream is, long contentLength, String fileName, HttpServletRequest request, HttpServletResponse response) {
        ServletOutputStream out = null;
        BufferedInputStream buff = null;
        try {
            int j;
            response.resetBuffer();
            String userAgent = request.getHeader("User-Agent");
            fileName = Arrays.stream(IE_BROWSERS).anyMatch(userAgent::contains) ? URLEncoder.encode(fileName, "UTF-8") : new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
            response.setHeader("Content-disposition", String.format("attachment; filename=\"%s\"", fileName));
            response.setHeader("Access-Control-Expose-Headers", "Content-disposition");
            response.setHeader("Content-Length", String.valueOf(contentLength));
            response.setContentType("application/x-download");
            response.setCharacterEncoding("UTF-8");
            out = response.getOutputStream();
            buff = new BufferedInputStream(is);
            byte[] b = new byte[2048];
            for (long l = 0L; l < contentLength; l += (long)j) {
                j = buff.read(b, 0, 2048);
                out.write(b, 0, j);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close(new AutoCloseable[]{out, is, buff});
                throw throwable;
            }
        }
        ObjectCloseUtil.close(new AutoCloseable[]{out, is, buff});
    }

    public static void downloadToFile(String fileName, String contents) {
        ServletOutputStream out = null;
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        HttpServletResponse response = servletRequestAttributes.getResponse();
        try {
            byte[] buffer = contents.getBytes("UTF-8");
            response.resetBuffer();
            String userAgent = request.getHeader("User-Agent");
            fileName = Arrays.stream(IE_BROWSERS).anyMatch(userAgent::contains) ? URLEncoder.encode(fileName, "UTF-8") : new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
            response.setHeader("Content-disposition", String.format("attachment; filename=\"%s\"", fileName));
            response.setHeader("Content-Length", String.valueOf(buffer.length));
            response.setContentType("application/x-download");
            response.setCharacterEncoding("UTF-8");
            out = response.getOutputStream();
            out.write(buffer, 0, buffer.length);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close(new AutoCloseable[]{out});
                throw throwable;
            }
        }
        ObjectCloseUtil.close(new AutoCloseable[]{out});
    }

    public static void downloadExcelFile(String fileName, List<List<Object>> datas) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        HttpServletResponse response = servletRequestAttributes.getResponse();
        try {
            response.resetBuffer();
            String userAgent = request.getHeader("User-Agent");
            fileName = Arrays.stream(IE_BROWSERS).anyMatch(userAgent::contains) ? URLEncoder.encode(fileName, "UTF-8") : new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
            response.setHeader("Content-disposition", String.format("attachment; filename=\"%s\"", fileName));
            response.setContentType("application/x-download");
            response.setCharacterEncoding("UTF-8");
            BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ExcelUtil.writeExcel(datas, outputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void downloadZipFile(List<File> srcFiles, String srcRootDir, String zipFileName) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        HttpServletResponse response = servletRequestAttributes.getResponse();
        try {
            response.resetBuffer();
            String userAgent = request.getHeader("User-Agent");
            zipFileName = Arrays.stream(IE_BROWSERS).anyMatch(userAgent::contains) ? URLEncoder.encode(zipFileName, "UTF-8") : new String(zipFileName.getBytes("UTF-8"), "ISO-8859-1");
            response.setHeader("Content-disposition", String.format("attachment; filename=\"%s\"", zipFileName));
            response.setContentType("application/x-download");
            response.setCharacterEncoding("UTF-8");
            BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ZipAndRarUtil.zipFiles(srcFiles, srcRootDir, outputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

