/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.gis;

import com.geoway.adf.gis.basic.geometry.CoordinateType;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureDataset;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;

public class FeatureClassUtil {
    public static IFeatureClass createFeatureClass(IFeatureClass srcFeatClass, IFeatureWorkspace tarWorkspace, String tarFCName, ISpatialReferenceSystem tarSR) {
        return FeatureClassUtil.createFeatureClass(srcFeatClass, tarWorkspace, tarFCName, null, srcFeatClass.getOidFieldName(), srcFeatClass.getShapeFieldName(), tarSR, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IFeatureClass createFeatureClass(IFeatureClass srcFeatClass, IFeatureWorkspace tarWorkspace, String tarFCName, IFields pExFields, String oidFieldName, String shapeFieldName, ISpatialReferenceSystem tarSR, String parentDatasetName) {
        int i;
        if (tarFCName.trim().length() == 0) {
            return null;
        }
        Fields newFields = new Fields();
        GeometryField geometryField = null;
        for (i = 0; i < srcFeatClass.getFields().getFieldCount(); ++i) {
            IField tempField = srcFeatClass.getFields().getField(i).clone();
            if (tempField.getFieldType() == FieldType.Shape) {
                tempField.setName(shapeFieldName);
                geometryField = (GeometryField)tempField;
                geometryField.setSpatialReferenceSystem(tarSR);
                geometryField.setCoordinateType(CoordinateType.XY);
                newFields.addField(tempField);
                continue;
            }
            if (tempField.getFieldType() == FieldType.OID) {
                tempField.setName(oidFieldName);
                newFields.addField(tempField);
                continue;
            }
            if (newFields.findFieldIndex(tempField.getName()) >= 0) continue;
            newFields.addField(tempField);
        }
        if (pExFields != null) {
            for (i = 0; i < pExFields.getFieldCount(); ++i) {
                if (pExFields.getField(i).getFieldType() == FieldType.OID || newFields.findFieldIndex(pExFields.getField(i).getName()) >= 0) continue;
                newFields.addField(pExFields.getField(i));
            }
        }
        IFeatureClass iFeatClass = null;
        if (parentDatasetName != null && parentDatasetName.length() > 0) {
            IFeatureDataset parentDataset = tarWorkspace.openFeatureDataset(parentDatasetName);
            if (parentDataset == null) throw new RuntimeException(String.format("\u8981\u7d20\u6570\u636e\u96c6[%s]\u6253\u5f00\u5931\u8d25", parentDatasetName));
            if (geometryField != null) {
                geometryField.setSpatialReferenceSystem(parentDataset.getSpatialReferenceSystem());
            }
            iFeatClass = parentDataset.createFeatureClass(tarFCName, (IFields)newFields, srcFeatClass.getFeatureType(), shapeFieldName, srcFeatClass.getSubTypeFieldName());
        } else {
            iFeatClass = tarWorkspace.createFeatureClass(tarFCName, (IFields)newFields, srcFeatClass.getFeatureType(), shapeFieldName, srcFeatClass.getSubTypeFieldName());
        }
        if (iFeatClass == null) return iFeatClass;
        iFeatClass.createSpatialIndex();
        return iFeatClass;
    }

    public static ITable createTable(ITable srcTable, IFeatureWorkspace tarWorkspace, String tarTableName, IFields pExFields, String oidFieldName) {
        int i;
        if (tarTableName.trim().length() == 0) {
            return null;
        }
        Fields newFields = new Fields();
        for (i = 0; i < srcTable.getFields().getFieldCount(); ++i) {
            IField tempField = srcTable.getFields().getField(i).clone();
            if (tempField.getFieldType() == FieldType.OID) {
                tempField.setName(oidFieldName);
                newFields.addField(tempField);
                continue;
            }
            if (newFields.findFieldIndex(tempField.getName()) >= 0) continue;
            newFields.addField(tempField);
        }
        if (pExFields != null) {
            for (i = 0; i < pExFields.getFieldCount(); ++i) {
                if (pExFields.getField(i).getFieldType() == FieldType.OID || newFields.findFieldIndex(pExFields.getField(i).getName()) >= 0) continue;
                newFields.addField(pExFields.getField(i));
            }
        }
        ITable iTable = tarWorkspace.createTable(tarTableName, (IFields)newFields);
        return iTable;
    }
}

