/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.filemodel.util;

import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.config.filemodel.DataCompactPackage;
import com.geoway.adf.dms.config.filemodel.DataPackage;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.fs.directory.DirectoryFileStorage;
import java.nio.file.Paths;

public class ArchivePackagePath {
    public static String ArchivePackageSeparator = "___";
    public static String ArchivePackageExtension = "Archive";

    public static IFileset getUnCompressFolder(IFileset realPath, IFileset scanPath, String packageType, DataPackage dataPackage, boolean isFile) {
        String folderName = "";
        folderName = isFile ? realPath.getParentFile().getFullPath().replace("\\", "/").replace(scanPath.getFullPath().replace("\\", "/"), ArchivePackagePath.getVirtualFolder(dataPackage)) : realPath.getFullPath().replace("\\", "/").replace(scanPath.getFullPath().replace("\\", "/"), ArchivePackagePath.getVirtualFolder(dataPackage));
        DirectoryFileStorage fileStorage = new DirectoryFileStorage(UploadPathConfig.getUploadPath().toString().replace("\\", "/"), null, null);
        fileStorage.createDirectory(folderName, "");
        return fileStorage.getFile(folderName);
    }

    public static IFileset getVirtualPackagePath(IFileset realPath, IFileset scanPath, DataPackage dataPackage, DataCompactPackage compactPackage) {
        String virtualPackagePath = ArchivePackagePath.getVirtualPackagePathStr(realPath, scanPath, dataPackage, compactPackage);
        DirectoryFileStorage fileStorage = new DirectoryFileStorage(UploadPathConfig.getUploadPath().toString().replace("\\", "/"), null, null);
        fileStorage.createDirectory(virtualPackagePath, "");
        return fileStorage.getFile(virtualPackagePath);
    }

    public static String getVirtualPackagePathStr(IFileset realPath, IFileset scanPath, DataPackage dataPackage, DataCompactPackage compactPackage) {
        String compactPackageFileName = ArchivePackagePath.getFileNameWithoutExtension(realPath, compactPackage.getPackageType(), false);
        String folderName = realPath.getParentFile().getFullPath().replace("\\", "/").replace(scanPath.getFullPath().replace("\\", "/"), ArchivePackagePath.getVirtualFolder(dataPackage));
        String virtualPackagePath = realPath.getFileStorage().combinePaths(folderName, new String[]{String.format("%s%s%s%s%s", compactPackageFileName, ArchivePackageSeparator, ArchivePackageExtension, ArchivePackageSeparator, compactPackage.getPackageType())});
        virtualPackagePath = virtualPackagePath.replace("\\", "/");
        return virtualPackagePath;
    }

    public static IFileset translateRealPackagePath(DataPackage dataPackage, IFileset scanFolder, IFileset virtualPackagePath) {
        String archivePackage = Paths.get(UploadPathConfig.getUploadPath().toString(), ArchivePackageExtension).toString().replace("\\", "/");
        if (!virtualPackagePath.getFullPath().replace("\\", "/").startsWith(archivePackage)) {
            return virtualPackagePath;
        }
        String virtualFolder = ArchivePackagePath.getVirtualFolder(dataPackage);
        if (scanFolder.getFullPath().endsWith("/")) {
            virtualFolder = virtualFolder + "/";
        }
        String realPackagePath = virtualPackagePath.getFullPath().replace("\\", "/").replace(virtualFolder, scanFolder.getFullPath());
        IFileStorage fileStorage = null;
        fileStorage = realPackagePath.startsWith(scanFolder.getFullPath()) ? scanFolder.getFileStorage() : virtualPackagePath.getFileStorage();
        return ArchivePackagePath.createRealPackagePath(fileStorage, realPackagePath);
    }

    public static boolean isContainVirtualPackagePath(String path) {
        return path.contains(ArchivePackagePath.getPrefixInfo());
    }

    private static IFileset createRealPackagePath(IFileStorage fileStorage, String realPackage) {
        String fileName = realPackage.replace(ArchivePackagePath.getPrefixInfo(), "");
        return fileStorage.getFile(fileName.replace("\\", "/"));
    }

    public static String getFileNameWithoutExtension(IFileset fileName, String extension, boolean isNeedAllPath) {
        if (isNeedAllPath) {
            return fileName.getFullPath().replace(extension, "");
        }
        return fileName.getName().replace(extension, "");
    }

    public static String getExtension(String extension) {
        return ArchivePackagePath.getPrefixInfo() + extension;
    }

    private static String getPrefixInfo() {
        return ArchivePackageSeparator + ArchivePackageExtension + ArchivePackageSeparator;
    }

    public static String getVirtualFolder(DataPackage dataPackage) {
        return Paths.get(UploadPathConfig.getUploadPath().toString(), "Archive", dataPackage.getArchiveEnvironment().getGuidDirectory(), dataPackage.getName()).toString().replace("\\", "/");
    }
}

