/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.service.impl;

import com.geoway.adf.dms.config.dao.DmDictValueDao;
import com.geoway.adf.dms.config.dao.DmDictionaryDao;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.dto.dict.edit.DmDictValueCreateDTO;
import com.geoway.adf.dms.config.dto.dict.edit.DmDictValueEditDTO;
import com.geoway.adf.dms.config.dto.dict.edit.DmDictValueSortDTO;
import com.geoway.adf.dms.config.dto.dict.edit.DmDictionaryCreateDTO;
import com.geoway.adf.dms.config.entity.DmDictValue;
import com.geoway.adf.dms.config.entity.DmDictionary;
import com.geoway.adf.dms.config.service.DictionaryService;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DictionaryServiceImpl
implements DictionaryService {
    private static final Logger log = LoggerFactory.getLogger(DictionaryServiceImpl.class);
    private static final String XML_SUFFIX = ".xml";
    @Resource
    private DmDictionaryDao dmDictionaryDao;
    @Resource
    private DmDictValueDao dmDictValueDao;

    @Override
    public List<DmDictionary> list(String keyword) {
        List<DmDictionary> list = this.dmDictionaryDao.queryAll();
        if (keyword != null && keyword.length() > 0) {
            String lowerKeyword = keyword.toLowerCase();
            list = list.stream().filter(f -> f.getDictionaryName().toLowerCase().contains(lowerKeyword) || f.getDictionaryKey().toLowerCase().contains(lowerKeyword)).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    @Cacheable(value={"DictionaryCache"}, keyGenerator="customKeyGenerator")
    public DmDictValueDTO getDictionaryTree(Long dictionaryId) {
        DmDictionary dictionary = this.dmDictionaryDao.selectByPrimaryKey(dictionaryId);
        if (dictionary == null) {
            log.error(String.format("\u5b57\u5178\u503c\u57df[%s]\u4e0d\u5b58\u5728", dictionaryId));
            return null;
        }
        return this.getDictionaryTree(dictionary);
    }

    @Override
    @Cacheable(value={"DictionaryCache"}, keyGenerator="customKeyGenerator")
    public DmDictValueDTO getDictionaryTree(String dictionaryKey) {
        DmDictionary dictionary = this.dmDictionaryDao.selectByKey(dictionaryKey);
        if (dictionary == null) {
            log.error(String.format("\u5b57\u5178\u503c\u57df[%s]\u4e0d\u5b58\u5728", dictionaryKey));
            return null;
        }
        return this.getDictionaryTree(dictionary);
    }

    @Override
    public List<DmDictValueDTO> getDictionaryTreeByKeys(String[] dictionaryKeys) {
        List<DmDictionary> dictionarys = this.dmDictionaryDao.selectByKeys(dictionaryKeys);
        ArrayList<DmDictValueDTO> dictValueDTOList = new ArrayList<DmDictValueDTO>();
        for (DmDictionary dictionary : dictionarys) {
            dictValueDTOList.add(this.getDictionaryTree(dictionary));
        }
        return dictValueDTOList;
    }

    @Override
    @Cacheable(value={"DictionaryCache"}, keyGenerator="customKeyGenerator")
    public List<DmDictValueDTO> getDictionaryValueList(String dictionaryKey) {
        DmDictionary dictionary = this.dmDictionaryDao.selectByKey(dictionaryKey);
        if (dictionary == null) {
            log.error(String.format("\u5b57\u5178\u503c\u57df[%s]\u4e0d\u5b58\u5728", dictionaryKey));
            return null;
        }
        List<DmDictValue> allDictValues = this.dmDictValueDao.queryAllDictValue(dictionary.getDictionaryId());
        ArrayList<DmDictValueDTO> results = new ArrayList<DmDictValueDTO>();
        if (allDictValues.size() > 0) {
            for (DmDictValue value : allDictValues) {
                DmDictValueDTO dto = new DmDictValueDTO();
                BeanUtils.copyProperties((Object)value, (Object)dto);
                results.add(dto);
            }
        }
        return results;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"DictionaryCache"}, allEntries=true)
    public Long addDictionary(DmDictionaryCreateDTO createDTO) {
        Assert.state((boolean)this.dictionaryNotExist(createDTO.getDictionaryKey()), (String)(createDTO.getDictionaryKey() + "\u503c\u57df\u5df2\u5b58\u5728!"));
        if (createDTO.getDictionaryKey() == null) {
            throw new RuntimeException("\u503c\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (createDTO.getDictionaryName() == null) {
            throw new RuntimeException("\u503c\u57df\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DmDictionary dictionary = new DmDictionary();
        dictionary.setDictionaryName(createDTO.getDictionaryName());
        dictionary.setDictionaryKey(createDTO.getDictionaryKey());
        dictionary.setDictionaryDes(createDTO.getDictionaryDes());
        dictionary.setDictionaryType(0L);
        dictionary.setDictionaryLength(Long.parseLong(createDTO.getDictionaryKey().length() + ""));
        this.dmDictionaryDao.insert(dictionary);
        return dictionary.getDictionaryId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"DictionaryCache"}, allEntries=true)
    public void updateDictionary(DmDictionaryCreateDTO editDTO) {
        DmDictionary dictionary = this.dmDictionaryDao.selectByKey(editDTO.getDictionaryKey());
        Assert.notNull((Object)dictionary, (String)"\u503c\u57df\u4e0d\u5b58\u5728\uff01");
        if (editDTO.getDictionaryName() == null) {
            throw new RuntimeException("\u503c\u57df\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        dictionary.setDictionaryName(editDTO.getDictionaryName());
        if (editDTO.getDictionaryDes() != null) {
            dictionary.setDictionaryDes(editDTO.getDictionaryDes());
        }
        this.dmDictionaryDao.updateByPrimaryKey(dictionary);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"DictionaryCache"}, allEntries=true)
    public void deleteDictionary(String dictionaryKey) {
        DmDictionary dictionary = this.dmDictionaryDao.selectByKey(dictionaryKey);
        Assert.notNull((Object)dictionary, (String)"\u503c\u57df\u4e0d\u5b58\u5728\uff01");
        this.dmDictionaryDao.deleteByPrimaryKey(dictionary.getDictionaryId());
        this.dmDictValueDao.deleteByDictionaryId(dictionary.getDictionaryId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"DictionaryCache"}, allEntries=true)
    public Long addDictionaryValue(DmDictValueCreateDTO createDTO) {
        createDTO.check();
        DmDictionary dictionary = this.dmDictionaryDao.selectByPrimaryKey(createDTO.getDictionaryId());
        Assert.notNull((Object)dictionary, (String)"\u503c\u57df\u4e0d\u5b58\u5728\uff01");
        Assert.state((boolean)this.valueNotExist(createDTO.getDictionaryId(), createDTO.getFatherId(), createDTO.getCode(), createDTO.getName()), (String)(createDTO.getCode() + "\u503c\u5df2\u5b58\u5728!"));
        Long fatherLevel = -1L;
        if (createDTO.getFatherId() != null && createDTO.getFatherId() != -1L) {
            DmDictValue fatherValue = this.dmDictValueDao.selectByPrimaryKey(createDTO.getFatherId());
            Assert.notNull((Object)fatherValue, (String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
            fatherLevel = fatherValue.getLevel();
        } else {
            createDTO.setFatherId(-1L);
        }
        if (createDTO.getOrder() == null) {
            createDTO.setOrder(this.getNextOrder(createDTO.getDictionaryId(), createDTO.getFatherId()));
        }
        DmDictValue dmDictValue = new DmDictValue();
        BeanUtils.copyProperties((Object)createDTO, (Object)dmDictValue);
        dmDictValue.setLevel(fatherLevel + 1L);
        this.dmDictValueDao.insert(dmDictValue);
        return dmDictValue.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"DictionaryCache"}, allEntries=true)
    public void updateDictionaryValue(DmDictValueEditDTO editDTO) {
        editDTO.check();
        DmDictValue dictValue = this.dmDictValueDao.selectByPrimaryKey(editDTO.getId());
        Assert.notNull((Object)dictValue, (String)"\u503c\u4e0d\u5b58\u5728\uff01");
        DmDictionary dictionary = this.dmDictionaryDao.selectByPrimaryKey(dictValue.getDictionaryId());
        Assert.notNull((Object)dictionary, (String)"\u503c\u57df\u4e0d\u5b58\u5728\uff01");
        if (!dictValue.getCode().equals(editDTO.getCode())) {
            Assert.state((boolean)this.valueNotExist(dictValue.getDictionaryId(), dictValue.getFatherId(), editDTO.getCode(), editDTO.getName()), (String)(editDTO.getCode() + "\u503c\u5df2\u5b58\u5728!"));
        }
        dictValue.setCode(editDTO.getCode());
        dictValue.setName(editDTO.getName());
        if (editDTO.getRemark() != null) {
            dictValue.setRemark(editDTO.getRemark());
        }
        this.dmDictValueDao.updateByPrimaryKey(dictValue);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"DictionaryCache"}, allEntries=true)
    public void deleteDictionaryValue(String ids) {
        String[] idArray = ids.split(",");
        try {
            List<Long> idList = Arrays.stream(idArray).map(Long::parseLong).collect(Collectors.toList());
            long dictionaryId = -1L;
            for (Long id2 : idList) {
                DmDictValue dictValue = this.dmDictValueDao.selectByPrimaryKey(id2);
                if (dictValue == null || dictValue.getDictionaryId() == null) continue;
                dictionaryId = dictValue.getDictionaryId();
                break;
            }
            DmDictionary dictionary = this.dmDictionaryDao.selectByPrimaryKey(dictionaryId);
            Assert.notNull((Object)dictionary, (String)"\u503c\u57df\u4e0d\u5b58\u5728\uff01");
            List<Long> allDeleteIds = this.getSubNodeIdList(dictionaryId, idList);
            idList.forEach(id -> {
                if (!allDeleteIds.contains(id)) {
                    allDeleteIds.add((Long)id);
                }
            });
            if (allDeleteIds.size() > 0) {
                this.dmDictValueDao.deleteByIds(allDeleteIds);
                DmDictValueDTO dictValueDTO = this.getDictionaryTree(dictionaryId);
                if (dictValueDTO != null) {
                    this.updateTreeOrder(dictValueDTO.getChildren());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u5220\u9664\u503c\u57df\u5931\u8d25\uff01", e);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"DictionaryCache"}, allEntries=true)
    public void sort(DmDictValueSortDTO sortDTO) {
        int i;
        DmDictValue dmDictValue = this.dmDictValueDao.selectByPrimaryKey(sortDTO.getId());
        Assert.notNull((Object)dmDictValue, (String)"\u679a\u4e3e\u503c\u4e0d\u5b58\u5728");
        List<DmDictValue> dmDictValueList = this.dmDictValueDao.queryByPid(dmDictValue.getDictionaryId(), dmDictValue.getFatherId());
        int currentValueIndex = 0;
        for (i = 0; i < dmDictValueList.size(); ++i) {
            if (sortDTO.getId() != (long)dmDictValueList.get(i).getId().intValue()) continue;
            dmDictValue = dmDictValueList.get(i);
            currentValueIndex = i;
            break;
        }
        switch (sortDTO.getOperate()) {
            case 0: {
                if (currentValueIndex == 0) {
                    throw new RuntimeException("\u5df2\u5728\u6700\u524d");
                }
                dmDictValueList.remove(currentValueIndex);
                dmDictValueList.add(0, dmDictValue);
                break;
            }
            case 1: {
                if (currentValueIndex == dmDictValueList.size() - 1) {
                    throw new RuntimeException("\u5df2\u5728\u6700\u540e");
                }
                dmDictValueList.remove(currentValueIndex);
                dmDictValueList.add(dmDictValue);
                break;
            }
            case 2: {
                if (currentValueIndex == 0) {
                    throw new RuntimeException("\u5df2\u5728\u6700\u524d");
                }
                dmDictValueList.remove(currentValueIndex);
                dmDictValueList.add(currentValueIndex - 1, dmDictValue);
                break;
            }
            case 3: {
                if (currentValueIndex == dmDictValueList.size() - 1) {
                    throw new RuntimeException("\u5df2\u5728\u6700\u540e");
                }
                dmDictValueList.remove(currentValueIndex);
                dmDictValueList.add(currentValueIndex + 1, dmDictValue);
                break;
            }
            default: {
                throw new RuntimeException("\u53c2\u6570\u6709\u8bef");
            }
        }
        for (i = 0; i < dmDictValueList.size(); ++i) {
            if (dmDictValueList.get(i).getOrder() != null && dmDictValueList.get(i).getOrder() == (long)i) continue;
            this.dmDictValueDao.updateOrderByPrimaryKey(dmDictValueList.get(i).getId(), Long.parseLong(i + ""));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"DictionaryCache"}, allEntries=true)
    public void importXml(MultipartFile file, Long dictionaryId) {
        Document document;
        if (file == null || !Objects.requireNonNull(file.getOriginalFilename()).endsWith(XML_SUFFIX)) {
            throw new RuntimeException("\u6587\u4ef6\u683c\u5f0f\u6709\u8bef");
        }
        SAXReader reader = new SAXReader();
        try {
            document = reader.read(file.getInputStream());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u89e3\u6790\u5931\u8d25: " + e.getMessage());
        }
        Element rootElement = document.getRootElement();
        boolean updateFlag = true;
        String name = rootElement.attributeValue("name");
        String code = rootElement.attributeValue("code");
        String desc = rootElement.attributeValue("desc");
        DmDictionaryCreateDTO createDTO = new DmDictionaryCreateDTO();
        createDTO.setDictionaryKey(code);
        createDTO.setDictionaryName(name);
        createDTO.setDictionaryDes(desc);
        if (dictionaryId == null) {
            dictionaryId = this.addDictionary(createDTO);
            updateFlag = false;
        } else {
            this.updateDictionary(createDTO);
        }
        if (updateFlag) {
            this.dmDictValueDao.deleteByDictionaryId(dictionaryId);
        }
        this.addChildrenFromXml(dictionaryId, rootElement, -1L, 0L);
    }

    @Override
    public void exportXml(HttpServletResponse response, Long dictionaryId) {
        DmDictValueDTO dictValueDTO = this.getDictionaryTree(dictionaryId);
        Assert.notNull((Object)dictValueDTO, (String)"\u503c\u57df\u4e0d\u5b58\u5728\uff01");
        Document document = DocumentHelper.createDocument();
        document.setXMLEncoding("UTF-8");
        Element root = document.addElement("root");
        root.addAttribute("name", dictValueDTO.getName());
        root.addAttribute("code", dictValueDTO.getCode());
        root.addAttribute("desc", dictValueDTO.getRemark());
        List<DmDictValueDTO> dictValues = dictValueDTO.getChildren();
        this.addXmlChildren(root, dictValues);
        try {
            response.setHeader("Content-disposition", String.format("attachment; filename=\"%s\"", "dict.xml"));
            response.setContentType("multipart/form-data");
            response.setCharacterEncoding("UTF-8");
            XMLWriter writer = new XMLWriter((OutputStream)response.getOutputStream(), this.xmlFormat());
            writer.write(document);
            writer.close();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    DmDictValueDTO getDictionaryTree(DmDictionary dictionary) {
        DmDictValueDTO result = new DmDictValueDTO();
        result.setId(-1L);
        result.setCode(dictionary.getDictionaryKey());
        result.setName(dictionary.getDictionaryName());
        result.setRemark(dictionary.getDictionaryDes());
        result.setLevel(0L);
        result.setDictionaryId(dictionary.getDictionaryId());
        result.setOrder(0L);
        result.setChildren(new ArrayList<DmDictValueDTO>());
        List<DmDictValue> allDictValues = this.dmDictValueDao.queryAllDictValue(dictionary.getDictionaryId());
        if (allDictValues.size() > 0) {
            result.setChildren(this.getDictValueTree(allDictValues, -1L));
        }
        return result;
    }

    List<DmDictValueDTO> getDictValueTree(List<DmDictValue> allDictValues, Long fatherId) {
        List valueList = allDictValues.stream().filter(v -> v.getFatherId().equals(fatherId)).collect(Collectors.toList());
        ArrayList<DmDictValueDTO> results = new ArrayList<DmDictValueDTO>();
        for (DmDictValue value : valueList) {
            DmDictValueDTO dto = new DmDictValueDTO();
            BeanUtils.copyProperties((Object)value, (Object)dto);
            dto.setChildren(this.getDictValueTree(allDictValues, value.getId()));
            results.add(dto);
        }
        results.sort(Comparator.comparingLong(DmDictValue::getOrder));
        return results;
    }

    private Boolean dictionaryNotExist(String dictionaryKey) {
        return this.dmDictionaryDao.selectByKey(dictionaryKey) == null;
    }

    private Boolean valueNotExist(Long dictionaryId, Long fatherId, String code, String name) {
        return this.dmDictValueDao.queryValue(dictionaryId, fatherId, code, name) == null;
    }

    private Long getNextOrder(Long dictionaryId, Long fatherId) {
        Long order = this.dmDictValueDao.queryMaxOrder(dictionaryId, fatherId);
        if (order == null) {
            order = -1L;
        }
        return order + 1L;
    }

    private List<Long> getSubNodeIdList(Long dictionaryId, List<Long> nodeIds) {
        List<DmDictValue> allDictValues = this.dmDictValueDao.queryAllDictValue(dictionaryId);
        ArrayList<Long> result = new ArrayList<Long>();
        for (Long nodeId : nodeIds) {
            List<DmDictValueDTO> childList = this.getDictValueTree(allDictValues, nodeId);
            ArrayList<Long> childIdList = new ArrayList<Long>();
            childList.forEach(child -> {
                if (!result.contains(child.getId())) {
                    result.add(child.getId());
                }
                childIdList.add(child.getId());
            });
            result.addAll(this.getSubNodeIdList(dictionaryId, childIdList));
        }
        return result;
    }

    private void updateTreeOrder(List<DmDictValueDTO> children) {
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                DmDictValueDTO item = children.get(i);
                DmDictValue dictValue = this.dmDictValueDao.selectByPrimaryKey(item.getId());
                dictValue.setOrder(Long.parseLong(i + ""));
                this.dmDictValueDao.updateOrderByPrimaryKey(item.getId(), Long.parseLong(i + ""));
                this.updateTreeOrder(item.getChildren());
            }
        }
    }

    private void addChildrenFromXml(Long dictionaryId, Element element, Long pid, Long level) {
        for (Element subElement : element.elements()) {
            Element item = subElement.element("item");
            String code = item.attributeValue("code");
            String name = item.attributeValue("name");
            String desc = item.attributeValue("desc");
            DmDictValue createValue = new DmDictValue();
            createValue.setDictionaryId(dictionaryId);
            createValue.setCode(code);
            createValue.setName(name);
            createValue.setRemark(desc);
            createValue.setFatherId(pid);
            createValue.setOrder(this.getNextOrder(dictionaryId, pid));
            createValue.setLevel(level);
            this.dmDictValueDao.insert(createValue);
            this.addChildrenFromXml(dictionaryId, item, createValue.getId(), level + 1L);
        }
    }

    private void addXmlChildren(Element element, List<DmDictValueDTO> dictValues) {
        for (DmDictValueDTO dictValue : dictValues) {
            Element items = element.addElement("items");
            Element item = items.addElement("item");
            item.addAttribute("name", dictValue.getName());
            item.addAttribute("code", dictValue.getCode());
            item.addAttribute("desc", dictValue.getRemark());
            List<DmDictValueDTO> children = dictValue.getChildren();
            if (children.isEmpty()) continue;
            this.addXmlChildren(item, children);
        }
    }

    private OutputFormat xmlFormat() {
        OutputFormat xmlFormat = OutputFormat.createPrettyPrint();
        xmlFormat.setEncoding("gb2312");
        xmlFormat.setNewlines(true);
        xmlFormat.setIndent(true);
        xmlFormat.setIndent("    ");
        return xmlFormat;
    }
}

