/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.service.impl;

import cn.hutool.core.util.IdUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dao.CmDrawSchemeDao;
import com.geoway.adf.dms.config.dto.drawscheme.DrawSchemeDTO;
import com.geoway.adf.dms.config.dto.drawscheme.DrawSchemeEditDTO;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.entity.CmDrawScheme;
import com.geoway.adf.dms.config.service.DrawSchemeService;
import com.geoway.adf.dms.config.service.LoginUserService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
@Transactional(rollbackFor={Exception.class})
public class DrawSchemeServiceImpl
implements DrawSchemeService {
    @Resource
    private CmDrawSchemeDao drawSchemeDao;
    @Resource
    private LoginUserService loginUserService;

    @Override
    public List<DrawSchemeDTO> list(Boolean withDetail) {
        ArrayList<DrawSchemeDTO> drawSchemeDTOList = new ArrayList<DrawSchemeDTO>();
        HashMap subSchemeList = new HashMap();
        String userId = this.getUserId();
        List<CmDrawScheme> schemeList = this.drawSchemeDao.selectAll(userId);
        schemeList.forEach(s -> {
            DrawSchemeDTO schemeDTO = new DrawSchemeDTO();
            BeanUtils.copyProperties((Object)s, (Object)schemeDTO);
            if (!Boolean.TRUE.equals(withDetail)) {
                schemeDTO.setStyle(null);
            }
            if (!StringUtil.isEmptyOrWhiteSpace((String)schemeDTO.getGroupId())) {
                if (!subSchemeList.containsKey(schemeDTO.getGroupId())) {
                    subSchemeList.put(schemeDTO.getGroupId(), new ArrayList());
                }
                ((List)subSchemeList.get(schemeDTO.getGroupId())).add(schemeDTO);
            } else {
                drawSchemeDTOList.add(schemeDTO);
            }
        });
        for (DrawSchemeDTO schemeDTO : drawSchemeDTOList) {
            if (!subSchemeList.containsKey(schemeDTO.getId())) continue;
            schemeDTO.setChildren((List)subSchemeList.get(schemeDTO.getId()));
        }
        return drawSchemeDTOList;
    }

    @Override
    public DrawSchemeDTO getDetail(String id) {
        if (StringUtil.isEmptyOrWhiteSpace((String)id)) {
            throw new RuntimeException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CmDrawScheme scheme = this.drawSchemeDao.selectByPrimaryKey(id);
        Assert.notNull((Object)scheme, (String)"\u6807\u7ed8\u5de5\u7a0b\u4e0d\u5b58\u5728");
        DrawSchemeDTO schemeDTO = new DrawSchemeDTO();
        BeanUtils.copyProperties((Object)scheme, (Object)schemeDTO);
        return schemeDTO;
    }

    @Override
    public String saveGroup(DrawSchemeEditDTO groupDTO) {
        if (StringUtil.isEmptyOrWhiteSpace((String)groupDTO.getId())) {
            groupDTO.setId(IdUtil.getSnowflakeNextIdStr());
            if (groupDTO.getGroupId() == null) {
                groupDTO.setGroupId("");
            }
            String userId = this.getUserId();
            CmDrawScheme group = new CmDrawScheme();
            BeanUtils.copyProperties((Object)groupDTO, (Object)group);
            group.setType(0);
            group.setCreateTime(new Date());
            group.setUserId(userId);
            this.drawSchemeDao.insert(group);
        } else {
            CmDrawScheme group = this.drawSchemeDao.selectByPrimaryKey(groupDTO.getId());
            Assert.notNull((Object)group, (String)"\u5206\u7ec4\u4e0d\u5b58\u5728");
            group.setName(groupDTO.getName());
            group.setDesc(groupDTO.getDesc());
            group.setStyle(groupDTO.getStyle());
            this.drawSchemeDao.updateByPrimaryKeySelective(group);
        }
        return groupDTO.getId();
    }

    @Override
    public String saveScheme(DrawSchemeEditDTO schemeDTO) {
        if (StringUtil.isEmptyOrWhiteSpace((String)schemeDTO.getId())) {
            schemeDTO.setId(IdUtil.getSnowflakeNextIdStr());
            if (schemeDTO.getGroupId() == null) {
                schemeDTO.setGroupId("");
            }
            String userId = this.getUserId();
            CmDrawScheme scheme = new CmDrawScheme();
            BeanUtils.copyProperties((Object)schemeDTO, (Object)scheme);
            scheme.setType(1);
            scheme.setCreateTime(new Date());
            scheme.setUserId(userId);
            this.drawSchemeDao.insert(scheme);
        } else {
            CmDrawScheme scheme = this.drawSchemeDao.selectByPrimaryKey(schemeDTO.getId());
            Assert.notNull((Object)scheme, (String)"\u6807\u7ed8\u5de5\u7a0b\u4e0d\u5b58\u5728");
            scheme.setName(schemeDTO.getName());
            scheme.setDesc(schemeDTO.getDesc());
            scheme.setStyle(schemeDTO.getStyle());
            if (schemeDTO.getGroupId() != null) {
                scheme.setGroupId(schemeDTO.getGroupId());
            }
            this.drawSchemeDao.updateByPrimaryKeySelective(scheme);
        }
        return schemeDTO.getId();
    }

    @Override
    public boolean delete(String id) {
        this.drawSchemeDao.deleteByPrimaryKey(id);
        return true;
    }

    private String getUserId() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (servletRequestAttributes == null) {
            return null;
        }
        HttpServletRequest request = servletRequestAttributes.getRequest();
        LoginUserInfo userInfo = this.loginUserService.getUserInfo(request);
        return userInfo.getUserId();
    }
}

