/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.service.impl;

import cn.hutool.core.util.IdUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dao.CmMetaDataDao;
import com.geoway.adf.dms.config.dao.CmMetaDataValueDao;
import com.geoway.adf.dms.config.dao.CmMetaKeywordDao;
import com.geoway.adf.dms.config.dto.attachment.AttachmentDTO;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.dto.meta.MetaDataDTO;
import com.geoway.adf.dms.config.dto.meta.MetaDataValueDTO;
import com.geoway.adf.dms.config.dto.meta.MetaTemplateDTO;
import com.geoway.adf.dms.config.dto.meta.MetaTemplateFieldDTO;
import com.geoway.adf.dms.config.dto.meta.MetaTemplateFieldType;
import com.geoway.adf.dms.config.dto.meta.edit.MetaDataCreateDTO;
import com.geoway.adf.dms.config.dto.meta.edit.MetaDataEditDTO;
import com.geoway.adf.dms.config.dto.meta.edit.MultiMetaDataEditDTO;
import com.geoway.adf.dms.config.entity.CmMetaData;
import com.geoway.adf.dms.config.entity.CmMetaDataValue;
import com.geoway.adf.dms.config.entity.CmMetaKeyword;
import com.geoway.adf.dms.config.service.AttachmentService;
import com.geoway.adf.dms.config.service.DictionaryService;
import com.geoway.adf.dms.config.service.MetaDataService;
import com.geoway.adf.dms.config.service.MetaTemplateService;
import com.geoway.adf.gis.geodb.field.FieldType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MetaDataServiceImpl
implements MetaDataService {
    private static final Logger log = LoggerFactory.getLogger(MetaDataServiceImpl.class);
    @Resource
    private CmMetaDataDao metaDataDao;
    @Resource
    private CmMetaDataValueDao metaDataValueDao;
    @Resource
    private CmMetaKeywordDao metaKeywordDao;
    @Resource
    private MetaTemplateService metaTemplateService;
    @Resource
    private DictionaryService dictionaryService;
    @Resource
    private AttachmentService attachmentService;
    private final String Attachment_RelateType = "meta";

    @Override
    public Long addMetaData(MetaDataCreateDTO createDTO) {
        CmMetaData existMetaData = this.metaDataDao.selectByRelatedId(createDTO.getRelatedType(), createDTO.getRelatedId());
        if (existMetaData != null) {
            MetaDataEditDTO editDTO = new MetaDataEditDTO();
            editDTO.setId(existMetaData.getId());
            editDTO.setKeywords(createDTO.getKeywords());
            editDTO.setValues(createDTO.getValues());
            this.updateMetaData(editDTO);
            return existMetaData.getId();
        }
        CmMetaData metaData = new CmMetaData();
        metaData.setRelatedIdType(createDTO.getRelatedType());
        metaData.setRelatedId(createDTO.getRelatedId());
        List<String> keywordList = new ArrayList<String>();
        if (StringUtil.isNotEmpty((String)createDTO.getKeywords())) {
            createDTO.setKeywords(createDTO.getKeywords().replace("\uff0c", ","));
            keywordList = Arrays.asList(createDTO.getKeywords().split(","));
            String keywords = String.join((CharSequence)",", keywordList) + ",";
            metaData.setKeywords(keywords);
        }
        this.metaDataDao.insert(metaData);
        this.updateKeywordsByMetaDataId(metaData.getId().toString(), keywordList);
        if (createDTO.getValues() != null && createDTO.getValues().size() > 0) {
            List values = ListUtil.convertAll(createDTO.getValues(), f -> this.convertToEntity(metaData.getId(), (MetaDataValueDTO)f));
            this.metaDataValueDao.batchInsert(values);
        }
        return metaData.getId();
    }

    @Override
    public void updateMetaData(MetaDataEditDTO editDTO) {
        CmMetaData metaData = this.metaDataDao.selectByPrimaryKey(editDTO.getId());
        Assert.notNull((Object)metaData, (String)"\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        if (editDTO.getKeywords() != null) {
            editDTO.setKeywords(editDTO.getKeywords().replace("\uff0c", ","));
            this.deleteKeyWordsByMetaDataId(metaData.getId());
            String keywords = "";
            ArrayList<String> keywordList = new ArrayList();
            if (editDTO.getKeywords().length() > 0) {
                keywordList = Arrays.asList(editDTO.getKeywords().split(","));
                keywords = String.join((CharSequence)",", keywordList) + ",";
            }
            metaData.setKeywords(keywords);
            this.updateKeywordsByMetaDataId(metaData.getId().toString(), keywordList);
        }
        if (editDTO.getValues() != null) {
            this.metaDataValueDao.deleteByMetaDataId(metaData.getId());
            if (editDTO.getValues().size() > 0) {
                List values = ListUtil.convertAll(editDTO.getValues(), f -> this.convertToEntity(metaData.getId(), (MetaDataValueDTO)f));
                this.metaDataValueDao.batchInsert(values);
            }
        }
        this.metaDataDao.updateByPrimaryKey(metaData);
    }

    @Override
    public void editMetaData(MultiMetaDataEditDTO editDTO) {
        Object values;
        List skipRelatedIds = new ArrayList();
        List<Long> skipMetaDataIds = new ArrayList();
        List<Object> existMetaData = new ArrayList();
        if (editDTO.getOverwriteKeywords().booleanValue() && editDTO.getOverwriteValue().booleanValue()) {
            this.deleteMetaData(editDTO.getRelatedType(), editDTO.getRelatedIdList());
        } else {
            existMetaData = this.metaDataDao.selectByRelatedIds(editDTO.getRelatedType(), editDTO.getRelatedIdList());
            skipRelatedIds = ListUtil.convertAll(existMetaData, CmMetaData::getRelatedId);
            skipMetaDataIds = ListUtil.convertAll(existMetaData, CmMetaData::getId);
        }
        editDTO.getRelatedIdList().removeAll(skipRelatedIds);
        ArrayList<CmMetaData> cmMetaDataList = new ArrayList<CmMetaData>();
        ArrayList<String> keywordList = new ArrayList();
        String keywords = "";
        if (StringUtil.isNotEmpty((String)editDTO.getKeywords())) {
            editDTO.setKeywords(editDTO.getKeywords().replace("\uff0c", ","));
            keywordList = Arrays.asList(editDTO.getKeywords().split(","));
            keywords = String.join((CharSequence)",", keywordList) + ",";
        }
        for (String relatedId : editDTO.getRelatedIdList()) {
            Object metaData = new CmMetaData();
            ((CmMetaData)metaData).setRelatedIdType(editDTO.getRelatedType());
            ((CmMetaData)metaData).setRelatedId(relatedId);
            ((CmMetaData)metaData).setKeywords(keywords);
            cmMetaDataList.add((CmMetaData)metaData);
        }
        if (cmMetaDataList.size() > 0) {
            this.metaDataDao.batchInsert(cmMetaDataList);
            List metaDataIds = ListUtil.convertAll(cmMetaDataList, f -> f.getId().toString());
            this.updateKeywordsByMetaDataId(String.join((CharSequence)",", metaDataIds), keywordList);
            if (editDTO.getValues() != null && editDTO.getValues().size() > 0) {
                values = new ArrayList();
                for (String id : metaDataIds) {
                    values.addAll(ListUtil.convertAll(editDTO.getValues(), f -> this.convertToEntity(Long.parseLong(id), (MetaDataValueDTO)f)));
                }
                this.metaDataValueDao.batchInsert((List<CmMetaDataValue>)values);
            }
        }
        ArrayList<CmMetaDataValue> addValues = new ArrayList<CmMetaDataValue>();
        for (Object metaData : existMetaData) {
            Integer count;
            if (StringUtil.isEmptyOrWhiteSpace((String)((CmMetaData)metaData).getKeywords()) || ",".equals(((CmMetaData)metaData).getKeywords())) {
                this.deleteKeyWordsByMetaDataId(((CmMetaData)metaData).getId());
                ((CmMetaData)metaData).setKeywords(keywords);
                this.metaDataDao.updateByPrimaryKey((CmMetaData)metaData);
                this.updateKeywordsByMetaDataId(((CmMetaData)metaData).getId().toString(), keywordList);
            }
            if (editDTO.getValues().size() <= 0 || (count = this.metaDataValueDao.selectCountByMetaDataId(((CmMetaData)metaData).getId())) != null && count != 0) continue;
            addValues.addAll(ListUtil.convertAll(editDTO.getValues(), arg_0 -> this.lambda$editMetaData$4((CmMetaData)metaData, arg_0)));
        }
        if (addValues.size() > 0) {
            this.metaDataValueDao.batchInsert(addValues);
        }
        if (skipMetaDataIds.size() > 0) {
            if (editDTO.getOverwriteKeywords().booleanValue() && !editDTO.getOverwriteValue().booleanValue()) {
                for (Object metaData : existMetaData) {
                    this.deleteKeyWordsByMetaDataId(((CmMetaData)metaData).getId());
                    ((CmMetaData)metaData).setKeywords(keywords);
                    this.metaDataDao.updateByPrimaryKey((CmMetaData)metaData);
                    this.updateKeywordsByMetaDataId(((CmMetaData)metaData).getId().toString(), keywordList);
                }
            } else if (!editDTO.getOverwriteKeywords().booleanValue() && editDTO.getOverwriteValue().booleanValue()) {
                this.metaDataValueDao.deleteByMetaDataIds(skipMetaDataIds);
                if (editDTO.getValues().size() > 0) {
                    values = new ArrayList();
                    for (Long metaId : skipMetaDataIds) {
                        values.addAll(ListUtil.convertAll(editDTO.getValues(), f -> this.convertToEntity(metaId, (MetaDataValueDTO)f)));
                    }
                    this.metaDataValueDao.batchInsert((List<CmMetaDataValue>)values);
                }
            }
        }
    }

    @Override
    public List<MetaDataDTO> list(Integer relatedType, String keyword) {
        List<CmMetaData> allMetaData;
        if (StringUtil.isNotEmpty((String)keyword)) {
            List metaDataIdList;
            List<CmMetaKeyword> metaKeywords = this.metaKeywordDao.selectByKeyword(keyword);
            if (metaKeywords.size() == 0) {
                return new ArrayList<MetaDataDTO>();
            }
            String metaDataIds = String.join((CharSequence)"", ListUtil.convertAll(metaKeywords, CmMetaKeyword::getMetaDataIds));
            if (metaDataIds.endsWith(",")) {
                metaDataIds = metaDataIds.substring(0, metaDataIds.length() - 1);
            }
            if ((metaDataIdList = StringUtil.split((String)metaDataIds, (String)",", Long::parseLong)).size() == 0) {
                return new ArrayList<MetaDataDTO>();
            }
            allMetaData = this.metaDataDao.selectByIds(metaDataIdList);
        } else {
            allMetaData = this.metaDataDao.selectByRelatedType(relatedType);
        }
        return ListUtil.convertAll(allMetaData, this::convertToDto);
    }

    @Override
    public List<MetaDataDTO> list(Integer relatedType, List<String> relatedIdList) {
        if (relatedIdList == null || relatedIdList.size() == 0) {
            return new ArrayList<MetaDataDTO>();
        }
        List<CmMetaData> allMetaData = this.metaDataDao.selectByRelatedIds(relatedType, relatedIdList);
        return ListUtil.convertAll(allMetaData, this::convertToDto);
    }

    @Override
    public MetaDataDTO getMetaDataDetail(Long metaId, Boolean translateFieldValue) {
        CmMetaData cmMetaData = this.metaDataDao.selectByPrimaryKey(metaId);
        return this.getMetaDataDetail(cmMetaData, translateFieldValue);
    }

    @Override
    public MetaDataDTO getMetaDataDetail(Integer relatedType, String relatedId, Boolean translateFieldValue) {
        CmMetaData cmMetaData = this.metaDataDao.selectByRelatedId(relatedType, relatedId);
        return this.getMetaDataDetail(cmMetaData, translateFieldValue);
    }

    @Override
    public MetaDataDTO getMetaDataDetail(Integer relatedType, String relatedId) {
        CmMetaData cmMetaData = this.metaDataDao.selectByRelatedId(relatedType, relatedId);
        return this.getMetaDataDetail(cmMetaData, (Boolean)false);
    }

    private MetaDataDTO getMetaDataDetail(CmMetaData cmMetaData, Boolean translateFieldValue) {
        if (cmMetaData == null) {
            return null;
        }
        MetaDataDTO metaDataDTO = this.convertToDto(cmMetaData);
        List<CmMetaDataValue> cmValues = this.metaDataValueDao.selectByMetaDataId(cmMetaData.getId());
        ArrayList<MetaDataValueDTO> metaDataValues = new ArrayList<MetaDataValueDTO>();
        metaDataDTO.setValues(metaDataValues);
        Map metaValueMap = cmValues.stream().collect(Collectors.groupingBy(f -> f.getTemplateId() == null ? "" : String.valueOf(f.getTemplateId()), LinkedHashMap::new, Collectors.toList()));
        for (String templateId : metaValueMap.keySet()) {
            MetaDataValueDTO metaDataValueDTO;
            MetaTemplateDTO metaTemplateDTO = null;
            try {
                if (StringUtil.isNotEmpty((String)templateId)) {
                    metaTemplateDTO = this.metaTemplateService.getMetaTemplateDetail(Long.valueOf(templateId), false);
                    metaTemplateDTO.setFields(this.metaTemplateService.getMetaMetaTemplateFieldTree(Long.valueOf(templateId)));
                }
            }
            catch (Exception e) {
                log.error(templateId + "\u5143\u6570\u636e\u6a21\u677f\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            }
            if (metaTemplateDTO == null) continue;
            ArrayList<MetaDataValueDTO> tMetaDataValues = new ArrayList<MetaDataValueDTO>();
            for (CmMetaDataValue cmMetaDataValue : (List)metaValueMap.get(templateId)) {
                metaDataValueDTO = this.convertToDto(cmMetaDataValue);
                metaDataValueDTO.setTemplateName(metaTemplateDTO.getName());
                tMetaDataValues.add(metaDataValueDTO);
            }
            for (MetaTemplateFieldDTO rootField : metaTemplateDTO.getFields()) {
                if (MetaTemplateFieldType.Group.getValue() == rootField.getFieldType().intValue()) {
                    List<MetaTemplateFieldDTO> fields = rootField.getChildren();
                    if (fields == null || fields.size() == 0) continue;
                    for (MetaTemplateFieldDTO metaTemplateField : fields) {
                        MetaDataValueDTO metaDataValueDTO2 = (MetaDataValueDTO)ListUtil.find(tMetaDataValues, m -> metaTemplateField.getName().equals(m.getFieldName()));
                        if (metaDataValueDTO2 == null) {
                            metaDataValueDTO2 = new MetaDataValueDTO();
                            metaDataValueDTO2.setId(IdUtil.getSnowflakeNextIdStr());
                            metaDataValueDTO2.setFieldName(metaTemplateField.getName());
                            metaDataValueDTO2.setType(metaTemplateField.getFieldType());
                            metaDataValueDTO2.setValue(null);
                            metaDataValueDTO2.setTemplateId(metaTemplateField.getTemplateId());
                        }
                        metaDataValueDTO2.setGroupName(rootField.getName());
                        if (Boolean.TRUE.equals(translateFieldValue)) {
                            this.translateFieldValue(metaDataValueDTO2, metaTemplateField);
                        }
                        metaDataValues.add(metaDataValueDTO2);
                    }
                    continue;
                }
                metaDataValueDTO = (MetaDataValueDTO)ListUtil.find(tMetaDataValues, m -> rootField.getName().equals(m.getFieldName()));
                if (metaDataValueDTO == null) {
                    metaDataValueDTO = new MetaDataValueDTO();
                    metaDataValueDTO.setId(IdUtil.getSnowflakeNextIdStr());
                    metaDataValueDTO.setFieldName(rootField.getName());
                    metaDataValueDTO.setType(rootField.getFieldType());
                    metaDataValueDTO.setValue(null);
                    metaDataValueDTO.setTemplateId(rootField.getTemplateId());
                }
                if (Boolean.TRUE.equals(translateFieldValue)) {
                    this.translateFieldValue(metaDataValueDTO, rootField);
                }
                metaDataValues.add(metaDataValueDTO);
            }
        }
        return metaDataDTO;
    }

    private void translateFieldValue(MetaDataValueDTO metaDataValueDTO, MetaTemplateFieldDTO metaTemplateField) {
        if (StringUtil.isEmptyOrWhiteSpace((String)metaDataValueDTO.getValue()) || StringUtil.isEmptyOrWhiteSpace((String)metaTemplateField.getDictionaryKey())) {
            return;
        }
        List<DmDictValueDTO> dictValueDTOs = this.dictionaryService.getDictionaryValueList(metaTemplateField.getDictionaryKey());
        if (dictValueDTOs != null) {
            HashMap map = new HashMap();
            dictValueDTOs.forEach(d -> map.put(String.valueOf(d.getId()), d));
            String[] dicIds = metaDataValueDTO.getValue().split(",");
            ArrayList<String> dicValues = new ArrayList<String>();
            for (String id : dicIds) {
                DmDictValueDTO valueDTO = (DmDictValueDTO)map.get(String.valueOf(id));
                if (valueDTO == null) continue;
                String valueWithPath = valueDTO.getName();
                while (valueDTO.getFatherId() != null && valueDTO.getFatherId() > 0L && (valueDTO = (DmDictValueDTO)map.get(String.valueOf(valueDTO.getFatherId()))) != null) {
                    valueWithPath = valueDTO.getName() + "/" + valueWithPath;
                }
                dicValues.add(valueWithPath);
            }
            metaDataValueDTO.setValue(String.join((CharSequence)",", dicValues));
        }
    }

    @Override
    public void deleteMetaData(Long id) {
        this.metaDataDao.deleteByPrimaryKey(id);
        this.metaDataValueDao.deleteByMetaDataId(id);
        this.deleteKeyWordsByMetaDataId(id);
    }

    @Override
    public void deleteMetaData(Integer relatedType, List<String> relatedIdList) {
        List<CmMetaData> allMetaData = this.metaDataDao.selectByRelatedIds(relatedType, relatedIdList);
        if (allMetaData.size() == 0) {
            return;
        }
        List allMetaDataId = ListUtil.convertAll(allMetaData, CmMetaData::getId);
        this.metaDataValueDao.deleteByMetaDataIds(allMetaDataId);
        List<CmMetaKeyword> keywordList = this.metaKeywordDao.selectAll();
        for (CmMetaKeyword keyword : keywordList) {
            for (Long metaDataId : allMetaDataId) {
                if (!keyword.getMetaDataIds().contains(metaDataId + ",")) continue;
                keyword.setMetaDataIds(keyword.getMetaDataIds().replace(metaDataId + ",", ""));
            }
            if (StringUtil.isEmptyOrWhiteSpace((String)keyword.getMetaDataIds())) {
                this.metaKeywordDao.deleteByPrimaryKey(keyword.getKey());
                continue;
            }
            this.metaKeywordDao.updateByPrimaryKey(keyword);
        }
        this.metaDataDao.deleteByRelatedIds(relatedType, relatedIdList);
    }

    @Override
    public void saveMetaFieldAttachment(String metaValueId, MultipartFile[] files) {
        CmMetaDataValue metaDataValue = this.metaDataValueDao.selectById(metaValueId);
        Assert.notNull((Object)metaDataValue, (String)"\u5143\u6570\u636e\u5b57\u6bb5\u4e0d\u5b58\u5728");
        String fieldName = metaDataValue.getFieldName();
        Assert.isTrue((MetaTemplateFieldType.Attachment.getValue() == metaDataValue.getType().intValue() ? 1 : 0) != 0, (String)("\u5143\u6570\u636e\u5b57\u6bb5[" + fieldName + "]\u4e0d\u662f\u9644\u4ef6\u5b57\u6bb5"));
        String key = metaValueId + "-" + fieldName;
        List<AttachmentDTO> attachmentDTOS = this.attachmentService.upload("meta", key, files);
        String attIds = StringUtil.join((String)",", attachmentDTOS);
        String value = metaDataValue.getValue();
        value = StringUtil.isEmptyOrWhiteSpace((String)value) ? attIds : value + "," + attIds;
        this.metaDataValueDao.updateValue(metaValueId, value);
    }

    @Override
    public void deleteMetaFieldAttachment(String metaValueId, String attachmentIds) {
        String[] attIds;
        CmMetaDataValue metaDataValue = this.metaDataValueDao.selectById(metaValueId);
        Assert.notNull((Object)metaDataValue, (String)"\u5143\u6570\u636e\u5b57\u6bb5\u4e0d\u5b58\u5728");
        String fieldName = metaDataValue.getFieldName();
        Assert.isTrue((MetaTemplateFieldType.Attachment.getValue() == metaDataValue.getType().intValue() ? 1 : 0) != 0, (String)("\u5143\u6570\u636e\u5b57\u6bb5[" + fieldName + "]\u4e0d\u662f\u9644\u4ef6\u5b57\u6bb5"));
        for (String attId : attIds = attachmentIds.split(",")) {
            this.attachmentService.delete(attId);
        }
        String value = metaDataValue.getValue();
        if (!StringUtil.isEmptyOrWhiteSpace((String)value)) {
            ArrayList<String> currentIds = new ArrayList<String>(Arrays.asList(value.split(",")));
            for (String attId : attIds) {
                currentIds.remove(attId);
            }
            value = String.join((CharSequence)",", currentIds);
            this.metaDataValueDao.updateValue(metaValueId, value);
        }
    }

    private void deleteKeyWordsByMetaDataId(Long metaDataId) {
        List<CmMetaKeyword> keywordList = this.metaKeywordDao.selectByMetaDataId(metaDataId + ",");
        for (CmMetaKeyword keyword : keywordList) {
            keyword.setMetaDataIds(keyword.getMetaDataIds().replace(metaDataId + ",", ""));
            if (StringUtil.isEmptyOrWhiteSpace((String)keyword.getMetaDataIds())) {
                this.metaKeywordDao.deleteByPrimaryKey(keyword.getKey());
                continue;
            }
            this.metaKeywordDao.updateByPrimaryKey(keyword);
        }
    }

    private void updateKeywordsByMetaDataId(String metaDataId, List<String> keywordList) {
        for (String keyword : keywordList) {
            CmMetaKeyword cmMetaKeyword = this.metaKeywordDao.selectByPrimaryKey(keyword);
            if (cmMetaKeyword == null) {
                cmMetaKeyword = new CmMetaKeyword();
                cmMetaKeyword.setKey(keyword);
                cmMetaKeyword.setMetaDataIds(metaDataId + ",");
                this.metaKeywordDao.insert(cmMetaKeyword);
                continue;
            }
            if (cmMetaKeyword.getMetaDataIds().contains(metaDataId + ",")) continue;
            cmMetaKeyword.setMetaDataIds(cmMetaKeyword.getMetaDataIds() + metaDataId + ",");
            this.metaKeywordDao.updateByPrimaryKey(cmMetaKeyword);
        }
    }

    private MetaDataDTO convertToDto(CmMetaData metaData) {
        MetaDataDTO metaDataDTO = new MetaDataDTO();
        metaDataDTO.setId(metaData.getId());
        metaDataDTO.setRelatedType(metaData.getRelatedIdType());
        metaDataDTO.setRelatedId(metaData.getRelatedId());
        String keywords = metaData.getKeywords();
        metaDataDTO.setKeywords(new ArrayList<String>());
        if (keywords != null && keywords.endsWith(",")) {
            keywords = keywords.substring(0, keywords.length() - 1);
            metaDataDTO.setKeywords(Arrays.asList(keywords.split(",")));
        }
        return metaDataDTO;
    }

    private MetaDataValueDTO convertToDto(CmMetaDataValue cmMetaDataValue) {
        MetaDataValueDTO valueDTO = new MetaDataValueDTO();
        valueDTO.setId(cmMetaDataValue.getId());
        valueDTO.setFieldName(cmMetaDataValue.getFieldName());
        valueDTO.setType(cmMetaDataValue.getType());
        valueDTO.setValue(cmMetaDataValue.getValue());
        valueDTO.setTemplateId(cmMetaDataValue.getTemplateId());
        return valueDTO;
    }

    private CmMetaDataValue convertToEntity(Long metaDataId, MetaDataValueDTO valueDTO) {
        CmMetaDataValue value = new CmMetaDataValue();
        value.setId(valueDTO.getId());
        value.setFieldName(valueDTO.getFieldName());
        value.setValue(valueDTO.getValue());
        value.setMetaDataId(metaDataId);
        value.setType(valueDTO.getType());
        value.setTemplateId(valueDTO.getTemplateId());
        if (value.getType() == null) {
            value.setType(FieldType.String.getValue());
        }
        if (valueDTO.getId() == null || valueDTO.getId().isEmpty()) {
            value.setId(IdUtil.getSnowflakeNextIdStr());
        }
        return value;
    }

    private /* synthetic */ CmMetaDataValue lambda$editMetaData$4(CmMetaData metaData, MetaDataValueDTO f) {
        return this.convertToEntity(metaData.getId(), f);
    }
}

