/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.filemodel.util;

import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.gis.fs.IFileset;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHelper {
    private static final Logger log = LoggerFactory.getLogger(FileHelper.class);

    public static List<IFileset> searchFileData(IFileset parentFolder, Predicate<IFileset> pattern, Boolean topDirectoryOnly) {
        ArrayList<IFileset> filePaths = new ArrayList<IFileset>();
        try {
            List allFile = parentFolder.listFiles();
            List subFiles = null;
            subFiles = pattern != null ? ListUtil.findAll((List)allFile, pattern) : allFile;
            if (subFiles == null) {
                return filePaths;
            }
            for (IFileset file : subFiles) {
                if (file.getIsDirectory()) continue;
                filePaths.add(file);
            }
            if (!topDirectoryOnly.booleanValue()) {
                if (allFile.size() == 0) {
                    return filePaths;
                }
                allFile = ListUtil.findAll((List)allFile, IFileset::getIsDirectory);
                for (IFileset item : allFile) {
                    filePaths.addAll(FileHelper.searchFileData(item, pattern, topDirectoryOnly));
                }
            }
            return filePaths;
        }
        catch (Exception ex) {
            log.error(parentFolder.getFullPath() + " \u641c\u7d22\u6587\u4ef6\u5f02\u5e38", (Throwable)ex);
            return filePaths;
        }
    }

    public static List<IFileset> getWholeDirectories(IFileset parentFolder, Predicate<IFileset> pattern, Boolean topDirectoryOnly) {
        ArrayList<IFileset> dirInfos = new ArrayList<IFileset>();
        try {
            List subFiles = parentFolder.listFiles();
            if (subFiles == null) {
                return dirInfos;
            }
            if (pattern != null) {
                subFiles = ListUtil.findAll((List)subFiles, pattern);
            }
            for (IFileset file : subFiles) {
                if (!file.getIsDirectory()) continue;
                dirInfos.add(file);
            }
            if (!topDirectoryOnly.booleanValue()) {
                List allFile = parentFolder.listFiles();
                if (allFile == null) {
                    return dirInfos;
                }
                allFile = ListUtil.findAll((List)allFile, IFileset::getIsDirectory);
                for (IFileset item : allFile) {
                    dirInfos.addAll(FileHelper.getWholeDirectories(item, pattern, topDirectoryOnly));
                }
            }
            return dirInfos;
        }
        catch (Exception ex) {
            String msg = parentFolder == null ? "" : parentFolder.getFullPath();
            log.error(msg + " \u6587\u4ef6\u5939\u904d\u5386\u5f02\u5e38", (Throwable)ex);
            return dirInfos;
        }
    }

    public static String getNameWithoutExt(IFileset fileName, String ext) {
        if (StringUtil.isEmptyOrWhiteSpace((String)ext)) {
            return FileUtil.getFileNameWithoutExtension((String)fileName.getName());
        }
        return fileName.getName().replace(ext, "");
    }
}

