/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.service.impl;

import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dao.DmFileModelDao;
import com.geoway.adf.dms.config.dao.DmFilePropertyDao;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.dto.filepackage.create.FileModelCreateDTO;
import com.geoway.adf.dms.config.dto.filepackage.create.FileModelEditDTO;
import com.geoway.adf.dms.config.dto.filepackage.create.ModelCompactPackageNodeCreateDTO;
import com.geoway.adf.dms.config.dto.filepackage.create.ModelFileNodeCreateDTO;
import com.geoway.adf.dms.config.dto.filepackage.create.ModelFileNodeEditDTO;
import com.geoway.adf.dms.config.dto.filepackage.create.ModelFolderNodeCreateDTO;
import com.geoway.adf.dms.config.dto.filepackage.create.ModelFolderNodeEditDTO;
import com.geoway.adf.dms.config.dto.filepackage.create.ModelNodeCopyDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.FileModelDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.FilePropertyDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.ModelCompactNodeDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.ModelFileNodeDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.ModelFolderNodeDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.ModelNodeDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.ModelPackageNodeDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.NameRuleDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.NameRuleJsCheckDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.RealFileModelNodeDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.ScanResultDTO;
import com.geoway.adf.dms.config.entity.DmFileModel;
import com.geoway.adf.dms.config.entity.DmFileProperty;
import com.geoway.adf.dms.config.filemodel.CustomNameRuler;
import com.geoway.adf.dms.config.filemodel.DataCompactPackage;
import com.geoway.adf.dms.config.filemodel.DataFile;
import com.geoway.adf.dms.config.filemodel.DataFolder;
import com.geoway.adf.dms.config.filemodel.DataPackage;
import com.geoway.adf.dms.config.filemodel.DatumModelDataObject;
import com.geoway.adf.dms.config.filemodel.constant.CustomNameRulerTypeEnum;
import com.geoway.adf.dms.config.filemodel.constant.DataFileNameRulerEnum;
import com.geoway.adf.dms.config.filemodel.constant.DataFolderNameRulerEnum;
import com.geoway.adf.dms.config.filemodel.constant.FileModelNodeTypeEnum;
import com.geoway.adf.dms.config.filemodel.constant.ModelNameRulerEnum;
import com.geoway.adf.dms.config.filemodel.event.FileModelBeforeDeleteEvent;
import com.geoway.adf.dms.config.filemodel.util.DataInstanceUtil;
import com.geoway.adf.dms.config.filemodel.util.DatumDataModelUtil;
import com.geoway.adf.dms.config.filemodel.util.FileModelFromFolderUtil;
import com.geoway.adf.dms.config.service.DictionaryService;
import com.geoway.adf.dms.config.service.FileModelService;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.fs.directory.DirectoryFileStorage;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileModelServiceImpl
implements FileModelService {
    private static final Logger log = LoggerFactory.getLogger(FileModelServiceImpl.class);
    @Resource
    private DmFileModelDao dmFileModelDao;
    @Resource
    private DictionaryService dictionaryService;
    @Resource
    private DmFilePropertyDao dmFilePropertyDao;
    private final ApplicationEventPublisher applicationEventPublisher;

    public FileModelServiceImpl(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public List<FileModelDTO> list(String keyword) {
        List<DmFileModel> allFileModel = this.dmFileModelDao.queryByKeyword(keyword);
        ArrayList<FileModelDTO> result = new ArrayList<FileModelDTO>();
        allFileModel.forEach(model -> result.add(this.convertFileModel((DmFileModel)model)));
        return result;
    }

    @Override
    public FileModelDTO getFileModelDetail(Long modelId) {
        DmFileModel model = this.dmFileModelDao.selectByPrimaryKey(modelId);
        Assert.notNull((Object)model, (String)"\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        return this.convertFileModelDetail(model);
    }

    @Override
    public DataPackage getDataPackage(Long modelId) {
        DmFileModel model = this.dmFileModelDao.selectByPrimaryKey(modelId);
        Assert.notNull((Object)model, (String)"\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        DatumModelDataObject modelDataObject = DatumDataModelUtil.parseDataModel(model);
        return (DataPackage)modelDataObject;
    }

    @Override
    public Long importXml(MultipartFile file, String name) {
        Assert.isNull((Object)this.dmFileModelDao.queryByName(name), (String)"\u540d\u79f0\u91cd\u590d");
        DmFileModel dataModel = new DmFileModel();
        dataModel.setName(name);
        dataModel.setObjectTypeId((short)2);
        try {
            byte[] bytes = file.getBytes();
            String xmlFile = new String(bytes, StandardCharsets.UTF_8);
            dataModel.setObject(xmlFile);
            DatumModelDataObject modelDataObject = DatumDataModelUtil.parseDataModel(dataModel);
            DataPackage dataPackage = (DataPackage)modelDataObject;
            dataModel.setModelKey(dataPackage.getIsDataKey() != false ? ConstantsValue.TRUE_VALUE.shortValue() : ConstantsValue.FALSE_VALUE.shortValue());
            dataModel.setDesc(dataPackage.getDescription());
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            throw new RuntimeException("\u7ed3\u6784\u6a21\u578b\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01");
        }
        this.dmFileModelDao.insert(dataModel);
        return dataModel.getId();
    }

    @Override
    public void exportXml(Long modelId) {
        DmFileModel model = this.dmFileModelDao.selectByPrimaryKey(modelId);
        Assert.notNull((Object)model, (String)"\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        String xmlFileContent = model.getObject();
        DownloadUtil.downloadToFile((String)(model.getName() + ".xml"), (String)xmlFileContent);
    }

    @Override
    public Long addFileModel(FileModelCreateDTO createDTO) {
        Assert.isNull((Object)this.dmFileModelDao.queryByName(createDTO.getName()), (String)"\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        DmFileModel dataModel = new DmFileModel();
        dataModel.setName(createDTO.getName());
        dataModel.setObjectTypeId((short)2);
        dataModel.setModelKey(ConstantsValue.TRUE_VALUE.shortValue());
        dataModel.setDesc(createDTO.getDesc());
        DataPackage dataPackage = new DataPackage();
        dataPackage.setName(createDTO.getName());
        dataPackage.setDescription(createDTO.getDesc());
        dataPackage.setIsDataKey(true);
        dataPackage.setDataNameRuler(ModelNameRulerEnum.getByValue(createDTO.getModelNameRuler()));
        String modelString = DatumDataModelUtil.convertToString(dataPackage);
        dataModel.setObject(modelString);
        this.dmFileModelDao.insert(dataModel);
        return dataModel.getId();
    }

    @Override
    public void updateFileModel(FileModelEditDTO editDTO) {
        DmFileModel model = this.dmFileModelDao.selectByPrimaryKey(editDTO.getModelId());
        Assert.notNull((Object)model, (String)"\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        if (!model.getName().equals(editDTO.getName())) {
            Assert.isNull((Object)this.dmFileModelDao.queryByName(editDTO.getName()), (String)"\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        model.setName(editDTO.getName());
        DatumModelDataObject modelDataObject = DatumDataModelUtil.parseDataModel(model);
        DataPackage dataPackage = (DataPackage)modelDataObject;
        dataPackage.setName(editDTO.getName());
        if (editDTO.getModelNameRuler() != null) {
            dataPackage.setDataNameRuler(ModelNameRulerEnum.getByValue(editDTO.getModelNameRuler()));
        }
        if (editDTO.getDesc() != null) {
            model.setDesc(editDTO.getDesc());
            dataPackage.setDescription(editDTO.getDesc());
        }
        model.setObject(DatumDataModelUtil.convertToString(dataPackage));
        this.dmFileModelDao.updateByPrimaryKey(model);
    }

    @Override
    public void delete(Long modelId) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new FileModelBeforeDeleteEvent(this, modelId));
        this.dmFileModelDao.deleteByPrimaryKey(modelId);
    }

    @Override
    public RealFileModelNodeDTO creatFileModelFromFolder(Long modelId, String dirPath) {
        String packageName = "\u65b0\u5efa\u6570\u636e\u6a21\u578b";
        DmFileModel model = this.dmFileModelDao.selectByPrimaryKey(modelId = Long.valueOf(modelId == null ? -1L : modelId));
        if (model != null) {
            packageName = model.getName();
        }
        DirectoryFileStorage fileStorage = new DirectoryFileStorage(dirPath, null, null);
        IFileset fileset = fileStorage.getFile(dirPath);
        List<DmDictValueDTO> fileFormats = this.getFileFormats();
        return FileModelFromFolderUtil.loadPackageTree(modelId, fileset, packageName, fileFormats);
    }

    @Override
    public RealFileModelNodeDTO creatFileModelFromFolder(Long modelId, IFileset dirFileset) {
        String packageName = "\u65b0\u5efa\u6570\u636e\u6a21\u578b";
        DmFileModel model = this.dmFileModelDao.selectByPrimaryKey(modelId = Long.valueOf(modelId == null ? -1L : modelId));
        if (model != null) {
            packageName = model.getName();
        }
        List<DmDictValueDTO> fileFormats = this.getFileFormats();
        return FileModelFromFolderUtil.loadPackageTree(modelId, dirFileset, packageName, fileFormats);
    }

    @Override
    public void saveFileModel(RealFileModelNodeDTO modelNodeDTO) {
        DataPackage dataPackage = FileModelFromFolderUtil.getPackage(modelNodeDTO);
        Long modelId = modelNodeDTO.getModelId() == null ? -1L : modelNodeDTO.getModelId();
        DmFileModel model = this.dmFileModelDao.selectByPrimaryKey(modelId);
        boolean isUpdate = false;
        if (model == null) {
            model = new DmFileModel();
            dataPackage.setDataNameRuler(ModelNameRulerEnum.MainDataFile);
        } else {
            DatumModelDataObject modelDataObject = DatumDataModelUtil.parseDataModel(model);
            DataPackage originPackage = (DataPackage)modelDataObject;
            dataPackage.setDescription(originPackage.getDescription());
            dataPackage.setDataNameRuler(originPackage.getDataNameRuler());
            isUpdate = true;
        }
        model.setName(modelNodeDTO.getNodeName());
        model.setModelKey(modelNodeDTO.getModelKey() != false ? ConstantsValue.TRUE_VALUE.shortValue() : ConstantsValue.FALSE_VALUE.shortValue());
        model.setObject(DatumDataModelUtil.convertToString(dataPackage));
        if (isUpdate) {
            this.dmFileModelDao.updateByPrimaryKey(model);
        } else {
            this.dmFileModelDao.insert(model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResultDTO scanFile(Long modelId, String dirPath, Boolean needScanInvalidData) {
        DataPackage dataPackage = this.getDataPackage(modelId);
        DirectoryFileStorage fileStorage = new DirectoryFileStorage(dirPath, null, null);
        IFileset fileset = fileStorage.getFile(dirPath);
        try {
            ScanResultDTO scanResultDTO = DatumDataModelUtil.scanFileData(dataPackage, fileset, needScanInvalidData);
            return scanResultDTO;
        }
        finally {
            dataPackage.getArchiveEnvironment().dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResultDTO scanFile(Long modelId, IFileset dirFileset, Boolean needScanInvalidData) {
        DataPackage dataPackage = this.getDataPackage(modelId);
        try {
            ScanResultDTO scanResultDTO = DatumDataModelUtil.scanFileData(dataPackage, dirFileset, needScanInvalidData);
            return scanResultDTO;
        }
        finally {
            dataPackage.getArchiveEnvironment().dispose();
        }
    }

    @Override
    public List<FilePropertyDTO> getFileProperty(List<Integer> nodeTypes) {
        List allFileProperty = this.dmFilePropertyDao.selectAll();
        if (nodeTypes != null && nodeTypes.size() > 0) {
            allFileProperty = ListUtil.findAll(allFileProperty, f -> nodeTypes.contains(f.getObjectType()));
        }
        ArrayList<FilePropertyDTO> result = new ArrayList<FilePropertyDTO>();
        allFileProperty.forEach(item -> {
            FilePropertyDTO dto = new FilePropertyDTO();
            dto.setName(item.getName());
            dto.setNodeType(item.getObjectType());
            dto.setKey(item.getKey());
            dto.setNecessary(item.getNecessary() != null && item.getNecessary().equals(ConstantsValue.TRUE_VALUE.shortValue()));
            dto.setUnique(item.getUnique() != null && item.getUnique().equals(ConstantsValue.TRUE_VALUE.shortValue()));
            result.add(dto);
        });
        return result;
    }

    @Override
    public List<NameRuleDTO> getNameRule(List<Integer> nodeTypes) {
        List<NameRuleDTO> allNameRule = new ArrayList<NameRuleDTO>();
        for (DataFileNameRulerEnum dataFileNameRulerEnum : DataFileNameRulerEnum.values()) {
            allNameRule.add(new NameRuleDTO(dataFileNameRulerEnum.getValue(), dataFileNameRulerEnum.getDesc(), FileModelNodeTypeEnum.DataFile.getValue()));
        }
        for (Enum enum_ : DataFolderNameRulerEnum.values()) {
            allNameRule.add(new NameRuleDTO(((DataFolderNameRulerEnum)enum_).getValue(), ((DataFolderNameRulerEnum)enum_).getDesc(), FileModelNodeTypeEnum.DataFolder.getValue()));
        }
        for (Enum enum_ : DataFolderNameRulerEnum.values()) {
            allNameRule.add(new NameRuleDTO(((DataFolderNameRulerEnum)enum_).getValue(), ((DataFolderNameRulerEnum)enum_).getDesc(), FileModelNodeTypeEnum.CompactPackage.getValue()));
        }
        for (Enum enum_ : ModelNameRulerEnum.values()) {
            allNameRule.add(new NameRuleDTO(((ModelNameRulerEnum)enum_).getValue(), ((ModelNameRulerEnum)enum_).getDesc(), FileModelNodeTypeEnum.DataPackage.getValue()));
        }
        if (nodeTypes != null && nodeTypes.size() > 0) {
            allNameRule = ListUtil.findAll(allNameRule, f -> nodeTypes.contains(f.getNodeType()));
        }
        return allNameRule;
    }

    @Override
    public List<String> getPropertySetting(Long modelId) {
        DmFileModel model = this.dmFileModelDao.selectByPrimaryKey(modelId);
        Assert.notNull((Object)model, (String)"\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        DatumModelDataObject modelDataObject = DatumDataModelUtil.parseDataModel(model);
        DataPackage dataPackage = (DataPackage)modelDataObject;
        ArrayList<String> strings = new ArrayList<String>();
        List<DmFileProperty> properties = this.dmFilePropertyDao.selectByType(0);
        if (properties != null && properties.size() > 0) {
            String tmp = "";
            DatumModelDataObject main = dataPackage.getDataKeyObject();
            tmp = main == null ? "<\u672a\u6307\u5b9a>" : (main.getParentObject() == null ? main.getName() : main.getPath());
            strings.add(String.format("\u4e3b\u6570\u636e\u6807\u8bc6\uff1a %s", tmp));
            for (DmFileProperty property : properties) {
                strings.add(String.format("%s\uff1a %s", property.getName(), this.getSpecificDataFileName(dataPackage, property.getKey())));
            }
        }
        return strings;
    }

    @Override
    public ModelNodeDTO getModelNodeDetail(Long modelId, String nodePath) {
        DmFileModel model = this.dmFileModelDao.selectByPrimaryKey(modelId);
        Assert.notNull((Object)model, (String)"\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        DatumModelDataObject modelDataObject = DatumDataModelUtil.parseDataModel(model);
        DataPackage dataPackage = (DataPackage)modelDataObject;
        if (modelDataObject.getPath().equals(nodePath)) {
            modelDataObject.setChildren(new ArrayList<DatumModelDataObject>());
            ModelFileNodeDTO packageNode = new ModelFileNodeDTO();
            packageNode.setNodeName(dataPackage.getName());
            packageNode.setModelKey(dataPackage.getIsDataKey());
            packageNode.setNodeType(dataPackage.getNodeType());
            packageNode.setNodePath(dataPackage.getPath());
            return packageNode;
        }
        DatumModelDataObject node = this.getDataNodeByPath(modelDataObject, nodePath);
        if (node != null) {
            node.setChildren(new ArrayList<DatumModelDataObject>());
            FileModelNodeTypeEnum nodeType = FileModelNodeTypeEnum.getByValue(node.getNodeType());
            switch (nodeType) {
                case DataFile: {
                    return this.convertFileNodeDTO((DataFile)node);
                }
                case DataFolder: {
                    return this.convertFolderNodeDTO((DataFolder)node);
                }
                case CompactPackage: {
                    return this.convertCompactNodeDTO((DataCompactPackage)node);
                }
            }
        }
        throw new RuntimeException("\u6a21\u578b\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
    }

    @Override
    public String copyModelNode(ModelNodeCopyDTO copyDTO) {
        DmFileModel sourceModel = this.dmFileModelDao.selectByPrimaryKey(copyDTO.getSourceModelId());
        Assert.notNull((Object)sourceModel, (String)"\u590d\u5236\u5931\u8d25-\u6e90\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        DatumModelDataObject sourceModelDataObject = DatumDataModelUtil.parseDataModel(sourceModel);
        if (StringUtil.isEmptyOrWhiteSpace((String)copyDTO.getSourceNodePath()) && copyDTO.getTargetModelId() == null) {
            sourceModel.setId(null);
            String name = sourceModel.getName() + "-\u526f\u672c";
            int index = 0;
            while (this.dmFileModelDao.queryByName(name) != null) {
                name = String.format("%s-\u526f\u672c(%d)", sourceModel.getName(), ++index);
            }
            sourceModel.setName(name);
            this.dmFileModelDao.insert(sourceModel);
            return sourceModel.getId().toString();
        }
        DatumModelDataObject sourceNode = this.getDataNodeByPath(sourceModelDataObject, copyDTO.getSourceNodePath());
        Assert.notNull((Object)sourceNode, (String)"\u590d\u5236\u5931\u8d25-\u6e90\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        DatumModelDataObject sourceDataKeyNode = sourceNode.getDataKeyNode();
        DmFileModel targetModel = this.dmFileModelDao.selectByPrimaryKey(copyDTO.getTargetModelId());
        Assert.notNull((Object)targetModel, (String)"\u590d\u5236\u5931\u8d25-\u76ee\u6807\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        if (copyDTO.getFatherNodePath().equalsIgnoreCase(targetModel.getName())) {
            sourceModel.setName(targetModel.getName());
            sourceModel.setId(targetModel.getId());
            this.dmFileModelDao.updateByPrimaryKey(sourceModel);
            return targetModel.getId().toString();
        }
        DatumModelDataObject targetModelDataObject = DatumDataModelUtil.parseDataModel(targetModel);
        DatumModelDataObject targetNode = this.getDataNodeByPath(targetModelDataObject, copyDTO.getFatherNodePath());
        Assert.notNull((Object)targetNode, (String)"\u590d\u5236\u5931\u8d25-\u76ee\u6807\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        if (targetNode.getNodeType().intValue() == FileModelNodeTypeEnum.DataFile.getValue()) {
            throw new RuntimeException("\u76ee\u6807\u8282\u70b9\u4e0d\u80fd\u4e3a\u6587\u4ef6\u7c7b\u578b\u8282\u70b9\uff01");
        }
        DatumModelDataObject sameNameNode = (DatumModelDataObject)ListUtil.find(targetNode.getChildren(), f -> f.getName().equals(sourceNode.getName()));
        Assert.isNull((Object)sameNameNode, (String)"\u5b58\u5728\u540c\u540d\u8282\u70b9");
        if (targetModelDataObject.getDataKeyNode() != null && sourceDataKeyNode != null) {
            sourceDataKeyNode.setIsDataKey(false);
        }
        sourceNode.setParentObject(targetNode);
        targetNode.getChildren().add(sourceNode);
        targetModel.setObject(DatumDataModelUtil.convertToString(targetModelDataObject));
        this.dmFileModelDao.updateByPrimaryKey(targetModel);
        return sourceNode.getPath();
    }

    @Override
    public String addModelFileNode(ModelFileNodeCreateDTO createDTO) {
        DmFileModel model = this.dmFileModelDao.selectByPrimaryKey(createDTO.getModelId());
        Assert.notNull((Object)model, (String)"\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        DatumModelDataObject modelDataObject = DatumDataModelUtil.parseDataModel(model);
        DatumModelDataObject fatherNode = this.getDataNodeByPath(modelDataObject, createDTO.getFatherNodePath());
        Assert.notNull((Object)fatherNode, (String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        Assert.notNull((Object)createDTO.getNodeName(), (String)"\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DataFile dataFile = new DataFile();
        DatumModelDataObject sameNameNode = (DatumModelDataObject)ListUtil.find(fatherNode.getChildren(), f -> f.getName().equals(createDTO.getNodeName()));
        Assert.isNull((Object)sameNameNode, (String)"\u5b58\u5728\u540c\u540d\u8282\u70b9");
        dataFile.setName(createDTO.getNodeName());
        dataFile.setDescription(createDTO.getRemark());
        dataFile.setDataFormat(createDTO.getFormat());
        dataFile.setFileExtension(createDTO.getFileExtension());
        dataFile.setProperties(createDTO.getPropertyKeys());
        dataFile.setFileNameRuler(DataFileNameRulerEnum.getByValue(createDTO.getNameRule()));
        CustomNameRuler customNameRuler = new CustomNameRuler();
        customNameRuler.setType(CustomNameRulerTypeEnum.getByValue(createDTO.getRuleContentType()));
        customNameRuler.setCustomString(createDTO.getRuleContent());
        dataFile.setCustomNameRuler(customNameRuler);
        dataFile.setNecessary(createDTO.getNecessary());
        dataFile.setParentObject(fatherNode);
        fatherNode.getChildren().add(dataFile);
        model.setObject(DatumDataModelUtil.convertToString(modelDataObject));
        this.dmFileModelDao.updateByPrimaryKey(model);
        return dataFile.getPath();
    }

    @Override
    public String updateModelFileNode(ModelFileNodeEditDTO editDTO) {
        DmFileModel model = this.dmFileModelDao.selectByPrimaryKey(editDTO.getModelId());
        Assert.notNull((Object)model, (String)"\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        Assert.notNull((Object)editDTO.getNodeName(), (String)"\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DatumModelDataObject modelDataObject = DatumDataModelUtil.parseDataModel(model);
        DatumModelDataObject node = this.getDataNodeByPath(modelDataObject, editDTO.getNodePath());
        DataFile dataFile = (DataFile)node;
        Assert.notNull((Object)dataFile, (String)"\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        if (!dataFile.getName().equals(editDTO.getNodeName())) {
            DatumModelDataObject fatherNode = this.getDataNodeByPath(modelDataObject, dataFile.getParentObject().getPath());
            Assert.notNull((Object)fatherNode, (String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
            DatumModelDataObject sameNameNode = (DatumModelDataObject)ListUtil.find(fatherNode.getChildren(), f -> f.getName().equals(editDTO.getNodeName()));
            Assert.isNull((Object)sameNameNode, (String)"\u5b58\u5728\u540c\u540d\u8282\u70b9");
        }
        dataFile.setName(editDTO.getNodeName());
        dataFile.setDescription(editDTO.getRemark());
        dataFile.setDataFormat(editDTO.getFormat());
        dataFile.setFileExtension(editDTO.getFileExtension());
        dataFile.setProperties(editDTO.getPropertyKeys());
        dataFile.setFileNameRuler(DataFileNameRulerEnum.getByValue(editDTO.getNameRule()));
        CustomNameRuler customNameRuler = new CustomNameRuler();
        customNameRuler.setType(CustomNameRulerTypeEnum.getByValue(editDTO.getRuleContentType()));
        customNameRuler.setCustomString(editDTO.getRuleContent());
        dataFile.setCustomNameRuler(customNameRuler);
        dataFile.setNecessary(editDTO.getNecessary());
        model.setObject(DatumDataModelUtil.convertToString(modelDataObject));
        this.dmFileModelDao.updateByPrimaryKey(model);
        return dataFile.getPath();
    }

    @Override
    public String addModelFolderNode(ModelFolderNodeCreateDTO createDTO) {
        DmFileModel model = this.dmFileModelDao.selectByPrimaryKey(createDTO.getModelId());
        Assert.notNull((Object)model, (String)"\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        DatumModelDataObject modelDataObject = DatumDataModelUtil.parseDataModel(model);
        DatumModelDataObject fatherNode = this.getDataNodeByPath(modelDataObject, createDTO.getFatherNodePath());
        Assert.notNull((Object)fatherNode, (String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        Assert.notNull((Object)createDTO.getNodeName(), (String)"\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DataFolder dataFolder = new DataFolder();
        DatumModelDataObject sameNameNode = (DatumModelDataObject)ListUtil.find(fatherNode.getChildren(), f -> f.getName().equals(createDTO.getNodeName()));
        Assert.isNull((Object)sameNameNode, (String)"\u5b58\u5728\u540c\u540d\u8282\u70b9");
        dataFolder.setName(createDTO.getNodeName());
        dataFolder.setDescription(createDTO.getRemark());
        dataFolder.setProperties(createDTO.getPropertyKeys());
        dataFolder.setFolderNameRulerType(DataFolderNameRulerEnum.getByValue(createDTO.getNameRule()));
        CustomNameRuler customNameRuler = new CustomNameRuler();
        customNameRuler.setType(CustomNameRulerTypeEnum.getByValue(createDTO.getRuleContentType()));
        customNameRuler.setCustomString(createDTO.getRuleContent());
        dataFolder.setCustomNameRuler(customNameRuler);
        dataFolder.setContainsSubFoldersAndFiles(createDTO.getContainsSubFoldersAndFiles());
        dataFolder.setCanBeEmpty(createDTO.getCanBeEmpty());
        dataFolder.setParentObject(fatherNode);
        fatherNode.getChildren().add(dataFolder);
        model.setObject(DatumDataModelUtil.convertToString(modelDataObject));
        this.dmFileModelDao.updateByPrimaryKey(model);
        return dataFolder.getPath();
    }

    @Override
    public String updateModelFolderNode(ModelFolderNodeEditDTO editDTO) {
        DmFileModel model = this.dmFileModelDao.selectByPrimaryKey(editDTO.getModelId());
        Assert.notNull((Object)model, (String)"\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        Assert.notNull((Object)editDTO.getNodeName(), (String)"\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DatumModelDataObject modelDataObject = DatumDataModelUtil.parseDataModel(model);
        DatumModelDataObject node = this.getDataNodeByPath(modelDataObject, editDTO.getNodePath());
        DataFolder dataFolder = (DataFolder)node;
        Assert.notNull((Object)dataFolder, (String)"\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        if (!dataFolder.getName().equals(editDTO.getNodeName())) {
            DatumModelDataObject fatherNode = this.getDataNodeByPath(modelDataObject, dataFolder.getParentObject().getPath());
            Assert.notNull((Object)fatherNode, (String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
            DatumModelDataObject sameNameNode = (DatumModelDataObject)ListUtil.find(fatherNode.getChildren(), f -> f.getName().equals(editDTO.getNodeName()));
            Assert.isNull((Object)sameNameNode, (String)"\u5b58\u5728\u540c\u540d\u8282\u70b9");
        }
        dataFolder.setName(editDTO.getNodeName());
        dataFolder.setDescription(editDTO.getRemark());
        dataFolder.setProperties(editDTO.getPropertyKeys());
        dataFolder.setFolderNameRulerType(DataFolderNameRulerEnum.getByValue(editDTO.getNameRule()));
        CustomNameRuler customNameRuler = new CustomNameRuler();
        customNameRuler.setType(CustomNameRulerTypeEnum.getByValue(editDTO.getRuleContentType()));
        customNameRuler.setCustomString(editDTO.getRuleContent());
        dataFolder.setCustomNameRuler(customNameRuler);
        dataFolder.setContainsSubFoldersAndFiles(editDTO.getContainsSubFoldersAndFiles());
        dataFolder.setCanBeEmpty(editDTO.getCanBeEmpty());
        model.setObject(DatumDataModelUtil.convertToString(modelDataObject));
        this.dmFileModelDao.updateByPrimaryKey(model);
        return dataFolder.getPath();
    }

    @Override
    public String addOrUpdateModelCompactPackageNode(ModelCompactPackageNodeCreateDTO createDTO) {
        DmFileModel model = this.dmFileModelDao.selectByPrimaryKey(createDTO.getModelId());
        Assert.notNull((Object)model, (String)"\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        Assert.notNull((Object)createDTO.getNodeName(), (String)"\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)createDTO.getPackageType(), (String)"\u538b\u7f29\u5305\u540e\u7f00\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DatumModelDataObject modelDataObject = DatumDataModelUtil.parseDataModel(model);
        DataCompactPackage dataCompactPackage = null;
        DatumModelDataObject fatherNode = null;
        boolean isAdd = false;
        if (StringUtil.isNotEmpty((String)createDTO.getNodePath())) {
            DatumModelDataObject node = this.getDataNodeByPath(modelDataObject, createDTO.getNodePath());
            dataCompactPackage = (DataCompactPackage)node;
            Assert.notNull((Object)dataCompactPackage, (String)"\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
            fatherNode = this.getDataNodeByPath(modelDataObject, dataCompactPackage.getParentObject().getPath());
        } else {
            dataCompactPackage = new DataCompactPackage();
            fatherNode = this.getDataNodeByPath(modelDataObject, createDTO.getFatherNodePath());
            isAdd = true;
        }
        Assert.notNull((Object)fatherNode, (String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        if (StringUtil.isEmptyOrWhiteSpace((String)dataCompactPackage.getName()) || !dataCompactPackage.getName().equals(createDTO.getNodeName())) {
            DatumModelDataObject sameNameNode = (DatumModelDataObject)ListUtil.find(fatherNode.getChildren(), f -> f.getName().equals(createDTO.getNodeName()));
            Assert.isNull((Object)sameNameNode, (String)"\u5b58\u5728\u540c\u540d\u8282\u70b9");
        }
        dataCompactPackage.setName(createDTO.getNodeName());
        dataCompactPackage.setPackageType(createDTO.getPackageType());
        dataCompactPackage.setDescription(createDTO.getRemark());
        dataCompactPackage.setProperties(createDTO.getPropertyKeys());
        dataCompactPackage.setFolderNameRulerType(DataFolderNameRulerEnum.getByValue(createDTO.getNameRule()));
        CustomNameRuler customNameRuler = new CustomNameRuler();
        customNameRuler.setType(CustomNameRulerTypeEnum.getByValue(createDTO.getRuleContentType()));
        customNameRuler.setCustomString(createDTO.getRuleContent());
        dataCompactPackage.setCustomNameRuler(customNameRuler);
        dataCompactPackage.setCanBeEmpty(createDTO.getCanBeEmpty());
        dataCompactPackage.setParentObject(fatherNode);
        if (isAdd) {
            fatherNode.getChildren().add(dataCompactPackage);
        }
        model.setObject(DatumDataModelUtil.convertToString(modelDataObject));
        this.dmFileModelDao.updateByPrimaryKey(model);
        return dataCompactPackage.getPath();
    }

    @Override
    public void deleteModelNode(Long modelId, String nodePath) {
        DmFileModel model = this.dmFileModelDao.selectByPrimaryKey(modelId);
        Assert.notNull((Object)model, (String)"\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        DatumModelDataObject modelDataObject = DatumDataModelUtil.parseDataModel(model);
        DatumModelDataObject node = this.getDataNodeByPath(modelDataObject, nodePath);
        Assert.notNull((Object)node, (String)"\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        DatumModelDataObject fatherNode = this.getDataNodeByPath(modelDataObject, node.getParentObject().getPath());
        Assert.notNull((Object)fatherNode, (String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        fatherNode.getChildren().remove(node);
        model.setObject(DatumDataModelUtil.convertToString(modelDataObject));
        this.dmFileModelDao.updateByPrimaryKey(model);
    }

    @Override
    public void setModelKey(Long modelId, String nodePath) {
        DmFileModel model = this.dmFileModelDao.selectByPrimaryKey(modelId);
        Assert.notNull((Object)model, (String)"\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        DatumModelDataObject modelDataObject = DatumDataModelUtil.parseDataModel(model);
        this.setModelKey(modelDataObject, nodePath);
        model.setObject(DatumDataModelUtil.convertToString(modelDataObject));
        this.dmFileModelDao.updateByPrimaryKey(model);
    }

    @Override
    public String checkNameRuleJs(NameRuleJsCheckDTO checkDTO) {
        return DataInstanceUtil.checkNameRuleJs(checkDTO);
    }

    private FileModelDTO convertFileModel(DmFileModel dmFileModel) {
        FileModelDTO dto = new FileModelDTO();
        dto.setModelId(dmFileModel.getId());
        dto.setModelKey(dmFileModel.getModelKey() != null && dmFileModel.getModelKey().equals(ConstantsValue.TRUE_VALUE.shortValue()));
        dto.setName(dmFileModel.getName());
        dto.setDesc(dmFileModel.getDesc());
        return dto;
    }

    private FileModelDTO convertFileModelDetail(DmFileModel dmFileModel) {
        FileModelDTO dto = this.convertFileModel(dmFileModel);
        dto.setModelNameRuler(ModelNameRulerEnum.MainDataFile.getValue());
        DatumModelDataObject modelDataObject = DatumDataModelUtil.parseDataModel(dmFileModel);
        DataPackage dataPackage = (DataPackage)modelDataObject;
        if (dataPackage.getDataNameRuler() != null) {
            dto.setModelNameRuler(dataPackage.getDataNameRuler().getValue());
        }
        ModelPackageNodeDTO packageNode = new ModelPackageNodeDTO();
        packageNode.setNodeName(dataPackage.getName());
        packageNode.setModelKey(dataPackage.getIsDataKey());
        packageNode.setNodeType(dataPackage.getNodeType());
        packageNode.setNodePath(dataPackage.getPath());
        packageNode.setChildren(this.getModelChildren(dataPackage));
        packageNode.setModelNameRuler(dataPackage.getDataNameRuler().getValue());
        dto.setFileModelNode(packageNode);
        return dto;
    }

    private List<ModelNodeDTO> getModelChildren(DatumModelDataObject modelDataObject) {
        List<DatumModelDataObject> children = modelDataObject.getChildren();
        ArrayList<ModelNodeDTO> result = new ArrayList<ModelNodeDTO>();
        if (children == null) {
            return result;
        }
        for (DatumModelDataObject child : children) {
            FileModelNodeTypeEnum nodeType = FileModelNodeTypeEnum.getByValue(child.getNodeType());
            switch (nodeType) {
                case DataFile: {
                    DataFile dataFile = (DataFile)child;
                    ModelFileNodeDTO fileNodeDTO = this.convertFileNodeDTO(dataFile);
                    result.add(fileNodeDTO);
                    break;
                }
                case DataFolder: {
                    DataFolder dataFolder = (DataFolder)child;
                    ModelFolderNodeDTO folderNodeDTO = this.convertFolderNodeDTO(dataFolder);
                    folderNodeDTO.setChildren(this.getModelChildren(dataFolder));
                    result.add(folderNodeDTO);
                    break;
                }
                case CompactPackage: {
                    DataCompactPackage dataCompactPackage = (DataCompactPackage)child;
                    ModelCompactNodeDTO compactNodeDTO = this.convertCompactNodeDTO(dataCompactPackage);
                    compactNodeDTO.setChildren(this.getModelChildren(dataCompactPackage));
                    result.add(compactNodeDTO);
                    break;
                }
            }
        }
        return result;
    }

    private ModelFileNodeDTO convertFileNodeDTO(DataFile dataFile) {
        ModelFileNodeDTO fileNodeDTO = new ModelFileNodeDTO();
        fileNodeDTO.setNodeName(dataFile.getName());
        fileNodeDTO.setNodeType(dataFile.getNodeType());
        fileNodeDTO.setModelKey(dataFile.getIsDataKey());
        fileNodeDTO.setNodePath(dataFile.getPath());
        fileNodeDTO.setRemark(dataFile.getDescription());
        fileNodeDTO.setFormat(dataFile.getDataFormat());
        fileNodeDTO.setFileExtension(dataFile.getFileExtension());
        fileNodeDTO.setPropertyKeys(dataFile.getProperties());
        fileNodeDTO.setNameRule(dataFile.getFileNameRuler().getValue());
        fileNodeDTO.setRuleContent(dataFile.getCustomNameRuler().getCustomString());
        fileNodeDTO.setRuleContentType(dataFile.getCustomNameRuler().getType().getValue());
        fileNodeDTO.setNecessary(dataFile.getNecessary());
        return fileNodeDTO;
    }

    private ModelFolderNodeDTO convertFolderNodeDTO(DataFolder dataFolder) {
        ModelFolderNodeDTO folderNodeDTO = new ModelFolderNodeDTO();
        folderNodeDTO.setNodeName(dataFolder.getName());
        folderNodeDTO.setNodeType(dataFolder.getNodeType());
        folderNodeDTO.setModelKey(dataFolder.getIsDataKey());
        folderNodeDTO.setNodePath(dataFolder.getPath());
        folderNodeDTO.setRemark(dataFolder.getDescription());
        folderNodeDTO.setPropertyKeys(dataFolder.getProperties());
        folderNodeDTO.setNameRule(dataFolder.getFolderNameRulerType().getValue());
        folderNodeDTO.setRuleContent(dataFolder.getCustomNameRuler().getCustomString());
        folderNodeDTO.setRuleContentType(dataFolder.getCustomNameRuler().getType().getValue());
        folderNodeDTO.setContainsSubFoldersAndFiles(dataFolder.getContainsSubFoldersAndFiles());
        folderNodeDTO.setCanBeEmpty(dataFolder.getCanBeEmpty());
        return folderNodeDTO;
    }

    private ModelCompactNodeDTO convertCompactNodeDTO(DataCompactPackage dataCompactPackage) {
        ModelCompactNodeDTO compactNodeDTO = new ModelCompactNodeDTO();
        compactNodeDTO.setNodeName(dataCompactPackage.getName());
        compactNodeDTO.setPackageType(dataCompactPackage.getPackageType());
        compactNodeDTO.setNodeType(dataCompactPackage.getNodeType());
        compactNodeDTO.setModelKey(dataCompactPackage.getIsDataKey());
        compactNodeDTO.setNodePath(dataCompactPackage.getPath());
        compactNodeDTO.setRemark(dataCompactPackage.getDescription());
        compactNodeDTO.setPropertyKeys(dataCompactPackage.getProperties());
        compactNodeDTO.setNameRule(dataCompactPackage.getFolderNameRulerType().getValue());
        compactNodeDTO.setRuleContent(dataCompactPackage.getCustomNameRuler().getCustomString());
        compactNodeDTO.setRuleContentType(dataCompactPackage.getCustomNameRuler().getType().getValue());
        compactNodeDTO.setCanBeEmpty(dataCompactPackage.getCanBeEmpty());
        return compactNodeDTO;
    }

    private String getSpecificDataFileName(DataPackage dataPackage, String key) {
        StringBuilder str = new StringBuilder();
        List<DataFile> files = dataPackage.getSpecificDataFile(key);
        if (files != null && files.size() > 0) {
            for (DataFile var : files) {
                str.append(var.getPath()).append(", ");
            }
            str = new StringBuilder(str.substring(0, str.length() - 2));
        } else {
            str = new StringBuilder("<\u672a\u6307\u5b9a>");
        }
        return str.toString();
    }

    private DatumModelDataObject getDataNodeByPath(DatumModelDataObject dataObject, String nodePath) {
        if (dataObject.getPath().equalsIgnoreCase(nodePath)) {
            return dataObject;
        }
        for (DatumModelDataObject item : dataObject.getChildren()) {
            if (item.getPath().equals(nodePath)) {
                return item;
            }
            DatumModelDataObject temp = this.getDataNodeByPath(item, nodePath);
            if (temp == null) continue;
            return temp;
        }
        return null;
    }

    private void setModelKey(DatumModelDataObject dataObject, String nodePath) {
        dataObject.setIsDataKey(nodePath.equals(dataObject.getPath()));
        for (DatumModelDataObject item : dataObject.getChildren()) {
            item.setIsDataKey(item.getPath().equals(nodePath));
            this.setModelKey(item, nodePath);
        }
    }

    private List<DmDictValueDTO> getFileFormats() {
        List<DmDictValueDTO> fileFormats = new ArrayList<DmDictValueDTO>();
        try {
            DmDictValueDTO dictValueDTO = this.dictionaryService.getDictionaryTree(FileModelFromFolderUtil.DataFormDicKey);
            if (dictValueDTO != null && dictValueDTO.getChildren() != null) {
                fileFormats = dictValueDTO.getChildren();
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
        }
        return fileFormats;
    }
}

