/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.filemodel;

import com.geoway.adf.dms.config.dto.filepackage.model.ScanResultDTO;
import com.geoway.adf.dms.config.filemodel.DataFile;
import com.geoway.adf.dms.config.filemodel.DatumModelDataObject;
import com.geoway.adf.dms.config.filemodel.ScanErrorMessage;
import com.geoway.adf.dms.config.filemodel.ScanFileParam;
import com.geoway.adf.dms.config.filemodel.ScanFileResultParam;
import com.geoway.adf.dms.config.filemodel.ScanModelParam;
import com.geoway.adf.dms.config.filemodel.constant.DataPackageNameRulerEnum;
import com.geoway.adf.dms.config.filemodel.constant.FileModelNodeTypeEnum;
import com.geoway.adf.dms.config.filemodel.constant.ModelNameRulerEnum;
import com.geoway.adf.dms.config.filemodel.util.ArchiveEnvironment;
import com.geoway.adf.dms.config.filemodel.util.DatumDataModelUtil;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.fs.directory.DirectoryFileStorage;
import java.util.ArrayList;
import java.util.List;

public class DataPackage
extends DatumModelDataObject {
    private List<ScanFileResultParam> scanFileResultParams;
    private List<String> files;
    private Integer max = 0;
    private Long newDataCount = 0L;
    private Long inValidCount = 0L;
    private ModelNameRulerEnum dataNameRuler;
    private DataPackageNameRulerEnum packageNameRulerType;
    private Boolean related2RealFolder;
    private boolean uncompress = true;
    private List<IFileset> dataCompactPackageFiles;
    private ArchiveEnvironment archiveEnvironment = new ArchiveEnvironment(this);
    private List<ScanErrorMessage> scanErrorMessages;

    public void setUncompress(boolean uncompress) {
        this.uncompress = uncompress;
    }

    public boolean isUncompress() {
        return this.uncompress;
    }

    public List<IFileset> getDataCompactPackageFiles() {
        if (this.dataCompactPackageFiles == null) {
            return new ArrayList<IFileset>();
        }
        return this.dataCompactPackageFiles;
    }

    public void setDataCompactPackageFiles(List<IFileset> dataCompactPackageFiles) {
        this.dataCompactPackageFiles = dataCompactPackageFiles;
    }

    public DataPackage() {
        this.setNodeType(2);
        this.scanFileResultParams = new ArrayList<ScanFileResultParam>();
        this.files = new ArrayList<String>();
        this.dataNameRuler = ModelNameRulerEnum.MainDataFile;
        this.packageNameRulerType = DataPackageNameRulerEnum.None;
        this.related2RealFolder = false;
        this.scanErrorMessages = new ArrayList<ScanErrorMessage>();
    }

    public DatumModelDataObject getDataKeyObject() {
        return this.getDataKeyObjectCall(this);
    }

    public ScanResultDTO scanFile(String dirPath, Boolean needScanInvalidData) {
        DirectoryFileStorage fileStorage = new DirectoryFileStorage(dirPath, null, null);
        IFileset fileset = fileStorage.getFile(dirPath);
        return DatumDataModelUtil.scanFileData(this, fileset, needScanInvalidData);
    }

    public ScanResultDTO scanFile(IFileset dirFileset, Boolean needScanInvalidData) {
        return DatumDataModelUtil.scanFileData(this, dirFileset, needScanInvalidData);
    }

    public ScanFileResultParam scanFilesByMainFile(IFileset folder, IFileset keyPath) {
        this.uncompress = true;
        ScanModelParam modelParam = new ScanModelParam(this);
        modelParam.setNeedScanInvalid(true);
        ScanFileParam scanFileParam = new ScanFileParam();
        scanFileParam.setFolder(folder);
        scanFileParam.setModelParam(modelParam);
        scanFileParam.setIsPackageType(false);
        scanFileParam.setVirRealPackages(null);
        return DatumDataModelUtil.scanFilesByMainFile(scanFileParam, keyPath);
    }

    public List<DataFile> getSpecificDataFile(String propertyKey) {
        ArrayList<DataFile> files = new ArrayList<DataFile>();
        this.getDataFileByProperty(this, propertyKey, files);
        return files;
    }

    private DatumModelDataObject getDataKeyObjectCall(DatumModelDataObject dataObject) {
        if (dataObject.getIsDataKey().booleanValue()) {
            return dataObject;
        }
        for (DatumModelDataObject obj : dataObject.getChildren()) {
            obj.setParentObject(dataObject);
            DatumModelDataObject dataObj = this.getDataKeyObjectCall(obj);
            if (dataObj == null) continue;
            return dataObj;
        }
        return null;
    }

    private void getDataFileByProperty(DatumModelDataObject dataObject, String propertyKey, List<DataFile> files) {
        if (dataObject.getNodeType().equals(FileModelNodeTypeEnum.DataFile.getValue())) {
            DataFile dataFile = (DataFile)dataObject;
            if (dataFile.getProperties().contains(propertyKey)) {
                files.add(dataFile);
            }
        } else {
            for (DatumModelDataObject object : dataObject.getChildren()) {
                object.setParentObject(dataObject);
                this.getDataFileByProperty(object, propertyKey, files);
            }
        }
    }

    public List<ScanFileResultParam> getScanFileResultParams() {
        return this.scanFileResultParams;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public Integer getMax() {
        return this.max;
    }

    public Long getNewDataCount() {
        return this.newDataCount;
    }

    public Long getInValidCount() {
        return this.inValidCount;
    }

    public ModelNameRulerEnum getDataNameRuler() {
        return this.dataNameRuler;
    }

    public DataPackageNameRulerEnum getPackageNameRulerType() {
        return this.packageNameRulerType;
    }

    public Boolean getRelated2RealFolder() {
        return this.related2RealFolder;
    }

    public ArchiveEnvironment getArchiveEnvironment() {
        return this.archiveEnvironment;
    }

    public List<ScanErrorMessage> getScanErrorMessages() {
        return this.scanErrorMessages;
    }

    public void setScanFileResultParams(List<ScanFileResultParam> scanFileResultParams) {
        this.scanFileResultParams = scanFileResultParams;
    }

    public void setFiles(List<String> files) {
        this.files = files;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public void setNewDataCount(Long newDataCount) {
        this.newDataCount = newDataCount;
    }

    public void setInValidCount(Long inValidCount) {
        this.inValidCount = inValidCount;
    }

    public void setDataNameRuler(ModelNameRulerEnum dataNameRuler) {
        this.dataNameRuler = dataNameRuler;
    }

    public void setPackageNameRulerType(DataPackageNameRulerEnum packageNameRulerType) {
        this.packageNameRulerType = packageNameRulerType;
    }

    public void setRelated2RealFolder(Boolean related2RealFolder) {
        this.related2RealFolder = related2RealFolder;
    }

    public void setArchiveEnvironment(ArchiveEnvironment archiveEnvironment) {
        this.archiveEnvironment = archiveEnvironment;
    }

    public void setScanErrorMessages(List<ScanErrorMessage> scanErrorMessages) {
        this.scanErrorMessages = scanErrorMessages;
    }

    @Override
    public String toString() {
        return "DataPackage(scanFileResultParams=" + this.getScanFileResultParams() + ", files=" + this.getFiles() + ", max=" + this.getMax() + ", newDataCount=" + this.getNewDataCount() + ", inValidCount=" + this.getInValidCount() + ", dataNameRuler=" + (Object)((Object)this.getDataNameRuler()) + ", packageNameRulerType=" + (Object)((Object)this.getPackageNameRulerType()) + ", related2RealFolder=" + this.getRelated2RealFolder() + ", uncompress=" + this.isUncompress() + ", dataCompactPackageFiles=" + this.getDataCompactPackageFiles() + ", archiveEnvironment=" + this.getArchiveEnvironment() + ", scanErrorMessages=" + this.getScanErrorMessages() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataPackage)) {
            return false;
        }
        DataPackage other = (DataPackage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isUncompress() != other.isUncompress()) {
            return false;
        }
        Integer this$max = this.getMax();
        Integer other$max = other.getMax();
        if (this$max == null ? other$max != null : !((Object)this$max).equals(other$max)) {
            return false;
        }
        Long this$newDataCount = this.getNewDataCount();
        Long other$newDataCount = other.getNewDataCount();
        if (this$newDataCount == null ? other$newDataCount != null : !((Object)this$newDataCount).equals(other$newDataCount)) {
            return false;
        }
        Long this$inValidCount = this.getInValidCount();
        Long other$inValidCount = other.getInValidCount();
        if (this$inValidCount == null ? other$inValidCount != null : !((Object)this$inValidCount).equals(other$inValidCount)) {
            return false;
        }
        Boolean this$related2RealFolder = this.getRelated2RealFolder();
        Boolean other$related2RealFolder = other.getRelated2RealFolder();
        if (this$related2RealFolder == null ? other$related2RealFolder != null : !((Object)this$related2RealFolder).equals(other$related2RealFolder)) {
            return false;
        }
        List<ScanFileResultParam> this$scanFileResultParams = this.getScanFileResultParams();
        List<ScanFileResultParam> other$scanFileResultParams = other.getScanFileResultParams();
        if (this$scanFileResultParams == null ? other$scanFileResultParams != null : !((Object)this$scanFileResultParams).equals(other$scanFileResultParams)) {
            return false;
        }
        List<String> this$files = this.getFiles();
        List<String> other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        ModelNameRulerEnum this$dataNameRuler = this.getDataNameRuler();
        ModelNameRulerEnum other$dataNameRuler = other.getDataNameRuler();
        if (this$dataNameRuler == null ? other$dataNameRuler != null : !((Object)((Object)this$dataNameRuler)).equals((Object)other$dataNameRuler)) {
            return false;
        }
        DataPackageNameRulerEnum this$packageNameRulerType = this.getPackageNameRulerType();
        DataPackageNameRulerEnum other$packageNameRulerType = other.getPackageNameRulerType();
        if (this$packageNameRulerType == null ? other$packageNameRulerType != null : !((Object)((Object)this$packageNameRulerType)).equals((Object)other$packageNameRulerType)) {
            return false;
        }
        List<IFileset> this$dataCompactPackageFiles = this.getDataCompactPackageFiles();
        List<IFileset> other$dataCompactPackageFiles = other.getDataCompactPackageFiles();
        if (this$dataCompactPackageFiles == null ? other$dataCompactPackageFiles != null : !((Object)this$dataCompactPackageFiles).equals(other$dataCompactPackageFiles)) {
            return false;
        }
        ArchiveEnvironment this$archiveEnvironment = this.getArchiveEnvironment();
        ArchiveEnvironment other$archiveEnvironment = other.getArchiveEnvironment();
        if (this$archiveEnvironment == null ? other$archiveEnvironment != null : !this$archiveEnvironment.equals(other$archiveEnvironment)) {
            return false;
        }
        List<ScanErrorMessage> this$scanErrorMessages = this.getScanErrorMessages();
        List<ScanErrorMessage> other$scanErrorMessages = other.getScanErrorMessages();
        return !(this$scanErrorMessages == null ? other$scanErrorMessages != null : !((Object)this$scanErrorMessages).equals(other$scanErrorMessages));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DataPackage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isUncompress() ? 79 : 97);
        Integer $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
        Long $newDataCount = this.getNewDataCount();
        result = result * 59 + ($newDataCount == null ? 43 : ((Object)$newDataCount).hashCode());
        Long $inValidCount = this.getInValidCount();
        result = result * 59 + ($inValidCount == null ? 43 : ((Object)$inValidCount).hashCode());
        Boolean $related2RealFolder = this.getRelated2RealFolder();
        result = result * 59 + ($related2RealFolder == null ? 43 : ((Object)$related2RealFolder).hashCode());
        List<ScanFileResultParam> $scanFileResultParams = this.getScanFileResultParams();
        result = result * 59 + ($scanFileResultParams == null ? 43 : ((Object)$scanFileResultParams).hashCode());
        List<String> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        ModelNameRulerEnum $dataNameRuler = this.getDataNameRuler();
        result = result * 59 + ($dataNameRuler == null ? 43 : ((Object)((Object)$dataNameRuler)).hashCode());
        DataPackageNameRulerEnum $packageNameRulerType = this.getPackageNameRulerType();
        result = result * 59 + ($packageNameRulerType == null ? 43 : ((Object)((Object)$packageNameRulerType)).hashCode());
        List<IFileset> $dataCompactPackageFiles = this.getDataCompactPackageFiles();
        result = result * 59 + ($dataCompactPackageFiles == null ? 43 : ((Object)$dataCompactPackageFiles).hashCode());
        ArchiveEnvironment $archiveEnvironment = this.getArchiveEnvironment();
        result = result * 59 + ($archiveEnvironment == null ? 43 : $archiveEnvironment.hashCode());
        List<ScanErrorMessage> $scanErrorMessages = this.getScanErrorMessages();
        result = result * 59 + ($scanErrorMessages == null ? 43 : ((Object)$scanErrorMessages).hashCode());
        return result;
    }
}

