/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.cache;

import com.alibaba.fastjson2.JSON;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.properties.UserRightProperties;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;

@Component(value="customKeyGenerator")
public class CustomKeyGenerator
implements KeyGenerator {
    @Resource
    private UserRightProperties userRightProperties;

    @Autowired
    public CustomKeyGenerator() {
    }

    public Object generate(Object target, Method method, Object ... params) {
        if (Boolean.TRUE.equals(this.userRightProperties.getTenantEnabled())) {
            LoginUserInfo userInfo = ThreadLocalUtil.getCurrentUser();
            if (userInfo == null) {
                throw new HttpClientErrorException(HttpStatus.UNAUTHORIZED, "\u7cfb\u7edf\u672a\u767b\u5f55");
            }
            return userInfo.getTenantId() + "-" + method.getName() + "(" + JSON.toJSONString((Object)params) + ")";
        }
        return method.getName() + "(" + JSON.toJSONString((Object)params) + ")";
    }
}

