/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONArray;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dao.CmColorSchemeDao;
import com.geoway.adf.dms.config.dto.colorscheme.ColorItemDTO;
import com.geoway.adf.dms.config.entity.CmColorItem;
import com.geoway.adf.dms.config.entity.CmColorScheme;
import com.geoway.adf.dms.config.service.ColorItemService;
import com.geoway.adf.dms.config.service.ColorSchemeService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ColorSchemeServiceImpl
implements ColorSchemeService {
    private static final Logger log = LoggerFactory.getLogger(ColorSchemeServiceImpl.class);
    @Resource
    private CmColorSchemeDao cmColorSchemeDao;
    @Resource
    private ColorItemService colorItemService;

    @Override
    public String saveOrUpdateInfo(CmColorScheme colorScheme) {
        if (StringUtil.isEmptyOrWhiteSpace((String)colorScheme.getName())) {
            throw new RuntimeException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNotEmpty((String)colorScheme.getId())) {
            CmColorScheme updateOne = this.cmColorSchemeDao.selectByPrimaryKey(colorScheme.getId());
            if (updateOne == null) {
                throw new RuntimeException("\u76ee\u6807\u4e0d\u5b58\u5728");
            }
            if (!colorScheme.getName().equals(updateOne.getName())) {
                this.checkSameName(colorScheme.getName());
            }
            this.cmColorSchemeDao.updateByPrimaryKey(colorScheme);
        } else {
            this.checkSameName(colorScheme.getName());
            colorScheme.setId(IdUtil.getSnowflakeNextIdStr());
            this.cmColorSchemeDao.insert(colorScheme);
        }
        return colorScheme.getId();
    }

    @Override
    public List<CmColorScheme> queryList() {
        return this.cmColorSchemeDao.selectAll();
    }

    @Override
    public Boolean deleteById(String id) {
        this.colorItemService.deleteByScheme(id);
        this.cmColorSchemeDao.deleteByPrimaryKey(id);
        return true;
    }

    @Override
    public void exportScheme(String schemeId) {
        CmColorScheme colorScheme = this.cmColorSchemeDao.selectByPrimaryKey(schemeId);
        if (colorScheme == null) {
            throw new RuntimeException("\u989c\u8272\u65b9\u6848\u4e0d\u5b58\u5728\uff01");
        }
        List<CmColorItem> itemList = this.colorItemService.queryByScheme(schemeId);
        List items = ListUtil.convertAll(itemList, item -> {
            ColorItemDTO dto = new ColorItemDTO();
            dto.setName(item.getName());
            dto.setCode(item.getCode());
            dto.setColor(item.getColor());
            return dto;
        });
        String contents = JSONArray.toJSONString((Object)items);
        String name = colorScheme.getName().replaceAll("[\\s\\\\/:\\*\\?\\\"<>\\|]", "");
        DownloadUtil.downloadToFile((String)(name + ".json"), (String)contents);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean importScheme(MultipartFile file, String schemeId) {
        if (file == null || !Objects.requireNonNull(file.getOriginalFilename()).endsWith(".json")) {
            throw new RuntimeException("\u6587\u4ef6\u683c\u5f0f\u6709\u8bef");
        }
        InputStreamReader streamReader = null;
        BufferedReader bufferedReader = null;
        StringBuilder stringBuffer = new StringBuilder();
        List items = null;
        try {
            streamReader = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);
            bufferedReader = new BufferedReader(streamReader);
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                stringBuffer.append(line);
            }
            bufferedReader.close();
            streamReader.close();
            items = JSONArray.parseArray((String)stringBuffer.toString(), ColorItemDTO.class);
        }
        catch (Exception e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff01" + e.getMessage());
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{streamReader, bufferedReader});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{streamReader, bufferedReader});
        CmColorScheme cmColorScheme = null;
        if (StringUtil.isEmptyOrWhiteSpace((String)schemeId)) {
            String name = file.getOriginalFilename();
            if (name.indexOf(".") > 0) {
                name = name.substring(0, name.indexOf("."));
            }
            int index = 1;
            List<CmColorScheme> sameNameItems = this.cmColorSchemeDao.selectByName(name);
            String reName = name;
            while (sameNameItems != null && sameNameItems.size() > 0) {
                reName = name + "-\u526f\u672c-" + index;
                sameNameItems = this.cmColorSchemeDao.selectByName(reName);
                ++index;
            }
            cmColorScheme = new CmColorScheme();
            cmColorScheme.setName(reName);
            cmColorScheme.setId(IdUtil.getSnowflakeNextIdStr());
            this.cmColorSchemeDao.insert(cmColorScheme);
            schemeId = cmColorScheme.getId();
        }
        if (cmColorScheme == null && (cmColorScheme = this.cmColorSchemeDao.selectByPrimaryKey(schemeId)) == null) {
            throw new RuntimeException("\u989c\u8272\u65b9\u6848\u4e0d\u5b58\u5728\uff01");
        }
        if (items == null || items.size() == 0) {
            throw new RuntimeException("\u672a\u89e3\u6790\u5230\u989c\u8272\u503c\uff01");
        }
        String colorId = schemeId;
        List itemList = ListUtil.convertAll((List)items, dto -> {
            CmColorItem item = new CmColorItem();
            item.setId(IdUtil.getSnowflakeNextIdStr());
            item.setName(dto.getName());
            item.setCode(dto.getCode());
            item.setColor(dto.getColor());
            item.setColorId(colorId);
            return item;
        });
        this.colorItemService.batchAddItems(itemList);
        return true;
    }

    public void checkSameName(String name) {
        CmColorScheme one = null;
        List<CmColorScheme> sameNameItems = this.cmColorSchemeDao.selectByName(name);
        if (sameNameItems != null && sameNameItems.size() > 0) {
            one = sameNameItems.get(0);
        }
        if (one != null) {
            throw new RuntimeException("\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\uff0c\u540d\u79f0\u3010" + name + "\u3011\u5df2\u5b58\u5728!");
        }
    }
}

