/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.filemodel.util;

import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FileStorageCache {
    private static final Map<IFileStorage, FilesetCache> cacheMap = new ConcurrentHashMap<IFileStorage, FilesetCache>();

    public static void initCache(IFileStorage storage) {
        cacheMap.computeIfAbsent(storage, FilesetCache::new);
    }

    public static void clearCache(IFileStorage storage) {
        FilesetCache cache = cacheMap.get(storage);
        if (cache != null) {
            cache.clear();
            cacheMap.remove(storage);
        }
    }

    public static IFileset getFile(IFileStorage storage, String path) {
        return cacheMap.get(storage).getFile(path);
    }

    public static List<IFileset> listFiles(IFileset fileset) {
        return cacheMap.get(fileset.getFileStorage()).listFiles(fileset.getFullPath());
    }

    public static IFileset getParentFile(IFileset fileset) {
        return cacheMap.get(fileset.getFileStorage()).getParentFile(fileset.getFullPath());
    }

    static class FilesetCache {
        private final IFileStorage storage;
        private final Map<String, IFileset> cache = new ConcurrentHashMap<String, IFileset>();

        public FilesetCache(IFileStorage storage) {
            this.storage = storage;
        }

        public IFileset getFile(String path) {
            return this.cache.computeIfAbsent(path, p -> this.storage.getFile(p));
        }

        public IFileset getParentFile(String path) {
            IFileset fileset = this.getFile(path);
            if (fileset == null) {
                return null;
            }
            IFileset parentFile = fileset.getParentFile();
            if (parentFile != null) {
                return this.cache.computeIfAbsent(parentFile.getFullPath(), p -> parentFile);
            }
            return parentFile;
        }

        public List<IFileset> listFiles(String path) {
            IFileset fileset = this.getFile(path);
            if (fileset == null) {
                return null;
            }
            List files = fileset.listFiles();
            if (files != null) {
                for (IFileset f : files) {
                    this.cache.putIfAbsent(f.getFullPath(), f);
                }
            }
            return files;
        }

        public void clear() {
            this.cache.clear();
        }
    }
}

