/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.service.impl;

import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dao.CmBaseLayerMapDao;
import com.geoway.adf.dms.config.dto.baselayermap.BaseMapCategoryDTO;
import com.geoway.adf.dms.config.dto.baselayermap.BaseMapGroupDTO;
import com.geoway.adf.dms.config.dto.baselayermap.BaseMapSchemeDTO;
import com.geoway.adf.dms.config.dto.baselayermap.BaseMapServiceDTO;
import com.geoway.adf.dms.config.dto.baselayermap.BaseMapType;
import com.geoway.adf.dms.config.entity.CmBaseLayerMap;
import com.geoway.adf.dms.config.service.BaseLayerMapService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@Transactional(rollbackFor={Exception.class})
public class BaseLayerMapServiceImpl
implements BaseLayerMapService {
    private static final Logger log = LoggerFactory.getLogger(BaseLayerMapServiceImpl.class);
    @Resource
    private CmBaseLayerMapDao cmBaseLayerMapDao;
    private static final String DEFAULT_SCHEME = "web_system";

    @Override
    public List<BaseMapSchemeDTO> listScheme() {
        CmBaseLayerMap defaultScheme;
        List<CmBaseLayerMap> cmBaseMaps = this.cmBaseLayerMapDao.selectByTypes(Collections.singletonList(BaseMapType.MapScheme.getValue()));
        boolean hasDefault = false;
        ArrayList<BaseMapSchemeDTO> list = new ArrayList<BaseMapSchemeDTO>();
        for (CmBaseLayerMap cmBaseMap : cmBaseMaps) {
            if (cmBaseMap.getId().equals(DEFAULT_SCHEME)) {
                hasDefault = true;
            }
            BaseMapSchemeDTO dto = new BaseMapSchemeDTO();
            dto.setId(cmBaseMap.getId());
            dto.setName(cmBaseMap.getName());
            dto.setCode(cmBaseMap.getCode());
            list.add(dto);
        }
        if (!hasDefault && (defaultScheme = this.getDefaultScheme()) != null) {
            BaseMapSchemeDTO defaultDTO = new BaseMapSchemeDTO();
            defaultDTO.setId(defaultScheme.getId());
            defaultDTO.setName(defaultScheme.getName());
            defaultDTO.setCode(defaultScheme.getCode());
            list.add(0, defaultDTO);
        }
        return list;
    }

    @Override
    public BaseMapSchemeDTO getBaseMapScheme(String shcemeId, String shcemeCode, Boolean onlyEnabled) {
        List<CmBaseLayerMap> list;
        CmBaseLayerMap cmBaseMapScheme = null;
        if (StringUtil.isEmpty((String)shcemeId) && StringUtil.isEmpty((String)shcemeCode)) {
            cmBaseMapScheme = this.getDefaultScheme();
        } else if (StringUtil.isNotEmpty((String)shcemeId)) {
            cmBaseMapScheme = this.cmBaseLayerMapDao.selectByPrimaryKey(shcemeId);
        } else if (StringUtil.isNotEmpty((String)shcemeCode) && (list = this.cmBaseLayerMapDao.selectByCode(shcemeCode, BaseMapType.MapScheme.getValue())).size() > 0) {
            cmBaseMapScheme = list.get(0);
        }
        if (cmBaseMapScheme == null) {
            return null;
        }
        if (BaseMapType.MapScheme.getValue() != cmBaseMapScheme.getType().intValue()) {
            return null;
        }
        BaseMapSchemeDTO mapSchemeDTO = new BaseMapSchemeDTO();
        mapSchemeDTO.setId(cmBaseMapScheme.getId());
        mapSchemeDTO.setName(cmBaseMapScheme.getName());
        mapSchemeDTO.setCode(cmBaseMapScheme.getCode());
        mapSchemeDTO.setExtension(cmBaseMapScheme.getExtension());
        mapSchemeDTO.setBaseMaps(new ArrayList<BaseMapCategoryDTO>());
        List<CmBaseLayerMap> cmBaseMaps = this.cmBaseLayerMapDao.selectBySchemeId(mapSchemeDTO.getId());
        Map<String, List<CmBaseLayerMap>> cmBaseMapGroups = cmBaseMaps.stream().collect(Collectors.groupingBy(m -> m.getPid() == null ? "" : m.getPid()));
        List<CmBaseLayerMap> mapCategories = cmBaseMapGroups.get(mapSchemeDTO.getId());
        if (mapCategories != null) {
            for (CmBaseLayerMap cmBaseMapCategory : mapCategories) {
                if (Boolean.TRUE.equals(onlyEnabled) && !cmBaseMapCategory.getEnable().booleanValue()) continue;
                BaseMapCategoryDTO mapCategoryDTO = this.buildBaseMapCategory(cmBaseMapCategory, cmBaseMapGroups);
                mapSchemeDTO.getBaseMaps().add(mapCategoryDTO);
            }
        }
        return mapSchemeDTO;
    }

    @Override
    public BaseMapCategoryDTO getBaseMapCategory(String id) {
        CmBaseLayerMap cmBaseMapCategory = this.cmBaseLayerMapDao.selectByPrimaryKey(id);
        if (cmBaseMapCategory == null) {
            return null;
        }
        List<CmBaseLayerMap> cmBaseMaps = this.cmBaseLayerMapDao.selectBySchemeId(cmBaseMapCategory.getSchemeId());
        Map<String, List<CmBaseLayerMap>> cmBaseMapGroups = cmBaseMaps.stream().collect(Collectors.groupingBy(m -> m.getPid() == null ? "" : m.getPid()));
        return this.buildBaseMapCategory(cmBaseMapCategory, cmBaseMapGroups);
    }

    private BaseMapCategoryDTO buildBaseMapCategory(CmBaseLayerMap cmBaseMapCategory, Map<String, List<CmBaseLayerMap>> cmBaseMapGroups) {
        BaseMapCategoryDTO mapCategoryDTO = new BaseMapCategoryDTO();
        BeanUtils.copyProperties((Object)cmBaseMapCategory, (Object)mapCategoryDTO);
        mapCategoryDTO.setPictureBase64(cmBaseMapCategory.getPicture());
        mapCategoryDTO.setGroups(new ArrayList<BaseMapGroupDTO>());
        List<CmBaseLayerMap> mapGroups = cmBaseMapGroups.get(cmBaseMapCategory.getId());
        if (mapGroups != null) {
            for (CmBaseLayerMap cmBaseMapGroup : mapGroups) {
                BaseMapGroupDTO mapGroupDTO = new BaseMapGroupDTO();
                BeanUtils.copyProperties((Object)cmBaseMapGroup, (Object)mapGroupDTO);
                mapGroupDTO.setServices(new ArrayList<BaseMapServiceDTO>());
                mapCategoryDTO.getGroups().add(mapGroupDTO);
                List<CmBaseLayerMap> mapServices = cmBaseMapGroups.get(cmBaseMapGroup.getId());
                if (mapServices == null) continue;
                for (CmBaseLayerMap cmBaseMapService : mapServices) {
                    BaseMapServiceDTO mapServiceDTO = new BaseMapServiceDTO();
                    BeanUtils.copyProperties((Object)cmBaseMapService, (Object)mapServiceDTO);
                    mapGroupDTO.getServices().add(mapServiceDTO);
                }
            }
        }
        return mapCategoryDTO;
    }

    @Override
    public String saveBaseMapScheme(BaseMapSchemeDTO schemeDTO) {
        if (StringUtil.isEmpty((String)schemeDTO.getId())) {
            if (this.cmBaseLayerMapDao.selectByCode(schemeDTO.getCode(), BaseMapType.MapScheme.getValue()).size() > 0) {
                throw new RuntimeException("\u7f16\u7801\u91cd\u590d");
            }
            if (!this.checkNameRepeat(null, "", schemeDTO.getName())) {
                throw new RuntimeException(String.format("\u540d\u79f0[%s]\u5df2\u5b58\u5728", schemeDTO.getName()));
            }
            Integer order = this.cmBaseLayerMapDao.queryMaxOrder("");
            order = (order == null ? 0 : order) + 1;
            CmBaseLayerMap cmBaseMapScheme = new CmBaseLayerMap();
            cmBaseMapScheme.setId(UUID.randomUUID().toString().replace("-", ""));
            cmBaseMapScheme.setPid("");
            cmBaseMapScheme.setName(schemeDTO.getName());
            cmBaseMapScheme.setCode(schemeDTO.getCode());
            cmBaseMapScheme.setType(BaseMapType.MapScheme.getValue());
            cmBaseMapScheme.setOrder(order);
            this.cmBaseLayerMapDao.insertSelective(cmBaseMapScheme);
            return cmBaseMapScheme.getId();
        }
        if (DEFAULT_SCHEME.equals(schemeDTO.getId())) {
            throw new RuntimeException("\u9ed8\u8ba4\u65b9\u6848\u4e0d\u652f\u6301\u4fee\u6539");
        }
        CmBaseLayerMap existMap = this.cmBaseLayerMapDao.selectByPrimaryKey(schemeDTO.getId());
        Assert.notNull((Object)existMap, (String)"\u5e95\u56fe\u65b9\u6848\u4e0d\u5b58\u5728");
        if (schemeDTO.getName() != null && !existMap.getName().equals(schemeDTO.getName()) && !this.checkNameRepeat(existMap.getId(), "", schemeDTO.getName())) {
            throw new RuntimeException(String.format("\u540d\u79f0[%s]\u5df2\u5b58\u5728", schemeDTO.getName()));
        }
        CmBaseLayerMap updateBaseMapScheme = new CmBaseLayerMap();
        updateBaseMapScheme.setId(existMap.getId());
        updateBaseMapScheme.setName(schemeDTO.getName());
        this.cmBaseLayerMapDao.updateByPrimaryKeySelective(updateBaseMapScheme);
        return existMap.getId();
    }

    @Override
    public String saveBaseMapCategory(BaseMapCategoryDTO categoryDTO) {
        if (StringUtil.isEmpty((String)categoryDTO.getId())) {
            if (!this.isMapCategory(categoryDTO.getType())) {
                throw new RuntimeException("\u5e95\u56fe\u7c7b\u578b\u4e0d\u6b63\u786e");
            }
            CmBaseLayerMap cmBaseMapScheme = this.cmBaseLayerMapDao.selectByPrimaryKey(categoryDTO.getSchemeId());
            Assert.notNull((Object)cmBaseMapScheme, (String)"\u5e95\u56fe\u65b9\u6848\u4e0d\u5b58\u5728");
            if (cmBaseMapScheme.getType().intValue() != BaseMapType.MapScheme.getValue()) {
                throw new RuntimeException("\u53ea\u80fd\u5728\u65b9\u6848\u4e0b\u6dfb\u52a0\u5e95\u56fe");
            }
            if (!this.checkNameRepeat(null, categoryDTO.getSchemeId(), categoryDTO.getName())) {
                throw new RuntimeException(String.format("\u540d\u79f0[%s]\u5df2\u5b58\u5728", categoryDTO.getName()));
            }
            Integer order = this.cmBaseLayerMapDao.queryMaxOrder(categoryDTO.getSchemeId());
            order = (order == null ? 0 : order) + 1;
            CmBaseLayerMap cmBaseMap = new CmBaseLayerMap();
            cmBaseMap.setId(UUID.randomUUID().toString().replace("-", ""));
            cmBaseMap.setPid(categoryDTO.getSchemeId());
            cmBaseMap.setSchemeId(categoryDTO.getSchemeId());
            cmBaseMap.setName(categoryDTO.getName());
            cmBaseMap.setType(categoryDTO.getType());
            cmBaseMap.setPicture(categoryDTO.getPictureBase64());
            cmBaseMap.setOrder(order);
            cmBaseMap.setEnable(true);
            this.cmBaseLayerMapDao.insertSelective(cmBaseMap);
            return cmBaseMap.getId();
        }
        CmBaseLayerMap existMap = this.cmBaseLayerMapDao.selectByPrimaryKey(categoryDTO.getId());
        Assert.notNull((Object)existMap, (String)"\u5e95\u56fe\u4e0d\u5b58\u5728");
        if (categoryDTO.getName() != null && !existMap.getName().equals(categoryDTO.getName()) && !this.checkNameRepeat(categoryDTO.getSchemeId(), existMap.getPid(), categoryDTO.getName())) {
            throw new RuntimeException(String.format("\u540d\u79f0[%s]\u5df2\u5b58\u5728", categoryDTO.getName()));
        }
        CmBaseLayerMap updateBaseMap = new CmBaseLayerMap();
        updateBaseMap.setId(categoryDTO.getId());
        updateBaseMap.setName(categoryDTO.getName());
        updateBaseMap.setEnable(categoryDTO.getEnable());
        updateBaseMap.setPicture(categoryDTO.getPictureBase64());
        this.cmBaseLayerMapDao.updateByPrimaryKeySelective(updateBaseMap);
        return categoryDTO.getId();
    }

    @Override
    public String saveBaseMapGroup(BaseMapGroupDTO groupDTO) {
        if (StringUtil.isEmpty((String)groupDTO.getId())) {
            CmBaseLayerMap cmBaseMap = this.cmBaseLayerMapDao.selectByPrimaryKey(groupDTO.getBaseMapId());
            Assert.notNull((Object)cmBaseMap, (String)"\u5e95\u56fe\u4e0d\u5b58\u5728");
            if (!this.isMapCategory(cmBaseMap.getType())) {
                throw new RuntimeException("\u53ea\u80fd\u5728\u5e95\u56fe\u4e0b\u6dfb\u52a0\u5206\u7ec4");
            }
            if (!this.checkNameRepeat(null, groupDTO.getBaseMapId(), groupDTO.getName())) {
                throw new RuntimeException(String.format("\u540d\u79f0[%s]\u5df2\u5b58\u5728", groupDTO.getName()));
            }
            Integer order = this.cmBaseLayerMapDao.queryMaxOrder(groupDTO.getBaseMapId());
            order = (order == null ? 0 : order) + 1;
            CmBaseLayerMap cmBaseMapGroup = new CmBaseLayerMap();
            cmBaseMapGroup.setId(UUID.randomUUID().toString().replace("-", ""));
            cmBaseMapGroup.setPid(groupDTO.getBaseMapId());
            cmBaseMapGroup.setSchemeId(cmBaseMap.getSchemeId());
            cmBaseMapGroup.setName(groupDTO.getName());
            cmBaseMapGroup.setType(BaseMapType.MapGroup.getValue());
            cmBaseMapGroup.setOrder(order);
            cmBaseMapGroup.setEnable(true);
            this.cmBaseLayerMapDao.insertSelective(cmBaseMapGroup);
            return cmBaseMapGroup.getId();
        }
        CmBaseLayerMap existMap = this.cmBaseLayerMapDao.selectByPrimaryKey(groupDTO.getId());
        Assert.notNull((Object)existMap, (String)"\u5206\u7ec4\u4e0d\u5b58\u5728");
        if (groupDTO.getName() != null && !existMap.getName().equals(groupDTO.getName()) && !this.checkNameRepeat(groupDTO.getId(), existMap.getPid(), groupDTO.getName())) {
            throw new RuntimeException(String.format("\u540d\u79f0[%s]\u5df2\u5b58\u5728", groupDTO.getName()));
        }
        CmBaseLayerMap updateBaseMap = new CmBaseLayerMap();
        updateBaseMap.setId(groupDTO.getId());
        updateBaseMap.setName(groupDTO.getName());
        this.cmBaseLayerMapDao.updateByPrimaryKeySelective(updateBaseMap);
        return groupDTO.getId();
    }

    @Override
    public String saveBaseMapService(BaseMapServiceDTO serviceDTO) {
        if (StringUtil.isEmpty((String)serviceDTO.getId())) {
            CmBaseLayerMap cmBaseMapGroup = this.cmBaseLayerMapDao.selectByPrimaryKey(serviceDTO.getGroupId());
            Assert.notNull((Object)cmBaseMapGroup, (String)"\u5206\u7ec4\u4e0d\u5b58\u5728");
            if (cmBaseMapGroup.getType().intValue() != BaseMapType.MapGroup.getValue()) {
                throw new RuntimeException("\u53ea\u80fd\u5728\u5206\u7ec4\u4e0b\u6dfb\u52a0\u670d\u52a1");
            }
            if (!this.checkNameRepeat(null, serviceDTO.getGroupId(), serviceDTO.getName())) {
                throw new RuntimeException(String.format("\u540d\u79f0[%s]\u5df2\u5b58\u5728", serviceDTO.getName()));
            }
            Integer order = this.cmBaseLayerMapDao.queryMaxOrder(serviceDTO.getGroupId());
            order = (order == null ? 0 : order) + 1;
            CmBaseLayerMap cmBaseMap = new CmBaseLayerMap();
            BeanUtils.copyProperties((Object)serviceDTO, (Object)cmBaseMap);
            cmBaseMap.setId(UUID.randomUUID().toString().replace("-", ""));
            cmBaseMap.setPid(serviceDTO.getGroupId());
            cmBaseMap.setSchemeId(cmBaseMapGroup.getSchemeId());
            cmBaseMap.setOrder(order);
            cmBaseMap.setEnable(true);
            cmBaseMap.setVisible2d(serviceDTO.getVisible2d() == null || serviceDTO.getVisible2d() != false);
            cmBaseMap.setVisible3d(serviceDTO.getVisible3d() == null || serviceDTO.getVisible3d() != false);
            this.cmBaseLayerMapDao.insertSelective(cmBaseMap);
            return cmBaseMap.getId();
        }
        CmBaseLayerMap existMap = this.cmBaseLayerMapDao.selectByPrimaryKey(serviceDTO.getId());
        Assert.notNull((Object)existMap, (String)"\u670d\u52a1\u4e0d\u5b58\u5728");
        if (serviceDTO.getName() != null && !existMap.getName().equals(serviceDTO.getName()) && !this.checkNameRepeat(serviceDTO.getId(), existMap.getPid(), serviceDTO.getName())) {
            throw new RuntimeException(String.format("\u540d\u79f0[%s]\u5df2\u5b58\u5728", serviceDTO.getName()));
        }
        CmBaseLayerMap updateBaseMap = new CmBaseLayerMap();
        BeanUtils.copyProperties((Object)serviceDTO, (Object)updateBaseMap);
        updateBaseMap.setPid(existMap.getPid());
        updateBaseMap.setSchemeId(existMap.getSchemeId());
        updateBaseMap.setOrder(existMap.getOrder());
        this.cmBaseLayerMapDao.updateByPrimaryKeySelective(updateBaseMap);
        return serviceDTO.getId();
    }

    @Override
    public void delete(String id) {
        CmBaseLayerMap cmBaseMap = this.cmBaseLayerMapDao.selectByPrimaryKey(id);
        if (cmBaseMap == null) {
            return;
        }
        if (BaseMapType.MapScheme.getValue() == cmBaseMap.getType().intValue()) {
            if (DEFAULT_SCHEME.equals(id)) {
                throw new RuntimeException("\u9ed8\u8ba4\u5e95\u56fe\u4e0d\u80fd\u5220\u9664");
            }
            this.cmBaseLayerMapDao.deleteBySchemeId(id);
            this.cmBaseLayerMapDao.deleteByPrimaryKey(id);
        } else if (this.isMapCategory(cmBaseMap.getType())) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(id);
            List<CmBaseLayerMap> allGroups = this.cmBaseLayerMapDao.selectByPid(id);
            for (CmBaseLayerMap group : allGroups) {
                ids.add(group.getId());
                ids.addAll(ListUtil.convertAll(this.cmBaseLayerMapDao.selectByPid(group.getId()), CmBaseLayerMap::getId));
            }
            this.cmBaseLayerMapDao.deleteByIds(ids);
        } else if (BaseMapType.MapGroup.getValue() == cmBaseMap.getType().intValue()) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(id);
            ids.addAll(ListUtil.convertAll(this.cmBaseLayerMapDao.selectByPid(id), CmBaseLayerMap::getId));
            this.cmBaseLayerMapDao.deleteByIds(ids);
        } else {
            this.cmBaseLayerMapDao.deleteByPrimaryKey(id);
        }
    }

    @Override
    public void setDefault(String id, Boolean isDefault) {
        CmBaseLayerMap cmBaseMap = this.cmBaseLayerMapDao.selectByPrimaryKey(id);
        if (cmBaseMap != null && (BaseMapType.MapGroup.getValue() == cmBaseMap.getType().intValue() || this.isMapCategory(cmBaseMap.getType()))) {
            if (Boolean.TRUE.equals(isDefault)) {
                this.cmBaseLayerMapDao.cancelDefault(cmBaseMap.getPid());
                this.cmBaseLayerMapDao.setDefault(id, ConstantsValue.TRUE_VALUE);
            } else {
                this.cmBaseLayerMapDao.setDefault(id, ConstantsValue.FALSE_VALUE);
            }
        }
    }

    @Override
    public void updateOrder(String id, String pid, Integer order) {
        int i;
        CmBaseLayerMap cmBaseMap = this.cmBaseLayerMapDao.selectByPrimaryKey(id);
        if (cmBaseMap == null) {
            return;
        }
        if (BaseMapType.MapScheme.getValue() == cmBaseMap.getType().intValue()) {
            return;
        }
        if (this.isMapCategory(cmBaseMap.getType())) {
            pid = cmBaseMap.getPid();
        } else if (BaseMapType.MapGroup.getValue() == cmBaseMap.getType().intValue()) {
            pid = cmBaseMap.getPid();
        } else {
            if (StringUtil.isEmpty((String)pid)) {
                pid = cmBaseMap.getPid();
            }
            if (!StringUtil.equals((String)pid, (String)cmBaseMap.getPid())) {
                CmBaseLayerMap cmBaseMapGroup = this.cmBaseLayerMapDao.selectByPrimaryKey(pid);
                Assert.notNull((Object)cmBaseMapGroup, (String)"\u5206\u7ec4\u4e0d\u5b58\u5728");
                if (BaseMapType.MapGroup.getValue() != cmBaseMapGroup.getType().intValue()) {
                    throw new RuntimeException("\u53ea\u80fd\u79fb\u52a8\u5230\u5206\u7ec4\u4e0b");
                }
                CmBaseLayerMap updateBaseMap = new CmBaseLayerMap();
                updateBaseMap.setId(id);
                updateBaseMap.setPid(pid);
                this.cmBaseLayerMapDao.updateByPrimaryKeySelective(updateBaseMap);
            }
        }
        List<CmBaseLayerMap> list = this.cmBaseLayerMapDao.selectByPid(pid);
        list.removeIf(f -> StringUtil.equals((String)f.getId(), (String)id));
        if (order == null) {
            order = 0;
        }
        int preIndex = -1;
        for (i = 0; i < list.size(); ++i) {
            if (list.get(i).getOrder() <= order) {
                preIndex = i;
                continue;
            }
            if (list.get(i).getOrder() > order) break;
        }
        list.add(preIndex + 1, cmBaseMap);
        for (i = 0; i < list.size(); ++i) {
            CmBaseLayerMap map = list.get(i);
            if (map.getOrder() == i + 1) continue;
            CmBaseLayerMap updateBaseMap = new CmBaseLayerMap();
            updateBaseMap.setId(map.getId());
            updateBaseMap.setOrder(i + 1);
            this.cmBaseLayerMapDao.updateByPrimaryKeySelective(updateBaseMap);
        }
    }

    @Override
    public void updateBaseMapExtent(String schemeId, String extentJson) {
        CmBaseLayerMap cmBaseMapScheme = this.cmBaseLayerMapDao.selectByPrimaryKey(schemeId);
        if (cmBaseMapScheme != null && BaseMapType.MapScheme.getValue() == cmBaseMapScheme.getType().intValue()) {
            CmBaseLayerMap cmBaseMap = new CmBaseLayerMap();
            cmBaseMap.setId(schemeId);
            cmBaseMap.setExtension(extentJson == null ? "" : extentJson);
            this.cmBaseLayerMapDao.updateByPrimaryKeySelective(cmBaseMap);
        }
    }

    private boolean checkNameRepeat(String id, String pid, String name) {
        CmBaseLayerMap existMap = this.cmBaseLayerMapDao.selectByName(pid, name);
        if (existMap == null) {
            return true;
        }
        if (StringUtil.isEmpty((String)id)) {
            return false;
        }
        return id.equals(existMap.getId());
    }

    private boolean isMapCategory(Integer type) {
        if (type == null) {
            return false;
        }
        return BaseMapType.MapCategoryVector.getValue() == type.intValue() || BaseMapType.MapCategoryRaster.getValue() == type.intValue() || BaseMapType.MapCategoryShaded.getValue() == type.intValue() || BaseMapType.MapCategoryCustom.getValue() == type.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CmBaseLayerMap getDefaultScheme() {
        CmBaseLayerMap cmBaseMap = this.cmBaseLayerMapDao.selectByPrimaryKey(DEFAULT_SCHEME);
        if (cmBaseMap == null) {
            BaseLayerMapServiceImpl baseLayerMapServiceImpl = this;
            synchronized (baseLayerMapServiceImpl) {
                cmBaseMap = this.cmBaseLayerMapDao.selectByPrimaryKey(DEFAULT_SCHEME);
                if (cmBaseMap == null) {
                    cmBaseMap = new CmBaseLayerMap();
                    cmBaseMap.setId(DEFAULT_SCHEME);
                    cmBaseMap.setPid("");
                    cmBaseMap.setCode(DEFAULT_SCHEME);
                    cmBaseMap.setName("\u9ed8\u8ba4\u65b9\u6848");
                    cmBaseMap.setType(BaseMapType.MapScheme.getValue());
                    cmBaseMap.setOrder(0);
                    cmBaseMap.setIsDefault(true);
                    cmBaseMap.setEnable(true);
                    this.cmBaseLayerMapDao.insertSelective(cmBaseMap);
                }
            }
        }
        return cmBaseMap;
    }
}

