/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.filemodel;

import com.geoway.adf.dms.config.filemodel.ScanErrorMessage;
import com.geoway.adf.dms.config.filemodel.ScanModelParam;
import com.geoway.adf.dms.config.filemodel.constant.FileModelNodeTypeEnum;
import com.geoway.adf.dms.config.filemodel.util.DataInstanceUtil;
import com.geoway.adf.dms.config.filemodel.util.FileHelper;
import com.geoway.adf.gis.fs.IFileset;
import java.util.ArrayList;
import java.util.List;

public class ScanInstanceParam {
    private ScanModelParam modelParam;
    private IFileset pacPath;
    private IFileset keyPath;
    private String folderName;
    private String keyName;
    private IFileset scanFolderName;
    private List<ScanErrorMessage> scanErrorMsgList;

    public ScanInstanceParam(IFileset keyPath, ScanModelParam modelParam) {
        this.keyPath = keyPath;
        this.modelParam = modelParam;
        this.scanErrorMsgList = new ArrayList<ScanErrorMessage>();
        this.pacPath = DataInstanceUtil.getPackageDir(keyPath, modelParam.getKeyObjType() == FileModelNodeTypeEnum.DataFile, modelParam);
        this.folderName = this.pacPath == null ? "" : this.pacPath.getName();
        switch (modelParam.getKeyObjType()) {
            case DataFile: {
                this.keyName = FileHelper.getNameWithoutExt(keyPath, null);
                break;
            }
            case CompactPackage: {
                this.keyName = FileHelper.getNameWithoutExt(keyPath, modelParam.getKeyCompactPackage().getPackageType());
                break;
            }
            case DataFolder: {
                this.keyName = keyPath.getName();
                break;
            }
        }
    }

    public ScanInstanceParam(IFileset keyPath, ScanModelParam modelParam, IFileset scanFolder) {
        this(keyPath, modelParam);
        this.scanFolderName = scanFolder;
    }

    public void appendScanErrorInfo(ScanErrorMessage msg) {
        this.scanErrorMsgList.add(msg);
    }

    public ScanModelParam getModelParam() {
        return this.modelParam;
    }

    public IFileset getPacPath() {
        return this.pacPath;
    }

    public IFileset getKeyPath() {
        return this.keyPath;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public IFileset getScanFolderName() {
        return this.scanFolderName;
    }

    public List<ScanErrorMessage> getScanErrorMsgList() {
        return this.scanErrorMsgList;
    }

    public void setModelParam(ScanModelParam modelParam) {
        this.modelParam = modelParam;
    }

    public void setPacPath(IFileset pacPath) {
        this.pacPath = pacPath;
    }

    public void setKeyPath(IFileset keyPath) {
        this.keyPath = keyPath;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public void setScanFolderName(IFileset scanFolderName) {
        this.scanFolderName = scanFolderName;
    }

    public void setScanErrorMsgList(List<ScanErrorMessage> scanErrorMsgList) {
        this.scanErrorMsgList = scanErrorMsgList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScanInstanceParam)) {
            return false;
        }
        ScanInstanceParam other = (ScanInstanceParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScanModelParam this$modelParam = this.getModelParam();
        ScanModelParam other$modelParam = other.getModelParam();
        if (this$modelParam == null ? other$modelParam != null : !((Object)this$modelParam).equals(other$modelParam)) {
            return false;
        }
        IFileset this$pacPath = this.getPacPath();
        IFileset other$pacPath = other.getPacPath();
        if (this$pacPath == null ? other$pacPath != null : !this$pacPath.equals(other$pacPath)) {
            return false;
        }
        IFileset this$keyPath = this.getKeyPath();
        IFileset other$keyPath = other.getKeyPath();
        if (this$keyPath == null ? other$keyPath != null : !this$keyPath.equals(other$keyPath)) {
            return false;
        }
        String this$folderName = this.getFolderName();
        String other$folderName = other.getFolderName();
        if (this$folderName == null ? other$folderName != null : !this$folderName.equals(other$folderName)) {
            return false;
        }
        String this$keyName = this.getKeyName();
        String other$keyName = other.getKeyName();
        if (this$keyName == null ? other$keyName != null : !this$keyName.equals(other$keyName)) {
            return false;
        }
        IFileset this$scanFolderName = this.getScanFolderName();
        IFileset other$scanFolderName = other.getScanFolderName();
        if (this$scanFolderName == null ? other$scanFolderName != null : !this$scanFolderName.equals(other$scanFolderName)) {
            return false;
        }
        List<ScanErrorMessage> this$scanErrorMsgList = this.getScanErrorMsgList();
        List<ScanErrorMessage> other$scanErrorMsgList = other.getScanErrorMsgList();
        return !(this$scanErrorMsgList == null ? other$scanErrorMsgList != null : !((Object)this$scanErrorMsgList).equals(other$scanErrorMsgList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScanInstanceParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScanModelParam $modelParam = this.getModelParam();
        result = result * 59 + ($modelParam == null ? 43 : ((Object)$modelParam).hashCode());
        IFileset $pacPath = this.getPacPath();
        result = result * 59 + ($pacPath == null ? 43 : $pacPath.hashCode());
        IFileset $keyPath = this.getKeyPath();
        result = result * 59 + ($keyPath == null ? 43 : $keyPath.hashCode());
        String $folderName = this.getFolderName();
        result = result * 59 + ($folderName == null ? 43 : $folderName.hashCode());
        String $keyName = this.getKeyName();
        result = result * 59 + ($keyName == null ? 43 : $keyName.hashCode());
        IFileset $scanFolderName = this.getScanFolderName();
        result = result * 59 + ($scanFolderName == null ? 43 : $scanFolderName.hashCode());
        List<ScanErrorMessage> $scanErrorMsgList = this.getScanErrorMsgList();
        result = result * 59 + ($scanErrorMsgList == null ? 43 : ((Object)$scanErrorMsgList).hashCode());
        return result;
    }

    public String toString() {
        return "ScanInstanceParam(modelParam=" + this.getModelParam() + ", pacPath=" + this.getPacPath() + ", keyPath=" + this.getKeyPath() + ", folderName=" + this.getFolderName() + ", keyName=" + this.getKeyName() + ", scanFolderName=" + this.getScanFolderName() + ", scanErrorMsgList=" + this.getScanErrorMsgList() + ")";
    }
}

